/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.core;

import io.atlasmap.api.AtlasException;
import io.atlasmap.api.AtlasSession;
import io.atlasmap.core.AtlasTestData;
import io.atlasmap.core.BaseAtlasModule;
import io.atlasmap.core.ConstantModule;
import io.atlasmap.core.DefaultAtlasContext;
import io.atlasmap.core.DefaultAtlasContextFactory;
import io.atlasmap.core.DefaultAtlasConversionService;
import io.atlasmap.core.DefaultAtlasPreviewContext;
import io.atlasmap.core.DefaultAtlasPropertyStrategy;
import io.atlasmap.core.DefaultAtlasSession;
import io.atlasmap.core.PropertyModule;
import io.atlasmap.spi.AtlasConversionService;
import io.atlasmap.spi.AtlasFieldReader;
import io.atlasmap.spi.AtlasFieldWriter;
import io.atlasmap.spi.AtlasInternalSession;
import io.atlasmap.spi.AtlasPropertyStrategy;
import io.atlasmap.v2.AtlasMapping;
import io.atlasmap.v2.AtlasModelFactory;
import io.atlasmap.v2.Audit;
import io.atlasmap.v2.Audits;
import io.atlasmap.v2.Constant;
import io.atlasmap.v2.DataSource;
import io.atlasmap.v2.DataSourceType;
import io.atlasmap.v2.Field;
import io.atlasmap.v2.FieldGroup;
import io.atlasmap.v2.FieldType;
import io.atlasmap.v2.LookupEntry;
import io.atlasmap.v2.LookupTable;
import io.atlasmap.v2.Mapping;
import io.atlasmap.v2.Property;
import io.atlasmap.v2.SimpleField;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.junit.jupiter.api.BeforeEach;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;

public abstract class BaseDefaultAtlasContextTest {
    protected DefaultAtlasContext context = null;
    protected DefaultAtlasPreviewContext previewContext = null;
    protected BaseAtlasModule sourceModule = null;
    protected BaseAtlasModule targetModule = null;
    protected AtlasMapping mapping = null;
    protected DefaultAtlasSession session = null;
    protected MockFieldReader reader = null;
    protected MockFieldWriter writer = null;

    @BeforeEach
    public void init() throws AtlasException {
        this.mapping = AtlasTestData.generateAtlasMapping();
        this.context = new DefaultAtlasContext(DefaultAtlasContextFactory.getInstance(), this.mapping){

            protected void init() {
            }
        };
        this.previewContext = new DefaultAtlasPreviewContext(DefaultAtlasContextFactory.getInstance());
        this.sourceModule = this.mockAtlasModule();
        DataSource sds = new DataSource();
        sds.setDataSourceType(DataSourceType.SOURCE);
        this.sourceModule.setDataSource(sds);
        this.targetModule = this.mockAtlasModule();
        DataSource tds = new DataSource();
        tds.setDataSourceType(DataSourceType.TARGET);
        this.targetModule.setDataSource(tds);
        this.context.getSourceModules().put("ATLAS_DEFAULT_SOURCE_DOC", this.sourceModule);
        this.context.getTargetModules().put("ATLAS_DEFAULT_TARGET_DOC", this.targetModule);
        ConstantModule constantModule = new ConstantModule();
        constantModule.setConversionService((AtlasConversionService)DefaultAtlasConversionService.getInstance());
        this.context.getSourceModules().put("ATLAS_CONSTANTS_DOC", constantModule);
        PropertyModule sourcePropertyModule = new PropertyModule((AtlasPropertyStrategy)new DefaultAtlasPropertyStrategy());
        sourcePropertyModule.setConversionService((AtlasConversionService)DefaultAtlasConversionService.getInstance());
        this.context.getSourceModules().put("ATLAS_SOURCE_PROPERTIES_DOC", sourcePropertyModule);
        PropertyModule targetPropertyModule = new PropertyModule((AtlasPropertyStrategy)new DefaultAtlasPropertyStrategy());
        targetPropertyModule.setConversionService((AtlasConversionService)DefaultAtlasConversionService.getInstance());
        this.context.getTargetModules().put("ATLAS_TARGET_PROPERTIES_DOC", targetPropertyModule);
        this.recreateSession();
    }

    protected void recreateSession() throws AtlasException {
        this.session = (DefaultAtlasSession)this.context.createSession();
        if (this.reader == null) {
            this.reader = new MockFieldReader();
        }
        this.session.setFieldReader("ATLAS_DEFAULT_SOURCE_DOC", (AtlasFieldReader)this.reader);
        if (this.writer == null) {
            this.writer = new MockFieldWriter();
        }
        this.session.setFieldWriter("ATLAS_DEFAULT_TARGET_DOC", (AtlasFieldWriter)this.writer);
    }

    private BaseAtlasModule mockAtlasModule() throws AtlasException {
        BaseAtlasModule module = (BaseAtlasModule)Mockito.spy(BaseAtlasModule.class);
        Mockito.when((Object)module.getConversionService()).thenReturn((Object)DefaultAtlasConversionService.getInstance());
        Mockito.when((Object)module.createField()).thenReturn((Object)new SimpleField());
        Mockito.when((Object)module.isSupportedField((Field)ArgumentMatchers.any(Field.class))).thenReturn((Object)true);
        ((BaseAtlasModule)Mockito.doAnswer((Answer)new Answer<Void>(){

            public Void answer(InvocationOnMock invocation) throws Throwable {
                AtlasInternalSession session = (AtlasInternalSession)invocation.getArguments()[0];
                BaseDefaultAtlasContextTest.this.reader.read(session);
                return null;
            }
        }).when((Object)module)).readSourceValue((AtlasInternalSession)ArgumentMatchers.any());
        ((BaseAtlasModule)Mockito.doAnswer((Answer)new Answer<Void>(){

            public Void answer(InvocationOnMock invocation) throws Throwable {
                AtlasInternalSession session = (AtlasInternalSession)invocation.getArguments()[0];
                LookupTable table = session.head().getLookupTable();
                Field source = session.head().getSourceField();
                Field target = session.head().getTargetField();
                Object value = source.getValue();
                if (table != null) {
                    for (LookupEntry e : table.getLookupEntry()) {
                        if (!value.equals(e.getSourceValue())) continue;
                        value = e.getTargetValue();
                    }
                }
                target.setValue(value);
                return null;
            }
        }).when((Object)module)).populateTargetField((AtlasInternalSession)ArgumentMatchers.any());
        ((BaseAtlasModule)Mockito.doAnswer((Answer)new Answer<Void>(){

            public Void answer(InvocationOnMock invocation) throws Throwable {
                AtlasInternalSession session = (AtlasInternalSession)invocation.getArguments()[0];
                BaseDefaultAtlasContextTest.this.writer.write(session);
                return null;
            }
        }).when((Object)module)).writeTargetValue((AtlasInternalSession)ArgumentMatchers.any());
        return module;
    }

    protected Field populateSourceField(Mapping mapping, String docId, FieldType type, Object value, int index) {
        Field field = this.populateSourceField(mapping, type, value);
        field.setDocId(docId);
        field.setIndex(Integer.valueOf(index));
        return field;
    }

    protected Field populateSourceField(Mapping mapping, FieldType type, Object value, int index) {
        Field field = this.populateSourceField(mapping, type, value);
        field.setIndex(Integer.valueOf(index));
        return field;
    }

    protected Field populateSourceField(Mapping mapping, FieldType type, Object value) {
        SimpleField field = new SimpleField();
        field.setFieldType(type);
        field.setPath("/testPath" + value);
        if (mapping != null) {
            mapping.getInputField().add(field);
        }
        this.reader.sources.put(field.getPath(), value);
        return field;
    }

    protected Field populateSourceField(Mapping mapping, String docId, FieldType type, Object value) {
        Field field = this.populateSourceField(mapping, type, value);
        field.setDocId(docId);
        return field;
    }

    protected Field populateSourceField(String docId, FieldType type, String name, Object value) {
        SimpleField field = new SimpleField();
        field.setFieldType(type);
        field.setDocId(docId);
        field.setName(name);
        field.setPath("/" + name);
        this.reader.sources.put(field.getPath(), value);
        return field;
    }

    protected Field populateUnsupportedSourceField(Mapping mapping, String docId, final String value, int index) {
        return this.populateSourceField(mapping, docId, FieldType.UNSUPPORTED, new Object(){

            public String toString() {
                return value;
            }
        }, index);
    }

    protected FieldGroup populateCollectionSourceField(Mapping mapping, String docId, String seed) {
        String basePath = "/testPath" + seed;
        FieldGroup fieldGroup = new FieldGroup();
        fieldGroup.setFieldType(FieldType.STRING);
        fieldGroup.setDocId(docId);
        fieldGroup.setPath(basePath + "<>");
        if (mapping != null) {
            mapping.setInputFieldGroup(fieldGroup);
        }
        for (int i = 0; i < 10; ++i) {
            SimpleField child = new SimpleField();
            child.setFieldType(FieldType.STRING);
            child.setDocId(docId);
            child.setPath(basePath + "<" + i + ">");
            child.setValue((Object)(seed + i));
            child.setIndex(Integer.valueOf(i));
            fieldGroup.getField().add(child);
            this.reader.sources.put(child.getPath(), child.getValue());
        }
        this.reader.sources.put(fieldGroup.getPath(), fieldGroup);
        return fieldGroup;
    }

    protected FieldGroup populateComplexCollectionSourceField(Mapping mapping, String docId, String seed) {
        String basePath = "/testPath" + seed;
        FieldGroup fieldGroup = new FieldGroup();
        fieldGroup.setFieldType(FieldType.COMPLEX);
        fieldGroup.setDocId(docId);
        fieldGroup.setPath(basePath + "<>");
        if (mapping != null) {
            mapping.setInputFieldGroup(fieldGroup);
        }
        ArrayList<SimpleField> terminals = new ArrayList<SimpleField>();
        for (int i = 0; i < 10; ++i) {
            FieldGroup child = new FieldGroup();
            child.setFieldType(FieldType.COMPLEX);
            child.setDocId(docId);
            child.setPath(basePath + "<" + i + ">");
            child.setIndex(Integer.valueOf(i));
            SimpleField terminal = new SimpleField();
            terminal.setFieldType(FieldType.STRING);
            terminal.setDocId(docId);
            terminal.setPath(basePath + "<" + i + ">/value");
            terminal.setValue((Object)(seed + i));
            child.getField().add(terminal);
            this.reader.sources.put(terminal.getPath(), terminal.getValue());
            fieldGroup.getField().add(child);
            this.reader.sources.put(child.getPath(), child);
            this.reader.sources.put(terminal.getPath(), terminal);
            terminals.add(terminal);
        }
        this.reader.sources.put(fieldGroup.getPath(), fieldGroup);
        FieldGroup valueGroup = AtlasModelFactory.copyFieldGroup((FieldGroup)fieldGroup);
        valueGroup.getField().addAll(terminals);
        valueGroup.setPath(fieldGroup.getPath() + "/value");
        this.reader.sources.put(valueGroup.getPath(), valueGroup);
        return fieldGroup;
    }

    protected Field populateUnsupportedSourceField(Mapping mapping, String value, int index) {
        return this.populateUnsupportedSourceField(mapping, null, value, index);
    }

    protected void populateConstant(String name, String value) {
        Constant c = new Constant();
        c.setName(name);
        c.setValue(value);
        this.session.getMapping().getConstants().getConstant().add(c);
    }

    protected void populateProperty(String scope, String name, String value) {
        Property p = new Property();
        p.setScope(scope);
        p.setName(name);
        p.setValue(value);
        this.session.getMapping().getProperties().getProperty().add(p);
    }

    protected Field prepareTargetField(Mapping mapping, String path) {
        SimpleField field = new SimpleField();
        field.setPath(path);
        mapping.getOutputField().add(field);
        return field;
    }

    protected Field prepareTargetField(Mapping mapping, String path, int index) {
        Field field = this.prepareTargetField(mapping, path);
        field.setIndex(Integer.valueOf(index));
        return field;
    }

    protected Field prepareTargetField(Mapping mapping, FieldType type, String path, int index) {
        Field field = this.prepareTargetField(mapping, path);
        field.setFieldType(type);
        field.setPath(path);
        field.setIndex(Integer.valueOf(index));
        return field;
    }

    protected Object getTargetFieldValue(String path) {
        return this.writer.targets.get(path);
    }

    protected String printAudit(Audits audits) {
        StringBuilder buf = new StringBuilder("Audits: ");
        for (Audit a : audits.getAudit()) {
            buf.append('[');
            buf.append(a.getStatus());
            buf.append(", message=");
            buf.append(a.getMessage());
            buf.append("], ");
        }
        return buf.toString();
    }

    protected String printAudit(AtlasSession session) {
        return this.printAudit(session.getAudits());
    }

    protected class MockFieldWriter
    implements AtlasFieldWriter {
        protected Map<String, Object> targets = new HashMap<String, Object>();

        protected MockFieldWriter() {
        }

        public void write(AtlasInternalSession session) throws AtlasException {
            this.targets.put(session.head().getTargetField().getPath(), session.head().getTargetField().getValue());
        }
    }

    protected class MockFieldReader
    implements AtlasFieldReader {
        protected Map<String, Object> sources = new HashMap<String, Object>();

        protected MockFieldReader() {
        }

        public Field read(AtlasInternalSession session) throws AtlasException {
            Field field = session.head().getSourceField();
            Object value = this.sources.get(field.getPath());
            if (value instanceof Field) {
                session.head().setSourceField((Field)value);
                return (Field)value;
            }
            field.setValue(value);
            return field;
        }
    }
}

