/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.validators;

import io.atlasmap.v2.Validation;
import io.atlasmap.v2.ValidationScope;
import io.atlasmap.v2.ValidationStatus;
import io.atlasmap.validators.BaseValidatorTest;
import io.atlasmap.validators.PositiveIntegerValidator;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class PositiveIntegerValidatorTest
extends BaseValidatorTest {
    private PositiveIntegerValidator validator;

    @Override
    @BeforeEach
    public void setUp() {
        super.setUp();
        this.validator = new PositiveIntegerValidator(ValidationScope.MAPPING, "Integer must be >= 0");
    }

    @Override
    @AfterEach
    public void tearDown() {
        super.tearDown();
        this.validator = null;
    }

    @Test
    public void testSupported() {
        Assertions.assertTrue((boolean)this.validator.supports(Integer.class));
        Assertions.assertTrue((boolean)this.validator.supports(String.class));
    }

    @Test
    public void testUnsupported() {
        Assertions.assertFalse((boolean)this.validator.supports(Boolean.class));
    }

    @Test
    public void testValidate() {
        this.validator.validate((Object)0, this.validations, null);
        this.validator.validate((Object)1222, this.validations, null);
        Assertions.assertFalse((boolean)this.validationHelper.hasErrors());
    }

    @Test
    public void testValidateInvalid() {
        this.validator.validate((Object)-1, this.validations, "testValidateInvalid");
        Assertions.assertTrue((boolean)this.validationHelper.hasErrors());
        Assertions.assertEquals((Integer)1, (Integer)this.validationHelper.getCount());
        Assertions.assertEquals((Object)"testValidateInvalid", (Object)((Validation)this.validationHelper.getValidation().get(0)).getId());
    }

    @Test
    public void testValidateInvalidWarn() {
        this.validator.validate((Object)-1, this.validations, "testValidateInvalidWarn", ValidationStatus.WARN);
        Assertions.assertFalse((boolean)this.validationHelper.hasErrors());
        Assertions.assertTrue((boolean)this.validationHelper.hasWarnings());
        Assertions.assertEquals((Integer)1, (Integer)this.validationHelper.getCount());
        Assertions.assertEquals((Object)"testValidateInvalidWarn", (Object)((Validation)this.validationHelper.getValidation().get(0)).getId());
    }

    @Test
    public void testValidateInvalidInfo() {
        this.validator.validate((Object)-1, this.validations, "testValidateInvalidInfo", ValidationStatus.INFO);
        Assertions.assertFalse((boolean)this.validationHelper.hasErrors());
        Assertions.assertFalse((boolean)this.validationHelper.hasWarnings());
        Assertions.assertTrue((boolean)this.validationHelper.hasInfos());
        Assertions.assertEquals((Integer)1, (Integer)this.validationHelper.getCount());
        Assertions.assertEquals((Object)"testValidateInvalidInfo", (Object)((Validation)this.validationHelper.getValidation().get(0)).getId());
    }

    @Test
    public void testValidateWithErrorLevel() {
        this.validator.validate((Object)0, this.validations, "testValidateWithErrorLevel", ValidationStatus.WARN);
        Assertions.assertFalse((boolean)this.validationHelper.hasErrors());
        Assertions.assertFalse((boolean)this.validationHelper.hasWarnings());
        Assertions.assertFalse((boolean)this.validationHelper.hasInfos());
    }
}

