/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.dfdl.core;

import io.atlasmap.api.AtlasException;
import io.atlasmap.dfdl.core.DfdlSchemaGenerator;
import java.io.File;
import java.net.URI;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.ServiceLoader;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;

public class DfdlSchemaResolver {
    private ClassLoader classLoader;
    private Map<String, DfdlSchemaGenerator> dfdlGenerators;

    public DfdlSchemaResolver(ClassLoader loader) {
        this.classLoader = loader;
        this.dfdlGenerators = new HashMap<String, DfdlSchemaGenerator>();
        ServiceLoader<DfdlSchemaGenerator> schemaGenLoader = ServiceLoader.load(DfdlSchemaGenerator.class, this.classLoader);
        for (DfdlSchemaGenerator generator : schemaGenLoader) {
            this.dfdlGenerators.put(generator.getName(), generator);
        }
    }

    public URI resolve(String dfdlSchemaName, Map<String, String> options) throws Exception {
        if (dfdlSchemaName == null) {
            throw new AtlasException("DFDL schema name must be specified");
        }
        URL url = null;
        try {
            url = this.classLoader.getResource(dfdlSchemaName + ".dfdl.xsd");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (url != null) {
            return url.toURI();
        }
        DfdlSchemaGenerator generator = this.dfdlGenerators.get(dfdlSchemaName);
        if (generator != null) {
            Document xsd = generator.generate(this.classLoader, options);
            File f = File.createTempFile(dfdlSchemaName, ".dfdl.xsd");
            f.deleteOnExit();
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            DOMSource source = new DOMSource(xsd);
            StreamResult result = new StreamResult(f);
            transformer.transform(source, result);
            return f.toURI();
        }
        throw new AtlasException(String.format("DFDL schema not found for '%s'", dfdlSchemaName));
    }
}

