/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.itests.core;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.atlasmap.api.AtlasContext;
import io.atlasmap.api.AtlasSession;
import io.atlasmap.core.DefaultAtlasContextFactory;
import io.atlasmap.itests.core.TestHelper;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Paths;
import org.junit.Assert;
import org.junit.Test;

public class JsonBigIntegerTest {
    @Test
    public void test() throws Exception {
        URL url = Thread.currentThread().getContextClassLoader().getResource("mappings/atlasmapping-json-biginteger.json");
        AtlasContext context = DefaultAtlasContextFactory.getInstance().createContext(url.toURI());
        AtlasSession session = context.createSession();
        String sourceJson = new String(Files.readAllBytes(Paths.get(Thread.currentThread().getContextClassLoader().getResource("data/json-source-biginteger.json").toURI())));
        session.setSourceDocument("json-source", (Object)sourceJson);
        context.process(session);
        Assert.assertFalse((String)TestHelper.printAudit(session), (boolean)session.hasErrors());
        String output = (String)session.getTargetDocument("json-target");
        JsonNode root = new ObjectMapper().readTree(output);
        JsonNode field = root.get("field");
        Assert.assertEquals((Object)true, (Object)field.isBigInteger());
        Assert.assertEquals((Object)"1234567890123456789012345678901234567890", (Object)field.asText());
        JsonNode auto = root.get("auto");
        Assert.assertEquals((Object)true, (Object)auto.isBigInteger());
        Assert.assertEquals((Object)"12345678901234567890123456789012345678901", (Object)auto.asText());
    }
}

