/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.java.v2;

import io.atlasmap.java.v2.ClassInspectionRequest;
import io.atlasmap.java.v2.JavaField;
import io.atlasmap.java.v2.MavenClasspathRequest;
import io.atlasmap.v2.Actions;
import io.atlasmap.v2.AtlasMapping;
import io.atlasmap.v2.AtlasModelFactory;
import io.atlasmap.v2.Camelize;
import io.atlasmap.v2.Capitalize;
import io.atlasmap.v2.Collection;
import io.atlasmap.v2.CollectionType;
import io.atlasmap.v2.ConstantField;
import io.atlasmap.v2.DataSource;
import io.atlasmap.v2.Field;
import io.atlasmap.v2.Lowercase;
import io.atlasmap.v2.Mapping;
import io.atlasmap.v2.MappingType;
import io.atlasmap.v2.Mappings;
import io.atlasmap.v2.Properties;
import io.atlasmap.v2.Property;
import io.atlasmap.v2.PropertyField;
import io.atlasmap.v2.SeparateByDash;
import io.atlasmap.v2.SeparateByUnderscore;
import io.atlasmap.v2.StringLength;
import io.atlasmap.v2.StringList;
import io.atlasmap.v2.Trim;
import io.atlasmap.v2.TrimLeft;
import io.atlasmap.v2.TrimRight;
import io.atlasmap.v2.Uppercase;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.rules.TestName;

public abstract class BaseMarshallerTest {
    public boolean deleteTestFolders = true;
    @Rule
    public TestName testName = new TestName();

    @Before
    public void setUp() throws Exception {
        Files.createDirectories(Paths.get("target/junit/" + this.testName.getMethodName(), new String[0]), new FileAttribute[0]);
    }

    @After
    public void tearDown() throws Exception {
        if (this.deleteTestFolders) {
            Path directory = Paths.get("target/junit/" + this.testName.getMethodName(), new String[0]);
            Files.walkFileTree(directory, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    Files.delete(file);
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
                    Files.delete(file);
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                    if (exc == null) {
                        Files.delete(dir);
                        return FileVisitResult.CONTINUE;
                    }
                    throw exc;
                }
            });
        }
    }

    protected AtlasMapping generateAtlasMapping() {
        AtlasMapping atlasMapping = AtlasModelFactory.createAtlasMapping();
        atlasMapping.setName("junit");
        JavaField inputField = new JavaField();
        inputField.setName("foo");
        inputField.setValue((Object)"bar");
        JavaField outputField = new JavaField();
        outputField.setName("woot");
        outputField.setValue((Object)"blerg");
        Mapping fm = (Mapping)AtlasModelFactory.createMapping((MappingType)MappingType.MAP);
        fm.getInputField().add(inputField);
        fm.getOutputField().add(outputField);
        atlasMapping.getMappings().getMapping().add(fm);
        return atlasMapping;
    }

    protected AtlasMapping generateActionMapping() {
        AtlasMapping mapping = this.generateAtlasMapping();
        JavaField outputField = (JavaField)((Mapping)mapping.getMappings().getMapping().get(0)).getOutputField().get(0);
        Actions actions = new Actions();
        actions.getActions().add(new Camelize());
        actions.getActions().add(new Capitalize());
        actions.getActions().add(new Lowercase());
        actions.getActions().add(new SeparateByDash());
        actions.getActions().add(new SeparateByUnderscore());
        actions.getActions().add(new StringLength());
        actions.getActions().add(new Trim());
        actions.getActions().add(new TrimLeft());
        actions.getActions().add(new TrimRight());
        actions.getActions().add(new Uppercase());
        outputField.setActions(actions);
        return mapping;
    }

    protected AtlasMapping generatePropertyReferenceMapping() {
        AtlasMapping mapping = this.generateAtlasMapping();
        PropertyField inputField = new PropertyField();
        inputField.setName("foo");
        Mapping fm = (Mapping)mapping.getMappings().getMapping().get(0);
        fm.getInputField().add(inputField);
        Property p = new Property();
        p.setName("foo");
        p.setValue("bar");
        mapping.setProperties(new Properties());
        mapping.getProperties().getProperty().add(p);
        return mapping;
    }

    protected AtlasMapping generateConstantMapping() {
        AtlasMapping mapping = this.generateAtlasMapping();
        ConstantField inputField = new ConstantField();
        inputField.setValue((Object)"foo");
        Mapping fm = (Mapping)mapping.getMappings().getMapping().get(0);
        fm.getInputField().add(inputField);
        return mapping;
    }

    protected AtlasMapping generateCollectionMapping() {
        AtlasMapping innerMapping1 = this.generateAtlasMapping();
        AtlasMapping innerMapping2 = this.generateAtlasMapping();
        Collection cMapping = (Collection)AtlasModelFactory.createMapping((MappingType)MappingType.COLLECTION);
        cMapping.setMappings(new Mappings());
        cMapping.getMappings().getMapping().addAll(innerMapping1.getMappings().getMapping());
        cMapping.getMappings().getMapping().addAll(innerMapping2.getMappings().getMapping());
        cMapping.setCollectionType(CollectionType.LIST);
        AtlasMapping mapping = this.generateAtlasMapping();
        mapping.getMappings().getMapping().clear();
        mapping.getMappings().getMapping().add(cMapping);
        return mapping;
    }

    protected AtlasMapping generateCombineMapping() {
        JavaField inputJavaField = new JavaField();
        inputJavaField.setName("foo");
        inputJavaField.setValue((Object)"bar");
        inputJavaField.setIndex(Integer.valueOf(4));
        JavaField inputJavaFieldB = new JavaField();
        inputJavaFieldB.setName("foo3");
        inputJavaFieldB.setValue((Object)"bar3");
        inputJavaFieldB.setIndex(Integer.valueOf(3));
        JavaField outputJavaFieldA = new JavaField();
        outputJavaFieldA.setName("woot");
        outputJavaFieldA.setValue((Object)"blerg");
        Mapping fm = (Mapping)AtlasModelFactory.createMapping((MappingType)MappingType.COMBINE);
        fm.setStrategy("SPACE");
        fm.getInputField().add(inputJavaField);
        fm.getInputField().add(inputJavaFieldB);
        fm.getOutputField().add(outputJavaFieldA);
        AtlasMapping mapping = this.generateAtlasMapping();
        mapping.getMappings().getMapping().clear();
        mapping.getMappings().getMapping().add(fm);
        return mapping;
    }

    protected AtlasMapping generateMultiSourceMapping() {
        AtlasMapping mapping = this.generateSeparateAtlasMapping();
        DataSource sourceA = new DataSource();
        sourceA.setUri("someSourceURI:A");
        sourceA.setId("sourceA");
        mapping.getDataSource().add(sourceA);
        DataSource targetA = new DataSource();
        targetA.setUri("someTargetURI:A");
        targetA.setId("targetA");
        mapping.getDataSource().add(targetA);
        DataSource targetB = new DataSource();
        targetB.setUri("someTargetURI:B");
        targetB.setId("targetB");
        mapping.getDataSource().add(targetB);
        Mapping fm = (Mapping)mapping.getMappings().getMapping().get(0);
        ((Field)fm.getInputField().get(0)).setDocId("sourceA");
        ((Field)fm.getOutputField().get(0)).setDocId("targetA");
        ((Field)fm.getOutputField().get(1)).setDocId("targetB");
        return mapping;
    }

    protected AtlasMapping generateSeparateAtlasMapping() {
        JavaField inputJavaField = new JavaField();
        inputJavaField.setName("foo");
        inputJavaField.setValue((Object)"bar");
        JavaField outputJavaFieldA = new JavaField();
        outputJavaFieldA.setIndex(Integer.valueOf(4));
        outputJavaFieldA.setName("woot");
        outputJavaFieldA.setValue((Object)"blerg");
        JavaField outputJavaFieldB = new JavaField();
        outputJavaFieldA.setIndex(Integer.valueOf(5));
        outputJavaFieldA.setName("woot2");
        outputJavaFieldA.setValue((Object)"blerg2");
        Mapping fm = (Mapping)AtlasModelFactory.createMapping((MappingType)MappingType.SEPARATE);
        fm.getInputField().add(inputJavaField);
        fm.getOutputField().add(outputJavaFieldA);
        fm.getOutputField().add(outputJavaFieldB);
        AtlasMapping mapping = this.generateAtlasMapping();
        mapping.getMappings().getMapping().clear();
        mapping.getMappings().getMapping().add(fm);
        return mapping;
    }

    public MavenClasspathRequest generateMavenClasspathRequest() {
        MavenClasspathRequest mavenClasspathRequest = new MavenClasspathRequest();
        mavenClasspathRequest.setExecuteTimeout(Long.valueOf(30000L));
        mavenClasspathRequest.setPomXmlData(this.generatePomXmlAsString());
        return mavenClasspathRequest;
    }

    public ClassInspectionRequest generateClassInspectionRequest() {
        ClassInspectionRequest classInspectionRequest = new ClassInspectionRequest();
        classInspectionRequest.setClasspath("/Users/mattrpav/.m2/repository/org/twitter4j/twitter4j-core/4.0.5/twitter4j-core-4.0.5.jar");
        classInspectionRequest.setClassName("twitter4j.StatusJSONImpl");
        classInspectionRequest.setFieldNameBlacklist(new StringList());
        classInspectionRequest.getFieldNameBlacklist().getString().add("createdAt");
        return classInspectionRequest;
    }

    public String generatePomXmlAsString() {
        return new String("<project xmlns=\"http://maven.apache.org/POM/4.0.0\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://maven.apache.org/POM/4.0.0 http://maven.apache.org/xsd/maven-4.0.0.xsd\">\t<modelVersion>4.0.0</modelVersion>\t<groupId>foo.bar</groupId>\t<artifactId>test.model</artifactId>\t<version>1.10.0</version>\t<packaging>jar</packaging>\t<name>Test :: Model</name>\t<dependencies>\t\t<dependency>\t\t\t<groupId>com.fasterxml.jackson.core</groupId>\t\t\t<artifactId>jackson-annotations</artifactId>\t\t\t<version>2.8.5</version>\t\t</dependency>\t\t<dependency>\t\t\t<groupId>com.fasterxml.jackson.core</groupId>\t\t\t<artifactId>jackson-databind</artifactId>\t\t\t<version>2.8.5</version>\t\t</dependency>\t\t<dependency>\t\t\t<groupId>com.fasterxml.jackson.core</groupId>\t\t\t<artifactId>jackson-core</artifactId>\t\t\t<version>2.8.5</version>\t\t</dependency>\t</dependencies></project>");
    }
}

