/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.java.v2;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import io.atlasmap.java.v2.BaseMarshallerTest;
import io.atlasmap.java.v2.ClassInspectionRequest;
import io.atlasmap.java.v2.MavenClasspathRequest;
import io.atlasmap.v2.AtlasMapping;
import java.io.File;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class JsonMarshallerTest
extends BaseMarshallerTest {
    public ObjectMapper mapper = null;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.deleteTestFolders = false;
        this.mapper = new ObjectMapper();
        this.mapper.configure(SerializationFeature.WRAP_ROOT_VALUE, true);
        this.mapper.configure(DeserializationFeature.UNWRAP_ROOT_VALUE, true);
        this.mapper.configure(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY, true);
        this.mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
    }

    @Override
    @After
    public void tearDown() throws Exception {
        super.tearDown();
        this.mapper = null;
    }

    @Test
    public void testJsonMapJavaField() throws Exception {
        AtlasMapping atlasMapping = this.generateAtlasMapping();
        this.mapper.writerWithDefaultPrettyPrinter().writeValue(new File("target" + File.separator + "junit" + File.separator + this.testName.getMethodName() + File.separator + "atlasmapping.json"), (Object)atlasMapping);
        AtlasMapping uMapping = (AtlasMapping)this.mapper.readValue(new File("target" + File.separator + "junit" + File.separator + this.testName.getMethodName() + File.separator + "atlasmapping.json"), AtlasMapping.class);
        Assert.assertNotNull((Object)uMapping);
    }

    @Test
    public void testJsonMavenClasspathRequest() throws Exception {
        MavenClasspathRequest request = this.generateMavenClasspathRequest();
        this.mapper.writerWithDefaultPrettyPrinter().writeValue(new File("target" + File.separator + "junit" + File.separator + this.testName.getMethodName() + File.separator + "atlasmapping-mavenclasspath-request.json"), (Object)request);
        MavenClasspathRequest uRequest = (MavenClasspathRequest)this.mapper.readValue(new File("target" + File.separator + "junit" + File.separator + this.testName.getMethodName() + File.separator + "atlasmapping-mavenclasspath-request.json"), MavenClasspathRequest.class);
        Assert.assertNotNull((Object)uRequest);
    }

    @Test
    public void testJsonClassInspectionRequest() throws Exception {
        ClassInspectionRequest request = this.generateClassInspectionRequest();
        this.mapper.writerWithDefaultPrettyPrinter().writeValue(new File("target" + File.separator + "junit" + File.separator + this.testName.getMethodName() + File.separator + "atlasmapping-classinspection-request.json"), (Object)request);
        ClassInspectionRequest uRequest = (ClassInspectionRequest)this.mapper.readValue(new File("target" + File.separator + "junit" + File.separator + this.testName.getMethodName() + File.separator + "atlasmapping-classinspection-request.json"), ClassInspectionRequest.class);
        Assert.assertNotNull((Object)uRequest);
    }

    @Test
    public void testComplexRequests() throws Exception {
        this.runJSONSerializationTest(this.generatePropertyReferenceMapping(), "atlasmapping-property-request.json");
        this.runJSONSerializationTest(this.generateConstantMapping(), "atlasmapping-constant-request.json");
        this.runJSONSerializationTest(this.generateMultiSourceMapping(), "atlasmapping-multisource-request.json");
        this.runJSONSerializationTest(this.generateCollectionMapping(), "atlasmapping-collection-request.json");
        this.runJSONSerializationTest(this.generateCombineMapping(), "atlasmapping-combine-request.json");
        this.runJSONSerializationTest(this.generateActionMapping(), "atlasmapping-field-action-request.json");
    }

    private void runJSONSerializationTest(Object object, String filename) throws Exception {
        File f = new File("target" + File.separator + "junit" + File.separator + this.testName.getMethodName() + File.separator + filename);
        this.mapper.writerWithDefaultPrettyPrinter().writeValue(f, object);
        Object readObject = this.mapper.readValue(f, object.getClass());
        Assert.assertNotNull((Object)readObject);
    }
}

