/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.java.v2;

import io.atlasmap.java.v2.ClassInspectionRequest;
import io.atlasmap.java.v2.JavaField;
import io.atlasmap.java.v2.MavenClasspathRequest;
import io.atlasmap.java.v2.Modifier;
import io.atlasmap.java.v2.ModifierList;
import io.atlasmap.v2.Action;
import io.atlasmap.v2.AtlasMapping;
import io.atlasmap.v2.AtlasModelFactory;
import io.atlasmap.v2.Camelize;
import io.atlasmap.v2.Capitalize;
import io.atlasmap.v2.Collection;
import io.atlasmap.v2.CollectionType;
import io.atlasmap.v2.ConstantField;
import io.atlasmap.v2.DataSource;
import io.atlasmap.v2.DataSourceType;
import io.atlasmap.v2.Field;
import io.atlasmap.v2.FieldStatus;
import io.atlasmap.v2.FieldType;
import io.atlasmap.v2.Length;
import io.atlasmap.v2.LookupEntry;
import io.atlasmap.v2.LookupTable;
import io.atlasmap.v2.Lowercase;
import io.atlasmap.v2.Mapping;
import io.atlasmap.v2.MappingType;
import io.atlasmap.v2.Mappings;
import io.atlasmap.v2.Properties;
import io.atlasmap.v2.Property;
import io.atlasmap.v2.PropertyField;
import io.atlasmap.v2.SeparateByDash;
import io.atlasmap.v2.SeparateByUnderscore;
import io.atlasmap.v2.StringList;
import io.atlasmap.v2.Trim;
import io.atlasmap.v2.TrimLeft;
import io.atlasmap.v2.TrimRight;
import io.atlasmap.v2.Uppercase;
import java.io.IOException;
import java.math.BigInteger;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.rules.TestName;

public abstract class BaseMarshallerTest {
    public boolean deleteTestFolders = true;
    @Rule
    public TestName testName = new TestName();

    @Before
    public void setUp() throws Exception {
        Files.createDirectories(Paths.get("target/junit/" + this.testName.getMethodName(), new String[0]), new FileAttribute[0]);
    }

    @After
    public void tearDown() throws Exception {
        if (this.deleteTestFolders) {
            Path directory = Paths.get("target/junit/" + this.testName.getMethodName(), new String[0]);
            Files.walkFileTree(directory, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    Files.delete(file);
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
                    Files.delete(file);
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                    if (exc == null) {
                        Files.delete(dir);
                        return FileVisitResult.CONTINUE;
                    }
                    throw exc;
                }
            });
        }
    }

    protected AtlasMapping generateAtlasMapping() {
        AtlasMapping atlasMapping = AtlasModelFactory.createAtlasMapping();
        atlasMapping.setName("junit");
        this.generateDataSource(atlasMapping);
        this.generateLookupTables(atlasMapping);
        ArrayList<Action> actions = this.generateActions();
        StringList annotations = this.generateAnnotations();
        ModifierList modifierList = this.generateModifierList();
        StringList parameterizedTypes = this.generateParameterizedTypes();
        JavaField inputField = this.generateJavaField(actions, annotations, modifierList, parameterizedTypes);
        JavaField outputField = this.generateJavaField(actions, annotations, modifierList, parameterizedTypes);
        Mapping fm = (Mapping)AtlasModelFactory.createMapping((MappingType)MappingType.MAP);
        fm.getInputField().add(inputField);
        fm.getOutputField().add(outputField);
        this.populateMapping(fm, MappingType.MAP, "MapPropertyFieldAlias", ",", ",");
        this.populateMappingString(fm, "description", "id", "lookupTableName", "strategy", "strategyClassName");
        atlasMapping.getMappings().getMapping().add(fm);
        this.generateProperties(atlasMapping);
        return atlasMapping;
    }

    private void populateMapping(Mapping mapping, MappingType mappingType, String alias, String delimiter, String delimiterString) {
        if (mappingType != null) {
            mapping.setMappingType(mappingType);
        }
        mapping.setAlias(alias);
        mapping.setDelimiter(delimiter);
        mapping.setDelimiterString(delimiterString);
    }

    private void populateMappingString(Mapping mapping, String description, String id, String lookupTableName, String strategy, String strategyClassName) {
        mapping.setDescription(description);
        mapping.setId(id);
        mapping.setLookupTableName(lookupTableName);
        mapping.setStrategy(strategy);
        mapping.setStrategyClassName(strategyClassName);
    }

    private void generateLookupTables(AtlasMapping atlasMapping) {
        LookupTable table = new LookupTable();
        table.setName("lookupTable");
        table.setDescription("lookupTableDescription");
        LookupEntry l1 = new LookupEntry();
        l1.setSourceType(FieldType.STRING);
        l1.setSourceValue("Foo");
        l1.setTargetType(FieldType.STRING);
        l1.setTargetValue("Bar");
        table.getLookupEntry().add(l1);
        atlasMapping.getLookupTables().getLookupTable().add(table);
    }

    private void generateDataSource(AtlasMapping atlasMapping) {
        DataSource src = this.generateDataSource("srcId", "srcUri", DataSourceType.SOURCE);
        DataSource tgt = this.generateDataSource("tgtId", "tgtUri", DataSourceType.TARGET);
        atlasMapping.getDataSource().add(src);
        atlasMapping.getDataSource().add(tgt);
    }

    private DataSource generateDataSource(String id, String uri, DataSourceType type) {
        DataSource dataSource = new DataSource();
        dataSource.setId(id);
        dataSource.setUri(uri);
        dataSource.setDataSourceType(type);
        return dataSource;
    }

    protected AtlasMapping generateActionMapping() {
        AtlasMapping mapping = this.generateAtlasMapping();
        JavaField outputField = (JavaField)((Mapping)mapping.getMappings().getMapping().get(0)).getOutputField().get(0);
        this.populateJavaField(outputField, this.generateAnnotations(), this.generateModifierList(), this.generateParameterizedTypes(), Boolean.FALSE, Boolean.TRUE);
        this.populateJavaFieldString(outputField, "JavaField", "ArrayList", "getMethod", "setMethod", "foo");
        this.populateFieldComplexObject((Field)outputField, this.generateActions(), CollectionType.ARRAY, FieldStatus.SUPPORTED, FieldType.INTEGER);
        this.populateFieldSimpleObject((Field)outputField, 3, "docid", "/path", false, "bar");
        return mapping;
    }

    protected AtlasMapping generatePropertyReferenceMapping() {
        AtlasMapping mapping = this.generateAtlasMapping();
        PropertyField inputField = new PropertyField();
        inputField.setName("foo");
        ArrayList<Action> actions = new ArrayList<Action>();
        actions.add((Action)new Trim());
        this.populateFieldComplexObject((Field)inputField, actions, CollectionType.ARRAY, FieldStatus.SUPPORTED, FieldType.INTEGER);
        this.populateFieldSimpleObject((Field)inputField, 3, "docid", "/path", false, "bar");
        Mapping fm = (Mapping)mapping.getMappings().getMapping().get(0);
        fm.getInputField().add(inputField);
        fm.getOutputField().add(inputField);
        this.populateMapping(fm, MappingType.MAP, "MapPropertyFieldAlias", ",", ",");
        this.populateMappingString(fm, "description", "id", "lookupTableName", "strategy", "strategyClassName");
        this.generateProperties(mapping);
        return mapping;
    }

    protected AtlasMapping generateConstantMapping() {
        AtlasMapping mapping = this.generateAtlasMapping();
        ConstantField inputField = new ConstantField();
        ArrayList<Action> actions = new ArrayList<Action>();
        actions.add((Action)new Trim());
        this.populateFieldComplexObject((Field)inputField, actions, CollectionType.ARRAY, FieldStatus.SUPPORTED, FieldType.INTEGER);
        this.populateFieldSimpleObject((Field)inputField, 3, "docid", "/path", false, "bar");
        Mapping fm = (Mapping)mapping.getMappings().getMapping().get(0);
        fm.getInputField().add(inputField);
        fm.getOutputField().add(inputField);
        this.populateMapping(fm, MappingType.MAP, "MapPropertyFieldAlias", ",", ",");
        this.populateMappingString(fm, "description", "id", "lookupTableName", "strategy", "strategyClassName");
        return mapping;
    }

    protected AtlasMapping generateCollectionMapping() {
        AtlasMapping innerMapping1 = this.generateAtlasMapping();
        AtlasMapping innerMapping2 = this.generateAtlasMapping();
        Collection cMapping = (Collection)AtlasModelFactory.createMapping((MappingType)MappingType.COLLECTION);
        cMapping.setMappings(new Mappings());
        cMapping.getMappings().getMapping().addAll(innerMapping1.getMappings().getMapping());
        cMapping.getMappings().getMapping().addAll(innerMapping2.getMappings().getMapping());
        cMapping.setCollectionType(CollectionType.LIST);
        cMapping.setCollectionSize(new BigInteger("2"));
        cMapping.setAlias("alias");
        cMapping.setDescription("description");
        AtlasMapping mapping = this.generateAtlasMapping();
        mapping.getMappings().getMapping().clear();
        mapping.getMappings().getMapping().add(cMapping);
        return mapping;
    }

    protected AtlasMapping generateCombineMapping() {
        ArrayList<Action> actions = this.generateActions();
        StringList annotations = this.generateAnnotations();
        ModifierList modifierList = this.generateModifierList();
        StringList parameterizedTypes = this.generateParameterizedTypes();
        JavaField inputJavaField = this.generateJavaField(actions, annotations, modifierList, parameterizedTypes);
        JavaField inputJavaFieldB = this.generateJavaField(actions, annotations, modifierList, parameterizedTypes);
        JavaField outputJavaFieldA = this.generateJavaField(actions, annotations, modifierList, parameterizedTypes);
        Mapping fm = (Mapping)AtlasModelFactory.createMapping((MappingType)MappingType.COMBINE);
        fm.getInputField().add(inputJavaField);
        fm.getInputField().add(inputJavaFieldB);
        fm.getOutputField().add(outputJavaFieldA);
        this.populateMapping(fm, MappingType.COMBINE, "MapPropertyFieldAlias", ",", ",");
        this.populateMappingString(fm, "description", "id", "lookupTableName", "strategy", "strategyClassName");
        AtlasMapping mapping = this.generateAtlasMapping();
        mapping.getMappings().getMapping().clear();
        mapping.getMappings().getMapping().add(fm);
        this.generateProperties(mapping);
        return mapping;
    }

    private void generateProperties(AtlasMapping mapping) {
        Property p = new Property();
        p.setName("foo");
        p.setValue("bar");
        p.setFieldType(FieldType.INTEGER);
        mapping.setProperties(new Properties());
        mapping.getProperties().getProperty().add(p);
    }

    protected AtlasMapping generateMultiSourceMapping() {
        AtlasMapping mapping = this.generateSeparateAtlasMapping();
        DataSource sourceA = this.generateDataSource("srcId", "srcUri", DataSourceType.SOURCE);
        mapping.getDataSource().add(sourceA);
        DataSource targetA = this.generateDataSource("tgtId", "tgtUri", DataSourceType.TARGET);
        mapping.getDataSource().add(targetA);
        DataSource targetB = this.generateDataSource("tgtId", "tgtUri", DataSourceType.TARGET);
        mapping.getDataSource().add(targetB);
        Mapping fm = (Mapping)mapping.getMappings().getMapping().get(0);
        ((Field)fm.getInputField().get(0)).setDocId("docid");
        ((Field)fm.getOutputField().get(0)).setDocId("docid");
        ((Field)fm.getOutputField().get(1)).setDocId("docid");
        this.populateMapping(fm, MappingType.MAP, "MapPropertyFieldAlias", ",", ",");
        this.populateMappingString(fm, "description", "id", "lookupTableName", "strategy", "strategyClassName");
        return mapping;
    }

    protected AtlasMapping generateSeparateAtlasMapping() {
        ArrayList<Action> actions = this.generateActions();
        StringList annotations = this.generateAnnotations();
        ModifierList modifierList = this.generateModifierList();
        StringList parameterizedTypes = this.generateParameterizedTypes();
        JavaField inputJavaField = this.generateJavaField(actions, annotations, modifierList, parameterizedTypes);
        JavaField outputJavaFieldA = this.generateJavaField(actions, annotations, modifierList, parameterizedTypes);
        JavaField outputJavaFieldB = this.generateJavaField(actions, annotations, modifierList, parameterizedTypes);
        Mapping fm = (Mapping)AtlasModelFactory.createMapping((MappingType)MappingType.SEPARATE);
        fm.getInputField().add(inputJavaField);
        fm.getOutputField().add(outputJavaFieldA);
        fm.getOutputField().add(outputJavaFieldB);
        this.populateMapping(fm, MappingType.SEPARATE, "MapPropertyFieldAlias", ",", ",");
        this.populateMappingString(fm, "description", "id", "lookupTableName", "strategy", "strategyClassName");
        AtlasMapping mapping = this.generateAtlasMapping();
        mapping.getMappings().getMapping().clear();
        mapping.getMappings().getMapping().add(fm);
        return mapping;
    }

    private StringList generateAnnotations() {
        StringList annotations = new StringList();
        annotations.getString().add("XmlAccessorType");
        annotations.getString().add("XmlType");
        return annotations;
    }

    private ModifierList generateModifierList() {
        ModifierList modifierList = new ModifierList();
        modifierList.getModifier().add(Modifier.PUBLIC);
        modifierList.getModifier().add(Modifier.STATIC);
        return modifierList;
    }

    private StringList generateParameterizedTypes() {
        StringList parameterizedTypes = new StringList();
        parameterizedTypes.getString().add("String");
        parameterizedTypes.getString().add("Integer");
        return parameterizedTypes;
    }

    private JavaField generateJavaField(ArrayList<Action> actions, StringList annotations, ModifierList modifierList, StringList parameterizedTypes) {
        JavaField outputJavaFieldB = new JavaField();
        this.populateJavaField(outputJavaFieldB, annotations, modifierList, parameterizedTypes, Boolean.FALSE, Boolean.TRUE);
        this.populateJavaFieldString(outputJavaFieldB, "JavaField", "ArrayList", "getMethod", "setMethod", "foo");
        this.populateFieldComplexObject((Field)outputJavaFieldB, actions, CollectionType.ARRAY, FieldStatus.SUPPORTED, FieldType.INTEGER);
        this.populateFieldSimpleObject((Field)outputJavaFieldB, 3, "docid", "/path", false, "bar");
        return outputJavaFieldB;
    }

    private void populateJavaField(JavaField javaField, StringList annotations, ModifierList modifierList, StringList parameterizedTypes, boolean isPrimitive, boolean isSynthetic) {
        javaField.setAnnotations(annotations);
        javaField.setModifiers(modifierList);
        javaField.setParameterizedTypes(parameterizedTypes);
        javaField.setPrimitive(Boolean.valueOf(isPrimitive));
        javaField.setSynthetic(Boolean.valueOf(isSynthetic));
    }

    private void populateJavaFieldString(JavaField javaField, String className, String collectionClassName, String getMethod, String setMethod, String name) {
        javaField.setClassName(className);
        javaField.setCollectionClassName(collectionClassName);
        javaField.setGetMethod(getMethod);
        javaField.setSetMethod(setMethod);
        javaField.setName(name);
    }

    private void populateFieldComplexObject(Field field, ArrayList<Action> actions, CollectionType collectionType, FieldStatus status, FieldType type) {
        field.setActions(actions);
        field.setCollectionType(collectionType);
        field.setStatus(status);
        field.setFieldType(type);
    }

    private void populateFieldSimpleObject(Field field, int n, String docid, String path, boolean isRequired, String value) {
        field.setValue((Object)value);
        field.setIndex(Integer.valueOf(n));
        field.setArrayDimensions(Integer.valueOf(n));
        field.setArraySize(Integer.valueOf(n));
        field.setDocId(docid);
        field.setPath(path);
        field.setRequired(Boolean.valueOf(isRequired));
    }

    private ArrayList<Action> generateActions() {
        ArrayList<Action> actions = new ArrayList<Action>();
        actions.add((Action)new Camelize());
        actions.add((Action)new Capitalize());
        actions.add((Action)new Length());
        actions.add((Action)new Lowercase());
        actions.add((Action)new SeparateByDash());
        actions.add((Action)new SeparateByUnderscore());
        actions.add((Action)new Trim());
        actions.add((Action)new TrimLeft());
        actions.add((Action)new TrimRight());
        actions.add((Action)new Uppercase());
        return actions;
    }

    public MavenClasspathRequest generateMavenClasspathRequest() {
        MavenClasspathRequest mavenClasspathRequest = new MavenClasspathRequest();
        mavenClasspathRequest.setExecuteTimeout(Long.valueOf(30000L));
        mavenClasspathRequest.setPomXmlData(this.generatePomXmlAsString());
        return mavenClasspathRequest;
    }

    public ClassInspectionRequest generateClassInspectionRequest() {
        ClassInspectionRequest classInspectionRequest = new ClassInspectionRequest();
        classInspectionRequest.setClasspath("/Users/mattrpav/.m2/repository/org/twitter4j/twitter4j-core/4.0.5/twitter4j-core-4.0.5.jar");
        classInspectionRequest.setClassName("twitter4j.StatusJSONImpl");
        classInspectionRequest.setFieldNameBlacklist(new StringList());
        classInspectionRequest.getFieldNameBlacklist().getString().add("createdAt");
        return classInspectionRequest;
    }

    public String generatePomXmlAsString() {
        return new String("<project xmlns=\"http://maven.apache.org/POM/4.0.0\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://maven.apache.org/POM/4.0.0 http://maven.apache.org/xsd/maven-4.0.0.xsd\">\t<modelVersion>4.0.0</modelVersion>\t<groupId>foo.bar</groupId>\t<artifactId>test.model</artifactId>\t<version>1.10.0</version>\t<packaging>jar</packaging>\t<name>Test :: Model</name>\t<dependencies>\t\t<dependency>\t\t\t<groupId>com.fasterxml.jackson.core</groupId>\t\t\t<artifactId>jackson-annotations</artifactId>\t\t\t<version>2.8.5</version>\t\t</dependency>\t\t<dependency>]t]t]t<groupId>com.fasterxml.jackson.core</groupId>\t\t\t<artifactId>jackson-databind</artifactId>\t\t\t<version>2.8.5</version>\t\t</dependency>\t\t<dependency>\t\t\t<groupId>com.fasterxml.jackson.core</groupId>\t\t\t<artifactId>jackson-core</artifactId>\t\t\t<version>2.8.5</version>\t\t</dependency>\t</dependencies></project>");
    }

    protected void validateAtlasMapping(AtlasMapping atlasMapping) {
        Assert.assertNotNull((Object)atlasMapping);
        Assert.assertEquals((Object)"junit", (Object)atlasMapping.getName());
        Assert.assertEquals((long)2L, (long)atlasMapping.getDataSource().size());
        this.valiateDataSource((DataSource)atlasMapping.getDataSource().get(0), DataSourceType.SOURCE, "srcId", "srcUri");
        this.valiateDataSource((DataSource)atlasMapping.getDataSource().get(1), DataSourceType.TARGET, "tgtId", "tgtUri");
        Assert.assertNotNull((Object)atlasMapping.getLookupTables());
        Assert.assertEquals((long)1L, (long)atlasMapping.getLookupTables().getLookupTable().size());
        this.validateLookupTable((LookupTable)atlasMapping.getLookupTables().getLookupTable().get(0));
        Assert.assertNotNull((Object)atlasMapping.getMappings());
        Assert.assertEquals((long)1L, (long)atlasMapping.getMappings().getMapping().size());
        Mapping mapping = (Mapping)atlasMapping.getMappings().getMapping().get(0);
        Assert.assertEquals((long)1L, (long)mapping.getInputField().size());
        this.validateJavaField((JavaField)mapping.getInputField().get(0));
        Assert.assertEquals((long)1L, (long)mapping.getOutputField().size());
        this.validateJavaField((JavaField)mapping.getOutputField().get(0));
        this.validateMapping(mapping, MappingType.MAP, this.generateMappingParams());
        Assert.assertNotNull((Object)atlasMapping.getProperties());
        Assert.assertEquals((long)1L, (long)atlasMapping.getProperties().getProperty().size());
        this.validateProperty((Property)atlasMapping.getProperties().getProperty().get(0));
    }

    private Map<String, String> generateMappingParams() {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("alias", "MapPropertyFieldAlias");
        params.put("delimiter", ",");
        params.put("delimiterString", ",");
        params.put("description", "description");
        params.put("id", "id");
        params.put("lookupTableName", "lookupTableName");
        params.put("strategy", "strategy");
        params.put("strategyClassName", "strategyClassName");
        return params;
    }

    private void validateLookupTable(LookupTable lookupTable) {
        Assert.assertEquals((Object)"lookupTableDescription", (Object)lookupTable.getDescription());
        Assert.assertEquals((Object)"lookupTable", (Object)lookupTable.getName());
        Assert.assertEquals((Object)FieldType.STRING, (Object)((LookupEntry)lookupTable.getLookupEntry().get(0)).getSourceType());
        Assert.assertEquals((Object)"Foo", (Object)((LookupEntry)lookupTable.getLookupEntry().get(0)).getSourceValue());
        Assert.assertEquals((Object)FieldType.STRING, (Object)((LookupEntry)lookupTable.getLookupEntry().get(0)).getTargetType());
        Assert.assertEquals((Object)"Bar", (Object)((LookupEntry)lookupTable.getLookupEntry().get(0)).getTargetValue());
    }

    private void validateMapping(Mapping mapping, MappingType mappingType, Map<String, String> params) {
        Assert.assertEquals((Object)params.get("alias"), (Object)mapping.getAlias());
        Assert.assertEquals((Object)mappingType, (Object)mapping.getMappingType());
        Assert.assertEquals((Object)params.get("delimiter"), (Object)mapping.getDelimiter());
        Assert.assertEquals((Object)params.get("delimiterString"), (Object)mapping.getDelimiterString());
        Assert.assertEquals((Object)params.get("description"), (Object)mapping.getDescription());
        Assert.assertEquals((Object)params.get("id"), (Object)mapping.getId());
        Assert.assertEquals((Object)params.get("lookupTableName"), (Object)mapping.getLookupTableName());
        Assert.assertEquals((Object)params.get("strategy"), (Object)mapping.getStrategy());
        Assert.assertEquals((Object)params.get("strategyClassName"), (Object)mapping.getStrategyClassName());
    }

    private void validateJavaField(JavaField field) {
        Assert.assertEquals((Object)"XmlAccessorType", field.getAnnotations().getString().get(0));
        Assert.assertEquals((Object)"XmlType", field.getAnnotations().getString().get(1));
        Assert.assertEquals((Object)"JavaField", (Object)field.getClassName());
        Assert.assertEquals((Object)"ArrayList", (Object)field.getCollectionClassName());
        Assert.assertEquals((Object)"getMethod", (Object)field.getGetMethod());
        Assert.assertEquals((long)2L, (long)field.getModifiers().getModifier().size());
        Assert.assertEquals((Object)Modifier.PUBLIC, field.getModifiers().getModifier().get(0));
        Assert.assertEquals((Object)Modifier.STATIC, field.getModifiers().getModifier().get(1));
        Assert.assertEquals((Object)"foo", (Object)field.getName());
        Assert.assertEquals((Object)"String", field.getParameterizedTypes().getString().get(0));
        Assert.assertEquals((Object)"Integer", field.getParameterizedTypes().getString().get(1));
        Assert.assertEquals((Object)Boolean.FALSE, (Object)field.isPrimitive());
        Assert.assertEquals((Object)"setMethod", (Object)field.getSetMethod());
        Assert.assertEquals((Object)Boolean.TRUE, (Object)field.isSynthetic());
        this.validateField((Field)field, 10);
    }

    private void validateField(Field field, int actionSize) {
        Assert.assertEquals((long)actionSize, (long)field.getActions().size());
        Assert.assertEquals((Object)3, (Object)field.getArrayDimensions());
        Assert.assertEquals((Object)3, (Object)field.getArraySize());
        Assert.assertEquals((Object)CollectionType.ARRAY, (Object)field.getCollectionType());
        Assert.assertEquals((Object)"docid", (Object)field.getDocId());
        Assert.assertEquals((Object)FieldType.INTEGER, (Object)field.getFieldType());
        Assert.assertEquals((Object)3, (Object)field.getIndex());
        Assert.assertEquals((Object)"/path", (Object)field.getPath());
        Assert.assertEquals((Object)Boolean.FALSE, (Object)field.isRequired());
        Assert.assertEquals((Object)FieldStatus.SUPPORTED, (Object)field.getStatus());
        Assert.assertEquals((Object)"bar", (Object)field.getValue());
    }

    private void validateProperty(Property p) {
        Assert.assertEquals((Object)FieldType.INTEGER, (Object)p.getFieldType());
        Assert.assertEquals((Object)"foo", (Object)p.getName());
        Assert.assertEquals((Object)"bar", (Object)p.getValue());
    }

    protected void validateSeparateAtlasMapping(AtlasMapping atlasMapping) {
        Assert.assertNotNull((Object)atlasMapping);
        Assert.assertEquals((Object)"junit", (Object)atlasMapping.getName());
        Assert.assertEquals((long)2L, (long)atlasMapping.getDataSource().size());
        this.valiateDataSource((DataSource)atlasMapping.getDataSource().get(0), DataSourceType.SOURCE, "srcId", "srcUri");
        this.valiateDataSource((DataSource)atlasMapping.getDataSource().get(1), DataSourceType.TARGET, "tgtId", "tgtUri");
        Assert.assertNotNull((Object)atlasMapping.getLookupTables());
        Assert.assertEquals((long)1L, (long)atlasMapping.getLookupTables().getLookupTable().size());
        this.validateLookupTable((LookupTable)atlasMapping.getLookupTables().getLookupTable().get(0));
        Assert.assertNotNull((Object)atlasMapping.getMappings());
        Assert.assertEquals((long)1L, (long)atlasMapping.getMappings().getMapping().size());
        this.validateSeparateMapping((Mapping)atlasMapping.getMappings().getMapping().get(0));
        Assert.assertNotNull((Object)atlasMapping.getProperties());
        Assert.assertEquals((long)1L, (long)atlasMapping.getProperties().getProperty().size());
        this.validateProperty((Property)atlasMapping.getProperties().getProperty().get(0));
    }

    private void validateSeparateMapping(Mapping mapping) {
        Assert.assertEquals((long)1L, (long)mapping.getInputField().size());
        this.validateJavaField((JavaField)mapping.getInputField().get(0));
        Assert.assertEquals((long)2L, (long)mapping.getOutputField().size());
        this.validateJavaField((JavaField)mapping.getOutputField().get(0));
        if (mapping.getOutputField().size() > 1) {
            this.validateJavaField((JavaField)mapping.getOutputField().get(1));
        }
        this.validateMapping(mapping, MappingType.SEPARATE, this.generateMappingParams());
    }

    protected void validateCombineAtlasMapping(AtlasMapping atlasMapping) {
        Assert.assertNotNull((Object)atlasMapping);
        Assert.assertEquals((Object)"junit", (Object)atlasMapping.getName());
        Assert.assertEquals((long)2L, (long)atlasMapping.getDataSource().size());
        this.valiateDataSource((DataSource)atlasMapping.getDataSource().get(0), DataSourceType.SOURCE, "srcId", "srcUri");
        this.valiateDataSource((DataSource)atlasMapping.getDataSource().get(1), DataSourceType.TARGET, "tgtId", "tgtUri");
        Assert.assertNotNull((Object)atlasMapping.getLookupTables());
        Assert.assertEquals((long)1L, (long)atlasMapping.getLookupTables().getLookupTable().size());
        this.validateLookupTable((LookupTable)atlasMapping.getLookupTables().getLookupTable().get(0));
        Assert.assertNotNull((Object)atlasMapping.getMappings());
        Assert.assertEquals((long)1L, (long)atlasMapping.getMappings().getMapping().size());
        this.validateCombineMapping((Mapping)atlasMapping.getMappings().getMapping().get(0));
        Assert.assertNotNull((Object)atlasMapping.getProperties());
        Assert.assertEquals((long)1L, (long)atlasMapping.getProperties().getProperty().size());
        this.validateProperty((Property)atlasMapping.getProperties().getProperty().get(0));
    }

    private void validateCombineMapping(Mapping mapping) {
        Assert.assertEquals((long)2L, (long)mapping.getInputField().size());
        this.validateJavaField((JavaField)mapping.getInputField().get(0));
        this.validateJavaField((JavaField)mapping.getInputField().get(1));
        Assert.assertEquals((long)1L, (long)mapping.getOutputField().size());
        this.validateJavaField((JavaField)mapping.getOutputField().get(0));
        this.validateMapping(mapping, MappingType.COMBINE, this.generateMappingParams());
    }

    protected void validatePropertyAtlasMapping(AtlasMapping atlasMapping) {
        Assert.assertNotNull((Object)atlasMapping);
        Assert.assertEquals((Object)"junit", (Object)atlasMapping.getName());
        Assert.assertEquals((long)2L, (long)atlasMapping.getDataSource().size());
        this.valiateDataSource((DataSource)atlasMapping.getDataSource().get(0), DataSourceType.SOURCE, "srcId", "srcUri");
        this.valiateDataSource((DataSource)atlasMapping.getDataSource().get(1), DataSourceType.TARGET, "tgtId", "tgtUri");
        Assert.assertNotNull((Object)atlasMapping.getLookupTables());
        Assert.assertEquals((long)1L, (long)atlasMapping.getLookupTables().getLookupTable().size());
        this.validateLookupTable((LookupTable)atlasMapping.getLookupTables().getLookupTable().get(0));
        Assert.assertNotNull((Object)atlasMapping.getMappings());
        Assert.assertEquals((long)1L, (long)atlasMapping.getMappings().getMapping().size());
        this.validatePropertyMapping((Mapping)atlasMapping.getMappings().getMapping().get(0));
        Assert.assertNotNull((Object)atlasMapping.getProperties());
        Assert.assertEquals((long)1L, (long)atlasMapping.getProperties().getProperty().size());
        this.validateProperty((Property)atlasMapping.getProperties().getProperty().get(0));
    }

    private void validatePropertyMapping(Mapping mapping) {
        Assert.assertEquals((long)2L, (long)mapping.getInputField().size());
        this.validateJavaField((JavaField)mapping.getInputField().get(0));
        this.validatePropertyField((PropertyField)mapping.getInputField().get(1));
        Assert.assertEquals((long)2L, (long)mapping.getOutputField().size());
        this.validateJavaField((JavaField)mapping.getOutputField().get(0));
        this.validatePropertyField((PropertyField)mapping.getOutputField().get(1));
        this.validateMapping(mapping, MappingType.MAP, this.generateMappingParams());
    }

    private void validatePropertyField(PropertyField field) {
        Assert.assertEquals((Object)"foo", (Object)field.getName());
        this.validateField((Field)field, 1);
    }

    protected void validateConstantAtlasMapping(AtlasMapping atlasMapping) {
        Assert.assertNotNull((Object)atlasMapping);
        Assert.assertEquals((Object)"junit", (Object)atlasMapping.getName());
        Assert.assertEquals((long)2L, (long)atlasMapping.getDataSource().size());
        this.valiateDataSource((DataSource)atlasMapping.getDataSource().get(0), DataSourceType.SOURCE, "srcId", "srcUri");
        this.valiateDataSource((DataSource)atlasMapping.getDataSource().get(1), DataSourceType.TARGET, "tgtId", "tgtUri");
        Assert.assertNotNull((Object)atlasMapping.getLookupTables());
        Assert.assertEquals((long)1L, (long)atlasMapping.getLookupTables().getLookupTable().size());
        this.validateLookupTable((LookupTable)atlasMapping.getLookupTables().getLookupTable().get(0));
        Assert.assertNotNull((Object)atlasMapping.getMappings());
        Assert.assertEquals((long)1L, (long)atlasMapping.getMappings().getMapping().size());
        this.validateConstantMapping((Mapping)atlasMapping.getMappings().getMapping().get(0));
        Assert.assertNotNull((Object)atlasMapping.getProperties());
        Assert.assertEquals((long)1L, (long)atlasMapping.getProperties().getProperty().size());
        this.validateProperty((Property)atlasMapping.getProperties().getProperty().get(0));
    }

    private void validateConstantMapping(Mapping mapping) {
        Assert.assertEquals((long)2L, (long)mapping.getInputField().size());
        this.validateJavaField((JavaField)mapping.getInputField().get(0));
        this.validateField((Field)mapping.getInputField().get(1), 1);
        Assert.assertEquals((long)2L, (long)mapping.getOutputField().size());
        this.validateJavaField((JavaField)mapping.getOutputField().get(0));
        this.validateField((Field)mapping.getOutputField().get(1), 1);
        this.validateMapping(mapping, MappingType.MAP, this.generateMappingParams());
    }

    protected void validateMultisourceAtlasMapping(AtlasMapping atlasMapping) {
        Assert.assertNotNull((Object)atlasMapping);
        Assert.assertEquals((Object)"junit", (Object)atlasMapping.getName());
        Assert.assertEquals((long)5L, (long)atlasMapping.getDataSource().size());
        this.valiateDataSource((DataSource)atlasMapping.getDataSource().get(0), DataSourceType.SOURCE, "srcId", "srcUri");
        this.valiateDataSource((DataSource)atlasMapping.getDataSource().get(1), DataSourceType.TARGET, "tgtId", "tgtUri");
        this.valiateDataSource((DataSource)atlasMapping.getDataSource().get(2), DataSourceType.SOURCE, "srcId", "srcUri");
        this.valiateDataSource((DataSource)atlasMapping.getDataSource().get(3), DataSourceType.TARGET, "tgtId", "tgtUri");
        this.valiateDataSource((DataSource)atlasMapping.getDataSource().get(4), DataSourceType.TARGET, "tgtId", "tgtUri");
        Assert.assertNotNull((Object)atlasMapping.getLookupTables());
        Assert.assertEquals((long)1L, (long)atlasMapping.getLookupTables().getLookupTable().size());
        this.validateLookupTable((LookupTable)atlasMapping.getLookupTables().getLookupTable().get(0));
        Assert.assertNotNull((Object)atlasMapping.getMappings());
        Assert.assertEquals((long)1L, (long)atlasMapping.getMappings().getMapping().size());
        this.validateMultisourceMapping((Mapping)atlasMapping.getMappings().getMapping().get(0));
        Assert.assertNotNull((Object)atlasMapping.getProperties());
        Assert.assertEquals((long)1L, (long)atlasMapping.getProperties().getProperty().size());
        this.validateProperty((Property)atlasMapping.getProperties().getProperty().get(0));
    }

    private void valiateDataSource(DataSource dataSource, DataSourceType dataSourceType, String id, String uri) {
        Assert.assertEquals((Object)dataSourceType, (Object)dataSource.getDataSourceType());
        Assert.assertEquals((Object)id, (Object)dataSource.getId());
        Assert.assertEquals((Object)uri, (Object)dataSource.getUri());
    }

    private void validateMultisourceMapping(Mapping mapping) {
        Assert.assertEquals((long)1L, (long)mapping.getInputField().size());
        this.validateJavaField((JavaField)mapping.getInputField().get(0));
        Assert.assertEquals((long)2L, (long)mapping.getOutputField().size());
        this.validateJavaField((JavaField)mapping.getOutputField().get(0));
        this.validateJavaField((JavaField)mapping.getOutputField().get(1));
        this.validateMapping(mapping, MappingType.MAP, this.generateMappingParams());
    }

    protected void validateCollectionAtlasMapping(AtlasMapping atlasMapping) {
        Assert.assertNotNull((Object)atlasMapping);
        Assert.assertEquals((Object)"junit", (Object)atlasMapping.getName());
        Assert.assertEquals((long)2L, (long)atlasMapping.getDataSource().size());
        this.valiateDataSource((DataSource)atlasMapping.getDataSource().get(0), DataSourceType.SOURCE, "srcId", "srcUri");
        this.valiateDataSource((DataSource)atlasMapping.getDataSource().get(1), DataSourceType.TARGET, "tgtId", "tgtUri");
        Assert.assertNotNull((Object)atlasMapping.getLookupTables());
        Assert.assertEquals((long)1L, (long)atlasMapping.getLookupTables().getLookupTable().size());
        this.validateLookupTable((LookupTable)atlasMapping.getLookupTables().getLookupTable().get(0));
        Assert.assertNotNull((Object)atlasMapping.getMappings());
        Assert.assertEquals((long)1L, (long)atlasMapping.getMappings().getMapping().size());
        this.validateCollectionMapping((Collection)atlasMapping.getMappings().getMapping().get(0));
        Assert.assertNotNull((Object)atlasMapping.getProperties());
        Assert.assertEquals((long)1L, (long)atlasMapping.getProperties().getProperty().size());
        this.validateProperty((Property)atlasMapping.getProperties().getProperty().get(0));
    }

    private void validateCollectionMapping(Collection collection) {
        Assert.assertEquals((Object)new BigInteger("2"), (Object)collection.getCollectionSize());
        Assert.assertEquals((Object)CollectionType.LIST, (Object)collection.getCollectionType());
        Mapping mapping = (Mapping)collection.getMappings().getMapping().get(0);
        Assert.assertEquals((long)1L, (long)mapping.getInputField().size());
        this.validateJavaField((JavaField)mapping.getInputField().get(0));
        Assert.assertEquals((long)1L, (long)mapping.getOutputField().size());
        this.validateJavaField((JavaField)mapping.getOutputField().get(0));
        this.validateMapping(mapping, MappingType.MAP, this.generateMappingParams());
        mapping = (Mapping)collection.getMappings().getMapping().get(1);
        Assert.assertEquals((long)1L, (long)mapping.getInputField().size());
        this.validateJavaField((JavaField)mapping.getInputField().get(0));
        Assert.assertEquals((long)1L, (long)mapping.getOutputField().size());
        this.validateJavaField((JavaField)mapping.getOutputField().get(0));
        this.validateMapping(mapping, MappingType.MAP, this.generateMappingParams());
    }
}

