/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.json.inspect;

import io.atlasmap.json.inspect.JsonDocumentInspectionService;
import io.atlasmap.json.inspect.JsonInspectionException;
import io.atlasmap.json.v2.JsonComplexType;
import io.atlasmap.json.v2.JsonDocument;
import io.atlasmap.json.v2.JsonField;
import io.atlasmap.v2.CollectionType;
import io.atlasmap.v2.Field;
import io.atlasmap.v2.FieldStatus;
import io.atlasmap.v2.FieldType;
import io.atlasmap.v2.Fields;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Test;

public class JsonDocumentInspectionServiceTest {
    private final JsonDocumentInspectionService inspectionService = new JsonDocumentInspectionService();

    @Test(expected=IllegalArgumentException.class)
    public void inspectJsonDocumentEmpty() throws Exception {
        String instance = "";
        this.inspectionService.inspectJsonDocument("");
    }

    @Test(expected=IllegalArgumentException.class)
    public void inspectJsonDocumentWhitespaceOnly() throws Exception {
        String instance = " ";
        this.inspectionService.inspectJsonDocument(" ");
    }

    @Test(expected=IllegalArgumentException.class)
    public void inspectJsonDocumentNull() throws Exception {
        String instance = null;
        this.inspectionService.inspectJsonDocument(instance);
    }

    @Test(expected=JsonInspectionException.class)
    public void inspectJsonDocumentUnparseableHighlyComplexNestedObject() throws Exception {
        String instance = new String(Files.readAllBytes(Paths.get("src/test/resources/inspect/unparseable-highly-complex-nested-object.json", new String[0])));
        this.inspectionService.inspectJsonDocument(instance);
    }

    @Test(expected=JsonInspectionException.class)
    public void inspectJsonDocumentUnparseableMissingOpenCurly() throws Exception {
        String instance = "\"ads\":[{\"id_ad\":\"20439\"}, {\"id_ad\":\"20449\"}]}";
        this.inspectionService.inspectJsonDocument("\"ads\":[{\"id_ad\":\"20439\"}, {\"id_ad\":\"20449\"}]}");
    }

    @Test(expected=JsonInspectionException.class)
    public void inspectJsonDocumentUnparseableMissingClosingCurly() throws Exception {
        String instance = "{\"ads\":[{\"id_ad\":\"20439\"}, {\"id_ad\":\"20449\"}]";
        this.inspectionService.inspectJsonDocument("{\"ads\":[{\"id_ad\":\"20439\"}, {\"id_ad\":\"20449\"}]");
    }

    @Test(expected=JsonInspectionException.class)
    public void inspectJsonDocumentUnparseableMissingKeySeperator() throws Exception {
        String instance = "{\"ads\"[{\"id_ad\":\"20439\"}, {\"id_ad\":\"20449\"}]";
        this.inspectionService.inspectJsonDocument("{\"ads\"[{\"id_ad\":\"20439\"}, {\"id_ad\":\"20449\"}]");
    }

    @Test(expected=JsonInspectionException.class)
    public void inspectJsonDocumentUnparseableMissingValueSeperator() throws Exception {
        String instance = "{\"id_ad\":\"20439\" \"id_ad\":\"20449\"}";
        this.inspectionService.inspectJsonDocument("{\"id_ad\":\"20439\" \"id_ad\":\"20449\"}");
    }

    @Test
    public void inspectJsonDocumentEmptyDocument() throws Exception {
        String instance = "{}";
        JsonDocument document = this.inspectionService.inspectJsonDocument("{}");
        Assert.assertNotNull((Object)document);
        Assert.assertThat((Object)document.getFields().getField().size(), (Matcher)Is.is((Object)0));
    }

    @Test
    public void inspectJsonDocumentSimpleArray() throws Exception {
        String instance = "[ 100, 500, 300, 200, 400 ]";
        JsonDocument document = this.inspectionService.inspectJsonDocument("[ 100, 500, 300, 200, 400 ]");
        Assert.assertNotNull((Object)document);
        Assert.assertThat((Object)1, (Matcher)Is.is((Object)document.getFields().getField().size()));
        JsonField jsonField = (JsonField)document.getFields().getField().get(0);
        Assert.assertTrue((jsonField.getStatus().compareTo((Enum)FieldStatus.UNSUPPORTED) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((jsonField.getCollectionType().compareTo((Enum)CollectionType.ARRAY) == 0 ? 1 : 0) != 0);
        Assert.assertNull((Object)jsonField.getFieldType());
        Assert.assertNull((Object)jsonField.getName());
        Assert.assertNull((Object)jsonField.getPath());
    }

    @Test
    public void inspectJsonDocumentSimpleArrayStartsWithWhiteSpace() throws Exception {
        String instance = "\n\t\r [ 100, 500, 300, 200, 400 ]";
        JsonDocument document = this.inspectionService.inspectJsonDocument("\n\t\r [ 100, 500, 300, 200, 400 ]");
        Assert.assertNotNull((Object)document);
        Assert.assertThat((Object)1, (Matcher)Is.is((Object)document.getFields().getField().size()));
        JsonField jsonField = (JsonField)document.getFields().getField().get(0);
        Assert.assertTrue((jsonField.getStatus().compareTo((Enum)FieldStatus.UNSUPPORTED) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((jsonField.getCollectionType().compareTo((Enum)CollectionType.ARRAY) == 0 ? 1 : 0) != 0);
        Assert.assertNull((Object)jsonField.getFieldType());
        Assert.assertNull((Object)jsonField.getName());
        Assert.assertNull((Object)jsonField.getPath());
    }

    @Test
    public void inspectJsonDocumentSimpleObjectArray() throws Exception {
        String instance = "[\n\t{\n\t\t\"color\": \"red\",\n\t\t\"value\": \"#f00\"\n\t},\n\t{\n\t\t\"color\": \"green\",\n\t\t\"value\": \"#0f0\"\n\t},\n\t{\n\t\t\"color\": \"blue\",\n\t\t\"value\": \"#00f\"\n\t}]";
        JsonDocument document = this.inspectionService.inspectJsonDocument("[\n\t{\n\t\t\"color\": \"red\",\n\t\t\"value\": \"#f00\"\n\t},\n\t{\n\t\t\"color\": \"green\",\n\t\t\"value\": \"#0f0\"\n\t},\n\t{\n\t\t\"color\": \"blue\",\n\t\t\"value\": \"#00f\"\n\t}]");
        Assert.assertNotNull((Object)document);
        Assert.assertThat((Object)1, (Matcher)Is.is((Object)document.getFields().getField().size()));
        JsonField jsonField = (JsonField)document.getFields().getField().get(0);
        Assert.assertTrue((jsonField.getStatus().compareTo((Enum)FieldStatus.UNSUPPORTED) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((jsonField.getCollectionType().compareTo((Enum)CollectionType.ARRAY) == 0 ? 1 : 0) != 0);
        Assert.assertNull((Object)jsonField.getFieldType());
        Assert.assertNull((Object)jsonField.getName());
        Assert.assertNull((Object)jsonField.getPath());
    }

    @Test
    public void inspectJsonDocumentArrayHighlyNestedObjects() throws Exception {
        String instance = new String(Files.readAllBytes(Paths.get("src/test/resources/inspect/array-highly-nested-objects.json", new String[0])));
        JsonDocument document = this.inspectionService.inspectJsonDocument(instance);
        Assert.assertNotNull((Object)document);
        Assert.assertThat((Object)document.getFields().getField().size(), (Matcher)Is.is((Object)1));
        JsonField jsonField = (JsonField)document.getFields().getField().get(0);
        Assert.assertTrue((jsonField.getStatus().compareTo((Enum)FieldStatus.UNSUPPORTED) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((jsonField.getCollectionType().compareTo((Enum)CollectionType.ARRAY) == 0 ? 1 : 0) != 0);
    }

    @Test
    public void inspectJsonDocumentEscapedCharsInKeys() throws Exception {
        String instance = new String(Files.readAllBytes(Paths.get("src/test/resources/inspect/keys-with-escaped-characters.json", new String[0])));
        JsonDocument document = this.inspectionService.inspectJsonDocument(instance);
        Assert.assertNotNull((Object)document);
        Assert.assertThat((Object)document.getFields().getField().size(), (Matcher)Is.is((Object)7));
        for (int i = 0; i < document.getFields().getField().size(); ++i) {
            JsonField field = (JsonField)document.getFields().getField().get(i);
            if (i == 0) {
                Assert.assertThat((Object)field.getName(), (Matcher)Is.is((Object)"'booleanField'"));
                Assert.assertThat((Object)field.getValue(), (Matcher)Is.is((Object)false));
                Assert.assertThat((Object)field.getPath(), (Matcher)Is.is((Object)"/".concat(field.getName())));
                Assert.assertThat((Object)field.getFieldType(), (Matcher)Is.is((Object)FieldType.BOOLEAN));
                Assert.assertThat((Object)field.getStatus(), (Matcher)Is.is((Object)FieldStatus.SUPPORTED));
                continue;
            }
            if (i == 1) {
                Assert.assertThat((Object)field.getName(), (Matcher)Is.is((Object)"\"charField\""));
                Assert.assertThat((Object)field.getValue(), (Matcher)Is.is((Object)"a"));
                Assert.assertThat((Object)field.getPath(), (Matcher)Is.is((Object)"/".concat(field.getName())));
                Assert.assertThat((Object)field.getFieldType(), (Matcher)Is.is((Object)FieldType.STRING));
                Assert.assertThat((Object)field.getStatus(), (Matcher)Is.is((Object)FieldStatus.SUPPORTED));
                continue;
            }
            if (i == 2) {
                Assert.assertThat((Object)field.getName(), (Matcher)Is.is((Object)"\\doubleField"));
                Assert.assertThat((Object)field.getValue(), (Matcher)Is.is((Object)-2.71527453422E7));
                Assert.assertThat((Object)field.getPath(), (Matcher)Is.is((Object)"/".concat(field.getName())));
                Assert.assertThat((Object)field.getFieldType(), (Matcher)Is.is((Object)FieldType.DOUBLE));
                Assert.assertThat((Object)field.getStatus(), (Matcher)Is.is((Object)FieldStatus.SUPPORTED));
                continue;
            }
            if (i == 3) {
                Assert.assertThat((Object)field.getName(), (Matcher)Is.is((Object)"floatField\t"));
                Assert.assertThat((Object)field.getValue(), (Matcher)Is.is((Object)-6.3988281E7));
                Assert.assertThat((Object)field.getPath(), (Matcher)Is.is((Object)"/".concat(field.getName())));
                Assert.assertThat((Object)field.getFieldType(), (Matcher)Is.is((Object)FieldType.DOUBLE));
                Assert.assertThat((Object)field.getStatus(), (Matcher)Is.is((Object)FieldStatus.SUPPORTED));
                continue;
            }
            if (i == 4) {
                Assert.assertThat((Object)field.getName(), (Matcher)Is.is((Object)"intField\n"));
                Assert.assertThat((Object)field.getValue(), (Matcher)Is.is((Object)8281));
                Assert.assertThat((Object)field.getPath(), (Matcher)Is.is((Object)"/".concat(field.getName())));
                Assert.assertThat((Object)field.getFieldType(), (Matcher)Is.is((Object)FieldType.INTEGER));
                Assert.assertThat((Object)field.getStatus(), (Matcher)Is.is((Object)FieldStatus.SUPPORTED));
                continue;
            }
            if (i == 5) {
                Assert.assertThat((Object)field.getName(), (Matcher)Is.is((Object)"shortField"));
                Assert.assertThat((Object)field.getValue(), (Matcher)Is.is((Object)81));
                Assert.assertThat((Object)field.getPath(), (Matcher)Is.is((Object)"/".concat(field.getName())));
                Assert.assertThat((Object)field.getFieldType(), (Matcher)Is.is((Object)FieldType.INTEGER));
                Assert.assertThat((Object)field.getStatus(), (Matcher)Is.is((Object)FieldStatus.SUPPORTED));
                continue;
            }
            if (i != 6) continue;
            Assert.assertThat((Object)field.getName(), (Matcher)Is.is((Object)"longField"));
            Assert.assertThat((Object)field.getValue(), (Matcher)Is.is((Object)3988281));
            Assert.assertThat((Object)field.getPath(), (Matcher)Is.is((Object)"/".concat(field.getName())));
            Assert.assertThat((Object)field.getFieldType(), (Matcher)Is.is((Object)FieldType.INTEGER));
            Assert.assertThat((Object)field.getStatus(), (Matcher)Is.is((Object)FieldStatus.SUPPORTED));
        }
    }

    @Test
    public void inspectJsonDocumentEscapedCharsInValue() throws Exception {
        String instance = new String(Files.readAllBytes(Paths.get("src/test/resources/inspect/value-with-escaped-characters.json", new String[0])));
        JsonDocument document = this.inspectionService.inspectJsonDocument(instance);
        Assert.assertNotNull((Object)document);
        Assert.assertThat((Object)document.getFields().getField().size(), (Matcher)Is.is((Object)5));
        for (int i = 0; i < document.getFields().getField().size(); ++i) {
            JsonField field = (JsonField)document.getFields().getField().get(i);
            if (i == 0) {
                Assert.assertThat((Object)field.getName(), (Matcher)Is.is((Object)"quote"));
                Assert.assertThat((Object)field.getValue(), (Matcher)Is.is((Object)"\"yadda\""));
                Assert.assertThat((Object)field.getPath(), (Matcher)Is.is((Object)"/".concat(field.getName())));
                Assert.assertThat((Object)field.getFieldType(), (Matcher)Is.is((Object)FieldType.STRING));
                Assert.assertThat((Object)field.getStatus(), (Matcher)Is.is((Object)FieldStatus.SUPPORTED));
                continue;
            }
            if (i == 1) {
                Assert.assertThat((Object)field.getName(), (Matcher)Is.is((Object)"singlequote"));
                Assert.assertThat((Object)field.getValue(), (Matcher)Is.is((Object)"'a'"));
                Assert.assertThat((Object)field.getPath(), (Matcher)Is.is((Object)"/".concat(field.getName())));
                Assert.assertThat((Object)field.getFieldType(), (Matcher)Is.is((Object)FieldType.STRING));
                Assert.assertThat((Object)field.getStatus(), (Matcher)Is.is((Object)FieldStatus.SUPPORTED));
                continue;
            }
            if (i == 2) {
                Assert.assertThat((Object)field.getName(), (Matcher)Is.is((Object)"backslash"));
                Assert.assertThat((Object)field.getValue(), (Matcher)Is.is((Object)"\\qwerty"));
                Assert.assertThat((Object)field.getPath(), (Matcher)Is.is((Object)"/".concat(field.getName())));
                Assert.assertThat((Object)field.getFieldType(), (Matcher)Is.is((Object)FieldType.STRING));
                Assert.assertThat((Object)field.getStatus(), (Matcher)Is.is((Object)FieldStatus.SUPPORTED));
                continue;
            }
            if (i == 3) {
                Assert.assertThat((Object)field.getName(), (Matcher)Is.is((Object)"tab"));
                Assert.assertThat((Object)field.getValue(), (Matcher)Is.is((Object)"foo\t"));
                Assert.assertThat((Object)field.getPath(), (Matcher)Is.is((Object)"/".concat(field.getName())));
                Assert.assertThat((Object)field.getFieldType(), (Matcher)Is.is((Object)FieldType.STRING));
                Assert.assertThat((Object)field.getStatus(), (Matcher)Is.is((Object)FieldStatus.SUPPORTED));
                continue;
            }
            if (i != 4) continue;
            Assert.assertThat((Object)field.getName(), (Matcher)Is.is((Object)"linefeed"));
            Assert.assertThat((Object)field.getValue(), (Matcher)Is.is((Object)"bar\n"));
            Assert.assertThat((Object)field.getPath(), (Matcher)Is.is((Object)"/".concat(field.getName())));
            Assert.assertThat((Object)field.getFieldType(), (Matcher)Is.is((Object)FieldType.STRING));
            Assert.assertThat((Object)field.getStatus(), (Matcher)Is.is((Object)FieldStatus.SUPPORTED));
        }
    }

    @Test
    public void inspectFlatPrimitiveNoRoot() throws Exception {
        String instance = new String(Files.readAllBytes(Paths.get("src/test/resources/inspect/flatprimitive-base-unrooted.json", new String[0])));
        JsonDocument document = this.inspectionService.inspectJsonDocument(instance);
        Assert.assertNotNull((Object)document);
        Assert.assertThat((Object)document.getFields().getField().size(), (Matcher)Is.is((Object)7));
        for (int i = 0; i < document.getFields().getField().size(); ++i) {
            JsonField field = (JsonField)document.getFields().getField().get(i);
            if (i == 0) {
                Assert.assertThat((Object)field.getName(), (Matcher)Is.is((Object)"booleanField"));
                Assert.assertThat((Object)field.getValue(), (Matcher)Is.is((Object)false));
                Assert.assertThat((Object)field.getPath(), (Matcher)Is.is((Object)"/".concat(field.getName())));
                Assert.assertThat((Object)field.getFieldType(), (Matcher)Is.is((Object)FieldType.BOOLEAN));
                Assert.assertThat((Object)field.getStatus(), (Matcher)Is.is((Object)FieldStatus.SUPPORTED));
                continue;
            }
            if (i == 1) {
                Assert.assertThat((Object)field.getName(), (Matcher)Is.is((Object)"charField"));
                Assert.assertThat((Object)field.getValue(), (Matcher)Is.is((Object)"a"));
                Assert.assertThat((Object)field.getPath(), (Matcher)Is.is((Object)"/".concat(field.getName())));
                Assert.assertThat((Object)field.getFieldType(), (Matcher)Is.is((Object)FieldType.STRING));
                Assert.assertThat((Object)field.getStatus(), (Matcher)Is.is((Object)FieldStatus.SUPPORTED));
                continue;
            }
            if (i == 2) {
                Assert.assertThat((Object)field.getName(), (Matcher)Is.is((Object)"doubleField"));
                Assert.assertThat((Object)field.getValue(), (Matcher)Is.is((Object)-2.71527453422E7));
                Assert.assertThat((Object)field.getPath(), (Matcher)Is.is((Object)"/".concat(field.getName())));
                Assert.assertThat((Object)field.getFieldType(), (Matcher)Is.is((Object)FieldType.DOUBLE));
                Assert.assertThat((Object)field.getStatus(), (Matcher)Is.is((Object)FieldStatus.SUPPORTED));
                continue;
            }
            if (i == 3) {
                Assert.assertThat((Object)field.getName(), (Matcher)Is.is((Object)"floatField"));
                Assert.assertThat((Object)field.getValue(), (Matcher)Is.is((Object)-6.3988281E7));
                Assert.assertThat((Object)field.getPath(), (Matcher)Is.is((Object)"/".concat(field.getName())));
                Assert.assertThat((Object)field.getFieldType(), (Matcher)Is.is((Object)FieldType.DOUBLE));
                Assert.assertThat((Object)field.getStatus(), (Matcher)Is.is((Object)FieldStatus.SUPPORTED));
                continue;
            }
            if (i == 4) {
                Assert.assertThat((Object)field.getName(), (Matcher)Is.is((Object)"intField"));
                Assert.assertThat((Object)field.getValue(), (Matcher)Is.is((Object)8281));
                Assert.assertThat((Object)field.getPath(), (Matcher)Is.is((Object)"/".concat(field.getName())));
                Assert.assertThat((Object)field.getFieldType(), (Matcher)Is.is((Object)FieldType.INTEGER));
                Assert.assertThat((Object)field.getStatus(), (Matcher)Is.is((Object)FieldStatus.SUPPORTED));
                continue;
            }
            if (i == 5) {
                Assert.assertThat((Object)field.getName(), (Matcher)Is.is((Object)"shortField"));
                Assert.assertThat((Object)field.getValue(), (Matcher)Is.is((Object)81));
                Assert.assertThat((Object)field.getPath(), (Matcher)Is.is((Object)"/".concat(field.getName())));
                Assert.assertThat((Object)field.getFieldType(), (Matcher)Is.is((Object)FieldType.INTEGER));
                Assert.assertThat((Object)field.getStatus(), (Matcher)Is.is((Object)FieldStatus.SUPPORTED));
                continue;
            }
            if (i != 6) continue;
            Assert.assertThat((Object)field.getName(), (Matcher)Is.is((Object)"longField"));
            Assert.assertThat((Object)field.getValue(), (Matcher)Is.is((Object)3988281));
            Assert.assertThat((Object)field.getPath(), (Matcher)Is.is((Object)"/".concat(field.getName())));
            Assert.assertThat((Object)field.getFieldType(), (Matcher)Is.is((Object)FieldType.INTEGER));
            Assert.assertThat((Object)field.getStatus(), (Matcher)Is.is((Object)FieldStatus.SUPPORTED));
        }
    }

    @Test
    public void inspectFlatPrimitiveWithRoot() throws Exception {
        String instance = new String(Files.readAllBytes(Paths.get("src/test/resources/inspect/flatprimitive-base-rooted.json", new String[0])));
        JsonDocument document = this.inspectionService.inspectJsonDocument(instance);
        Assert.assertNotNull((Object)document);
        Assert.assertThat((Object)document.getFields().getField().size(), (Matcher)Is.is((Object)1));
        JsonComplexType root = (JsonComplexType)document.getFields().getField().get(0);
        Assert.assertNotNull((Object)root);
        Assert.assertThat((Object)root.getName(), (Matcher)Is.is((Object)"SourceFlatPrimitive"));
        Assert.assertThat((Object)root.getPath(), (Matcher)Is.is((Object)"/SourceFlatPrimitive"));
        Assert.assertThat((Object)root.getFieldType(), (Matcher)Is.is((Object)FieldType.COMPLEX));
        Assert.assertThat((Object)root.getStatus(), (Matcher)Is.is((Object)FieldStatus.SUPPORTED));
        Assert.assertThat((Object)root.getJsonFields().getJsonField().size(), (Matcher)Is.is((Object)8));
        for (int i = 0; i < root.getJsonFields().getJsonField().size(); ++i) {
            JsonField field = (JsonField)root.getJsonFields().getJsonField().get(i);
            if (i == 0) {
                Assert.assertThat((Object)field.getName(), (Matcher)Is.is((Object)"booleanField"));
                Assert.assertThat((Object)field.getValue(), (Matcher)Is.is((Object)false));
                Assert.assertThat((Object)field.getPath(), (Matcher)Is.is((Object)"/SourceFlatPrimitive/".concat(field.getName())));
                Assert.assertThat((Object)field.getFieldType(), (Matcher)Is.is((Object)FieldType.BOOLEAN));
                Assert.assertThat((Object)field.getStatus(), (Matcher)Is.is((Object)FieldStatus.SUPPORTED));
                continue;
            }
            if (i == 1) {
                Assert.assertThat((Object)field.getName(), (Matcher)Is.is((Object)"charField"));
                Assert.assertThat((Object)field.getValue(), (Matcher)Is.is((Object)"a"));
                Assert.assertThat((Object)field.getPath(), (Matcher)Is.is((Object)"/SourceFlatPrimitive/".concat(field.getName())));
                Assert.assertThat((Object)field.getFieldType(), (Matcher)Is.is((Object)FieldType.STRING));
                Assert.assertThat((Object)field.getStatus(), (Matcher)Is.is((Object)FieldStatus.SUPPORTED));
                continue;
            }
            if (i == 2) {
                Assert.assertThat((Object)field.getName(), (Matcher)Is.is((Object)"doubleField"));
                Assert.assertThat((Object)field.getValue(), (Matcher)Is.is((Object)-2.71527453422E7));
                Assert.assertThat((Object)field.getPath(), (Matcher)Is.is((Object)"/SourceFlatPrimitive/".concat(field.getName())));
                Assert.assertThat((Object)field.getFieldType(), (Matcher)Is.is((Object)FieldType.DOUBLE));
                Assert.assertThat((Object)field.getStatus(), (Matcher)Is.is((Object)FieldStatus.SUPPORTED));
                continue;
            }
            if (i == 3) {
                Assert.assertThat((Object)field.getName(), (Matcher)Is.is((Object)"floatField"));
                Assert.assertThat((Object)field.getValue(), (Matcher)Is.is((Object)-6.3988281E7));
                Assert.assertThat((Object)field.getPath(), (Matcher)Is.is((Object)"/SourceFlatPrimitive/".concat(field.getName())));
                Assert.assertThat((Object)field.getFieldType(), (Matcher)Is.is((Object)FieldType.DOUBLE));
                Assert.assertThat((Object)field.getStatus(), (Matcher)Is.is((Object)FieldStatus.SUPPORTED));
                continue;
            }
            if (i == 4) {
                Assert.assertThat((Object)field.getName(), (Matcher)Is.is((Object)"intField"));
                Assert.assertThat((Object)field.getValue(), (Matcher)Is.is((Object)8281));
                Assert.assertThat((Object)field.getPath(), (Matcher)Is.is((Object)"/SourceFlatPrimitive/".concat(field.getName())));
                Assert.assertThat((Object)field.getFieldType(), (Matcher)Is.is((Object)FieldType.INTEGER));
                Assert.assertThat((Object)field.getStatus(), (Matcher)Is.is((Object)FieldStatus.SUPPORTED));
                continue;
            }
            if (i == 5) {
                Assert.assertThat((Object)field.getName(), (Matcher)Is.is((Object)"shortField"));
                Assert.assertThat((Object)field.getValue(), (Matcher)Is.is((Object)81));
                Assert.assertThat((Object)field.getPath(), (Matcher)Is.is((Object)"/SourceFlatPrimitive/".concat(field.getName())));
                Assert.assertThat((Object)field.getFieldType(), (Matcher)Is.is((Object)FieldType.INTEGER));
                Assert.assertThat((Object)field.getStatus(), (Matcher)Is.is((Object)FieldStatus.SUPPORTED));
                continue;
            }
            if (i != 6) continue;
            Assert.assertThat((Object)field.getName(), (Matcher)Is.is((Object)"longField"));
            Assert.assertThat((Object)field.getValue(), (Matcher)Is.is((Object)3988281));
            Assert.assertThat((Object)field.getPath(), (Matcher)Is.is((Object)"/SourceFlatPrimitive/".concat(field.getName())));
            Assert.assertThat((Object)field.getFieldType(), (Matcher)Is.is((Object)FieldType.INTEGER));
            Assert.assertThat((Object)field.getStatus(), (Matcher)Is.is((Object)FieldStatus.SUPPORTED));
        }
    }

    @Test
    public void inspectComplexObjectNoRoot() throws Exception {
        String instance = new String(Files.readAllBytes(Paths.get("src/test/resources/inspect/complex-object-unrooted.json", new String[0])));
        JsonDocument document = this.inspectionService.inspectJsonDocument(instance);
        Assert.assertNotNull((Object)document);
        Assert.assertThat((Object)document.getFields().getField().size(), (Matcher)Is.is((Object)3));
        JsonComplexType address = (JsonComplexType)document.getFields().getField().get(0);
        Assert.assertNotNull((Object)address);
        Assert.assertThat((Object)address.getJsonFields().getJsonField().size(), (Matcher)Is.is((Object)5));
        JsonField address1 = (JsonField)address.getJsonFields().getJsonField().get(0);
        Assert.assertNotNull((Object)address1);
        Assert.assertThat((Object)address1.getName(), (Matcher)Is.is((Object)"addressLine1"));
        Assert.assertThat((Object)address1.getValue(), (Matcher)Is.is((Object)"123 Main St"));
        Assert.assertThat((Object)address1.getPath(), (Matcher)Is.is((Object)"/address/addressLine1"));
        Assert.assertThat((Object)address1.getFieldType(), (Matcher)Is.is((Object)FieldType.STRING));
        Assert.assertThat((Object)address1.getStatus(), (Matcher)Is.is((Object)FieldStatus.SUPPORTED));
        JsonField address2 = (JsonField)address.getJsonFields().getJsonField().get(1);
        Assert.assertNotNull((Object)address2);
        Assert.assertThat((Object)address2.getName(), (Matcher)Is.is((Object)"addressLine2"));
        Assert.assertThat((Object)address2.getValue(), (Matcher)Is.is((Object)"Suite 42b"));
        Assert.assertThat((Object)address2.getPath(), (Matcher)Is.is((Object)"/address/addressLine2"));
        Assert.assertThat((Object)address2.getFieldType(), (Matcher)Is.is((Object)FieldType.STRING));
        Assert.assertThat((Object)address2.getStatus(), (Matcher)Is.is((Object)FieldStatus.SUPPORTED));
        JsonField city = (JsonField)address.getJsonFields().getJsonField().get(2);
        Assert.assertNotNull((Object)city);
        Assert.assertThat((Object)city.getName(), (Matcher)Is.is((Object)"city"));
        Assert.assertThat((Object)city.getValue(), (Matcher)Is.is((Object)"Anytown"));
        Assert.assertThat((Object)city.getPath(), (Matcher)Is.is((Object)"/address/city"));
        Assert.assertThat((Object)city.getFieldType(), (Matcher)Is.is((Object)FieldType.STRING));
        Assert.assertThat((Object)city.getStatus(), (Matcher)Is.is((Object)FieldStatus.SUPPORTED));
        JsonField state = (JsonField)address.getJsonFields().getJsonField().get(3);
        Assert.assertNotNull((Object)state);
        Assert.assertThat((Object)state.getName(), (Matcher)Is.is((Object)"state"));
        Assert.assertThat((Object)state.getValue(), (Matcher)Is.is((Object)"NY"));
        Assert.assertThat((Object)state.getPath(), (Matcher)Is.is((Object)"/address/state"));
        Assert.assertThat((Object)state.getFieldType(), (Matcher)Is.is((Object)FieldType.STRING));
        Assert.assertThat((Object)state.getStatus(), (Matcher)Is.is((Object)FieldStatus.SUPPORTED));
        JsonField postalCode = (JsonField)address.getJsonFields().getJsonField().get(4);
        Assert.assertNotNull((Object)postalCode);
        Assert.assertThat((Object)postalCode.getName(), (Matcher)Is.is((Object)"zipCode"));
        Assert.assertThat((Object)postalCode.getValue(), (Matcher)Is.is((Object)"90210"));
        Assert.assertThat((Object)postalCode.getPath(), (Matcher)Is.is((Object)"/address/zipCode"));
        Assert.assertThat((Object)postalCode.getFieldType(), (Matcher)Is.is((Object)FieldType.STRING));
        Assert.assertThat((Object)postalCode.getStatus(), (Matcher)Is.is((Object)FieldStatus.SUPPORTED));
        JsonComplexType contact = (JsonComplexType)document.getFields().getField().get(1);
        Assert.assertNotNull((Object)contact);
        Assert.assertThat((Object)contact.getJsonFields().getJsonField().size(), (Matcher)Is.is((Object)4));
        JsonField firstName = (JsonField)contact.getJsonFields().getJsonField().get(0);
        Assert.assertNotNull((Object)firstName);
        Assert.assertThat((Object)firstName.getName(), (Matcher)Is.is((Object)"firstName"));
        Assert.assertThat((Object)firstName.getValue(), (Matcher)Is.is((Object)"Ozzie"));
        Assert.assertThat((Object)firstName.getPath(), (Matcher)Is.is((Object)"/contact/firstName"));
        Assert.assertThat((Object)firstName.getFieldType(), (Matcher)Is.is((Object)FieldType.STRING));
        Assert.assertThat((Object)firstName.getStatus(), (Matcher)Is.is((Object)FieldStatus.SUPPORTED));
        JsonField lastName = (JsonField)contact.getJsonFields().getJsonField().get(1);
        Assert.assertNotNull((Object)lastName);
        Assert.assertThat((Object)lastName.getName(), (Matcher)Is.is((Object)"lastName"));
        Assert.assertThat((Object)lastName.getValue(), (Matcher)Is.is((Object)"Smith"));
        Assert.assertThat((Object)lastName.getPath(), (Matcher)Is.is((Object)"/contact/lastName"));
        Assert.assertThat((Object)lastName.getFieldType(), (Matcher)Is.is((Object)FieldType.STRING));
        Assert.assertThat((Object)lastName.getStatus(), (Matcher)Is.is((Object)FieldStatus.SUPPORTED));
        JsonField phoneNumber = (JsonField)contact.getJsonFields().getJsonField().get(2);
        Assert.assertNotNull((Object)phoneNumber);
        Assert.assertThat((Object)phoneNumber.getName(), (Matcher)Is.is((Object)"phoneNumber"));
        Assert.assertThat((Object)phoneNumber.getValue(), (Matcher)Is.is((Object)"5551212"));
        Assert.assertThat((Object)phoneNumber.getPath(), (Matcher)Is.is((Object)"/contact/phoneNumber"));
        Assert.assertThat((Object)phoneNumber.getFieldType(), (Matcher)Is.is((Object)FieldType.STRING));
        Assert.assertThat((Object)phoneNumber.getStatus(), (Matcher)Is.is((Object)FieldStatus.SUPPORTED));
        JsonField zipCode = (JsonField)contact.getJsonFields().getJsonField().get(3);
        Assert.assertNotNull((Object)zipCode);
        Assert.assertThat((Object)zipCode.getName(), (Matcher)Is.is((Object)"zipCode"));
        Assert.assertThat((Object)zipCode.getValue(), (Matcher)Is.is((Object)"81111"));
        Assert.assertThat((Object)zipCode.getPath(), (Matcher)Is.is((Object)"/contact/zipCode"));
        Assert.assertThat((Object)zipCode.getFieldType(), (Matcher)Is.is((Object)FieldType.STRING));
        Assert.assertThat((Object)zipCode.getStatus(), (Matcher)Is.is((Object)FieldStatus.SUPPORTED));
        JsonField orderId = (JsonField)document.getFields().getField().get(2);
        Assert.assertNotNull((Object)orderId);
        Assert.assertThat((Object)orderId.getName(), (Matcher)Is.is((Object)"orderId"));
        Assert.assertThat((Object)orderId.getValue(), (Matcher)Is.is((Object)0));
        Assert.assertThat((Object)orderId.getPath(), (Matcher)Is.is((Object)"/orderId"));
        Assert.assertThat((Object)orderId.getFieldType(), (Matcher)Is.is((Object)FieldType.INTEGER));
        Assert.assertThat((Object)orderId.getStatus(), (Matcher)Is.is((Object)FieldStatus.SUPPORTED));
    }

    @Test
    public void inspectComplexObjectWithRoot() throws Exception {
        String instance = new String(Files.readAllBytes(Paths.get("src/test/resources/inspect/complex-object-rooted.json", new String[0])));
        JsonDocument document = this.inspectionService.inspectJsonDocument(instance);
        Assert.assertNotNull((Object)document);
        Assert.assertThat((Object)document.getFields().getField().size(), (Matcher)Is.is((Object)1));
        JsonComplexType root = (JsonComplexType)document.getFields().getField().get(0);
        Assert.assertThat((Object)root.getJsonFields().getJsonField().size(), (Matcher)Is.is((Object)3));
        JsonComplexType address = (JsonComplexType)root.getJsonFields().getJsonField().get(0);
        Assert.assertNotNull((Object)address);
        Assert.assertThat((Object)address.getJsonFields().getJsonField().size(), (Matcher)Is.is((Object)5));
        JsonField address1 = (JsonField)address.getJsonFields().getJsonField().get(0);
        Assert.assertNotNull((Object)address1);
        Assert.assertThat((Object)address1.getName(), (Matcher)Is.is((Object)"addressLine1"));
        Assert.assertThat((Object)address1.getValue(), (Matcher)Is.is((Object)"123 Main St"));
        Assert.assertThat((Object)address1.getPath(), (Matcher)Is.is((Object)"/order/address/addressLine1"));
        Assert.assertThat((Object)address1.getFieldType(), (Matcher)Is.is((Object)FieldType.STRING));
        Assert.assertThat((Object)address1.getStatus(), (Matcher)Is.is((Object)FieldStatus.SUPPORTED));
        JsonField address2 = (JsonField)address.getJsonFields().getJsonField().get(1);
        Assert.assertNotNull((Object)address2);
        Assert.assertThat((Object)address2.getName(), (Matcher)Is.is((Object)"addressLine2"));
        Assert.assertThat((Object)address2.getValue(), (Matcher)Is.is((Object)"Suite 42b"));
        Assert.assertThat((Object)address2.getPath(), (Matcher)Is.is((Object)"/order/address/addressLine2"));
        Assert.assertThat((Object)address2.getFieldType(), (Matcher)Is.is((Object)FieldType.STRING));
        Assert.assertThat((Object)address2.getStatus(), (Matcher)Is.is((Object)FieldStatus.SUPPORTED));
        JsonField city = (JsonField)address.getJsonFields().getJsonField().get(2);
        Assert.assertNotNull((Object)city);
        Assert.assertThat((Object)city.getName(), (Matcher)Is.is((Object)"city"));
        Assert.assertThat((Object)city.getValue(), (Matcher)Is.is((Object)"Anytown"));
        Assert.assertThat((Object)city.getPath(), (Matcher)Is.is((Object)"/order/address/city"));
        Assert.assertThat((Object)city.getFieldType(), (Matcher)Is.is((Object)FieldType.STRING));
        Assert.assertThat((Object)city.getStatus(), (Matcher)Is.is((Object)FieldStatus.SUPPORTED));
        JsonField state = (JsonField)address.getJsonFields().getJsonField().get(3);
        Assert.assertNotNull((Object)state);
        Assert.assertThat((Object)state.getName(), (Matcher)Is.is((Object)"state"));
        Assert.assertThat((Object)state.getValue(), (Matcher)Is.is((Object)"NY"));
        Assert.assertThat((Object)state.getPath(), (Matcher)Is.is((Object)"/order/address/state"));
        Assert.assertThat((Object)state.getFieldType(), (Matcher)Is.is((Object)FieldType.STRING));
        Assert.assertThat((Object)state.getStatus(), (Matcher)Is.is((Object)FieldStatus.SUPPORTED));
        JsonField postalCode = (JsonField)address.getJsonFields().getJsonField().get(4);
        Assert.assertNotNull((Object)postalCode);
        Assert.assertThat((Object)postalCode.getName(), (Matcher)Is.is((Object)"zipCode"));
        Assert.assertThat((Object)postalCode.getValue(), (Matcher)Is.is((Object)"90210"));
        Assert.assertThat((Object)postalCode.getPath(), (Matcher)Is.is((Object)"/order/address/zipCode"));
        Assert.assertThat((Object)postalCode.getFieldType(), (Matcher)Is.is((Object)FieldType.STRING));
        Assert.assertThat((Object)postalCode.getStatus(), (Matcher)Is.is((Object)FieldStatus.SUPPORTED));
        JsonComplexType contact = (JsonComplexType)root.getJsonFields().getJsonField().get(1);
        Assert.assertNotNull((Object)contact);
        Assert.assertThat((Object)contact.getJsonFields().getJsonField().size(), (Matcher)Is.is((Object)4));
        JsonField firstName = (JsonField)contact.getJsonFields().getJsonField().get(0);
        Assert.assertNotNull((Object)firstName);
        Assert.assertThat((Object)firstName.getName(), (Matcher)Is.is((Object)"firstName"));
        Assert.assertThat((Object)firstName.getValue(), (Matcher)Is.is((Object)"Ozzie"));
        Assert.assertThat((Object)firstName.getPath(), (Matcher)Is.is((Object)"/order/contact/firstName"));
        Assert.assertThat((Object)firstName.getFieldType(), (Matcher)Is.is((Object)FieldType.STRING));
        Assert.assertThat((Object)firstName.getStatus(), (Matcher)Is.is((Object)FieldStatus.SUPPORTED));
        JsonField lastName = (JsonField)contact.getJsonFields().getJsonField().get(1);
        Assert.assertNotNull((Object)lastName);
        Assert.assertThat((Object)lastName.getName(), (Matcher)Is.is((Object)"lastName"));
        Assert.assertThat((Object)lastName.getValue(), (Matcher)Is.is((Object)"Smith"));
        Assert.assertThat((Object)lastName.getPath(), (Matcher)Is.is((Object)"/order/contact/lastName"));
        Assert.assertThat((Object)lastName.getFieldType(), (Matcher)Is.is((Object)FieldType.STRING));
        Assert.assertThat((Object)lastName.getStatus(), (Matcher)Is.is((Object)FieldStatus.SUPPORTED));
        JsonField phoneNumber = (JsonField)contact.getJsonFields().getJsonField().get(2);
        Assert.assertNotNull((Object)phoneNumber);
        Assert.assertThat((Object)phoneNumber.getName(), (Matcher)Is.is((Object)"phoneNumber"));
        Assert.assertThat((Object)phoneNumber.getValue(), (Matcher)Is.is((Object)"5551212"));
        Assert.assertThat((Object)phoneNumber.getPath(), (Matcher)Is.is((Object)"/order/contact/phoneNumber"));
        Assert.assertThat((Object)phoneNumber.getFieldType(), (Matcher)Is.is((Object)FieldType.STRING));
        Assert.assertThat((Object)phoneNumber.getStatus(), (Matcher)Is.is((Object)FieldStatus.SUPPORTED));
        JsonField zipCode = (JsonField)contact.getJsonFields().getJsonField().get(3);
        Assert.assertNotNull((Object)zipCode);
        Assert.assertThat((Object)zipCode.getName(), (Matcher)Is.is((Object)"zipCode"));
        Assert.assertThat((Object)zipCode.getValue(), (Matcher)Is.is((Object)"81111"));
        Assert.assertThat((Object)zipCode.getPath(), (Matcher)Is.is((Object)"/order/contact/zipCode"));
        Assert.assertThat((Object)zipCode.getFieldType(), (Matcher)Is.is((Object)FieldType.STRING));
        Assert.assertThat((Object)zipCode.getStatus(), (Matcher)Is.is((Object)FieldStatus.SUPPORTED));
        JsonField orderId = (JsonField)root.getJsonFields().getJsonField().get(2);
        Assert.assertNotNull((Object)orderId);
        Assert.assertThat((Object)orderId.getName(), (Matcher)Is.is((Object)"orderId"));
        Assert.assertThat((Object)orderId.getValue(), (Matcher)Is.is((Object)0));
        Assert.assertThat((Object)orderId.getPath(), (Matcher)Is.is((Object)"/order/orderId"));
        Assert.assertThat((Object)orderId.getFieldType(), (Matcher)Is.is((Object)FieldType.INTEGER));
        Assert.assertThat((Object)orderId.getStatus(), (Matcher)Is.is((Object)FieldStatus.SUPPORTED));
    }

    @Test
    public void inspectRepeatingComplexObjectWithRoot() throws Exception {
        String instance = new String(Files.readAllBytes(Paths.get("src/test/resources/inspect/complex-repeated-rooted.json", new String[0])));
        JsonDocument document = this.inspectionService.inspectJsonDocument(instance);
        Assert.assertNotNull((Object)document);
        Assert.assertThat((Object)document.getFields().getField().size(), (Matcher)Is.is((Object)1));
        JsonComplexType root = (JsonComplexType)document.getFields().getField().get(0);
        Assert.assertNotNull((Object)root);
        Assert.assertThat((Object)root.getJsonFields().getJsonField().size(), (Matcher)Is.is((Object)3));
        Assert.assertThat((Object)root.getName(), (Matcher)Is.is((Object)"SourceOrderList"));
        JsonComplexType orders = (JsonComplexType)root.getJsonFields().getJsonField().get(0);
        Assert.assertNotNull((Object)orders);
        Assert.assertThat((Object)orders.getJsonFields().getJsonField().size(), (Matcher)Is.is((Object)15));
        Assert.assertThat((Object)orders.getName(), (Matcher)Is.is((Object)"orders"));
        JsonField orderBatchNumber = (JsonField)root.getJsonFields().getJsonField().get(1);
        Assert.assertNotNull((Object)orderBatchNumber);
        Assert.assertThat((Object)orderBatchNumber.getName(), (Matcher)Is.is((Object)"orderBatchNumber"));
        Assert.assertThat((Object)orderBatchNumber.getValue(), (Matcher)Is.is((Object)4123562));
        Assert.assertThat((Object)orderBatchNumber.getPath(), (Matcher)Is.is((Object)"/SourceOrderList/orderBatchNumber"));
        Assert.assertThat((Object)orderBatchNumber.getFieldType(), (Matcher)Is.is((Object)FieldType.INTEGER));
        Assert.assertThat((Object)orderBatchNumber.getStatus(), (Matcher)Is.is((Object)FieldStatus.SUPPORTED));
        JsonField numberOrders = (JsonField)root.getJsonFields().getJsonField().get(2);
        Assert.assertNotNull((Object)numberOrders);
        Assert.assertThat((Object)numberOrders.getName(), (Matcher)Is.is((Object)"numberOrders"));
        Assert.assertThat((Object)numberOrders.getValue(), (Matcher)Is.is((Object)5));
        Assert.assertThat((Object)numberOrders.getPath(), (Matcher)Is.is((Object)"/SourceOrderList/numberOrders"));
        Assert.assertThat((Object)numberOrders.getFieldType(), (Matcher)Is.is((Object)FieldType.INTEGER));
        Assert.assertThat((Object)numberOrders.getStatus(), (Matcher)Is.is((Object)FieldStatus.SUPPORTED));
        JsonComplexType complexAddress11 = (JsonComplexType)orders.getJsonFields().getJsonField().get(0);
        Assert.assertNotNull((Object)complexAddress11);
        Assert.assertThat((Object)complexAddress11.getJsonFields().getJsonField().size(), (Matcher)Is.is((Object)5));
        Assert.assertThat((Object)complexAddress11.getName(), (Matcher)Is.is((Object)"address"));
        Assert.assertThat((Object)complexAddress11.getPath(), (Matcher)Is.is((Object)"/SourceOrderList/orders/address"));
        JsonField address11 = (JsonField)complexAddress11.getJsonFields().getJsonField().get(0);
        Assert.assertNotNull((Object)address11);
        Assert.assertThat((Object)address11.getName(), (Matcher)Is.is((Object)"addressLine1"));
        Assert.assertThat((Object)address11.getValue(), (Matcher)Is.is((Object)"123 Main St"));
        Assert.assertThat((Object)address11.getPath(), (Matcher)Is.is((Object)"/SourceOrderList/orders/address/addressLine1"));
        Assert.assertThat((Object)address11.getFieldType(), (Matcher)Is.is((Object)FieldType.STRING));
        Assert.assertThat((Object)address11.getStatus(), (Matcher)Is.is((Object)FieldStatus.SUPPORTED));
        JsonField address12 = (JsonField)complexAddress11.getJsonFields().getJsonField().get(1);
        Assert.assertNotNull((Object)address12);
        Assert.assertThat((Object)address12.getName(), (Matcher)Is.is((Object)"addressLine2"));
        Assert.assertThat((Object)address12.getValue(), (Matcher)Is.is((Object)"Suite 42b"));
        Assert.assertThat((Object)address12.getPath(), (Matcher)Is.is((Object)"/SourceOrderList/orders/address/addressLine2"));
        Assert.assertThat((Object)address12.getFieldType(), (Matcher)Is.is((Object)FieldType.STRING));
        Assert.assertThat((Object)address12.getStatus(), (Matcher)Is.is((Object)FieldStatus.SUPPORTED));
        JsonField city = (JsonField)complexAddress11.getJsonFields().getJsonField().get(2);
        Assert.assertNotNull((Object)city);
        Assert.assertThat((Object)city.getName(), (Matcher)Is.is((Object)"city"));
        Assert.assertThat((Object)city.getValue(), (Matcher)Is.is((Object)"Anytown"));
        Assert.assertThat((Object)city.getPath(), (Matcher)Is.is((Object)"/SourceOrderList/orders/address/city"));
        Assert.assertThat((Object)city.getFieldType(), (Matcher)Is.is((Object)FieldType.STRING));
        Assert.assertThat((Object)city.getStatus(), (Matcher)Is.is((Object)FieldStatus.SUPPORTED));
        JsonField state = (JsonField)complexAddress11.getJsonFields().getJsonField().get(3);
        Assert.assertNotNull((Object)state);
        Assert.assertThat((Object)state.getName(), (Matcher)Is.is((Object)"state"));
        Assert.assertThat((Object)state.getValue(), (Matcher)Is.is((Object)"NY"));
        Assert.assertThat((Object)state.getPath(), (Matcher)Is.is((Object)"/SourceOrderList/orders/address/state"));
        Assert.assertThat((Object)state.getFieldType(), (Matcher)Is.is((Object)FieldType.STRING));
        Assert.assertThat((Object)state.getStatus(), (Matcher)Is.is((Object)FieldStatus.SUPPORTED));
        JsonField postalCode = (JsonField)complexAddress11.getJsonFields().getJsonField().get(4);
        Assert.assertNotNull((Object)postalCode);
        Assert.assertThat((Object)postalCode.getName(), (Matcher)Is.is((Object)"zipCode"));
        Assert.assertThat((Object)postalCode.getValue(), (Matcher)Is.is((Object)"90210"));
        Assert.assertThat((Object)postalCode.getPath(), (Matcher)Is.is((Object)"/SourceOrderList/orders/address/zipCode"));
        Assert.assertThat((Object)postalCode.getFieldType(), (Matcher)Is.is((Object)FieldType.STRING));
        Assert.assertThat((Object)postalCode.getStatus(), (Matcher)Is.is((Object)FieldStatus.SUPPORTED));
        JsonComplexType complexContact11 = (JsonComplexType)orders.getJsonFields().getJsonField().get(1);
        Assert.assertNotNull((Object)complexContact11);
        Assert.assertThat((Object)complexContact11.getJsonFields().getJsonField().size(), (Matcher)Is.is((Object)4));
        Assert.assertThat((Object)complexContact11.getName(), (Matcher)Is.is((Object)"contact"));
        Assert.assertThat((Object)complexContact11.getPath(), (Matcher)Is.is((Object)"/SourceOrderList/orders/contact"));
        JsonField firstName = (JsonField)complexContact11.getJsonFields().getJsonField().get(0);
        Assert.assertNotNull((Object)firstName);
        Assert.assertThat((Object)firstName.getName(), (Matcher)Is.is((Object)"firstName"));
        Assert.assertThat((Object)firstName.getValue(), (Matcher)Is.is((Object)"Ozzie"));
        Assert.assertThat((Object)firstName.getPath(), (Matcher)Is.is((Object)"/SourceOrderList/orders/contact/firstName"));
        Assert.assertThat((Object)firstName.getFieldType(), (Matcher)Is.is((Object)FieldType.STRING));
        Assert.assertThat((Object)firstName.getStatus(), (Matcher)Is.is((Object)FieldStatus.SUPPORTED));
        JsonField lastName = (JsonField)complexContact11.getJsonFields().getJsonField().get(1);
        Assert.assertNotNull((Object)lastName);
        Assert.assertThat((Object)lastName.getName(), (Matcher)Is.is((Object)"lastName"));
        Assert.assertThat((Object)lastName.getValue(), (Matcher)Is.is((Object)"Smith"));
        Assert.assertThat((Object)lastName.getPath(), (Matcher)Is.is((Object)"/SourceOrderList/orders/contact/lastName"));
        Assert.assertThat((Object)lastName.getFieldType(), (Matcher)Is.is((Object)FieldType.STRING));
        Assert.assertThat((Object)lastName.getStatus(), (Matcher)Is.is((Object)FieldStatus.SUPPORTED));
        JsonField phoneNumber = (JsonField)complexContact11.getJsonFields().getJsonField().get(2);
        Assert.assertNotNull((Object)phoneNumber);
        Assert.assertThat((Object)phoneNumber.getName(), (Matcher)Is.is((Object)"phoneNumber"));
        Assert.assertThat((Object)phoneNumber.getValue(), (Matcher)Is.is((Object)"5551212"));
        Assert.assertThat((Object)phoneNumber.getPath(), (Matcher)Is.is((Object)"/SourceOrderList/orders/contact/phoneNumber"));
        Assert.assertThat((Object)phoneNumber.getFieldType(), (Matcher)Is.is((Object)FieldType.STRING));
        Assert.assertThat((Object)phoneNumber.getStatus(), (Matcher)Is.is((Object)FieldStatus.SUPPORTED));
        JsonField zipCode = (JsonField)complexContact11.getJsonFields().getJsonField().get(3);
        Assert.assertNotNull((Object)zipCode);
        Assert.assertThat((Object)zipCode.getName(), (Matcher)Is.is((Object)"zipCode"));
        Assert.assertThat((Object)zipCode.getValue(), (Matcher)Is.is((Object)"81111"));
        Assert.assertThat((Object)zipCode.getPath(), (Matcher)Is.is((Object)"/SourceOrderList/orders/contact/zipCode"));
        Assert.assertThat((Object)zipCode.getFieldType(), (Matcher)Is.is((Object)FieldType.STRING));
        Assert.assertThat((Object)zipCode.getStatus(), (Matcher)Is.is((Object)FieldStatus.SUPPORTED));
        JsonComplexType complexAddress12 = (JsonComplexType)orders.getJsonFields().getJsonField().get(3);
        Assert.assertNotNull((Object)complexAddress12);
        Assert.assertThat((Object)complexAddress12.getJsonFields().getJsonField().size(), (Matcher)Is.is((Object)5));
        Assert.assertThat((Object)complexAddress12.getName(), (Matcher)Is.is((Object)"address"));
        Assert.assertThat((Object)complexAddress12.getPath(), (Matcher)Is.is((Object)"/SourceOrderList/orders[1]/address"));
        JsonField address2 = (JsonField)complexAddress12.getJsonFields().getJsonField().get(0);
        Assert.assertNotNull((Object)address2);
        Assert.assertThat((Object)address2.getName(), (Matcher)Is.is((Object)"addressLine1"));
        Assert.assertThat((Object)address2.getValue(), (Matcher)Is.is((Object)"123 Main St"));
        Assert.assertThat((Object)address2.getPath(), (Matcher)Is.is((Object)"/SourceOrderList/orders[1]/address/addressLine1"));
        Assert.assertThat((Object)address2.getFieldType(), (Matcher)Is.is((Object)FieldType.STRING));
        Assert.assertThat((Object)address2.getStatus(), (Matcher)Is.is((Object)FieldStatus.SUPPORTED));
        JsonField address22 = (JsonField)complexAddress12.getJsonFields().getJsonField().get(1);
        Assert.assertNotNull((Object)address22);
        Assert.assertThat((Object)address22.getName(), (Matcher)Is.is((Object)"addressLine2"));
        Assert.assertThat((Object)address22.getValue(), (Matcher)Is.is((Object)"Suite 42b"));
        Assert.assertThat((Object)address22.getPath(), (Matcher)Is.is((Object)"/SourceOrderList/orders[1]/address/addressLine2"));
        Assert.assertThat((Object)address22.getFieldType(), (Matcher)Is.is((Object)FieldType.STRING));
        Assert.assertThat((Object)address22.getStatus(), (Matcher)Is.is((Object)FieldStatus.SUPPORTED));
        JsonField city2 = (JsonField)complexAddress12.getJsonFields().getJsonField().get(2);
        Assert.assertNotNull((Object)city2);
        Assert.assertThat((Object)city2.getName(), (Matcher)Is.is((Object)"city"));
        Assert.assertThat((Object)city2.getValue(), (Matcher)Is.is((Object)"Anytown"));
        Assert.assertThat((Object)city2.getPath(), (Matcher)Is.is((Object)"/SourceOrderList/orders[1]/address/city"));
        Assert.assertThat((Object)city2.getFieldType(), (Matcher)Is.is((Object)FieldType.STRING));
        Assert.assertThat((Object)city2.getStatus(), (Matcher)Is.is((Object)FieldStatus.SUPPORTED));
        JsonField state2 = (JsonField)complexAddress12.getJsonFields().getJsonField().get(3);
        Assert.assertNotNull((Object)state2);
        Assert.assertThat((Object)state2.getName(), (Matcher)Is.is((Object)"state"));
        Assert.assertThat((Object)state2.getValue(), (Matcher)Is.is((Object)"NY"));
        Assert.assertThat((Object)state2.getPath(), (Matcher)Is.is((Object)"/SourceOrderList/orders[1]/address/state"));
        Assert.assertThat((Object)state2.getFieldType(), (Matcher)Is.is((Object)FieldType.STRING));
        Assert.assertThat((Object)state2.getStatus(), (Matcher)Is.is((Object)FieldStatus.SUPPORTED));
        JsonField postalCode2 = (JsonField)complexAddress12.getJsonFields().getJsonField().get(4);
        Assert.assertNotNull((Object)postalCode2);
        Assert.assertThat((Object)postalCode2.getName(), (Matcher)Is.is((Object)"zipCode"));
        Assert.assertThat((Object)postalCode2.getValue(), (Matcher)Is.is((Object)"90210"));
        Assert.assertThat((Object)postalCode2.getPath(), (Matcher)Is.is((Object)"/SourceOrderList/orders[1]/address/zipCode"));
        Assert.assertThat((Object)postalCode2.getFieldType(), (Matcher)Is.is((Object)FieldType.STRING));
        Assert.assertThat((Object)postalCode2.getStatus(), (Matcher)Is.is((Object)FieldStatus.SUPPORTED));
        JsonComplexType complexContact12 = (JsonComplexType)orders.getJsonFields().getJsonField().get(4);
        Assert.assertNotNull((Object)complexContact12);
        Assert.assertThat((Object)complexContact12.getJsonFields().getJsonField().size(), (Matcher)Is.is((Object)4));
        Assert.assertThat((Object)complexContact12.getName(), (Matcher)Is.is((Object)"contact"));
        Assert.assertThat((Object)complexContact12.getPath(), (Matcher)Is.is((Object)"/SourceOrderList/orders[1]/contact"));
        JsonField firstName2 = (JsonField)complexContact12.getJsonFields().getJsonField().get(0);
        Assert.assertNotNull((Object)firstName2);
        Assert.assertThat((Object)firstName2.getName(), (Matcher)Is.is((Object)"firstName"));
        Assert.assertThat((Object)firstName2.getValue(), (Matcher)Is.is((Object)"Ozzie"));
        Assert.assertThat((Object)firstName2.getPath(), (Matcher)Is.is((Object)"/SourceOrderList/orders[1]/contact/firstName"));
        Assert.assertThat((Object)firstName2.getFieldType(), (Matcher)Is.is((Object)FieldType.STRING));
        Assert.assertThat((Object)firstName2.getStatus(), (Matcher)Is.is((Object)FieldStatus.SUPPORTED));
        JsonField lastName2 = (JsonField)complexContact12.getJsonFields().getJsonField().get(1);
        Assert.assertNotNull((Object)lastName2);
        Assert.assertThat((Object)lastName2.getName(), (Matcher)Is.is((Object)"lastName"));
        Assert.assertThat((Object)lastName2.getValue(), (Matcher)Is.is((Object)"Smith"));
        Assert.assertThat((Object)lastName2.getPath(), (Matcher)Is.is((Object)"/SourceOrderList/orders[1]/contact/lastName"));
        Assert.assertThat((Object)lastName2.getFieldType(), (Matcher)Is.is((Object)FieldType.STRING));
        Assert.assertThat((Object)lastName2.getStatus(), (Matcher)Is.is((Object)FieldStatus.SUPPORTED));
        JsonField phoneNumber2 = (JsonField)complexContact12.getJsonFields().getJsonField().get(2);
        Assert.assertNotNull((Object)phoneNumber2);
        Assert.assertThat((Object)phoneNumber2.getName(), (Matcher)Is.is((Object)"phoneNumber"));
        Assert.assertThat((Object)phoneNumber2.getValue(), (Matcher)Is.is((Object)"5551212"));
        Assert.assertThat((Object)phoneNumber2.getPath(), (Matcher)Is.is((Object)"/SourceOrderList/orders[1]/contact/phoneNumber"));
        Assert.assertThat((Object)phoneNumber2.getFieldType(), (Matcher)Is.is((Object)FieldType.STRING));
        Assert.assertThat((Object)phoneNumber2.getStatus(), (Matcher)Is.is((Object)FieldStatus.SUPPORTED));
        JsonField zipCode2 = (JsonField)complexContact12.getJsonFields().getJsonField().get(3);
        Assert.assertNotNull((Object)zipCode2);
        Assert.assertThat((Object)zipCode2.getName(), (Matcher)Is.is((Object)"zipCode"));
        Assert.assertThat((Object)zipCode2.getValue(), (Matcher)Is.is((Object)"81111"));
        Assert.assertThat((Object)zipCode2.getPath(), (Matcher)Is.is((Object)"/SourceOrderList/orders[1]/contact/zipCode"));
        Assert.assertThat((Object)zipCode2.getFieldType(), (Matcher)Is.is((Object)FieldType.STRING));
        Assert.assertThat((Object)zipCode2.getStatus(), (Matcher)Is.is((Object)FieldStatus.SUPPORTED));
    }

    @Test
    public void inspectISO8601DatesNoRoot() throws Exception {
        String instance = new String(Files.readAllBytes(Paths.get("src/test/resources/inspect/iso8601dates-unrooted.json", new String[0])));
        JsonDocument document = this.inspectionService.inspectJsonDocument(instance);
        Assert.assertNotNull((Object)document);
        Assert.assertThat((Object)document.getFields().getField().size(), (Matcher)Is.is((Object)7));
        JsonField yyyy = (JsonField)document.getFields().getField().get(0);
        Assert.assertNotNull((Object)yyyy);
        Assert.assertThat((Object)yyyy.getName(), (Matcher)Is.is((Object)"YYYY"));
        Assert.assertThat((Object)yyyy.getValue(), (Matcher)Is.is((Object)"1997"));
        Assert.assertThat((Object)yyyy.getPath(), (Matcher)Is.is((Object)"/YYYY"));
        Assert.assertThat((Object)yyyy.getFieldType(), (Matcher)Is.is((Object)FieldType.STRING));
        Assert.assertThat((Object)yyyy.getStatus(), (Matcher)Is.is((Object)FieldStatus.SUPPORTED));
        JsonField yyyymm = (JsonField)document.getFields().getField().get(1);
        Assert.assertNotNull((Object)yyyymm);
        Assert.assertThat((Object)yyyymm.getName(), (Matcher)Is.is((Object)"YYYY-MM"));
        Assert.assertThat((Object)yyyymm.getValue(), (Matcher)Is.is((Object)"1997-07"));
        Assert.assertThat((Object)yyyymm.getPath(), (Matcher)Is.is((Object)"/YYYY-MM"));
        Assert.assertThat((Object)yyyymm.getFieldType(), (Matcher)Is.is((Object)FieldType.STRING));
        Assert.assertThat((Object)yyyymm.getStatus(), (Matcher)Is.is((Object)FieldStatus.SUPPORTED));
        JsonField yyyymmdd = (JsonField)document.getFields().getField().get(2);
        Assert.assertNotNull((Object)yyyymmdd);
        Assert.assertThat((Object)yyyymmdd.getName(), (Matcher)Is.is((Object)"YYYY-MM-DD"));
        Assert.assertThat((Object)yyyymmdd.getValue(), (Matcher)Is.is((Object)"1997-07-16"));
        Assert.assertThat((Object)yyyymmdd.getPath(), (Matcher)Is.is((Object)"/YYYY-MM-DD"));
        Assert.assertThat((Object)yyyymmdd.getFieldType(), (Matcher)Is.is((Object)FieldType.STRING));
        Assert.assertThat((Object)yyyymmdd.getStatus(), (Matcher)Is.is((Object)FieldStatus.SUPPORTED));
        JsonField yyyymmddthhmmtzd = (JsonField)document.getFields().getField().get(3);
        Assert.assertNotNull((Object)yyyymmddthhmmtzd);
        Assert.assertThat((Object)yyyymmddthhmmtzd.getName(), (Matcher)Is.is((Object)"YYYY-MM-DDThh:mmTZD"));
        Assert.assertThat((Object)yyyymmddthhmmtzd.getValue(), (Matcher)Is.is((Object)"1997-07-16T19:20+01:00"));
        Assert.assertThat((Object)yyyymmddthhmmtzd.getPath(), (Matcher)Is.is((Object)"/YYYY-MM-DDThh:mmTZD"));
        Assert.assertThat((Object)yyyymmddthhmmtzd.getFieldType(), (Matcher)Is.is((Object)FieldType.STRING));
        Assert.assertThat((Object)yyyymmddthhmmtzd.getStatus(), (Matcher)Is.is((Object)FieldStatus.SUPPORTED));
        JsonField yyyymmddthhmmsstzd = (JsonField)document.getFields().getField().get(4);
        Assert.assertNotNull((Object)yyyymmddthhmmsstzd);
        Assert.assertThat((Object)yyyymmddthhmmsstzd.getName(), (Matcher)Is.is((Object)"YYYY-MM-DDThh:mm:ssTZD"));
        Assert.assertThat((Object)yyyymmddthhmmsstzd.getValue(), (Matcher)Is.is((Object)"1997-07-16T19:20:30+01:00"));
        Assert.assertThat((Object)yyyymmddthhmmsstzd.getPath(), (Matcher)Is.is((Object)"/YYYY-MM-DDThh:mm:ssTZD"));
        Assert.assertThat((Object)yyyymmddthhmmsstzd.getFieldType(), (Matcher)Is.is((Object)FieldType.STRING));
        Assert.assertThat((Object)yyyymmddthhmmsstzd.getStatus(), (Matcher)Is.is((Object)FieldStatus.SUPPORTED));
        JsonField yyyymmddthhmmssstzd = (JsonField)document.getFields().getField().get(5);
        Assert.assertNotNull((Object)yyyymmddthhmmssstzd);
        Assert.assertThat((Object)yyyymmddthhmmssstzd.getName(), (Matcher)Is.is((Object)"YYYY-MM-DDThh:mm:ss.sTZD"));
        Assert.assertThat((Object)yyyymmddthhmmssstzd.getValue(), (Matcher)Is.is((Object)"1997-07-16T19:20:30.45+01:00"));
        Assert.assertThat((Object)yyyymmddthhmmssstzd.getPath(), (Matcher)Is.is((Object)"/YYYY-MM-DDThh:mm:ss.sTZD"));
        Assert.assertThat((Object)yyyymmddthhmmssstzd.getFieldType(), (Matcher)Is.is((Object)FieldType.STRING));
        Assert.assertThat((Object)yyyymmddthhmmssstzd.getStatus(), (Matcher)Is.is((Object)FieldStatus.SUPPORTED));
        JsonField yyyymmddthhmmssutz = (JsonField)document.getFields().getField().get(6);
        Assert.assertNotNull((Object)yyyymmddthhmmssutz);
        Assert.assertThat((Object)yyyymmddthhmmssutz.getName(), (Matcher)Is.is((Object)"YYYY-MM-DDThh:mm:ssUTZ"));
        Assert.assertThat((Object)yyyymmddthhmmssutz.getValue(), (Matcher)Is.is((Object)"1994-11-05T13:15:30Z"));
        Assert.assertThat((Object)yyyymmddthhmmssutz.getPath(), (Matcher)Is.is((Object)"/YYYY-MM-DDThh:mm:ssUTZ"));
        Assert.assertThat((Object)yyyymmddthhmmssutz.getFieldType(), (Matcher)Is.is((Object)FieldType.STRING));
        Assert.assertThat((Object)yyyymmddthhmmssutz.getStatus(), (Matcher)Is.is((Object)FieldStatus.SUPPORTED));
    }

    @Test
    public void inspectJsonDocumentNoRoot() throws Exception {
        String instance = "{ \"brand\" : \"Mercedes\", \"doors\" : 5 }";
        JsonDocument document = this.inspectionService.inspectJsonDocument("{ \"brand\" : \"Mercedes\", \"doors\" : 5 }");
        Assert.assertNotNull((Object)document);
        Assert.assertThat((Object)document.getFields().getField().size(), (Matcher)Is.is((Object)2));
        JsonField field1 = (JsonField)document.getFields().getField().get(0);
        Assert.assertNotNull((Object)field1);
        Assert.assertThat((Object)field1.getName(), (Matcher)Is.is((Object)"brand"));
        Assert.assertThat((Object)field1.getValue(), (Matcher)Is.is((Object)"Mercedes"));
        Assert.assertThat((Object)field1.getPath(), (Matcher)Is.is((Object)"/brand"));
        Assert.assertThat((Object)field1.getFieldType(), (Matcher)Is.is((Object)FieldType.STRING));
        Assert.assertThat((Object)field1.getStatus(), (Matcher)Is.is((Object)FieldStatus.SUPPORTED));
        JsonField field2 = (JsonField)document.getFields().getField().get(1);
        Assert.assertNotNull((Object)field2);
        Assert.assertThat((Object)field2.getName(), (Matcher)Is.is((Object)"doors"));
        Assert.assertThat((Object)field2.getValue(), (Matcher)Is.is((Object)5));
        Assert.assertThat((Object)field2.getPath(), (Matcher)Is.is((Object)"/doors"));
        Assert.assertThat((Object)field2.getFieldType(), (Matcher)Is.is((Object)FieldType.INTEGER));
        Assert.assertThat((Object)field2.getStatus(), (Matcher)Is.is((Object)FieldStatus.SUPPORTED));
    }

    @Test
    public void inspectJsonDocumentWithRoot() throws Exception {
        String instance = "{\"car\" :{ \"brand\" : \"Mercedes\", \"doors\" : 5 } }";
        JsonDocument document = this.inspectionService.inspectJsonDocument("{\"car\" :{ \"brand\" : \"Mercedes\", \"doors\" : 5 } }");
        Assert.assertNotNull((Object)document);
        Assert.assertThat((Object)document.getFields().getField().size(), (Matcher)Is.is((Object)1));
        JsonComplexType car = (JsonComplexType)document.getFields().getField().get(0);
        Assert.assertNotNull((Object)car);
        Assert.assertThat((Object)car.getName(), (Matcher)Is.is((Object)"car"));
        Assert.assertThat((Object)car.getFieldType(), (Matcher)Is.is((Object)FieldType.COMPLEX));
        Assert.assertThat((Object)car.getPath(), (Matcher)Is.is((Object)"/car"));
        Assert.assertThat((Object)car.getStatus(), (Matcher)Is.is((Object)FieldStatus.SUPPORTED));
        Assert.assertThat((Object)car.getJsonFields().getJsonField().size(), (Matcher)Is.is((Object)2));
        JsonField field1 = (JsonField)car.getJsonFields().getJsonField().get(0);
        Assert.assertNotNull((Object)field1);
        Assert.assertThat((Object)field1.getName(), (Matcher)Is.is((Object)"brand"));
        Assert.assertThat((Object)field1.getValue(), (Matcher)Is.is((Object)"Mercedes"));
        Assert.assertThat((Object)field1.getPath(), (Matcher)Is.is((Object)"/car/brand"));
        Assert.assertThat((Object)field1.getFieldType(), (Matcher)Is.is((Object)FieldType.STRING));
        Assert.assertThat((Object)field1.getStatus(), (Matcher)Is.is((Object)FieldStatus.SUPPORTED));
        JsonField field2 = (JsonField)car.getJsonFields().getJsonField().get(1);
        Assert.assertNotNull((Object)field2);
        Assert.assertThat((Object)field2.getName(), (Matcher)Is.is((Object)"doors"));
        Assert.assertThat((Object)field2.getValue(), (Matcher)Is.is((Object)5));
        Assert.assertThat((Object)field2.getPath(), (Matcher)Is.is((Object)"/car/doors"));
        Assert.assertThat((Object)field2.getFieldType(), (Matcher)Is.is((Object)FieldType.INTEGER));
        Assert.assertThat((Object)field2.getStatus(), (Matcher)Is.is((Object)FieldStatus.SUPPORTED));
    }

    @Test
    public void inspectJsonDocumentNestedObjectArray() throws Exception {
        String instance = "{\"menu\": {\n  \"id\": \"file\",\n  \"value\": \"Filed\",\n  \"popup\": {\n    \"menuitem\": [\n      {\"value\": \"New\", \"onclick\": \"CreateNewDoc()\"},\n      {\"value\": \"Open\", \"onclick\": \"OpenDoc()\"},\n      {\"value\": \"Close\", \"onclick\": \"CloseDoc()\"}\n    ]\n  }\n}}";
        JsonDocument document = this.inspectionService.inspectJsonDocument("{\"menu\": {\n  \"id\": \"file\",\n  \"value\": \"Filed\",\n  \"popup\": {\n    \"menuitem\": [\n      {\"value\": \"New\", \"onclick\": \"CreateNewDoc()\"},\n      {\"value\": \"Open\", \"onclick\": \"OpenDoc()\"},\n      {\"value\": \"Close\", \"onclick\": \"CloseDoc()\"}\n    ]\n  }\n}}");
        Assert.assertNotNull((Object)document);
        Assert.assertThat((Object)1, (Matcher)Is.is((Object)document.getFields().getField().size()));
        Assert.assertNotNull((Object)document.getFields().getField());
        JsonComplexType jsonComplexType = (JsonComplexType)document.getFields().getField().get(0);
        Assert.assertNotNull((Object)jsonComplexType);
        Assert.assertNotNull((Object)jsonComplexType.getJsonFields().getJsonField());
        Assert.assertThat((Object)jsonComplexType.getJsonFields().getJsonField().size(), (Matcher)Is.is((Object)3));
        Assert.assertThat((Object)jsonComplexType.getName(), (Matcher)Is.is((Object)"menu"));
        JsonField jsonField1 = (JsonField)jsonComplexType.getJsonFields().getJsonField().get(0);
        Assert.assertNotNull((Object)jsonField1);
        Assert.assertThat((Object)jsonField1.getName(), (Matcher)Is.is((Object)"id"));
        Assert.assertThat((Object)jsonField1.getValue(), (Matcher)Is.is((Object)"file"));
        Assert.assertThat((Object)jsonField1.getPath(), (Matcher)Is.is((Object)"/menu/id"));
        Assert.assertThat((Object)jsonField1.getFieldType(), (Matcher)Is.is((Object)FieldType.STRING));
        Assert.assertThat((Object)jsonField1.getStatus(), (Matcher)Is.is((Object)FieldStatus.SUPPORTED));
        JsonField jsonField2 = (JsonField)jsonComplexType.getJsonFields().getJsonField().get(1);
        Assert.assertNotNull((Object)jsonField2);
        Assert.assertThat((Object)jsonField2.getName(), (Matcher)Is.is((Object)"value"));
        Assert.assertThat((Object)jsonField2.getValue(), (Matcher)Is.is((Object)"Filed"));
        Assert.assertThat((Object)jsonField2.getPath(), (Matcher)Is.is((Object)"/menu/value"));
        Assert.assertThat((Object)jsonField2.getFieldType(), (Matcher)Is.is((Object)FieldType.STRING));
        Assert.assertThat((Object)jsonField2.getStatus(), (Matcher)Is.is((Object)FieldStatus.SUPPORTED));
        JsonComplexType popup = (JsonComplexType)jsonComplexType.getJsonFields().getJsonField().get(2);
        Assert.assertNotNull((Object)popup);
        Assert.assertNotNull((Object)popup.getJsonFields().getJsonField());
        Assert.assertThat((Object)popup.getJsonFields().getJsonField().size(), (Matcher)Is.is((Object)1));
        Assert.assertThat((Object)popup.getName(), (Matcher)Is.is((Object)"popup"));
        Assert.assertThat((Object)popup.getPath(), (Matcher)Is.is((Object)"/menu/popup"));
        Assert.assertThat((Object)popup.getFieldType(), (Matcher)Is.is((Object)FieldType.COMPLEX));
        JsonComplexType menuitem = (JsonComplexType)popup.getJsonFields().getJsonField().get(0);
        Assert.assertNotNull((Object)menuitem);
        Assert.assertNotNull((Object)menuitem.getJsonFields().getJsonField());
        Assert.assertThat((Object)menuitem.getJsonFields().getJsonField().size(), (Matcher)Is.is((Object)6));
        JsonField menuitemValue = (JsonField)menuitem.getJsonFields().getJsonField().get(0);
        Assert.assertNotNull((Object)menuitemValue);
        Assert.assertThat((Object)menuitemValue.getName(), (Matcher)Is.is((Object)"value"));
        Assert.assertThat((Object)menuitemValue.getValue(), (Matcher)Is.is((Object)"New"));
        Assert.assertThat((Object)menuitemValue.getPath(), (Matcher)Is.is((Object)"/menu/popup/menuitem/value"));
        Assert.assertThat((Object)menuitemValue.getFieldType(), (Matcher)Is.is((Object)FieldType.STRING));
        Assert.assertThat((Object)menuitemValue.getStatus(), (Matcher)Is.is((Object)FieldStatus.SUPPORTED));
        JsonField menuitemOnclick = (JsonField)menuitem.getJsonFields().getJsonField().get(1);
        Assert.assertNotNull((Object)menuitemOnclick);
        Assert.assertThat((Object)menuitemOnclick.getName(), (Matcher)Is.is((Object)"onclick"));
        Assert.assertThat((Object)menuitemOnclick.getValue(), (Matcher)Is.is((Object)"CreateNewDoc()"));
        Assert.assertThat((Object)menuitemOnclick.getPath(), (Matcher)Is.is((Object)"/menu/popup/menuitem/onclick"));
        Assert.assertThat((Object)menuitemOnclick.getFieldType(), (Matcher)Is.is((Object)FieldType.STRING));
        Assert.assertThat((Object)menuitemOnclick.getStatus(), (Matcher)Is.is((Object)FieldStatus.SUPPORTED));
        JsonField menuitem1Value = (JsonField)menuitem.getJsonFields().getJsonField().get(2);
        Assert.assertNotNull((Object)menuitem1Value);
        Assert.assertThat((Object)menuitem1Value.getName(), (Matcher)Is.is((Object)"value"));
        Assert.assertThat((Object)menuitem1Value.getValue(), (Matcher)Is.is((Object)"Open"));
        Assert.assertThat((Object)menuitem1Value.getPath(), (Matcher)Is.is((Object)"/menu/popup/menuitem[1]/value"));
        Assert.assertThat((Object)menuitem1Value.getFieldType(), (Matcher)Is.is((Object)FieldType.STRING));
        Assert.assertThat((Object)menuitem1Value.getStatus(), (Matcher)Is.is((Object)FieldStatus.SUPPORTED));
        JsonField menuitem1Onclick = (JsonField)menuitem.getJsonFields().getJsonField().get(3);
        Assert.assertNotNull((Object)menuitem1Onclick);
        Assert.assertThat((Object)menuitem1Onclick.getName(), (Matcher)Is.is((Object)"onclick"));
        Assert.assertThat((Object)menuitem1Onclick.getValue(), (Matcher)Is.is((Object)"OpenDoc()"));
        Assert.assertThat((Object)menuitem1Onclick.getPath(), (Matcher)Is.is((Object)"/menu/popup/menuitem[1]/onclick"));
        Assert.assertThat((Object)menuitem1Onclick.getFieldType(), (Matcher)Is.is((Object)FieldType.STRING));
        Assert.assertThat((Object)menuitem1Onclick.getStatus(), (Matcher)Is.is((Object)FieldStatus.SUPPORTED));
        JsonField menuitem2Value = (JsonField)menuitem.getJsonFields().getJsonField().get(4);
        Assert.assertNotNull((Object)menuitem2Value);
        Assert.assertThat((Object)menuitem2Value.getName(), (Matcher)Is.is((Object)"value"));
        Assert.assertThat((Object)menuitem2Value.getValue(), (Matcher)Is.is((Object)"Close"));
        Assert.assertThat((Object)menuitem2Value.getPath(), (Matcher)Is.is((Object)"/menu/popup/menuitem[2]/value"));
        Assert.assertThat((Object)menuitem2Value.getFieldType(), (Matcher)Is.is((Object)FieldType.STRING));
        Assert.assertThat((Object)menuitem2Value.getStatus(), (Matcher)Is.is((Object)FieldStatus.SUPPORTED));
        JsonField menuitem2Onclick = (JsonField)menuitem.getJsonFields().getJsonField().get(5);
        Assert.assertNotNull((Object)menuitem2Onclick);
        Assert.assertThat((Object)menuitem2Onclick.getName(), (Matcher)Is.is((Object)"onclick"));
        Assert.assertThat((Object)menuitem2Onclick.getValue(), (Matcher)Is.is((Object)"CloseDoc()"));
        Assert.assertThat((Object)menuitem2Onclick.getPath(), (Matcher)Is.is((Object)"/menu/popup/menuitem[2]/onclick"));
        Assert.assertThat((Object)menuitem2Onclick.getFieldType(), (Matcher)Is.is((Object)FieldType.STRING));
        Assert.assertThat((Object)menuitem2Onclick.getStatus(), (Matcher)Is.is((Object)FieldStatus.SUPPORTED));
    }

    @Test
    public void inspectJsonDocumentHighlyNestedObject() throws Exception {
        String instance = new String(Files.readAllBytes(Paths.get("src/test/resources/inspect/highly-nested-object.json", new String[0])));
        JsonDocument document = this.inspectionService.inspectJsonDocument(instance);
        Assert.assertNotNull((Object)document);
        Assert.assertThat((Object)document.getFields().getField().size(), (Matcher)Is.is((Object)6));
        JsonField id = (JsonField)document.getFields().getField().get(0);
        Assert.assertNotNull((Object)id);
        Assert.assertThat((Object)id.getName(), (Matcher)Is.is((Object)"id"));
        Assert.assertThat((Object)id.getValue(), (Matcher)Is.is((Object)"0001"));
        Assert.assertThat((Object)id.getPath(), (Matcher)Is.is((Object)"/id"));
        Assert.assertThat((Object)id.getFieldType(), (Matcher)Is.is((Object)FieldType.STRING));
        Assert.assertThat((Object)id.getStatus(), (Matcher)Is.is((Object)FieldStatus.SUPPORTED));
        JsonField value = (JsonField)document.getFields().getField().get(1);
        Assert.assertNotNull((Object)value);
        Assert.assertThat((Object)value.getName(), (Matcher)Is.is((Object)"type"));
        Assert.assertThat((Object)value.getValue(), (Matcher)Is.is((Object)"donut"));
        Assert.assertThat((Object)value.getPath(), (Matcher)Is.is((Object)"/type"));
        Assert.assertThat((Object)value.getFieldType(), (Matcher)Is.is((Object)FieldType.STRING));
        Assert.assertThat((Object)value.getStatus(), (Matcher)Is.is((Object)FieldStatus.SUPPORTED));
        JsonField name = (JsonField)document.getFields().getField().get(2);
        Assert.assertNotNull((Object)name);
        Assert.assertThat((Object)name.getName(), (Matcher)Is.is((Object)"name"));
        Assert.assertThat((Object)name.getValue(), (Matcher)Is.is((Object)"Cake"));
        Assert.assertThat((Object)name.getPath(), (Matcher)Is.is((Object)"/name"));
        Assert.assertThat((Object)name.getFieldType(), (Matcher)Is.is((Object)FieldType.STRING));
        Assert.assertThat((Object)name.getStatus(), (Matcher)Is.is((Object)FieldStatus.SUPPORTED));
        JsonField itemPPU = (JsonField)document.getFields().getField().get(3);
        Assert.assertNotNull((Object)itemPPU);
        Assert.assertThat((Object)itemPPU.getName(), (Matcher)Is.is((Object)"ppu"));
        Assert.assertThat((Object)itemPPU.getPath(), (Matcher)Is.is((Object)"/ppu"));
        Assert.assertThat((Object)itemPPU.getValue(), (Matcher)Is.is((Object)0.55));
        Assert.assertThat((Object)itemPPU.getFieldType(), (Matcher)Is.is((Object)FieldType.DOUBLE));
        Assert.assertThat((Object)itemPPU.getStatus(), (Matcher)Is.is((Object)FieldStatus.SUPPORTED));
        JsonComplexType batters = (JsonComplexType)document.getFields().getField().get(4);
        Assert.assertNotNull((Object)batters);
        Assert.assertThat((Object)batters.getJsonFields().getJsonField().size(), (Matcher)Is.is((Object)1));
        JsonComplexType batterParent = (JsonComplexType)batters.getJsonFields().getJsonField().get(0);
        Assert.assertNotNull((Object)batterParent);
        Assert.assertThat((Object)batterParent.getJsonFields().getJsonField().size(), (Matcher)Is.is((Object)8));
        JsonField batter0Id = (JsonField)batterParent.getJsonFields().getJsonField().get(0);
        Assert.assertNotNull((Object)batter0Id);
        Assert.assertThat((Object)batter0Id.getName(), (Matcher)Is.is((Object)"id"));
        Assert.assertThat((Object)batter0Id.getValue(), (Matcher)Is.is((Object)"1001"));
        Assert.assertThat((Object)batter0Id.getPath(), (Matcher)Is.is((Object)"/batters/batter/id"));
        Assert.assertThat((Object)batter0Id.getFieldType(), (Matcher)Is.is((Object)FieldType.STRING));
        Assert.assertThat((Object)batter0Id.getStatus(), (Matcher)Is.is((Object)FieldStatus.SUPPORTED));
        JsonField batter0Type = (JsonField)batterParent.getJsonFields().getJsonField().get(1);
        Assert.assertNotNull((Object)batter0Type);
        Assert.assertThat((Object)batter0Type.getName(), (Matcher)Is.is((Object)"type"));
        Assert.assertThat((Object)batter0Type.getValue(), (Matcher)Is.is((Object)"Regular"));
        Assert.assertThat((Object)batter0Type.getPath(), (Matcher)Is.is((Object)"/batters/batter/type"));
        Assert.assertThat((Object)batter0Type.getFieldType(), (Matcher)Is.is((Object)FieldType.STRING));
        Assert.assertThat((Object)batter0Type.getStatus(), (Matcher)Is.is((Object)FieldStatus.SUPPORTED));
        JsonField batter1Id = (JsonField)batterParent.getJsonFields().getJsonField().get(2);
        Assert.assertNotNull((Object)batter1Id);
        Assert.assertThat((Object)batter1Id.getName(), (Matcher)Is.is((Object)"id"));
        Assert.assertThat((Object)batter1Id.getValue(), (Matcher)Is.is((Object)"1002"));
        Assert.assertThat((Object)batter1Id.getPath(), (Matcher)Is.is((Object)"/batters/batter[1]/id"));
        Assert.assertThat((Object)batter1Id.getFieldType(), (Matcher)Is.is((Object)FieldType.STRING));
        Assert.assertThat((Object)batter1Id.getStatus(), (Matcher)Is.is((Object)FieldStatus.SUPPORTED));
        JsonField batter1Type = (JsonField)batterParent.getJsonFields().getJsonField().get(3);
        Assert.assertNotNull((Object)batter1Type);
        Assert.assertThat((Object)batter1Type.getName(), (Matcher)Is.is((Object)"type"));
        Assert.assertThat((Object)batter1Type.getValue(), (Matcher)Is.is((Object)"Chocolate"));
        Assert.assertThat((Object)batter1Type.getPath(), (Matcher)Is.is((Object)"/batters/batter[1]/type"));
        Assert.assertThat((Object)batter1Type.getFieldType(), (Matcher)Is.is((Object)FieldType.STRING));
        Assert.assertThat((Object)batter1Type.getStatus(), (Matcher)Is.is((Object)FieldStatus.SUPPORTED));
        JsonField batter2Id = (JsonField)batterParent.getJsonFields().getJsonField().get(4);
        Assert.assertNotNull((Object)batter2Id);
        Assert.assertThat((Object)batter2Id.getName(), (Matcher)Is.is((Object)"id"));
        Assert.assertThat((Object)batter2Id.getValue(), (Matcher)Is.is((Object)"1003"));
        Assert.assertThat((Object)batter2Id.getPath(), (Matcher)Is.is((Object)"/batters/batter[2]/id"));
        Assert.assertThat((Object)batter2Id.getFieldType(), (Matcher)Is.is((Object)FieldType.STRING));
        Assert.assertThat((Object)batter2Id.getStatus(), (Matcher)Is.is((Object)FieldStatus.SUPPORTED));
        JsonField batter2Type = (JsonField)batterParent.getJsonFields().getJsonField().get(5);
        Assert.assertNotNull((Object)batter2Type);
        Assert.assertThat((Object)batter2Type.getName(), (Matcher)Is.is((Object)"type"));
        Assert.assertThat((Object)batter2Type.getValue(), (Matcher)Is.is((Object)"Blueberry"));
        Assert.assertThat((Object)batter2Type.getPath(), (Matcher)Is.is((Object)"/batters/batter[2]/type"));
        Assert.assertThat((Object)batter2Type.getFieldType(), (Matcher)Is.is((Object)FieldType.STRING));
        Assert.assertThat((Object)batter2Type.getStatus(), (Matcher)Is.is((Object)FieldStatus.SUPPORTED));
        JsonField batter3Id = (JsonField)batterParent.getJsonFields().getJsonField().get(6);
        Assert.assertNotNull((Object)batter3Id);
        Assert.assertThat((Object)batter3Id.getName(), (Matcher)Is.is((Object)"id"));
        Assert.assertThat((Object)batter3Id.getValue(), (Matcher)Is.is((Object)"1004"));
        Assert.assertThat((Object)batter3Id.getPath(), (Matcher)Is.is((Object)"/batters/batter[3]/id"));
        Assert.assertThat((Object)batter3Id.getFieldType(), (Matcher)Is.is((Object)FieldType.STRING));
        Assert.assertThat((Object)batter3Id.getStatus(), (Matcher)Is.is((Object)FieldStatus.SUPPORTED));
        JsonField batter3Type = (JsonField)batterParent.getJsonFields().getJsonField().get(7);
        Assert.assertNotNull((Object)batter3Type);
        Assert.assertThat((Object)batter3Type.getName(), (Matcher)Is.is((Object)"type"));
        Assert.assertThat((Object)batter3Type.getValue(), (Matcher)Is.is((Object)"Devil's Food"));
        Assert.assertThat((Object)batter3Type.getPath(), (Matcher)Is.is((Object)"/batters/batter[3]/type"));
        Assert.assertThat((Object)batter3Type.getFieldType(), (Matcher)Is.is((Object)FieldType.STRING));
        Assert.assertThat((Object)batter3Type.getStatus(), (Matcher)Is.is((Object)FieldStatus.SUPPORTED));
        JsonComplexType topping = (JsonComplexType)document.getFields().getField().get(5);
        Assert.assertNotNull((Object)topping);
        Assert.assertThat((Object)topping.getJsonFields().getJsonField().size(), (Matcher)Is.is((Object)14));
        JsonField toppingId0 = (JsonField)topping.getJsonFields().getJsonField().get(0);
        Assert.assertNotNull((Object)toppingId0);
        Assert.assertThat((Object)toppingId0.getName(), (Matcher)Is.is((Object)"id"));
        Assert.assertThat((Object)toppingId0.getValue(), (Matcher)Is.is((Object)"5001"));
        Assert.assertThat((Object)toppingId0.getPath(), (Matcher)Is.is((Object)"/topping/id"));
        Assert.assertThat((Object)toppingId0.getFieldType(), (Matcher)Is.is((Object)FieldType.STRING));
        Assert.assertThat((Object)toppingId0.getStatus(), (Matcher)Is.is((Object)FieldStatus.SUPPORTED));
        JsonField toppingType0 = (JsonField)topping.getJsonFields().getJsonField().get(1);
        Assert.assertNotNull((Object)toppingType0);
        Assert.assertThat((Object)toppingType0.getName(), (Matcher)Is.is((Object)"type"));
        Assert.assertThat((Object)toppingType0.getValue(), (Matcher)Is.is((Object)"None"));
        Assert.assertThat((Object)toppingType0.getPath(), (Matcher)Is.is((Object)"/topping/type"));
        Assert.assertThat((Object)toppingType0.getFieldType(), (Matcher)Is.is((Object)FieldType.STRING));
        Assert.assertThat((Object)toppingType0.getStatus(), (Matcher)Is.is((Object)FieldStatus.SUPPORTED));
        JsonField toppingId1 = (JsonField)topping.getJsonFields().getJsonField().get(2);
        Assert.assertNotNull((Object)toppingId1);
        Assert.assertThat((Object)toppingId1.getName(), (Matcher)Is.is((Object)"id"));
        Assert.assertThat((Object)toppingId1.getValue(), (Matcher)Is.is((Object)"5002"));
        Assert.assertThat((Object)toppingId1.getPath(), (Matcher)Is.is((Object)"/topping/id[1]"));
        Assert.assertThat((Object)toppingId1.getFieldType(), (Matcher)Is.is((Object)FieldType.STRING));
        Assert.assertThat((Object)toppingId1.getStatus(), (Matcher)Is.is((Object)FieldStatus.SUPPORTED));
        JsonField toppingType1 = (JsonField)topping.getJsonFields().getJsonField().get(3);
        Assert.assertNotNull((Object)toppingType1);
        Assert.assertThat((Object)toppingType1.getName(), (Matcher)Is.is((Object)"type"));
        Assert.assertThat((Object)toppingType1.getValue(), (Matcher)Is.is((Object)"Glazed"));
        Assert.assertThat((Object)toppingType1.getPath(), (Matcher)Is.is((Object)"/topping/type[1]"));
        Assert.assertThat((Object)toppingType1.getFieldType(), (Matcher)Is.is((Object)FieldType.STRING));
        Assert.assertThat((Object)toppingType1.getStatus(), (Matcher)Is.is((Object)FieldStatus.SUPPORTED));
        JsonField toppingId2 = (JsonField)topping.getJsonFields().getJsonField().get(4);
        Assert.assertNotNull((Object)toppingId2);
        Assert.assertThat((Object)toppingId2.getName(), (Matcher)Is.is((Object)"id"));
        Assert.assertThat((Object)toppingId2.getValue(), (Matcher)Is.is((Object)"5005"));
        Assert.assertThat((Object)toppingId2.getPath(), (Matcher)Is.is((Object)"/topping/id[2]"));
        Assert.assertThat((Object)toppingId2.getFieldType(), (Matcher)Is.is((Object)FieldType.STRING));
        Assert.assertThat((Object)toppingId2.getStatus(), (Matcher)Is.is((Object)FieldStatus.SUPPORTED));
        JsonField toppingType2 = (JsonField)topping.getJsonFields().getJsonField().get(5);
        Assert.assertNotNull((Object)toppingType2);
        Assert.assertThat((Object)toppingType2.getName(), (Matcher)Is.is((Object)"type"));
        Assert.assertThat((Object)toppingType2.getValue(), (Matcher)Is.is((Object)"Sugar"));
        Assert.assertThat((Object)toppingType2.getPath(), (Matcher)Is.is((Object)"/topping/type[2]"));
        Assert.assertThat((Object)toppingType2.getFieldType(), (Matcher)Is.is((Object)FieldType.STRING));
        Assert.assertThat((Object)toppingType2.getStatus(), (Matcher)Is.is((Object)FieldStatus.SUPPORTED));
    }

    @Test
    public void inspectJsonDocumentHighlyComplexNestedObject() throws Exception {
        String instance = new String(Files.readAllBytes(Paths.get("src/test/resources/inspect/highly-complex-nested-object.json", new String[0])));
        JsonDocument document = this.inspectionService.inspectJsonDocument(instance);
        Assert.assertNotNull((Object)document);
        Assert.assertThat((Object)document.getFields().getField().size(), (Matcher)Is.is((Object)1));
        JsonComplexType items = (JsonComplexType)document.getFields().getField().get(0);
        Assert.assertNotNull((Object)items);
        Assert.assertThat((Object)items.getFieldType(), (Matcher)Is.is((Object)FieldType.COMPLEX));
        Assert.assertThat((Object)items.getStatus(), (Matcher)Is.is((Object)FieldStatus.SUPPORTED));
        Assert.assertThat((Object)items.getName(), (Matcher)Is.is((Object)"items"));
        Assert.assertThat((Object)items.getJsonFields().getJsonField().size(), (Matcher)Is.is((Object)1));
        JsonComplexType item = (JsonComplexType)items.getJsonFields().getJsonField().get(0);
        Assert.assertNotNull((Object)item);
        Assert.assertThat((Object)item.getFieldType(), (Matcher)Is.is((Object)FieldType.COMPLEX));
        Assert.assertThat((Object)item.getJsonFields().getJsonField().size(), (Matcher)Is.is((Object)38));
        JsonField itemId = (JsonField)item.getJsonFields().getJsonField().get(0);
        Assert.assertNotNull((Object)itemId);
        Assert.assertThat((Object)itemId.getName(), (Matcher)Is.is((Object)"id"));
        Assert.assertThat((Object)itemId.getValue(), (Matcher)Is.is((Object)"0001"));
        Assert.assertThat((Object)itemId.getPath(), (Matcher)Is.is((Object)"/items/item/id"));
        Assert.assertThat((Object)itemId.getFieldType(), (Matcher)Is.is((Object)FieldType.STRING));
        Assert.assertThat((Object)itemId.getStatus(), (Matcher)Is.is((Object)FieldStatus.SUPPORTED));
        JsonField itemValue = (JsonField)item.getJsonFields().getJsonField().get(1);
        Assert.assertNotNull((Object)itemValue);
        Assert.assertThat((Object)itemValue.getName(), (Matcher)Is.is((Object)"type"));
        Assert.assertThat((Object)itemValue.getValue(), (Matcher)Is.is((Object)"donut"));
        Assert.assertThat((Object)itemValue.getPath(), (Matcher)Is.is((Object)"/items/item/type"));
        Assert.assertThat((Object)itemValue.getFieldType(), (Matcher)Is.is((Object)FieldType.STRING));
        Assert.assertThat((Object)itemValue.getStatus(), (Matcher)Is.is((Object)FieldStatus.SUPPORTED));
        JsonField itemName = (JsonField)item.getJsonFields().getJsonField().get(2);
        Assert.assertNotNull((Object)itemName);
        Assert.assertThat((Object)itemName.getName(), (Matcher)Is.is((Object)"name"));
        Assert.assertThat((Object)itemName.getValue(), (Matcher)Is.is((Object)"Cake"));
        Assert.assertThat((Object)itemName.getPath(), (Matcher)Is.is((Object)"/items/item/name"));
        Assert.assertThat((Object)itemName.getFieldType(), (Matcher)Is.is((Object)FieldType.STRING));
        Assert.assertThat((Object)itemName.getStatus(), (Matcher)Is.is((Object)FieldStatus.SUPPORTED));
        JsonField itemPPU = (JsonField)item.getJsonFields().getJsonField().get(3);
        Assert.assertNotNull((Object)itemPPU);
        Assert.assertThat((Object)itemPPU.getName(), (Matcher)Is.is((Object)"ppu"));
        Assert.assertThat((Object)itemPPU.getPath(), (Matcher)Is.is((Object)"/items/item/ppu"));
        Assert.assertThat((Object)itemPPU.getValue(), (Matcher)Is.is((Object)0.55));
        Assert.assertThat((Object)itemPPU.getFieldType(), (Matcher)Is.is((Object)FieldType.DOUBLE));
        Assert.assertThat((Object)itemPPU.getStatus(), (Matcher)Is.is((Object)FieldStatus.SUPPORTED));
        JsonComplexType itemBattersComplexType = (JsonComplexType)item.getJsonFields().getJsonField().get(4);
        Assert.assertNotNull((Object)itemBattersComplexType);
        Assert.assertThat((Object)itemBattersComplexType.getFieldType(), (Matcher)Is.is((Object)FieldType.COMPLEX));
        Assert.assertThat((Object)itemBattersComplexType.getName(), (Matcher)Is.is((Object)"batters"));
        Assert.assertThat((Object)itemBattersComplexType.getJsonFields().getJsonField().size(), (Matcher)Is.is((Object)1));
        JsonComplexType itemBatterComplexType = (JsonComplexType)itemBattersComplexType.getJsonFields().getJsonField().get(0);
        Assert.assertNotNull((Object)itemBatterComplexType);
        Assert.assertThat((Object)itemBatterComplexType.getFieldType(), (Matcher)Is.is((Object)FieldType.COMPLEX));
        Assert.assertThat((Object)itemBatterComplexType.getName(), (Matcher)Is.is((Object)"batter"));
        Assert.assertThat((Object)itemBatterComplexType.getJsonFields().getJsonField().size(), (Matcher)Is.is((Object)8));
        JsonField batterId = (JsonField)itemBatterComplexType.getJsonFields().getJsonField().get(0);
        Assert.assertNotNull((Object)batterId);
        Assert.assertThat((Object)batterId.getName(), (Matcher)Is.is((Object)"id"));
        Assert.assertThat((Object)batterId.getValue(), (Matcher)Is.is((Object)"1001"));
        Assert.assertThat((Object)batterId.getPath(), (Matcher)Is.is((Object)"/items/item/batters/batter/id"));
        Assert.assertThat((Object)batterId.getFieldType(), (Matcher)Is.is((Object)FieldType.STRING));
        Assert.assertThat((Object)batterId.getStatus(), (Matcher)Is.is((Object)FieldStatus.SUPPORTED));
        JsonField batterType = (JsonField)itemBatterComplexType.getJsonFields().getJsonField().get(1);
        Assert.assertNotNull((Object)batterType);
        Assert.assertThat((Object)batterType.getName(), (Matcher)Is.is((Object)"type"));
        Assert.assertThat((Object)batterType.getValue(), (Matcher)Is.is((Object)"Regular"));
        Assert.assertThat((Object)batterType.getPath(), (Matcher)Is.is((Object)"/items/item/batters/batter/type"));
        Assert.assertThat((Object)batterType.getFieldType(), (Matcher)Is.is((Object)FieldType.STRING));
        Assert.assertThat((Object)batterType.getStatus(), (Matcher)Is.is((Object)FieldStatus.SUPPORTED));
        JsonField batterId1 = (JsonField)itemBatterComplexType.getJsonFields().getJsonField().get(2);
        Assert.assertNotNull((Object)batterId1);
        Assert.assertThat((Object)batterId1.getName(), (Matcher)Is.is((Object)"id"));
        Assert.assertThat((Object)batterId1.getValue(), (Matcher)Is.is((Object)"1002"));
        Assert.assertThat((Object)batterId1.getPath(), (Matcher)Is.is((Object)"/items/item/batters/batter[1]/id"));
        Assert.assertThat((Object)batterId1.getFieldType(), (Matcher)Is.is((Object)FieldType.STRING));
        Assert.assertThat((Object)batterId1.getStatus(), (Matcher)Is.is((Object)FieldStatus.SUPPORTED));
        JsonField batterType1 = (JsonField)itemBatterComplexType.getJsonFields().getJsonField().get(3);
        Assert.assertNotNull((Object)batterType1);
        Assert.assertThat((Object)batterType1.getName(), (Matcher)Is.is((Object)"type"));
        Assert.assertThat((Object)batterType1.getValue(), (Matcher)Is.is((Object)"Chocolate"));
        Assert.assertThat((Object)batterType1.getPath(), (Matcher)Is.is((Object)"/items/item/batters/batter[1]/type"));
        Assert.assertThat((Object)batterType1.getFieldType(), (Matcher)Is.is((Object)FieldType.STRING));
        Assert.assertThat((Object)batterType1.getStatus(), (Matcher)Is.is((Object)FieldStatus.SUPPORTED));
        JsonField batterId2 = (JsonField)itemBatterComplexType.getJsonFields().getJsonField().get(4);
        Assert.assertNotNull((Object)batterId2);
        Assert.assertThat((Object)batterId2.getName(), (Matcher)Is.is((Object)"id"));
        Assert.assertThat((Object)batterId2.getValue(), (Matcher)Is.is((Object)"1003"));
        Assert.assertThat((Object)batterId2.getPath(), (Matcher)Is.is((Object)"/items/item/batters/batter[2]/id"));
        Assert.assertThat((Object)batterId2.getFieldType(), (Matcher)Is.is((Object)FieldType.STRING));
        Assert.assertThat((Object)batterId2.getStatus(), (Matcher)Is.is((Object)FieldStatus.SUPPORTED));
        JsonField batterType2 = (JsonField)itemBatterComplexType.getJsonFields().getJsonField().get(5);
        Assert.assertNotNull((Object)batterType2);
        Assert.assertThat((Object)batterType2.getName(), (Matcher)Is.is((Object)"type"));
        Assert.assertThat((Object)batterType2.getValue(), (Matcher)Is.is((Object)"Blueberry"));
        Assert.assertThat((Object)batterType2.getPath(), (Matcher)Is.is((Object)"/items/item/batters/batter[2]/type"));
        Assert.assertThat((Object)batterType2.getFieldType(), (Matcher)Is.is((Object)FieldType.STRING));
        Assert.assertThat((Object)batterType2.getStatus(), (Matcher)Is.is((Object)FieldStatus.SUPPORTED));
        JsonField batterId3 = (JsonField)itemBatterComplexType.getJsonFields().getJsonField().get(6);
        Assert.assertNotNull((Object)batterId3);
        Assert.assertThat((Object)batterId3.getName(), (Matcher)Is.is((Object)"id"));
        Assert.assertThat((Object)batterId3.getValue(), (Matcher)Is.is((Object)"1004"));
        Assert.assertThat((Object)batterId3.getPath(), (Matcher)Is.is((Object)"/items/item/batters/batter[3]/id"));
        Assert.assertThat((Object)batterId3.getFieldType(), (Matcher)Is.is((Object)FieldType.STRING));
        Assert.assertThat((Object)batterId3.getStatus(), (Matcher)Is.is((Object)FieldStatus.SUPPORTED));
        JsonField batterType3 = (JsonField)itemBatterComplexType.getJsonFields().getJsonField().get(7);
        Assert.assertNotNull((Object)batterType3);
        Assert.assertThat((Object)batterType3.getName(), (Matcher)Is.is((Object)"type"));
        Assert.assertThat((Object)batterType3.getValue(), (Matcher)Is.is((Object)"Devil's Food"));
        Assert.assertThat((Object)batterType3.getPath(), (Matcher)Is.is((Object)"/items/item/batters/batter[3]/type"));
        Assert.assertThat((Object)batterType3.getFieldType(), (Matcher)Is.is((Object)FieldType.STRING));
        Assert.assertThat((Object)batterType3.getStatus(), (Matcher)Is.is((Object)FieldStatus.SUPPORTED));
        JsonComplexType itemToppingComplexType = (JsonComplexType)item.getJsonFields().getJsonField().get(5);
        Assert.assertNotNull((Object)itemToppingComplexType);
        Assert.assertThat((Object)itemToppingComplexType.getFieldType(), (Matcher)Is.is((Object)FieldType.COMPLEX));
        Assert.assertThat((Object)itemToppingComplexType.getName(), (Matcher)Is.is((Object)"topping"));
        Assert.assertThat((Object)itemToppingComplexType.getJsonFields().getJsonField().size(), (Matcher)Is.is((Object)14));
        JsonField toppingID = (JsonField)itemToppingComplexType.getJsonFields().getJsonField().get(0);
        Assert.assertNotNull((Object)toppingID);
        Assert.assertThat((Object)toppingID.getName(), (Matcher)Is.is((Object)"id"));
        Assert.assertThat((Object)toppingID.getValue(), (Matcher)Is.is((Object)"5001"));
        Assert.assertThat((Object)toppingID.getPath(), (Matcher)Is.is((Object)"/items/item/topping/id"));
        Assert.assertThat((Object)toppingID.getFieldType(), (Matcher)Is.is((Object)FieldType.STRING));
        Assert.assertThat((Object)toppingID.getStatus(), (Matcher)Is.is((Object)FieldStatus.SUPPORTED));
        JsonField toppingType = (JsonField)itemToppingComplexType.getJsonFields().getJsonField().get(1);
        Assert.assertNotNull((Object)toppingType);
        Assert.assertThat((Object)toppingType.getName(), (Matcher)Is.is((Object)"type"));
        Assert.assertThat((Object)toppingType.getValue(), (Matcher)Is.is((Object)"None"));
        Assert.assertThat((Object)toppingType.getPath(), (Matcher)Is.is((Object)"/items/item/topping/type"));
        Assert.assertThat((Object)toppingType.getFieldType(), (Matcher)Is.is((Object)FieldType.STRING));
        Assert.assertThat((Object)toppingType.getStatus(), (Matcher)Is.is((Object)FieldStatus.SUPPORTED));
        JsonField toppingID1 = (JsonField)itemToppingComplexType.getJsonFields().getJsonField().get(2);
        Assert.assertNotNull((Object)toppingID1);
        Assert.assertThat((Object)toppingID1.getName(), (Matcher)Is.is((Object)"id"));
        Assert.assertThat((Object)toppingID1.getValue(), (Matcher)Is.is((Object)"5002"));
        Assert.assertThat((Object)toppingID1.getPath(), (Matcher)Is.is((Object)"/items/item/topping/id[1]"));
        Assert.assertThat((Object)toppingID1.getFieldType(), (Matcher)Is.is((Object)FieldType.STRING));
        Assert.assertThat((Object)toppingID1.getStatus(), (Matcher)Is.is((Object)FieldStatus.SUPPORTED));
        JsonField toppingType1 = (JsonField)itemToppingComplexType.getJsonFields().getJsonField().get(3);
        Assert.assertNotNull((Object)toppingType1);
        Assert.assertThat((Object)toppingType1.getName(), (Matcher)Is.is((Object)"type"));
        Assert.assertThat((Object)toppingType1.getValue(), (Matcher)Is.is((Object)"Glazed"));
        Assert.assertThat((Object)toppingType1.getPath(), (Matcher)Is.is((Object)"/items/item/topping/type[1]"));
        Assert.assertThat((Object)toppingType1.getFieldType(), (Matcher)Is.is((Object)FieldType.STRING));
        Assert.assertThat((Object)toppingType1.getStatus(), (Matcher)Is.is((Object)FieldStatus.SUPPORTED));
        JsonField toppingID2 = (JsonField)itemToppingComplexType.getJsonFields().getJsonField().get(4);
        Assert.assertNotNull((Object)toppingID2);
        Assert.assertThat((Object)toppingID2.getName(), (Matcher)Is.is((Object)"id"));
        Assert.assertThat((Object)toppingID2.getValue(), (Matcher)Is.is((Object)"5005"));
        Assert.assertThat((Object)toppingID2.getPath(), (Matcher)Is.is((Object)"/items/item/topping/id[2]"));
        Assert.assertThat((Object)toppingID2.getFieldType(), (Matcher)Is.is((Object)FieldType.STRING));
        Assert.assertThat((Object)toppingID2.getStatus(), (Matcher)Is.is((Object)FieldStatus.SUPPORTED));
        JsonField toppingType2 = (JsonField)itemToppingComplexType.getJsonFields().getJsonField().get(5);
        Assert.assertNotNull((Object)toppingType2);
        Assert.assertThat((Object)toppingType2.getName(), (Matcher)Is.is((Object)"type"));
        Assert.assertThat((Object)toppingType2.getValue(), (Matcher)Is.is((Object)"Sugar"));
        Assert.assertThat((Object)toppingType2.getPath(), (Matcher)Is.is((Object)"/items/item/topping/type[2]"));
        Assert.assertThat((Object)toppingType2.getFieldType(), (Matcher)Is.is((Object)FieldType.STRING));
        Assert.assertThat((Object)toppingType2.getStatus(), (Matcher)Is.is((Object)FieldStatus.SUPPORTED));
        JsonField toppingID3 = (JsonField)itemToppingComplexType.getJsonFields().getJsonField().get(6);
        Assert.assertNotNull((Object)toppingID3);
        Assert.assertThat((Object)toppingID3.getName(), (Matcher)Is.is((Object)"id"));
        Assert.assertThat((Object)toppingID3.getValue(), (Matcher)Is.is((Object)"5007"));
        Assert.assertThat((Object)toppingID3.getPath(), (Matcher)Is.is((Object)"/items/item/topping/id[3]"));
        Assert.assertThat((Object)toppingID3.getFieldType(), (Matcher)Is.is((Object)FieldType.STRING));
        Assert.assertThat((Object)toppingID3.getStatus(), (Matcher)Is.is((Object)FieldStatus.SUPPORTED));
        JsonField toppingType3 = (JsonField)itemToppingComplexType.getJsonFields().getJsonField().get(7);
        Assert.assertNotNull((Object)toppingType3);
        Assert.assertThat((Object)toppingType3.getName(), (Matcher)Is.is((Object)"type"));
        Assert.assertThat((Object)toppingType3.getValue(), (Matcher)Is.is((Object)"Powdered Sugar"));
        Assert.assertThat((Object)toppingType3.getPath(), (Matcher)Is.is((Object)"/items/item/topping/type[3]"));
        Assert.assertThat((Object)toppingType3.getFieldType(), (Matcher)Is.is((Object)FieldType.STRING));
        Assert.assertThat((Object)toppingType3.getStatus(), (Matcher)Is.is((Object)FieldStatus.SUPPORTED));
        JsonField toppingID4 = (JsonField)itemToppingComplexType.getJsonFields().getJsonField().get(8);
        Assert.assertNotNull((Object)toppingID4);
        Assert.assertThat((Object)toppingID4.getName(), (Matcher)Is.is((Object)"id"));
        Assert.assertThat((Object)toppingID4.getValue(), (Matcher)Is.is((Object)"5006"));
        Assert.assertThat((Object)toppingID4.getPath(), (Matcher)Is.is((Object)"/items/item/topping/id[4]"));
        Assert.assertThat((Object)toppingID4.getFieldType(), (Matcher)Is.is((Object)FieldType.STRING));
        Assert.assertThat((Object)toppingID4.getStatus(), (Matcher)Is.is((Object)FieldStatus.SUPPORTED));
        JsonField toppingType4 = (JsonField)itemToppingComplexType.getJsonFields().getJsonField().get(9);
        Assert.assertNotNull((Object)toppingType4);
        Assert.assertThat((Object)toppingType4.getName(), (Matcher)Is.is((Object)"type"));
        Assert.assertThat((Object)toppingType4.getValue(), (Matcher)Is.is((Object)"Chocolate with Sprinkles"));
        Assert.assertThat((Object)toppingType4.getPath(), (Matcher)Is.is((Object)"/items/item/topping/type[4]"));
        Assert.assertThat((Object)toppingType4.getFieldType(), (Matcher)Is.is((Object)FieldType.STRING));
        Assert.assertThat((Object)toppingType4.getStatus(), (Matcher)Is.is((Object)FieldStatus.SUPPORTED));
        JsonField toppingID5 = (JsonField)itemToppingComplexType.getJsonFields().getJsonField().get(10);
        Assert.assertNotNull((Object)toppingID5);
        Assert.assertThat((Object)toppingID5.getName(), (Matcher)Is.is((Object)"id"));
        Assert.assertThat((Object)toppingID5.getValue(), (Matcher)Is.is((Object)"5003"));
        Assert.assertThat((Object)toppingID5.getPath(), (Matcher)Is.is((Object)"/items/item/topping/id[5]"));
        Assert.assertThat((Object)toppingID5.getFieldType(), (Matcher)Is.is((Object)FieldType.STRING));
        Assert.assertThat((Object)toppingID5.getStatus(), (Matcher)Is.is((Object)FieldStatus.SUPPORTED));
        JsonField toppingType5 = (JsonField)itemToppingComplexType.getJsonFields().getJsonField().get(11);
        Assert.assertNotNull((Object)toppingType5);
        Assert.assertThat((Object)toppingType5.getName(), (Matcher)Is.is((Object)"type"));
        Assert.assertThat((Object)toppingType5.getValue(), (Matcher)Is.is((Object)"Chocolate"));
        Assert.assertThat((Object)toppingType5.getPath(), (Matcher)Is.is((Object)"/items/item/topping/type[5]"));
        Assert.assertThat((Object)toppingType5.getFieldType(), (Matcher)Is.is((Object)FieldType.STRING));
        Assert.assertThat((Object)toppingType5.getStatus(), (Matcher)Is.is((Object)FieldStatus.SUPPORTED));
        JsonField toppingID6 = (JsonField)itemToppingComplexType.getJsonFields().getJsonField().get(12);
        Assert.assertNotNull((Object)toppingID6);
        Assert.assertThat((Object)toppingID6.getName(), (Matcher)Is.is((Object)"id"));
        Assert.assertThat((Object)toppingID6.getValue(), (Matcher)Is.is((Object)"5004"));
        Assert.assertThat((Object)toppingID6.getPath(), (Matcher)Is.is((Object)"/items/item/topping/id[6]"));
        Assert.assertThat((Object)toppingID6.getFieldType(), (Matcher)Is.is((Object)FieldType.STRING));
        Assert.assertThat((Object)toppingID6.getStatus(), (Matcher)Is.is((Object)FieldStatus.SUPPORTED));
        JsonField toppingType6 = (JsonField)itemToppingComplexType.getJsonFields().getJsonField().get(13);
        Assert.assertNotNull((Object)toppingType6);
        Assert.assertThat((Object)toppingType6.getName(), (Matcher)Is.is((Object)"type"));
        Assert.assertThat((Object)toppingType6.getValue(), (Matcher)Is.is((Object)"Maple"));
        Assert.assertThat((Object)toppingType6.getPath(), (Matcher)Is.is((Object)"/items/item/topping/type[6]"));
        Assert.assertThat((Object)toppingType6.getFieldType(), (Matcher)Is.is((Object)FieldType.STRING));
        Assert.assertThat((Object)toppingType6.getStatus(), (Matcher)Is.is((Object)FieldStatus.SUPPORTED));
        JsonField item1 = (JsonField)item.getJsonFields().getJsonField().get(6);
        Assert.assertNotNull((Object)item1);
        Assert.assertThat((Object)item1.getName(), (Matcher)Is.is((Object)"id"));
        Assert.assertThat((Object)item1.getValue(), (Matcher)Is.is((Object)"0002"));
        Assert.assertThat((Object)item1.getPath(), (Matcher)Is.is((Object)"/items/item[1]/id"));
        Assert.assertThat((Object)item1.getFieldType(), (Matcher)Is.is((Object)FieldType.STRING));
        Assert.assertThat((Object)item1.getStatus(), (Matcher)Is.is((Object)FieldStatus.SUPPORTED));
        JsonField itemValue1 = (JsonField)item.getJsonFields().getJsonField().get(7);
        Assert.assertNotNull((Object)itemValue1);
        Assert.assertThat((Object)itemValue1.getName(), (Matcher)Is.is((Object)"type"));
        Assert.assertThat((Object)itemValue1.getValue(), (Matcher)Is.is((Object)"donut"));
        Assert.assertThat((Object)itemValue1.getPath(), (Matcher)Is.is((Object)"/items/item[1]/type"));
        Assert.assertThat((Object)itemValue1.getFieldType(), (Matcher)Is.is((Object)FieldType.STRING));
        Assert.assertThat((Object)itemValue1.getStatus(), (Matcher)Is.is((Object)FieldStatus.SUPPORTED));
        JsonField itemName1 = (JsonField)item.getJsonFields().getJsonField().get(8);
        Assert.assertNotNull((Object)itemName1);
        Assert.assertThat((Object)itemName1.getName(), (Matcher)Is.is((Object)"name"));
        Assert.assertThat((Object)itemName1.getValue(), (Matcher)Is.is((Object)"Raised"));
        Assert.assertThat((Object)itemName1.getPath(), (Matcher)Is.is((Object)"/items/item[1]/name"));
        Assert.assertThat((Object)itemName1.getFieldType(), (Matcher)Is.is((Object)FieldType.STRING));
        Assert.assertThat((Object)itemName1.getStatus(), (Matcher)Is.is((Object)FieldStatus.SUPPORTED));
        JsonField itemPPU1 = (JsonField)item.getJsonFields().getJsonField().get(9);
        Assert.assertNotNull((Object)itemPPU1);
        Assert.assertThat((Object)itemPPU1.getName(), (Matcher)Is.is((Object)"ppu"));
        Assert.assertThat((Object)itemPPU1.getPath(), (Matcher)Is.is((Object)"/items/item[1]/ppu"));
        Assert.assertThat((Object)itemPPU1.getValue(), (Matcher)Is.is((Object)0.55));
        Assert.assertThat((Object)itemPPU1.getFieldType(), (Matcher)Is.is((Object)FieldType.DOUBLE));
        Assert.assertThat((Object)itemPPU1.getStatus(), (Matcher)Is.is((Object)FieldStatus.SUPPORTED));
        JsonComplexType itemBattersComplexType1 = (JsonComplexType)item.getJsonFields().getJsonField().get(10);
        Assert.assertNotNull((Object)itemBattersComplexType1);
        Assert.assertThat((Object)itemBattersComplexType1.getFieldType(), (Matcher)Is.is((Object)FieldType.COMPLEX));
        Assert.assertThat((Object)itemBattersComplexType1.getName(), (Matcher)Is.is((Object)"batters"));
        Assert.assertThat((Object)itemBattersComplexType1.getJsonFields().getJsonField().size(), (Matcher)Is.is((Object)1));
        JsonComplexType itemBatterComplexType1 = (JsonComplexType)itemBattersComplexType1.getJsonFields().getJsonField().get(0);
        Assert.assertNotNull((Object)itemBatterComplexType1);
        Assert.assertThat((Object)itemBatterComplexType1.getFieldType(), (Matcher)Is.is((Object)FieldType.COMPLEX));
        Assert.assertThat((Object)itemBatterComplexType1.getName(), (Matcher)Is.is((Object)"batter"));
        Assert.assertThat((Object)itemBatterComplexType1.getJsonFields().getJsonField().size(), (Matcher)Is.is((Object)2));
        JsonField batterId10 = (JsonField)itemBatterComplexType1.getJsonFields().getJsonField().get(0);
        Assert.assertNotNull((Object)batterId10);
        Assert.assertThat((Object)batterId10.getName(), (Matcher)Is.is((Object)"id"));
        Assert.assertThat((Object)batterId10.getValue(), (Matcher)Is.is((Object)"1001"));
        Assert.assertThat((Object)batterId10.getPath(), (Matcher)Is.is((Object)"/items/item[1]/batters/batter/id"));
        Assert.assertThat((Object)batterId10.getFieldType(), (Matcher)Is.is((Object)FieldType.STRING));
        Assert.assertThat((Object)batterId10.getStatus(), (Matcher)Is.is((Object)FieldStatus.SUPPORTED));
        JsonField batterType10 = (JsonField)itemBatterComplexType1.getJsonFields().getJsonField().get(1);
        Assert.assertNotNull((Object)batterType10);
        Assert.assertThat((Object)batterType10.getName(), (Matcher)Is.is((Object)"type"));
        Assert.assertThat((Object)batterType10.getValue(), (Matcher)Is.is((Object)"Regular"));
        Assert.assertThat((Object)batterType10.getPath(), (Matcher)Is.is((Object)"/items/item[1]/batters/batter/type"));
        Assert.assertThat((Object)batterType10.getFieldType(), (Matcher)Is.is((Object)FieldType.STRING));
        Assert.assertThat((Object)batterType10.getStatus(), (Matcher)Is.is((Object)FieldStatus.SUPPORTED));
        JsonComplexType itemToppingsComplexType1 = (JsonComplexType)item.getJsonFields().getJsonField().get(11);
        Assert.assertNotNull((Object)itemToppingsComplexType1);
        Assert.assertThat((Object)itemToppingsComplexType1.getFieldType(), (Matcher)Is.is((Object)FieldType.COMPLEX));
        Assert.assertThat((Object)itemToppingsComplexType1.getName(), (Matcher)Is.is((Object)"topping"));
        Assert.assertThat((Object)itemToppingsComplexType1.getJsonFields().getJsonField().size(), (Matcher)Is.is((Object)10));
        JsonField toppingID11 = (JsonField)itemToppingsComplexType1.getJsonFields().getJsonField().get(0);
        Assert.assertNotNull((Object)toppingID11);
        Assert.assertThat((Object)toppingID11.getName(), (Matcher)Is.is((Object)"id"));
        Assert.assertThat((Object)toppingID11.getValue(), (Matcher)Is.is((Object)"5001"));
        Assert.assertThat((Object)toppingID11.getPath(), (Matcher)Is.is((Object)"/items/item[1]/topping/id"));
        Assert.assertThat((Object)toppingID11.getFieldType(), (Matcher)Is.is((Object)FieldType.STRING));
        Assert.assertThat((Object)toppingID11.getStatus(), (Matcher)Is.is((Object)FieldStatus.SUPPORTED));
        JsonField toppingType11 = (JsonField)itemToppingsComplexType1.getJsonFields().getJsonField().get(1);
        Assert.assertNotNull((Object)toppingType11);
        Assert.assertThat((Object)toppingType11.getName(), (Matcher)Is.is((Object)"type"));
        Assert.assertThat((Object)toppingType11.getValue(), (Matcher)Is.is((Object)"None"));
        Assert.assertThat((Object)toppingType11.getPath(), (Matcher)Is.is((Object)"/items/item[1]/topping/type"));
        Assert.assertThat((Object)toppingType11.getFieldType(), (Matcher)Is.is((Object)FieldType.STRING));
        Assert.assertThat((Object)toppingType11.getStatus(), (Matcher)Is.is((Object)FieldStatus.SUPPORTED));
        JsonField toppingID12 = (JsonField)itemToppingsComplexType1.getJsonFields().getJsonField().get(2);
        Assert.assertNotNull((Object)toppingID12);
        Assert.assertThat((Object)toppingID12.getName(), (Matcher)Is.is((Object)"id"));
        Assert.assertThat((Object)toppingID12.getValue(), (Matcher)Is.is((Object)"5002"));
        Assert.assertThat((Object)toppingID12.getPath(), (Matcher)Is.is((Object)"/items/item[1]/topping/id[1]"));
        Assert.assertThat((Object)toppingID12.getFieldType(), (Matcher)Is.is((Object)FieldType.STRING));
        Assert.assertThat((Object)toppingID12.getStatus(), (Matcher)Is.is((Object)FieldStatus.SUPPORTED));
        JsonField toppingType12 = (JsonField)itemToppingsComplexType1.getJsonFields().getJsonField().get(3);
        Assert.assertNotNull((Object)toppingType12);
        Assert.assertThat((Object)toppingType12.getName(), (Matcher)Is.is((Object)"type"));
        Assert.assertThat((Object)toppingType12.getValue(), (Matcher)Is.is((Object)"Glazed"));
        Assert.assertThat((Object)toppingType12.getPath(), (Matcher)Is.is((Object)"/items/item[1]/topping/type[1]"));
        Assert.assertThat((Object)toppingType12.getFieldType(), (Matcher)Is.is((Object)FieldType.STRING));
        Assert.assertThat((Object)toppingType12.getStatus(), (Matcher)Is.is((Object)FieldStatus.SUPPORTED));
        JsonField toppingID13 = (JsonField)itemToppingsComplexType1.getJsonFields().getJsonField().get(4);
        Assert.assertNotNull((Object)toppingID13);
        Assert.assertThat((Object)toppingID13.getName(), (Matcher)Is.is((Object)"id"));
        Assert.assertThat((Object)toppingID13.getValue(), (Matcher)Is.is((Object)"5005"));
        Assert.assertThat((Object)toppingID13.getPath(), (Matcher)Is.is((Object)"/items/item[1]/topping/id[2]"));
        Assert.assertThat((Object)toppingID13.getFieldType(), (Matcher)Is.is((Object)FieldType.STRING));
        Assert.assertThat((Object)toppingID13.getStatus(), (Matcher)Is.is((Object)FieldStatus.SUPPORTED));
        JsonField toppingType13 = (JsonField)itemToppingsComplexType1.getJsonFields().getJsonField().get(5);
        Assert.assertNotNull((Object)toppingType13);
        Assert.assertThat((Object)toppingType13.getName(), (Matcher)Is.is((Object)"type"));
        Assert.assertThat((Object)toppingType13.getValue(), (Matcher)Is.is((Object)"Sugar"));
        Assert.assertThat((Object)toppingType13.getPath(), (Matcher)Is.is((Object)"/items/item[1]/topping/type[2]"));
        Assert.assertThat((Object)toppingType13.getFieldType(), (Matcher)Is.is((Object)FieldType.STRING));
        Assert.assertThat((Object)toppingType13.getStatus(), (Matcher)Is.is((Object)FieldStatus.SUPPORTED));
        JsonField toppingID14 = (JsonField)itemToppingsComplexType1.getJsonFields().getJsonField().get(6);
        Assert.assertNotNull((Object)toppingID14);
        Assert.assertThat((Object)toppingID14.getName(), (Matcher)Is.is((Object)"id"));
        Assert.assertThat((Object)toppingID14.getValue(), (Matcher)Is.is((Object)"5003"));
        Assert.assertThat((Object)toppingID14.getPath(), (Matcher)Is.is((Object)"/items/item[1]/topping/id[3]"));
        Assert.assertThat((Object)toppingID14.getFieldType(), (Matcher)Is.is((Object)FieldType.STRING));
        Assert.assertThat((Object)toppingID14.getStatus(), (Matcher)Is.is((Object)FieldStatus.SUPPORTED));
        JsonField toppingType14 = (JsonField)itemToppingsComplexType1.getJsonFields().getJsonField().get(7);
        Assert.assertNotNull((Object)toppingType14);
        Assert.assertThat((Object)toppingType14.getName(), (Matcher)Is.is((Object)"type"));
        Assert.assertThat((Object)toppingType14.getValue(), (Matcher)Is.is((Object)"Chocolate"));
        Assert.assertThat((Object)toppingType14.getPath(), (Matcher)Is.is((Object)"/items/item[1]/topping/type[3]"));
        Assert.assertThat((Object)toppingType14.getFieldType(), (Matcher)Is.is((Object)FieldType.STRING));
        Assert.assertThat((Object)toppingType14.getStatus(), (Matcher)Is.is((Object)FieldStatus.SUPPORTED));
        JsonField toppingID15 = (JsonField)itemToppingsComplexType1.getJsonFields().getJsonField().get(8);
        Assert.assertNotNull((Object)toppingID15);
        Assert.assertThat((Object)toppingID15.getName(), (Matcher)Is.is((Object)"id"));
        Assert.assertThat((Object)toppingID15.getValue(), (Matcher)Is.is((Object)"5004"));
        Assert.assertThat((Object)toppingID15.getPath(), (Matcher)Is.is((Object)"/items/item[1]/topping/id[4]"));
        Assert.assertThat((Object)toppingID15.getFieldType(), (Matcher)Is.is((Object)FieldType.STRING));
        Assert.assertThat((Object)toppingID15.getStatus(), (Matcher)Is.is((Object)FieldStatus.SUPPORTED));
        JsonField toppingType15 = (JsonField)itemToppingsComplexType1.getJsonFields().getJsonField().get(9);
        Assert.assertNotNull((Object)toppingType15);
        Assert.assertThat((Object)toppingType15.getName(), (Matcher)Is.is((Object)"type"));
        Assert.assertThat((Object)toppingType15.getValue(), (Matcher)Is.is((Object)"Maple"));
        Assert.assertThat((Object)toppingType15.getPath(), (Matcher)Is.is((Object)"/items/item[1]/topping/type[4]"));
        Assert.assertThat((Object)toppingType15.getFieldType(), (Matcher)Is.is((Object)FieldType.STRING));
        Assert.assertThat((Object)toppingType15.getStatus(), (Matcher)Is.is((Object)FieldStatus.SUPPORTED));
    }

    private void printDocument(JsonDocument document) {
        Assert.assertNotNull((Object)document.getFields());
        this.printFields(document.getFields());
    }

    private void printFields(Fields fields) {
        Assert.assertNotNull((Object)fields.getField());
        for (Field field : fields.getField()) {
            if (field instanceof JsonComplexType) {
                this.printJsonComplexType((JsonComplexType)field);
                continue;
            }
            this.printJsonField((JsonField)field);
        }
    }

    private void printFields(List<JsonField> jsonField) {
        for (JsonField field : jsonField) {
            if (field instanceof JsonComplexType) {
                this.printJsonComplexType((JsonComplexType)field);
                continue;
            }
            this.printJsonField(field);
        }
    }

    private void printJsonComplexType(JsonComplexType field) {
        Assert.assertNotNull((Object)field.getJsonFields());
        this.printJsonField((JsonField)field);
        this.printFields(field.getJsonFields().getJsonField());
    }

    private void printJsonField(JsonField jsonField) {
        System.out.println("Name --> " + jsonField.getName());
        System.out.println("Path --> " + jsonField.getPath());
        System.out.println("Value --> " + jsonField.getValue());
        if (jsonField.getFieldType() != null) {
            System.out.println("Type --> " + jsonField.getFieldType().name());
        }
        if (jsonField.getTypeName() != null) {
            System.out.println("Type Name --> " + jsonField.getTypeName());
        }
        if (jsonField.getCollectionType() != null) {
            System.out.println("Collection Type --> " + jsonField.getCollectionType().name());
        }
        if (jsonField.getStatus() != null) {
            System.out.println("Status  --> " + jsonField.getStatus().name());
        }
        System.out.println();
    }
}

