/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.json.v2;

import io.atlasmap.json.v2.JsonDataSource;
import io.atlasmap.json.v2.JsonField;
import io.atlasmap.v2.Actions;
import io.atlasmap.v2.AtlasMapping;
import io.atlasmap.v2.AtlasModelFactory;
import io.atlasmap.v2.Camelize;
import io.atlasmap.v2.Capitalize;
import io.atlasmap.v2.CollectionType;
import io.atlasmap.v2.DataSource;
import io.atlasmap.v2.DataSourceType;
import io.atlasmap.v2.FieldStatus;
import io.atlasmap.v2.FieldType;
import io.atlasmap.v2.Length;
import io.atlasmap.v2.LookupEntry;
import io.atlasmap.v2.LookupTable;
import io.atlasmap.v2.Lowercase;
import io.atlasmap.v2.Mapping;
import io.atlasmap.v2.MappingType;
import io.atlasmap.v2.Properties;
import io.atlasmap.v2.Property;
import io.atlasmap.v2.SeparateByDash;
import io.atlasmap.v2.SeparateByUnderscore;
import io.atlasmap.v2.Trim;
import io.atlasmap.v2.TrimLeft;
import io.atlasmap.v2.TrimRight;
import io.atlasmap.v2.Uppercase;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.rules.TestName;

public abstract class BaseMarshallerTest {
    public boolean deleteTestFolders = true;
    @Rule
    public TestName testName = new TestName();

    @Before
    public void setUp() throws Exception {
        Files.createDirectories(Paths.get("target/junit/" + this.testName.getMethodName(), new String[0]), new FileAttribute[0]);
    }

    @After
    public void tearDown() throws Exception {
        if (this.deleteTestFolders) {
            Path directory = Paths.get("target/junit/" + this.testName.getMethodName(), new String[0]);
            Files.walkFileTree(directory, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    Files.delete(file);
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
                    Files.delete(file);
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                    if (exc == null) {
                        Files.delete(dir);
                        return FileVisitResult.CONTINUE;
                    }
                    throw exc;
                }
            });
        }
    }

    protected AtlasMapping generateAtlasMapping() {
        AtlasMapping atlasMapping = AtlasModelFactory.createAtlasMapping();
        atlasMapping.setName("junit");
        this.generateDataSource(atlasMapping);
        this.generateLookupTables(atlasMapping);
        this.generateMapping(atlasMapping);
        this.generateProperties(atlasMapping);
        return atlasMapping;
    }

    private void generateProperties(AtlasMapping atlasMapping) {
        Property p = new Property();
        p.setName("foo");
        p.setValue("bar");
        p.setFieldType(FieldType.INTEGER);
        atlasMapping.setProperties(new Properties());
        atlasMapping.getProperties().getProperty().add(p);
    }

    private void generateMapping(AtlasMapping atlasMapping) {
        Mapping mapping = (Mapping)AtlasModelFactory.createMapping((MappingType)MappingType.MAP);
        this.generateInputField(mapping);
        this.generateOutputField(mapping);
        mapping.setMappingType(MappingType.MAP);
        mapping.setDelimiterString(",");
        mapping.setAlias("MapPropertyFieldAlias");
        mapping.setDelimiter(",");
        mapping.setDescription("description");
        mapping.setId("id");
        mapping.setLookupTableName("lookupTableName");
        mapping.setStrategy("strategy");
        mapping.setStrategyClassName("strategyClassName");
        atlasMapping.getMappings().getMapping().add(mapping);
    }

    private void generateOutputField(Mapping mapping) {
        JsonField outputField = new JsonField();
        this.generateActions(outputField);
        this.populateJsonField(outputField);
        mapping.getOutputField().add(outputField);
    }

    private void generateInputField(Mapping mapping) {
        JsonField inputField = new JsonField();
        this.generateActions(inputField);
        this.populateJsonField(inputField);
        mapping.getInputField().add(inputField);
    }

    private void populateJsonField(JsonField inputField) {
        inputField.setName("foo");
        inputField.setValue((Object)"bar");
        inputField.setArrayDimensions(Integer.valueOf(3));
        inputField.setArraySize(Integer.valueOf(3));
        inputField.setCollectionType(CollectionType.ARRAY);
        inputField.setDocId("docid");
        inputField.setPath("/path");
        inputField.setRequired(Boolean.valueOf(false));
        inputField.setStatus(FieldStatus.SUPPORTED);
        inputField.setFieldType(FieldType.INTEGER);
        inputField.setIndex(Integer.valueOf(3));
        inputField.setPrimitive(Boolean.FALSE);
        inputField.setTypeName("typeName");
        inputField.setUserCreated(Boolean.TRUE);
    }

    private void generateActions(JsonField inputField) {
        Actions actions = new Actions();
        actions.getActions().add(new Camelize());
        actions.getActions().add(new Capitalize());
        actions.getActions().add(new Length());
        actions.getActions().add(new Lowercase());
        actions.getActions().add(new SeparateByDash());
        actions.getActions().add(new SeparateByUnderscore());
        actions.getActions().add(new Trim());
        actions.getActions().add(new TrimLeft());
        actions.getActions().add(new TrimRight());
        actions.getActions().add(new Uppercase());
        inputField.setActions(actions);
    }

    private void generateLookupTables(AtlasMapping atlasMapping) {
        LookupTable table = new LookupTable();
        table.setName("lookupTable");
        table.setDescription("lookupTableDescription");
        LookupEntry l1 = new LookupEntry();
        l1.setSourceType(FieldType.STRING);
        l1.setSourceValue("Foo");
        l1.setTargetType(FieldType.STRING);
        l1.setTargetValue("Bar");
        table.getLookupEntry().add(l1);
        atlasMapping.getLookupTables().getLookupTable().add(table);
    }

    private void generateDataSource(AtlasMapping atlasMapping) {
        JsonDataSource src = this.generateJsonDataSource("srcId", "srcUri", DataSourceType.SOURCE, "template");
        JsonDataSource tgt = this.generateJsonDataSource("tgtId", "tgtUri", DataSourceType.TARGET, "template");
        atlasMapping.getDataSource().add(src);
        atlasMapping.getDataSource().add(tgt);
    }

    private JsonDataSource generateJsonDataSource(String id, String uri, DataSourceType dataSourceType, String template) {
        JsonDataSource src = new JsonDataSource();
        src.setId(id);
        src.setUri(uri);
        src.setDataSourceType(dataSourceType);
        src.setTemplate(template);
        return src;
    }

    protected void validateAtlasMapping(AtlasMapping mapping) {
        Assert.assertNotNull((Object)mapping);
        Assert.assertNotNull((Object)mapping.getName());
        Assert.assertEquals((Object)"junit", (Object)mapping.getName());
        Assert.assertEquals((long)2L, (long)mapping.getDataSource().size());
        this.validateJsonDataSource((DataSource)mapping.getDataSource().get(0), DataSourceType.SOURCE, "srcId", "srcUri", "template");
        this.validateJsonDataSource((DataSource)mapping.getDataSource().get(1), DataSourceType.TARGET, "tgtId", "tgtUri", "template");
        Assert.assertNotNull((Object)mapping.getLookupTables());
        Assert.assertEquals((long)1L, (long)mapping.getLookupTables().getLookupTable().size());
        this.validateLookupTable((LookupTable)mapping.getLookupTables().getLookupTable().get(0));
        Assert.assertNotNull((Object)mapping.getMappings());
        Assert.assertEquals((Object)new Integer(1), (Object)new Integer(mapping.getMappings().getMapping().size()));
        this.validateMapping((Mapping)mapping.getMappings().getMapping().get(0));
        Assert.assertNotNull((Object)mapping.getProperties());
        Assert.assertEquals((long)1L, (long)mapping.getProperties().getProperty().size());
        this.validateProperty((Property)mapping.getProperties().getProperty().get(0));
    }

    private void validateJsonDataSource(DataSource ds, DataSourceType dataSourceType, String id, String uri, String template) {
        Assert.assertEquals((Object)dataSourceType, (Object)ds.getDataSourceType());
        Assert.assertEquals((Object)id, (Object)ds.getId());
        Assert.assertEquals((Object)uri, (Object)ds.getUri());
        Assert.assertEquals((Object)template, (Object)((JsonDataSource)ds).getTemplate());
    }

    private void validateMapping(Mapping mapping) {
        Assert.assertEquals((Object)"MapPropertyFieldAlias", (Object)mapping.getAlias());
        Assert.assertEquals((Object)MappingType.MAP, (Object)mapping.getMappingType());
        Assert.assertEquals((Object)",", (Object)mapping.getDelimiter());
        Assert.assertEquals((Object)",", (Object)mapping.getDelimiterString());
        Assert.assertEquals((Object)"description", (Object)mapping.getDescription());
        Assert.assertEquals((Object)"id", (Object)mapping.getId());
        Assert.assertEquals((long)1L, (long)mapping.getInputField().size());
        this.validateJsonField((JsonField)mapping.getInputField().get(0));
        Assert.assertEquals((Object)"lookupTableName", (Object)mapping.getLookupTableName());
        Assert.assertEquals((long)1L, (long)mapping.getOutputField().size());
        this.validateJsonField((JsonField)mapping.getOutputField().get(0));
        Assert.assertEquals((Object)"strategy", (Object)mapping.getStrategy());
        Assert.assertEquals((Object)"strategyClassName", (Object)mapping.getStrategyClassName());
    }

    private void validateJsonField(JsonField field) {
        Assert.assertEquals((long)10L, (long)field.getActions().getActions().size());
        Assert.assertEquals((Object)3, (Object)field.getArrayDimensions());
        Assert.assertEquals((Object)3, (Object)field.getArraySize());
        Assert.assertEquals((Object)CollectionType.ARRAY, (Object)field.getCollectionType());
        Assert.assertEquals((Object)"docid", (Object)field.getDocId());
        Assert.assertEquals((Object)FieldType.INTEGER, (Object)field.getFieldType());
        Assert.assertEquals((Object)3, (Object)field.getIndex());
        Assert.assertEquals((Object)"foo", (Object)field.getName());
        Assert.assertEquals((Object)"/path", (Object)field.getPath());
        Assert.assertEquals((Object)Boolean.FALSE, (Object)field.isPrimitive());
        Assert.assertEquals((Object)Boolean.FALSE, (Object)field.isRequired());
        Assert.assertEquals((Object)FieldStatus.SUPPORTED, (Object)field.getStatus());
        Assert.assertEquals((Object)"bar", (Object)field.getValue());
        Assert.assertEquals((Object)"typeName", (Object)field.getTypeName());
        Assert.assertEquals((Object)Boolean.TRUE, (Object)field.isUserCreated());
    }

    private void validateLookupTable(LookupTable lookupTable) {
        Assert.assertEquals((Object)"lookupTableDescription", (Object)lookupTable.getDescription());
        Assert.assertEquals((Object)"lookupTable", (Object)lookupTable.getName());
        Assert.assertEquals((Object)FieldType.STRING, (Object)((LookupEntry)lookupTable.getLookupEntry().get(0)).getSourceType());
        Assert.assertEquals((Object)"Foo", (Object)((LookupEntry)lookupTable.getLookupEntry().get(0)).getSourceValue());
        Assert.assertEquals((Object)FieldType.STRING, (Object)((LookupEntry)lookupTable.getLookupEntry().get(0)).getTargetType());
        Assert.assertEquals((Object)"Bar", (Object)((LookupEntry)lookupTable.getLookupEntry().get(0)).getTargetValue());
    }

    private void validateProperty(Property p) {
        Assert.assertEquals((Object)FieldType.INTEGER, (Object)p.getFieldType());
        Assert.assertEquals((Object)"foo", (Object)p.getName());
        Assert.assertEquals((Object)"bar", (Object)p.getValue());
    }
}

