/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.json.v2;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import io.atlasmap.json.v2.BaseMarshallerTest;
import io.atlasmap.v2.AtlasMapping;
import java.io.File;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class JsonMarshallerTest
extends BaseMarshallerTest {
    public ObjectMapper mapper = null;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.deleteTestFolders = false;
        this.mapper = new ObjectMapper();
        this.mapper.configure(SerializationFeature.WRAP_ROOT_VALUE, true);
        this.mapper.configure(DeserializationFeature.UNWRAP_ROOT_VALUE, true);
        this.mapper.configure(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY, true);
        this.mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
    }

    @Override
    @After
    public void tearDown() throws Exception {
        super.tearDown();
        this.mapper = null;
    }

    @Test
    public void testReferenceMapping() throws Exception {
        AtlasMapping atlasMapping = this.generateAtlasMapping();
        this.mapper.writerWithDefaultPrettyPrinter().writeValue(new File("target" + File.separator + "junit" + File.separator + this.testName.getMethodName() + File.separator + "atlasmapping.json"), (Object)atlasMapping);
        AtlasMapping uMapping = (AtlasMapping)this.mapper.readValue(new File("target" + File.separator + "junit" + File.separator + this.testName.getMethodName() + File.separator + "atlasmapping.json"), AtlasMapping.class);
        Assert.assertNotNull((Object)uMapping);
        this.validateAtlasMapping(uMapping);
    }
}

