
package io.atlasmap.json.test;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;


/**
 * BaseFlatPrimitive
 * <p>
 * 
 * 
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "intField",
    "shortField",
    "longField",
    "doubleField",
    "floatField",
    "booleanField",
    "charField",
    "byteField",
    "boxedIntField",
    "boxedShortField",
    "boxedLongField",
    "boxedDoubleField",
    "boxedFloatField",
    "boxedBooleanField",
    "boxedCharField",
    "boxedStringField",
    "intArrayField",
    "shortArrayField",
    "longArrayField",
    "doubleArrayField",
    "floatArrayField",
    "booleanArrayField",
    "charArrayField",
    "boxedIntArrayField",
    "boxedShortArrayField",
    "boxedLongArrayField",
    "boxedDoubleArrayField",
    "boxedFloatArrayField",
    "boxedBooleanArrayField",
    "boxedCharArrayField",
    "boxedStringArrayField"
})
public class BaseFlatPrimitive {

    @JsonProperty("intField")
    private Integer intField;
    @JsonProperty("shortField")
    private Integer shortField;
    @JsonProperty("longField")
    private Double longField;
    @JsonProperty("doubleField")
    private Double doubleField;
    @JsonProperty("floatField")
    private Double floatField;
    @JsonProperty("booleanField")
    private Boolean booleanField;
    @JsonProperty("charField")
    private String charField;
    @JsonProperty("byteField")
    private Integer byteField;
    @JsonProperty("boxedIntField")
    private Integer boxedIntField;
    @JsonProperty("boxedShortField")
    private Integer boxedShortField;
    @JsonProperty("boxedLongField")
    private Double boxedLongField;
    @JsonProperty("boxedDoubleField")
    private Double boxedDoubleField;
    @JsonProperty("boxedFloatField")
    private Double boxedFloatField;
    @JsonProperty("boxedBooleanField")
    private Boolean boxedBooleanField;
    @JsonProperty("boxedCharField")
    private String boxedCharField;
    @JsonProperty("boxedStringField")
    private String boxedStringField;
    @JsonProperty("intArrayField")
    private List<Integer> intArrayField = new ArrayList<Integer>();
    @JsonProperty("shortArrayField")
    private List<Integer> shortArrayField = new ArrayList<Integer>();
    @JsonProperty("longArrayField")
    private List<Double> longArrayField = new ArrayList<Double>();
    @JsonProperty("doubleArrayField")
    private List<Double> doubleArrayField = new ArrayList<Double>();
    @JsonProperty("floatArrayField")
    private List<Double> floatArrayField = new ArrayList<Double>();
    @JsonProperty("booleanArrayField")
    private List<Boolean> booleanArrayField = new ArrayList<Boolean>();
    @JsonProperty("charArrayField")
    private List<String> charArrayField = new ArrayList<String>();
    @JsonProperty("boxedIntArrayField")
    private List<Integer> boxedIntArrayField = new ArrayList<Integer>();
    @JsonProperty("boxedShortArrayField")
    private List<Integer> boxedShortArrayField = new ArrayList<Integer>();
    @JsonProperty("boxedLongArrayField")
    private List<Double> boxedLongArrayField = new ArrayList<Double>();
    @JsonProperty("boxedDoubleArrayField")
    private List<Double> boxedDoubleArrayField = new ArrayList<Double>();
    @JsonProperty("boxedFloatArrayField")
    private List<Double> boxedFloatArrayField = new ArrayList<Double>();
    @JsonProperty("boxedBooleanArrayField")
    private List<Boolean> boxedBooleanArrayField = new ArrayList<Boolean>();
    @JsonProperty("boxedCharArrayField")
    private List<String> boxedCharArrayField = new ArrayList<String>();
    @JsonProperty("boxedStringArrayField")
    private List<String> boxedStringArrayField = new ArrayList<String>();
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();

    @JsonProperty("intField")
    public Integer getIntField() {
        return intField;
    }

    @JsonProperty("intField")
    public void setIntField(Integer intField) {
        this.intField = intField;
    }

    @JsonProperty("shortField")
    public Integer getShortField() {
        return shortField;
    }

    @JsonProperty("shortField")
    public void setShortField(Integer shortField) {
        this.shortField = shortField;
    }

    @JsonProperty("longField")
    public Double getLongField() {
        return longField;
    }

    @JsonProperty("longField")
    public void setLongField(Double longField) {
        this.longField = longField;
    }

    @JsonProperty("doubleField")
    public Double getDoubleField() {
        return doubleField;
    }

    @JsonProperty("doubleField")
    public void setDoubleField(Double doubleField) {
        this.doubleField = doubleField;
    }

    @JsonProperty("floatField")
    public Double getFloatField() {
        return floatField;
    }

    @JsonProperty("floatField")
    public void setFloatField(Double floatField) {
        this.floatField = floatField;
    }

    @JsonProperty("booleanField")
    public Boolean getBooleanField() {
        return booleanField;
    }

    @JsonProperty("booleanField")
    public void setBooleanField(Boolean booleanField) {
        this.booleanField = booleanField;
    }

    @JsonProperty("charField")
    public String getCharField() {
        return charField;
    }

    @JsonProperty("charField")
    public void setCharField(String charField) {
        this.charField = charField;
    }

    @JsonProperty("byteField")
    public Integer getByteField() {
        return byteField;
    }

    @JsonProperty("byteField")
    public void setByteField(Integer byteField) {
        this.byteField = byteField;
    }

    @JsonProperty("boxedIntField")
    public Integer getBoxedIntField() {
        return boxedIntField;
    }

    @JsonProperty("boxedIntField")
    public void setBoxedIntField(Integer boxedIntField) {
        this.boxedIntField = boxedIntField;
    }

    @JsonProperty("boxedShortField")
    public Integer getBoxedShortField() {
        return boxedShortField;
    }

    @JsonProperty("boxedShortField")
    public void setBoxedShortField(Integer boxedShortField) {
        this.boxedShortField = boxedShortField;
    }

    @JsonProperty("boxedLongField")
    public Double getBoxedLongField() {
        return boxedLongField;
    }

    @JsonProperty("boxedLongField")
    public void setBoxedLongField(Double boxedLongField) {
        this.boxedLongField = boxedLongField;
    }

    @JsonProperty("boxedDoubleField")
    public Double getBoxedDoubleField() {
        return boxedDoubleField;
    }

    @JsonProperty("boxedDoubleField")
    public void setBoxedDoubleField(Double boxedDoubleField) {
        this.boxedDoubleField = boxedDoubleField;
    }

    @JsonProperty("boxedFloatField")
    public Double getBoxedFloatField() {
        return boxedFloatField;
    }

    @JsonProperty("boxedFloatField")
    public void setBoxedFloatField(Double boxedFloatField) {
        this.boxedFloatField = boxedFloatField;
    }

    @JsonProperty("boxedBooleanField")
    public Boolean getBoxedBooleanField() {
        return boxedBooleanField;
    }

    @JsonProperty("boxedBooleanField")
    public void setBoxedBooleanField(Boolean boxedBooleanField) {
        this.boxedBooleanField = boxedBooleanField;
    }

    @JsonProperty("boxedCharField")
    public String getBoxedCharField() {
        return boxedCharField;
    }

    @JsonProperty("boxedCharField")
    public void setBoxedCharField(String boxedCharField) {
        this.boxedCharField = boxedCharField;
    }

    @JsonProperty("boxedStringField")
    public String getBoxedStringField() {
        return boxedStringField;
    }

    @JsonProperty("boxedStringField")
    public void setBoxedStringField(String boxedStringField) {
        this.boxedStringField = boxedStringField;
    }

    @JsonProperty("intArrayField")
    public List<Integer> getIntArrayField() {
        return intArrayField;
    }

    @JsonProperty("intArrayField")
    public void setIntArrayField(List<Integer> intArrayField) {
        this.intArrayField = intArrayField;
    }

    @JsonProperty("shortArrayField")
    public List<Integer> getShortArrayField() {
        return shortArrayField;
    }

    @JsonProperty("shortArrayField")
    public void setShortArrayField(List<Integer> shortArrayField) {
        this.shortArrayField = shortArrayField;
    }

    @JsonProperty("longArrayField")
    public List<Double> getLongArrayField() {
        return longArrayField;
    }

    @JsonProperty("longArrayField")
    public void setLongArrayField(List<Double> longArrayField) {
        this.longArrayField = longArrayField;
    }

    @JsonProperty("doubleArrayField")
    public List<Double> getDoubleArrayField() {
        return doubleArrayField;
    }

    @JsonProperty("doubleArrayField")
    public void setDoubleArrayField(List<Double> doubleArrayField) {
        this.doubleArrayField = doubleArrayField;
    }

    @JsonProperty("floatArrayField")
    public List<Double> getFloatArrayField() {
        return floatArrayField;
    }

    @JsonProperty("floatArrayField")
    public void setFloatArrayField(List<Double> floatArrayField) {
        this.floatArrayField = floatArrayField;
    }

    @JsonProperty("booleanArrayField")
    public List<Boolean> getBooleanArrayField() {
        return booleanArrayField;
    }

    @JsonProperty("booleanArrayField")
    public void setBooleanArrayField(List<Boolean> booleanArrayField) {
        this.booleanArrayField = booleanArrayField;
    }

    @JsonProperty("charArrayField")
    public List<String> getCharArrayField() {
        return charArrayField;
    }

    @JsonProperty("charArrayField")
    public void setCharArrayField(List<String> charArrayField) {
        this.charArrayField = charArrayField;
    }

    @JsonProperty("boxedIntArrayField")
    public List<Integer> getBoxedIntArrayField() {
        return boxedIntArrayField;
    }

    @JsonProperty("boxedIntArrayField")
    public void setBoxedIntArrayField(List<Integer> boxedIntArrayField) {
        this.boxedIntArrayField = boxedIntArrayField;
    }

    @JsonProperty("boxedShortArrayField")
    public List<Integer> getBoxedShortArrayField() {
        return boxedShortArrayField;
    }

    @JsonProperty("boxedShortArrayField")
    public void setBoxedShortArrayField(List<Integer> boxedShortArrayField) {
        this.boxedShortArrayField = boxedShortArrayField;
    }

    @JsonProperty("boxedLongArrayField")
    public List<Double> getBoxedLongArrayField() {
        return boxedLongArrayField;
    }

    @JsonProperty("boxedLongArrayField")
    public void setBoxedLongArrayField(List<Double> boxedLongArrayField) {
        this.boxedLongArrayField = boxedLongArrayField;
    }

    @JsonProperty("boxedDoubleArrayField")
    public List<Double> getBoxedDoubleArrayField() {
        return boxedDoubleArrayField;
    }

    @JsonProperty("boxedDoubleArrayField")
    public void setBoxedDoubleArrayField(List<Double> boxedDoubleArrayField) {
        this.boxedDoubleArrayField = boxedDoubleArrayField;
    }

    @JsonProperty("boxedFloatArrayField")
    public List<Double> getBoxedFloatArrayField() {
        return boxedFloatArrayField;
    }

    @JsonProperty("boxedFloatArrayField")
    public void setBoxedFloatArrayField(List<Double> boxedFloatArrayField) {
        this.boxedFloatArrayField = boxedFloatArrayField;
    }

    @JsonProperty("boxedBooleanArrayField")
    public List<Boolean> getBoxedBooleanArrayField() {
        return boxedBooleanArrayField;
    }

    @JsonProperty("boxedBooleanArrayField")
    public void setBoxedBooleanArrayField(List<Boolean> boxedBooleanArrayField) {
        this.boxedBooleanArrayField = boxedBooleanArrayField;
    }

    @JsonProperty("boxedCharArrayField")
    public List<String> getBoxedCharArrayField() {
        return boxedCharArrayField;
    }

    @JsonProperty("boxedCharArrayField")
    public void setBoxedCharArrayField(List<String> boxedCharArrayField) {
        this.boxedCharArrayField = boxedCharArrayField;
    }

    @JsonProperty("boxedStringArrayField")
    public List<String> getBoxedStringArrayField() {
        return boxedStringArrayField;
    }

    @JsonProperty("boxedStringArrayField")
    public void setBoxedStringArrayField(List<String> boxedStringArrayField) {
        this.boxedStringArrayField = boxedStringArrayField;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

}
