/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.xml.inspect;

import io.atlasmap.xml.inspect.BaseXmlInspectionServiceTest;
import io.atlasmap.xml.inspect.XmlInspectionException;
import io.atlasmap.xml.inspect.XmlInspectionService;
import io.atlasmap.xml.v2.XmlComplexType;
import io.atlasmap.xml.v2.XmlDocument;
import io.atlasmap.xml.v2.XmlField;
import io.atlasmap.xml.v2.XmlNamespace;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.List;
import java.util.stream.Collectors;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Test;
import org.w3c.dom.Document;

public class XmlInstanceInspectionTest
extends BaseXmlInspectionServiceTest {
    @Test
    public void testInspectXmlStringAsSource() throws Exception {
        String source = "<data>\n     <intField>32000</intField>\n     <longField>12421</longField>\n     <stringField>abc</stringField>\n     <booleanField>true</booleanField>\n     <doubleField>12.0</doubleField>\n     <shortField>1000</shortField>\n     <floatField>234.5f</floatField>\n     <charField>A</charField>\n</data>";
        XmlInspectionService service = new XmlInspectionService();
        XmlDocument xmlDocument = service.inspectXmlDocument("<data>\n     <intField>32000</intField>\n     <longField>12421</longField>\n     <stringField>abc</stringField>\n     <booleanField>true</booleanField>\n     <doubleField>12.0</doubleField>\n     <shortField>1000</shortField>\n     <floatField>234.5f</floatField>\n     <charField>A</charField>\n</data>");
        Assert.assertNotNull((Object)xmlDocument);
        Assert.assertNotNull((Object)xmlDocument.getFields());
        Assert.assertThat((Object)xmlDocument.getFields().getField().size(), (Matcher)Is.is((Object)1));
        List complexTypeList = xmlDocument.getFields().getField().stream().filter(xmlField -> xmlField instanceof XmlComplexType).map(xmlField -> (XmlComplexType)xmlField).collect(Collectors.toList());
        Assert.assertThat((Object)complexTypeList.size(), (Matcher)Is.is((Object)1));
        XmlComplexType root = (XmlComplexType)xmlDocument.getFields().getField().get(0);
        Assert.assertNotNull((Object)root);
        Assert.assertThat((Object)root.getXmlFields().getXmlField().size(), (Matcher)Is.is((Object)8));
        complexTypeList = root.getXmlFields().getXmlField().stream().filter(xmlField -> xmlField instanceof XmlComplexType).map(xmlField -> (XmlComplexType)xmlField).collect(Collectors.toList());
        Assert.assertThat((Object)complexTypeList.size(), (Matcher)Is.is((Object)0));
    }

    @Test
    public void testInspectXmlStringAsSourceElementsWithAttrs() throws Exception {
        String source = "<data>\n     <intField a='1'>32000</intField>\n     <longField>12421</longField>\n     <stringField>abc</stringField>\n     <booleanField>true</booleanField>\n     <doubleField b='2'>12.0</doubleField>\n     <shortField>1000</shortField>\n     <floatField>234.5f</floatField>\n     <charField>A</charField>\n</data>";
        XmlInspectionService service = new XmlInspectionService();
        XmlDocument xmlDocument = service.inspectXmlDocument("<data>\n     <intField a='1'>32000</intField>\n     <longField>12421</longField>\n     <stringField>abc</stringField>\n     <booleanField>true</booleanField>\n     <doubleField b='2'>12.0</doubleField>\n     <shortField>1000</shortField>\n     <floatField>234.5f</floatField>\n     <charField>A</charField>\n</data>");
        Assert.assertNotNull((Object)xmlDocument);
        Assert.assertNotNull((Object)xmlDocument.getFields());
        Assert.assertThat((Object)xmlDocument.getFields().getField().size(), (Matcher)Is.is((Object)1));
        XmlComplexType root = (XmlComplexType)xmlDocument.getFields().getField().get(0);
        Assert.assertNotNull((Object)root);
        Assert.assertThat((Object)root.getXmlFields().getXmlField().size(), (Matcher)Is.is((Object)10));
    }

    @Test
    public void testInspectXmlStringAsSourceUsingAttrs() throws Exception {
        String source = "<data intField='32000' longField='12421' stringField='abc' booleanField='true' doubleField='12.0' shortField='1000' floatField='234.5f' charField='A' />";
        XmlInspectionService service = new XmlInspectionService();
        XmlDocument xmlDocument = service.inspectXmlDocument("<data intField='32000' longField='12421' stringField='abc' booleanField='true' doubleField='12.0' shortField='1000' floatField='234.5f' charField='A' />");
        Assert.assertNotNull((Object)xmlDocument);
        Assert.assertNotNull((Object)xmlDocument.getFields());
        Assert.assertThat((Object)xmlDocument.getFields().getField().size(), (Matcher)Is.is((Object)1));
        XmlComplexType root = (XmlComplexType)xmlDocument.getFields().getField().get(0);
        Assert.assertNotNull((Object)root);
        Assert.assertThat((Object)root.getXmlFields().getXmlField().size(), (Matcher)Is.is((Object)8));
    }

    @Test
    public void testInspectXmlStringWithDefaultNamespace() throws Exception {
        String source = "<data xmlns=\"http://x.namespace.com/\">\n     <intField>32000</intField>\n     <longField>12421</longField>\n     <stringField>abc</stringField>\n     <booleanField>true</booleanField>\n     <doubleField>12.0</doubleField>\n     <shortField>1000</shortField>\n     <floatField>234.5f</floatField>\n     <charField>A</charField>\n</data>";
        XmlInspectionService service = new XmlInspectionService();
        XmlDocument xmlDocument = service.inspectXmlDocument("<data xmlns=\"http://x.namespace.com/\">\n     <intField>32000</intField>\n     <longField>12421</longField>\n     <stringField>abc</stringField>\n     <booleanField>true</booleanField>\n     <doubleField>12.0</doubleField>\n     <shortField>1000</shortField>\n     <floatField>234.5f</floatField>\n     <charField>A</charField>\n</data>");
        Assert.assertNotNull((Object)xmlDocument);
        Assert.assertNotNull((Object)xmlDocument.getXmlNamespaces());
        XmlNamespace namespace = (XmlNamespace)xmlDocument.getXmlNamespaces().getXmlNamespace().get(0);
        Assert.assertThat((Object)xmlDocument.getXmlNamespaces().getXmlNamespace().size(), (Matcher)Is.is((Object)1));
        Assert.assertNotNull((Object)namespace);
        Assert.assertNull((Object)namespace.getAlias());
        Assert.assertEquals((Object)"http://x.namespace.com/", (Object)namespace.getUri());
        Assert.assertNotNull((Object)xmlDocument.getFields());
        Assert.assertThat((Object)xmlDocument.getFields().getField().size(), (Matcher)Is.is((Object)1));
        XmlComplexType root = (XmlComplexType)xmlDocument.getFields().getField().get(0);
        Assert.assertNotNull((Object)root);
        Assert.assertThat((Object)root.getXmlFields().getXmlField().size(), (Matcher)Is.is((Object)8));
    }

    @Test
    public void testInspectXmlStringWithNamespaces() throws Exception {
        String source = "<x:data xmlns:x=\"http://x.namespace.com/\">\n     <x:intField>32000</x:intField>\n     <x:longField>12421</x:longField>\n     <x:stringField>abc</x:stringField>\n     <x:booleanField>true</x:booleanField>\n     <x:doubleField>12.0</x:doubleField>\n     <x:shortField>1000</x:shortField>\n     <x:floatField>234.5f</x:floatField>\n     <x:charField>A</x:charField>\n</x:data>";
        XmlInspectionService service = new XmlInspectionService();
        XmlDocument xmlDocument = service.inspectXmlDocument("<x:data xmlns:x=\"http://x.namespace.com/\">\n     <x:intField>32000</x:intField>\n     <x:longField>12421</x:longField>\n     <x:stringField>abc</x:stringField>\n     <x:booleanField>true</x:booleanField>\n     <x:doubleField>12.0</x:doubleField>\n     <x:shortField>1000</x:shortField>\n     <x:floatField>234.5f</x:floatField>\n     <x:charField>A</x:charField>\n</x:data>");
        Assert.assertNotNull((Object)xmlDocument);
        Assert.assertNotNull((Object)xmlDocument.getFields());
        Assert.assertNotNull((Object)xmlDocument.getXmlNamespaces());
        XmlNamespace namespace = (XmlNamespace)xmlDocument.getXmlNamespaces().getXmlNamespace().get(0);
        Assert.assertThat((Object)xmlDocument.getXmlNamespaces().getXmlNamespace().size(), (Matcher)Is.is((Object)1));
        Assert.assertNotNull((Object)namespace);
        Assert.assertEquals((Object)"x", (Object)namespace.getAlias());
        Assert.assertEquals((Object)"http://x.namespace.com/", (Object)namespace.getUri());
        Assert.assertNotNull((Object)xmlDocument.getFields());
        Assert.assertThat((Object)xmlDocument.getFields().getField().size(), (Matcher)Is.is((Object)1));
        XmlComplexType root = (XmlComplexType)xmlDocument.getFields().getField().get(0);
        Assert.assertNotNull((Object)root);
        Assert.assertThat((Object)root.getXmlFields().getXmlField().size(), (Matcher)Is.is((Object)8));
    }

    @Test
    public void testInspectXmlStringAsSourceAttrsWithNamespace() throws Exception {
        String source = "<data xmlns:y=\"http://y.namespace.com/\" y:intField='32000' longField='12421' stringField='abc' booleanField='true' doubleField='12.0' shortField='1000' floatField='234.5f' y:charField='A' />";
        XmlInspectionService service = new XmlInspectionService();
        XmlDocument xmlDocument = service.inspectXmlDocument("<data xmlns:y=\"http://y.namespace.com/\" y:intField='32000' longField='12421' stringField='abc' booleanField='true' doubleField='12.0' shortField='1000' floatField='234.5f' y:charField='A' />");
        Assert.assertNotNull((Object)xmlDocument);
        Assert.assertNotNull((Object)xmlDocument.getFields());
        Assert.assertNotNull((Object)xmlDocument.getXmlNamespaces());
        Assert.assertThat((Object)xmlDocument.getXmlNamespaces().getXmlNamespace().size(), (Matcher)Is.is((Object)1));
        XmlNamespace namespace = (XmlNamespace)xmlDocument.getXmlNamespaces().getXmlNamespace().get(0);
        Assert.assertNotNull((Object)namespace);
        Assert.assertEquals((Object)"y", (Object)namespace.getAlias());
        Assert.assertEquals((Object)"http://y.namespace.com/", (Object)namespace.getUri());
        Assert.assertNotNull((Object)xmlDocument.getFields());
        Assert.assertThat((Object)xmlDocument.getFields().getField().size(), (Matcher)Is.is((Object)1));
        XmlComplexType root = (XmlComplexType)xmlDocument.getFields().getField().get(0);
        Assert.assertNotNull((Object)root);
        Assert.assertThat((Object)root.getXmlFields().getXmlField().size(), (Matcher)Is.is((Object)8));
    }

    @Test
    public void testInspectXmlStringAsSourceMultipleChildren() throws Exception {
        String source = "<data>\n     <intFields><int>3200</int><int>2500</int><int>15</int></intFields>\n     <longFields><long>12421</long></longFields>\n     <stringFields><string>abc</string></stringFields>\n     <booleanFields><boolean>true</boolean></booleanFields>\n     <doubleFields><double>12.0</double></doubleFields>\n     <shortFields><short>1000</short></shortFields>\n     <floatFields><float>234.5f</float></floatFields>\n     <charFields><char>A</char></charFields>\n</data>";
        XmlInspectionService service = new XmlInspectionService();
        XmlDocument xmlDocument = service.inspectXmlDocument("<data>\n     <intFields><int>3200</int><int>2500</int><int>15</int></intFields>\n     <longFields><long>12421</long></longFields>\n     <stringFields><string>abc</string></stringFields>\n     <booleanFields><boolean>true</boolean></booleanFields>\n     <doubleFields><double>12.0</double></doubleFields>\n     <shortFields><short>1000</short></shortFields>\n     <floatFields><float>234.5f</float></floatFields>\n     <charFields><char>A</char></charFields>\n</data>");
        Assert.assertNotNull((Object)xmlDocument);
        Assert.assertNotNull((Object)xmlDocument.getFields());
        Assert.assertThat((Object)xmlDocument.getFields().getField().size(), (Matcher)Is.is((Object)1));
        XmlComplexType root = (XmlComplexType)xmlDocument.getFields().getField().get(0);
        Assert.assertNotNull((Object)root);
        Assert.assertThat((Object)root.getXmlFields().getXmlField().size(), (Matcher)Is.is((Object)8));
        XmlComplexType childZero = (XmlComplexType)root.getXmlFields().getXmlField().get(0);
        Assert.assertNotNull((Object)childZero);
        Assert.assertThat((Object)childZero.getXmlFields().getXmlField().size(), (Matcher)Is.is((Object)3));
        XmlField childZeroZero = (XmlField)childZero.getXmlFields().getXmlField().get(0);
        Assert.assertNotNull((Object)childZeroZero);
        Assert.assertThat((Object)childZeroZero.getName(), (Matcher)Is.is((Object)"int"));
        Assert.assertThat((Object)childZeroZero.getValue(), (Matcher)Is.is((Object)"3200"));
        Assert.assertThat((Object)childZeroZero.getPath(), (Matcher)Is.is((Object)"/data/intFields/int"));
        XmlField childZeroOne = (XmlField)childZero.getXmlFields().getXmlField().get(1);
        Assert.assertNotNull((Object)childZeroOne);
        Assert.assertThat((Object)childZeroOne.getName(), (Matcher)Is.is((Object)"int"));
        Assert.assertThat((Object)childZeroOne.getValue(), (Matcher)Is.is((Object)"2500"));
        Assert.assertThat((Object)childZeroOne.getPath(), (Matcher)Is.is((Object)"/data/intFields/int[1]"));
    }

    @Test
    public void testInspectXmlStringAsSourceAT370A() throws Exception {
        String source = "<order>\n   <orders>\n      <order>\n\t      <items>\n\t\t     <item sku=\"4\"/>\n\t\t     <item sku=\"5\"/>\n\t      </items>\n      </order>\n   </orders>\n</order>";
        XmlInspectionService service = new XmlInspectionService();
        XmlDocument xmlDocument = service.inspectXmlDocument("<order>\n   <orders>\n      <order>\n\t      <items>\n\t\t     <item sku=\"4\"/>\n\t\t     <item sku=\"5\"/>\n\t      </items>\n      </order>\n   </orders>\n</order>");
        Assert.assertNotNull((Object)xmlDocument);
        Assert.assertNotNull((Object)xmlDocument.getFields());
        Assert.assertThat((Object)xmlDocument.getFields().getField().size(), (Matcher)Is.is((Object)1));
        XmlComplexType root = (XmlComplexType)xmlDocument.getFields().getField().get(0);
        Assert.assertNotNull((Object)root);
        Assert.assertThat((Object)root.getXmlFields().getXmlField().size(), (Matcher)Is.is((Object)1));
    }

    @Test
    public void testInspectXmlStringAsSourceAT370B() throws Exception {
        String source = "<order>\n   <orders>\n      <order>\n\t      <items>\n\t\t     <item sku=\"4\"/>\n\t\t     <item sku=\"7\"/>\n\t      </items>\n      </order>\n      <order>\n\t      <items>\n\t\t     <item sku=\"5\"/>\n\t\t     <item sku=\"8\"/>\n\t      </items>\n      </order>\n   </orders>\n</order>";
        XmlInspectionService service = new XmlInspectionService();
        XmlDocument xmlDocument = service.inspectXmlDocument("<order>\n   <orders>\n      <order>\n\t      <items>\n\t\t     <item sku=\"4\"/>\n\t\t     <item sku=\"7\"/>\n\t      </items>\n      </order>\n      <order>\n\t      <items>\n\t\t     <item sku=\"5\"/>\n\t\t     <item sku=\"8\"/>\n\t      </items>\n      </order>\n   </orders>\n</order>");
        Assert.assertNotNull((Object)xmlDocument);
        Assert.assertNotNull((Object)xmlDocument.getFields());
        Assert.assertThat((Object)xmlDocument.getFields().getField().size(), (Matcher)Is.is((Object)1));
        XmlComplexType root = (XmlComplexType)xmlDocument.getFields().getField().get(0);
        Assert.assertNotNull((Object)root);
        Assert.assertThat((Object)root.getXmlFields().getXmlField().size(), (Matcher)Is.is((Object)1));
    }

    @Test
    public void testInspectInstanceFileWithXSIType() throws Exception {
        String instance = new String(Files.readAllBytes(Paths.get("src/test/resources/inspect/xsi-type-instance.xml", new String[0])));
        XmlInspectionService service = new XmlInspectionService();
        XmlDocument xmlDocument = service.inspectXmlDocument(instance);
        Assert.assertNotNull((Object)xmlDocument);
        Assert.assertNotNull((Object)xmlDocument.getFields());
        Assert.assertThat((Object)xmlDocument.getFields().getField().size(), (Matcher)Is.is((Object)1));
        XmlComplexType root = (XmlComplexType)xmlDocument.getFields().getField().get(0);
        Assert.assertNotNull((Object)root);
        Assert.assertThat((Object)root.getXmlFields().getXmlField().size(), (Matcher)Is.is((Object)8));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInspectXmlStringAsSourceNull() throws Exception {
        XmlInspectionService service = new XmlInspectionService();
        String xmlDocument = null;
        service.inspectXmlDocument(xmlDocument);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInspectXmlStringAsSourceBlank() throws Exception {
        XmlInspectionService service = new XmlInspectionService();
        String xmlDocument = "";
        service.inspectXmlDocument(xmlDocument);
    }

    @Test(expected=XmlInspectionException.class)
    public void testInspectXmlStringAsSourceParseExpection() throws Exception {
        XmlInspectionService service = new XmlInspectionService();
        String xmlDocument = "<?>";
        service.inspectXmlDocument(xmlDocument);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInspectXmlDocumentAsSourceNull() {
        XmlInspectionService service = new XmlInspectionService();
        Document xmlDocument = null;
        service.inspectXmlDocument(xmlDocument);
    }

    @Test(expected=XmlInspectionException.class)
    public void testInspectXmlStringAsSourceBadHeaderWithBOM() throws Exception {
        XmlInspectionService service = new XmlInspectionService();
        String xmlDocument = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\\ufeff<foo>bar</foo>";
        service.inspectXmlDocument(xmlDocument);
    }
}

