/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.xml.v2;

import io.atlasmap.v2.AtlasMapping;
import io.atlasmap.v2.AtlasModelFactory;
import io.atlasmap.v2.Collection;
import io.atlasmap.v2.CollectionType;
import io.atlasmap.v2.ConstantField;
import io.atlasmap.v2.DataSource;
import io.atlasmap.v2.DataSourceType;
import io.atlasmap.v2.Field;
import io.atlasmap.v2.Mapping;
import io.atlasmap.v2.MappingType;
import io.atlasmap.v2.Mappings;
import io.atlasmap.v2.Properties;
import io.atlasmap.v2.Property;
import io.atlasmap.v2.PropertyField;
import io.atlasmap.xml.v2.InspectionType;
import io.atlasmap.xml.v2.XmlField;
import io.atlasmap.xml.v2.XmlInspectionRequest;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.rules.TestName;

public abstract class BaseMarshallerTest {
    public boolean deleteTestFolders = true;
    @Rule
    public TestName testName = new TestName();

    @Before
    public void setUp() throws Exception {
        Files.createDirectories(Paths.get("target/junit/" + this.testName.getMethodName(), new String[0]), new FileAttribute[0]);
    }

    @After
    public void tearDown() throws Exception {
        if (this.deleteTestFolders) {
            Path directory = Paths.get("target/junit/" + this.testName.getMethodName(), new String[0]);
            Files.walkFileTree(directory, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    Files.delete(file);
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
                    Files.delete(file);
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                    if (exc == null) {
                        Files.delete(dir);
                        return FileVisitResult.CONTINUE;
                    }
                    throw exc;
                }
            });
        }
    }

    protected AtlasMapping generateAtlasMapping() {
        AtlasMapping atlasMapping = AtlasModelFactory.createAtlasMapping();
        atlasMapping.setName("junit");
        Mapping mapping = (Mapping)AtlasModelFactory.createMapping((MappingType)MappingType.MAP);
        XmlField inputField = new XmlField();
        inputField.setName("foo");
        inputField.setValue((Object)"bar");
        mapping.getInputField().add(inputField);
        XmlField outputField = new XmlField();
        outputField.setName("woot");
        outputField.setValue((Object)"blerg");
        outputField.setUserCreated(Boolean.valueOf(true));
        mapping.getOutputField().add(outputField);
        atlasMapping.getMappings().getMapping().add(mapping);
        return atlasMapping;
    }

    protected AtlasMapping generateCollectionMapping() {
        AtlasMapping innerMapping1 = this.generateAtlasMapping();
        AtlasMapping innerMapping2 = this.generateAtlasMapping();
        Collection cMapping = new Collection();
        cMapping.getMappings().getMapping().addAll(innerMapping1.getMappings().getMapping());
        cMapping.getMappings().getMapping().addAll(innerMapping2.getMappings().getMapping());
        cMapping.setCollectionType(CollectionType.LIST);
        AtlasMapping mapping = this.generateAtlasMapping();
        mapping.getMappings().getMapping().clear();
        mapping.getMappings().getMapping().add(cMapping);
        return mapping;
    }

    protected AtlasMapping generateCombineMapping() {
        XmlField inputFieldA = new XmlField();
        inputFieldA.setName("foo");
        inputFieldA.setValue((Object)"bar");
        XmlField inputFieldB = new XmlField();
        inputFieldB.setName("foo3");
        inputFieldB.setValue((Object)"bar3");
        XmlField outputFieldA = new XmlField();
        outputFieldA.setName("woot");
        outputFieldA.setValue((Object)"blerg");
        Mapping fm = (Mapping)AtlasModelFactory.createMapping((MappingType)MappingType.COMBINE);
        fm.getInputField().add(inputFieldA);
        fm.getInputField().add(inputFieldB);
        fm.getOutputField().add(outputFieldA);
        AtlasMapping mapping = this.generateAtlasMapping();
        mapping.getMappings().getMapping().clear();
        mapping.getMappings().getMapping().add(fm);
        return mapping;
    }

    protected AtlasMapping generatePropertyReferenceMapping() {
        AtlasMapping mapping = this.generateAtlasMapping();
        PropertyField inputField = new PropertyField();
        inputField.setName("foo");
        Mapping fm = (Mapping)mapping.getMappings().getMapping().get(0);
        fm.getInputField().add(inputField);
        Property p = new Property();
        p.setName("foo");
        p.setValue("bar");
        mapping.setProperties(new Properties());
        mapping.getProperties().getProperty().add(p);
        return mapping;
    }

    protected AtlasMapping generateConstantMapping() {
        AtlasMapping mapping = this.generateAtlasMapping();
        ConstantField inputField = new ConstantField();
        inputField.setValue((Object)"foo");
        Mapping fm = (Mapping)mapping.getMappings().getMapping().get(0);
        fm.getInputField().add(inputField);
        return mapping;
    }

    protected AtlasMapping generateMultiSourceMapping() {
        AtlasMapping mapping = this.generateSeparateAtlasMapping();
        DataSource source1 = new DataSource();
        source1.setUri("xml:foo1");
        source1.setDataSourceType(DataSourceType.SOURCE);
        source1.setId("xml1");
        DataSource source2 = new DataSource();
        source2.setUri("xml:foo2");
        source2.setDataSourceType(DataSourceType.SOURCE);
        source2.setId("xml2");
        DataSource target = new DataSource();
        target.setUri("xml:bar");
        target.setDataSourceType(DataSourceType.TARGET);
        target.setId("target1");
        mapping.getDataSource().add(source1);
        mapping.getDataSource().add(source2);
        mapping.getDataSource().add(target);
        Mapping fm = (Mapping)mapping.getMappings().getMapping().get(0);
        ((Field)fm.getInputField().get(0)).setDocId("xml1");
        ((Field)fm.getOutputField().get(0)).setDocId("target1");
        ((Field)fm.getOutputField().get(1)).setDocId("target1");
        return mapping;
    }

    protected void validateAtlasMapping(AtlasMapping mapping) {
        Assert.assertNotNull((Object)mapping);
        Assert.assertNotNull((Object)mapping.getName());
        Assert.assertEquals((Object)"junit", (Object)mapping.getName());
        Assert.assertNotNull((Object)mapping.getMappings());
        Assert.assertEquals((Object)new Integer(1), (Object)new Integer(mapping.getMappings().getMapping().size()));
        Assert.assertNotNull((Object)mapping.getProperties());
        Mapping fm = (Mapping)mapping.getMappings().getMapping().get(0);
        Assert.assertNotNull((Object)fm);
        Assert.assertNull((Object)fm.getAlias());
        Assert.assertTrue((boolean)(fm.getInputField().get(0) instanceof XmlField));
        XmlField m1 = (XmlField)fm.getInputField().get(0);
        Assert.assertNotNull((Object)m1);
        Assert.assertNull((Object)m1.getActions());
        Assert.assertEquals((Object)"foo", (Object)m1.getName());
        Assert.assertEquals((Object)"bar", (Object)m1.getValue());
        Assert.assertNull((Object)m1.getFieldType());
        Assert.assertTrue((boolean)(fm.getOutputField().get(0) instanceof XmlField));
        XmlField m2 = (XmlField)fm.getOutputField().get(0);
        Assert.assertNotNull((Object)m2);
        Assert.assertNull((Object)m2.getActions());
        Assert.assertEquals((Object)"woot", (Object)m2.getName());
        Assert.assertEquals((Object)"blerg", (Object)m2.getValue());
        Assert.assertNull((Object)m2.getFieldType());
    }

    protected AtlasMapping generateSeparateAtlasMapping() {
        AtlasMapping atlasMapping = new AtlasMapping();
        atlasMapping.setName("junit");
        atlasMapping.setMappings(new Mappings());
        Mapping mapping = (Mapping)AtlasModelFactory.createMapping((MappingType)MappingType.SEPARATE);
        XmlField inputField = new XmlField();
        inputField.setName("foo");
        inputField.setValue((Object)"bar");
        XmlField outputFieldA = new XmlField();
        outputFieldA.setName("woot");
        outputFieldA.setValue((Object)"blerg");
        outputFieldA.setIndex(Integer.valueOf(1));
        XmlField outputFieldB = new XmlField();
        outputFieldB.setName("meow");
        outputFieldB.setValue((Object)"ruff");
        outputFieldB.setIndex(Integer.valueOf(2));
        mapping.getInputField().add(inputField);
        mapping.getOutputField().add(outputFieldA);
        mapping.getOutputField().add(outputFieldB);
        atlasMapping.getMappings().getMapping().add(mapping);
        return atlasMapping;
    }

    protected void validateSeparateAtlasMapping(AtlasMapping mapping) {
        Assert.assertNotNull((Object)mapping);
        Assert.assertNotNull((Object)mapping.getName());
        Assert.assertEquals((Object)"junit", (Object)mapping.getName());
        Assert.assertNotNull((Object)mapping.getMappings());
        Assert.assertEquals((Object)new Integer(1), (Object)new Integer(mapping.getMappings().getMapping().size()));
        Assert.assertNull((Object)mapping.getProperties());
        Mapping fm = (Mapping)mapping.getMappings().getMapping().get(0);
        Assert.assertNotNull((Object)fm);
        Assert.assertEquals((Object)MappingType.SEPARATE, (Object)fm.getMappingType());
        Assert.assertNull((Object)fm.getAlias());
        XmlField m1 = (XmlField)fm.getInputField().get(0);
        Assert.assertNotNull((Object)m1);
        Assert.assertNull((Object)m1.getActions());
        Assert.assertEquals((Object)"foo", (Object)m1.getName());
        Assert.assertEquals((Object)"bar", (Object)m1.getValue());
        Assert.assertNull((Object)m1.getFieldType());
        XmlField m2 = (XmlField)fm.getOutputField().get(0);
        Assert.assertNotNull((Object)m2);
        Assert.assertNull((Object)m2.getActions());
        Assert.assertEquals((Object)"woot", (Object)m2.getName());
        Assert.assertEquals((Object)"blerg", (Object)m2.getValue());
        Assert.assertNull((Object)m2.getFieldType());
        Assert.assertEquals((Object)new Integer(1), (Object)m2.getIndex());
        XmlField m3 = (XmlField)fm.getOutputField().get(0);
        Assert.assertNotNull((Object)m3);
        Assert.assertNull((Object)m3.getActions());
        Assert.assertEquals((Object)"meow", (Object)m3.getName());
        Assert.assertEquals((Object)"ruff", (Object)m3.getValue());
        Assert.assertNull((Object)m3.getFieldType());
        Assert.assertEquals((Object)new Integer(2), (Object)m3.getIndex());
    }

    public XmlInspectionRequest generateInspectionRequest() {
        XmlInspectionRequest xmlInspectionRequest = new XmlInspectionRequest();
        xmlInspectionRequest.setType(InspectionType.INSTANCE);
        String xmlData = "<data>\n     <intField a='1'>32000</intField>\n     <longField>12421</longField>\n     <stringField>abc</stringField>\n     <booleanField>true</booleanField>\n     <doubleField b='2'>12.0</doubleField>\n     <shortField>1000</shortField>\n     <floatField>234.5f</floatField>\n     <charField>A</charField>\n</data>";
        xmlInspectionRequest.setXmlData("<data>\n     <intField a='1'>32000</intField>\n     <longField>12421</longField>\n     <stringField>abc</stringField>\n     <booleanField>true</booleanField>\n     <doubleField b='2'>12.0</doubleField>\n     <shortField>1000</shortField>\n     <floatField>234.5f</floatField>\n     <charField>A</charField>\n</data>");
        return xmlInspectionRequest;
    }
}

