/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.xml.v2;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import io.atlasmap.v2.AtlasMapping;
import io.atlasmap.v2.DataSource;
import io.atlasmap.v2.DataSourceType;
import io.atlasmap.xml.v2.BaseMarshallerTest;
import io.atlasmap.xml.v2.XmlDataSource;
import io.atlasmap.xml.v2.XmlInspectionRequest;
import io.atlasmap.xml.v2.XmlNamespace;
import io.atlasmap.xml.v2.XmlNamespaces;
import java.io.File;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class JsonMarshallerTest
extends BaseMarshallerTest {
    public ObjectMapper mapper = null;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.deleteTestFolders = false;
        this.mapper = new ObjectMapper();
        this.mapper.configure(SerializationFeature.WRAP_ROOT_VALUE, true);
        this.mapper.configure(DeserializationFeature.UNWRAP_ROOT_VALUE, true);
        this.mapper.configure(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY, true);
        this.mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
    }

    @Override
    @After
    public void tearDown() throws Exception {
        super.tearDown();
        this.mapper = null;
    }

    @Test
    public void testJsonMapXMLField() throws Exception {
        AtlasMapping atlasMapping = this.generateAtlasMapping();
        XmlDataSource ds = new XmlDataSource();
        ds.setUri("someuri");
        ds.setId("someid");
        ds.setDataSourceType(DataSourceType.SOURCE);
        ds.setXmlNamespaces(new XmlNamespaces());
        ds.setTemplate("Some template");
        XmlNamespace ns = new XmlNamespace();
        ns.setAlias("tns");
        ns.setLocationUri("location");
        ns.setTargetNamespace(Boolean.valueOf(false));
        ns.setUri("uri");
        ds.getXmlNamespaces().getXmlNamespace().add(ns);
        atlasMapping.getDataSource().add(ds);
        DataSource ds2 = new DataSource();
        ds2.setUri("someuri2");
        ds2.setId("someid2");
        ds2.setDataSourceType(DataSourceType.TARGET);
        atlasMapping.getDataSource().add(ds2);
        this.mapper.writerWithDefaultPrettyPrinter().writeValue(new File("target" + File.separator + "junit" + File.separator + this.testName.getMethodName() + File.separator + "atlasmapping.json"), (Object)atlasMapping);
        AtlasMapping uMapping = (AtlasMapping)this.mapper.readValue(new File("target" + File.separator + "junit" + File.separator + this.testName.getMethodName() + File.separator + "atlasmapping.json"), AtlasMapping.class);
        Assert.assertNotNull((Object)uMapping);
        this.validateAtlasMapping(uMapping);
    }

    @Test
    public void testJsonXmlInspectionRequest() throws Exception {
        XmlInspectionRequest request = this.generateInspectionRequest();
        this.mapper.writerWithDefaultPrettyPrinter().writeValue(new File("target" + File.separator + "junit" + File.separator + this.testName.getMethodName() + File.separator + "atlasmapping-xmlinspection-request.json"), (Object)request);
        XmlInspectionRequest uRequest = (XmlInspectionRequest)this.mapper.readValue(new File("target" + File.separator + "junit" + File.separator + this.testName.getMethodName() + File.separator + "atlasmapping-xmlinspection-request.json"), XmlInspectionRequest.class);
        Assert.assertNotNull((Object)uRequest);
    }
}

