/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.xml.v2;

import io.atlasmap.v2.Action;
import io.atlasmap.v2.AtlasMapping;
import io.atlasmap.v2.AtlasModelFactory;
import io.atlasmap.v2.Camelize;
import io.atlasmap.v2.Capitalize;
import io.atlasmap.v2.Collection;
import io.atlasmap.v2.CollectionType;
import io.atlasmap.v2.ConstantField;
import io.atlasmap.v2.DataSource;
import io.atlasmap.v2.DataSourceType;
import io.atlasmap.v2.Field;
import io.atlasmap.v2.FieldStatus;
import io.atlasmap.v2.FieldType;
import io.atlasmap.v2.Length;
import io.atlasmap.v2.LookupEntry;
import io.atlasmap.v2.LookupTable;
import io.atlasmap.v2.Lowercase;
import io.atlasmap.v2.Mapping;
import io.atlasmap.v2.MappingType;
import io.atlasmap.v2.Mappings;
import io.atlasmap.v2.Properties;
import io.atlasmap.v2.Property;
import io.atlasmap.v2.PropertyField;
import io.atlasmap.v2.SeparateByDash;
import io.atlasmap.v2.SeparateByUnderscore;
import io.atlasmap.v2.StringList;
import io.atlasmap.v2.Trim;
import io.atlasmap.v2.TrimLeft;
import io.atlasmap.v2.TrimRight;
import io.atlasmap.v2.Uppercase;
import io.atlasmap.xml.v2.InspectionType;
import io.atlasmap.xml.v2.NodeType;
import io.atlasmap.xml.v2.Restriction;
import io.atlasmap.xml.v2.RestrictionType;
import io.atlasmap.xml.v2.Restrictions;
import io.atlasmap.xml.v2.XmlDataSource;
import io.atlasmap.xml.v2.XmlField;
import io.atlasmap.xml.v2.XmlInspectionRequest;
import io.atlasmap.xml.v2.XmlNamespace;
import io.atlasmap.xml.v2.XmlNamespaces;
import java.io.IOException;
import java.lang.reflect.Method;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestInfo;

public abstract class BaseMarshallerTest {
    public boolean deleteTestFolders = true;
    protected String testMethodName;

    @BeforeEach
    public void setUp(TestInfo testInfo) throws Exception {
        this.testMethodName = ((Method)testInfo.getTestMethod().get()).getName();
        Files.createDirectories(Paths.get("target/junit/" + this.testMethodName, new String[0]), new FileAttribute[0]);
    }

    @AfterEach
    public void tearDown() throws Exception {
        if (this.deleteTestFolders) {
            Path directory = Paths.get("target/junit/" + this.testMethodName, new String[0]);
            Files.walkFileTree(directory, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    Files.delete(file);
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
                    Files.delete(file);
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                    if (exc == null) {
                        Files.delete(dir);
                        return FileVisitResult.CONTINUE;
                    }
                    throw exc;
                }
            });
        }
    }

    protected AtlasMapping generateAtlasMapping() {
        AtlasMapping atlasMapping = AtlasModelFactory.createAtlasMapping();
        atlasMapping.setName("junit");
        this.generateXmlDataSource(atlasMapping);
        this.generateLookupTables(atlasMapping);
        ArrayList<Action> actions = this.generateactions();
        StringList stringList = new StringList();
        stringList.getString().add("XmlAccessorType");
        stringList.getString().add("XmlType");
        Restrictions restrictions = new Restrictions();
        Restriction restriction = new Restriction();
        restriction.setType(RestrictionType.LENGTH);
        restriction.setValue("100");
        restrictions.getRestriction().add(restriction);
        Mapping mapping = (Mapping)AtlasModelFactory.createMapping((MappingType)MappingType.MAP);
        XmlField inputField = this.generateXmlField(actions, stringList, restrictions);
        mapping.getInputField().add(inputField);
        XmlField outputField = this.generateXmlField(actions, stringList, restrictions);
        mapping.getOutputField().add(outputField);
        mapping.setMappingType(MappingType.MAP);
        mapping.setDelimiterString(",");
        mapping.setAlias("MapPropertyFieldAlias");
        mapping.setDelimiter(",");
        mapping.setDescription("description");
        mapping.setId("id");
        mapping.setLookupTableName("lookupTableName");
        mapping.setStrategy("strategy");
        mapping.setStrategyClassName("strategyClassName");
        atlasMapping.getMappings().getMapping().add(mapping);
        this.generateProperties(atlasMapping);
        return atlasMapping;
    }

    private void generateProperties(AtlasMapping atlasMapping) {
        Property p = new Property();
        p.setName("foo");
        p.setValue("bar");
        p.setFieldType(FieldType.INTEGER);
        atlasMapping.setProperties(new Properties());
        atlasMapping.getProperties().getProperty().add(p);
    }

    private XmlField generateXmlField(ArrayList<Action> actions, StringList stringList, Restrictions restrictions) {
        XmlField inputField = new XmlField();
        inputField.setName("foo");
        inputField.setValue((Object)"bar");
        inputField.setActions(actions);
        inputField.setArrayDimensions(Integer.valueOf(3));
        inputField.setArraySize(Integer.valueOf(3));
        inputField.setCollectionType(CollectionType.ARRAY);
        inputField.setDocId("docid");
        inputField.setPath("/path");
        inputField.setRequired(Boolean.valueOf(false));
        inputField.setStatus(FieldStatus.SUPPORTED);
        inputField.setFieldType(FieldType.INTEGER);
        inputField.setIndex(Integer.valueOf(3));
        inputField.setAnnotations(stringList);
        inputField.setPrimitive(Boolean.FALSE);
        inputField.setNodeType(NodeType.ELEMENT);
        inputField.setRestrictions(restrictions);
        inputField.setTypeName("typeName");
        inputField.setUserCreated(Boolean.TRUE);
        return inputField;
    }

    private ArrayList<Action> generateactions() {
        ArrayList<Action> actions = new ArrayList<Action>();
        actions.add((Action)new Camelize());
        actions.add((Action)new Capitalize());
        actions.add((Action)new Length());
        actions.add((Action)new Lowercase());
        actions.add((Action)new SeparateByDash());
        actions.add((Action)new SeparateByUnderscore());
        actions.add((Action)new Trim());
        actions.add((Action)new TrimLeft());
        actions.add((Action)new TrimRight());
        actions.add((Action)new Uppercase());
        return actions;
    }

    private void generateLookupTables(AtlasMapping atlasMapping) {
        LookupTable table = new LookupTable();
        table.setName("lookupTable");
        table.setDescription("lookupTableDescription");
        LookupEntry l1 = new LookupEntry();
        l1.setSourceType(FieldType.STRING);
        l1.setSourceValue("Foo");
        l1.setTargetType(FieldType.STRING);
        l1.setTargetValue("Bar");
        table.getLookupEntry().add(l1);
        atlasMapping.getLookupTables().getLookupTable().add(table);
    }

    private void generateXmlDataSource(AtlasMapping atlasMapping) {
        XmlNamespace xmlNs = this.generateXmlNamespace("alias", "http://atlasmap.io/xml/test/v2", "http://atlasmap.io/xml/test/v2", Boolean.FALSE);
        XmlDataSource src = this.generateXmlDataSource("srcId", "srcUri", DataSourceType.SOURCE, "template", xmlNs);
        xmlNs = this.generateXmlNamespace("alias", "http://atlasmap.io/xml/test/v2", "http://atlasmap.io/xml/test/v2", Boolean.TRUE);
        XmlDataSource tgt = this.generateXmlDataSource("tgtId", "tgtUri", DataSourceType.TARGET, "template", xmlNs);
        atlasMapping.getDataSource().add(src);
        atlasMapping.getDataSource().add(tgt);
    }

    private XmlNamespace generateXmlNamespace(String alias, String uri, String location, boolean isTarget) {
        XmlNamespace xmlNs = new XmlNamespace();
        xmlNs.setAlias(alias);
        xmlNs.setUri(uri);
        xmlNs.setLocationUri(location);
        xmlNs.setTargetNamespace(Boolean.valueOf(isTarget));
        return xmlNs;
    }

    private XmlDataSource generateXmlDataSource(String id, String uri, DataSourceType dataSourceType, String template, XmlNamespace xmlNs) {
        XmlDataSource src = new XmlDataSource();
        src.setId(id);
        src.setUri(uri);
        src.setDataSourceType(dataSourceType);
        src.setTemplate(template);
        src.setXmlNamespaces(new XmlNamespaces());
        src.getXmlNamespaces().getXmlNamespace().add(xmlNs);
        return src;
    }

    protected AtlasMapping generateCollectionMapping() {
        AtlasMapping innerMapping1 = this.generateAtlasMapping();
        AtlasMapping innerMapping2 = this.generateAtlasMapping();
        Collection cMapping = new Collection();
        cMapping.getMappings().getMapping().addAll(innerMapping1.getMappings().getMapping());
        cMapping.getMappings().getMapping().addAll(innerMapping2.getMappings().getMapping());
        cMapping.setCollectionType(CollectionType.LIST);
        AtlasMapping mapping = this.generateAtlasMapping();
        mapping.getMappings().getMapping().clear();
        mapping.getMappings().getMapping().add(cMapping);
        return mapping;
    }

    protected AtlasMapping generateCombineMapping() {
        XmlField inputFieldA = new XmlField();
        inputFieldA.setName("foo");
        inputFieldA.setValue((Object)"bar");
        XmlField inputFieldB = new XmlField();
        inputFieldB.setName("foo3");
        inputFieldB.setValue((Object)"bar3");
        XmlField outputFieldA = new XmlField();
        outputFieldA.setName("woot");
        outputFieldA.setValue((Object)"blerg");
        Mapping fm = (Mapping)AtlasModelFactory.createMapping((MappingType)MappingType.COMBINE);
        fm.getInputField().add(inputFieldA);
        fm.getInputField().add(inputFieldB);
        fm.getOutputField().add(outputFieldA);
        AtlasMapping mapping = this.generateAtlasMapping();
        mapping.getMappings().getMapping().clear();
        mapping.getMappings().getMapping().add(fm);
        return mapping;
    }

    protected AtlasMapping generatePropertyReferenceMapping() {
        AtlasMapping mapping = this.generateAtlasMapping();
        PropertyField inputField = new PropertyField();
        inputField.setName("foo");
        Mapping fm = (Mapping)mapping.getMappings().getMapping().get(0);
        fm.getInputField().add(inputField);
        Property p = new Property();
        p.setName("foo");
        p.setValue("bar");
        mapping.setProperties(new Properties());
        mapping.getProperties().getProperty().add(p);
        return mapping;
    }

    protected AtlasMapping generateConstantMapping() {
        AtlasMapping mapping = this.generateAtlasMapping();
        ConstantField inputField = new ConstantField();
        inputField.setValue((Object)"foo");
        Mapping fm = (Mapping)mapping.getMappings().getMapping().get(0);
        fm.getInputField().add(inputField);
        return mapping;
    }

    protected AtlasMapping generateMultiSourceMapping() {
        AtlasMapping mapping = this.generateSeparateAtlasMapping();
        DataSource source1 = new DataSource();
        source1.setUri("xml:foo1");
        source1.setDataSourceType(DataSourceType.SOURCE);
        source1.setId("xml1");
        DataSource source2 = new DataSource();
        source2.setUri("xml:foo2");
        source2.setDataSourceType(DataSourceType.SOURCE);
        source2.setId("xml2");
        DataSource target = new DataSource();
        target.setUri("xml:bar");
        target.setDataSourceType(DataSourceType.TARGET);
        target.setId("target1");
        mapping.getDataSource().add(source1);
        mapping.getDataSource().add(source2);
        mapping.getDataSource().add(target);
        Mapping fm = (Mapping)mapping.getMappings().getMapping().get(0);
        ((Field)fm.getInputField().get(0)).setDocId("xml1");
        ((Field)fm.getOutputField().get(0)).setDocId("target1");
        ((Field)fm.getOutputField().get(1)).setDocId("target1");
        return mapping;
    }

    protected void validateAtlasMapping(AtlasMapping mapping) {
        Assertions.assertNotNull((Object)mapping);
        Assertions.assertNotNull((Object)mapping.getName());
        Assertions.assertEquals((Object)"junit", (Object)mapping.getName());
        Assertions.assertEquals((int)2, (int)mapping.getDataSource().size());
        Assertions.assertEquals((Object)DataSourceType.SOURCE, (Object)((DataSource)mapping.getDataSource().get(0)).getDataSourceType());
        Assertions.assertEquals((Object)"srcId", (Object)((DataSource)mapping.getDataSource().get(0)).getId());
        Assertions.assertEquals((Object)"srcUri", (Object)((DataSource)mapping.getDataSource().get(0)).getUri());
        Assertions.assertEquals((Object)"template", (Object)((XmlDataSource)mapping.getDataSource().get(0)).getTemplate());
        Assertions.assertEquals((Object)"alias", (Object)((XmlNamespace)((XmlDataSource)mapping.getDataSource().get(0)).getXmlNamespaces().getXmlNamespace().get(0)).getAlias());
        Assertions.assertEquals((Object)"http://atlasmap.io/xml/test/v2", (Object)((XmlNamespace)((XmlDataSource)mapping.getDataSource().get(0)).getXmlNamespaces().getXmlNamespace().get(0)).getUri());
        Assertions.assertEquals((Object)"http://atlasmap.io/xml/test/v2", (Object)((XmlNamespace)((XmlDataSource)mapping.getDataSource().get(0)).getXmlNamespaces().getXmlNamespace().get(0)).getLocationUri());
        Assertions.assertEquals((Object)Boolean.FALSE, (Object)((XmlNamespace)((XmlDataSource)mapping.getDataSource().get(0)).getXmlNamespaces().getXmlNamespace().get(0)).isTargetNamespace());
        Assertions.assertEquals((Object)DataSourceType.TARGET, (Object)((DataSource)mapping.getDataSource().get(1)).getDataSourceType());
        Assertions.assertEquals((Object)"tgtId", (Object)((DataSource)mapping.getDataSource().get(1)).getId());
        Assertions.assertEquals((Object)"tgtUri", (Object)((DataSource)mapping.getDataSource().get(1)).getUri());
        Assertions.assertEquals((Object)"template", (Object)((XmlDataSource)mapping.getDataSource().get(1)).getTemplate());
        Assertions.assertEquals((Object)"alias", (Object)((XmlNamespace)((XmlDataSource)mapping.getDataSource().get(1)).getXmlNamespaces().getXmlNamespace().get(0)).getAlias());
        Assertions.assertEquals((Object)"http://atlasmap.io/xml/test/v2", (Object)((XmlNamespace)((XmlDataSource)mapping.getDataSource().get(1)).getXmlNamespaces().getXmlNamespace().get(0)).getUri());
        Assertions.assertEquals((Object)"http://atlasmap.io/xml/test/v2", (Object)((XmlNamespace)((XmlDataSource)mapping.getDataSource().get(1)).getXmlNamespaces().getXmlNamespace().get(0)).getLocationUri());
        Assertions.assertEquals((Object)Boolean.TRUE, (Object)((XmlNamespace)((XmlDataSource)mapping.getDataSource().get(1)).getXmlNamespaces().getXmlNamespace().get(0)).isTargetNamespace());
        Assertions.assertNotNull((Object)mapping.getLookupTables());
        Assertions.assertEquals((int)1, (int)mapping.getLookupTables().getLookupTable().size());
        this.validateLookupTable((LookupTable)mapping.getLookupTables().getLookupTable().get(0));
        Assertions.assertNotNull((Object)mapping.getMappings());
        Assertions.assertEquals((Integer)1, (Integer)mapping.getMappings().getMapping().size());
        this.validateMapping((Mapping)mapping.getMappings().getMapping().get(0));
        Assertions.assertNotNull((Object)mapping.getProperties());
        Assertions.assertEquals((int)1, (int)mapping.getProperties().getProperty().size());
        this.validateProperty((Property)mapping.getProperties().getProperty().get(0));
    }

    private void validateMapping(Mapping mapping) {
        Assertions.assertEquals((Object)"MapPropertyFieldAlias", (Object)mapping.getAlias());
        Assertions.assertEquals((Object)MappingType.MAP, (Object)mapping.getMappingType());
        Assertions.assertEquals((Object)",", (Object)mapping.getDelimiter());
        Assertions.assertEquals((Object)",", (Object)mapping.getDelimiterString());
        Assertions.assertEquals((Object)"description", (Object)mapping.getDescription());
        Assertions.assertEquals((Object)"id", (Object)mapping.getId());
        Assertions.assertEquals((int)1, (int)mapping.getInputField().size());
        this.validateXmlField((XmlField)mapping.getInputField().get(0));
        Assertions.assertEquals((Object)"lookupTableName", (Object)mapping.getLookupTableName());
        Assertions.assertEquals((int)1, (int)mapping.getOutputField().size());
        this.validateXmlField((XmlField)mapping.getOutputField().get(0));
        Assertions.assertEquals((Object)"strategy", (Object)mapping.getStrategy());
        Assertions.assertEquals((Object)"strategyClassName", (Object)mapping.getStrategyClassName());
    }

    private void validateXmlField(XmlField field) {
        Assertions.assertEquals((int)10, (int)field.getActions().size());
        Assertions.assertEquals((Object)"XmlAccessorType", field.getAnnotations().getString().get(0));
        Assertions.assertEquals((Object)"XmlType", field.getAnnotations().getString().get(1));
        Assertions.assertEquals((Integer)3, (Integer)field.getArrayDimensions());
        Assertions.assertEquals((Integer)3, (Integer)field.getArraySize());
        Assertions.assertEquals((Object)CollectionType.ARRAY, (Object)field.getCollectionType());
        Assertions.assertEquals((Object)"docid", (Object)field.getDocId());
        Assertions.assertEquals((Object)FieldType.INTEGER, (Object)field.getFieldType());
        Assertions.assertEquals((Integer)3, (Integer)field.getIndex());
        Assertions.assertEquals((Object)"foo", (Object)field.getName());
        Assertions.assertEquals((Object)"/path", (Object)field.getPath());
        Assertions.assertEquals((Object)Boolean.FALSE, (Object)field.isPrimitive());
        Assertions.assertEquals((Object)Boolean.FALSE, (Object)field.isRequired());
        Assertions.assertEquals((Object)FieldStatus.SUPPORTED, (Object)field.getStatus());
        Assertions.assertEquals((Object)"bar", (Object)field.getValue());
        Assertions.assertEquals((Object)NodeType.ELEMENT, (Object)field.getNodeType());
        Assertions.assertEquals((Object)"typeName", (Object)field.getTypeName());
        Assertions.assertEquals((Object)Boolean.TRUE, (Object)field.isUserCreated());
        Assertions.assertEquals((Object)RestrictionType.LENGTH, (Object)((Restriction)field.getRestrictions().getRestriction().get(0)).getType());
        Assertions.assertEquals((Object)"100", (Object)((Restriction)field.getRestrictions().getRestriction().get(0)).getValue());
    }

    private void validateLookupTable(LookupTable lookupTable) {
        Assertions.assertEquals((Object)"lookupTableDescription", (Object)lookupTable.getDescription());
        Assertions.assertEquals((Object)"lookupTable", (Object)lookupTable.getName());
        Assertions.assertEquals((Object)FieldType.STRING, (Object)((LookupEntry)lookupTable.getLookupEntry().get(0)).getSourceType());
        Assertions.assertEquals((Object)"Foo", (Object)((LookupEntry)lookupTable.getLookupEntry().get(0)).getSourceValue());
        Assertions.assertEquals((Object)FieldType.STRING, (Object)((LookupEntry)lookupTable.getLookupEntry().get(0)).getTargetType());
        Assertions.assertEquals((Object)"Bar", (Object)((LookupEntry)lookupTable.getLookupEntry().get(0)).getTargetValue());
    }

    private void validateProperty(Property p) {
        Assertions.assertEquals((Object)FieldType.INTEGER, (Object)p.getFieldType());
        Assertions.assertEquals((Object)"foo", (Object)p.getName());
        Assertions.assertEquals((Object)"bar", (Object)p.getValue());
    }

    protected AtlasMapping generateSeparateAtlasMapping() {
        AtlasMapping atlasMapping = new AtlasMapping();
        atlasMapping.setName("junit");
        atlasMapping.setMappings(new Mappings());
        Mapping mapping = (Mapping)AtlasModelFactory.createMapping((MappingType)MappingType.SEPARATE);
        XmlField inputField = new XmlField();
        inputField.setName("foo");
        inputField.setValue((Object)"bar");
        XmlField outputFieldA = new XmlField();
        outputFieldA.setName("woot");
        outputFieldA.setValue((Object)"blerg");
        outputFieldA.setIndex(Integer.valueOf(1));
        XmlField outputFieldB = new XmlField();
        outputFieldB.setName("meow");
        outputFieldB.setValue((Object)"ruff");
        outputFieldB.setIndex(Integer.valueOf(2));
        mapping.getInputField().add(inputField);
        mapping.getOutputField().add(outputFieldA);
        mapping.getOutputField().add(outputFieldB);
        atlasMapping.getMappings().getMapping().add(mapping);
        return atlasMapping;
    }

    protected void validateSeparateAtlasMapping(AtlasMapping mapping) {
        Assertions.assertNotNull((Object)mapping);
        Assertions.assertNotNull((Object)mapping.getName());
        Assertions.assertEquals((Object)"junit", (Object)mapping.getName());
        Assertions.assertNotNull((Object)mapping.getMappings());
        Assertions.assertEquals((Integer)1, (Integer)mapping.getMappings().getMapping().size());
        Assertions.assertNull((Object)mapping.getProperties());
        Mapping fm = (Mapping)mapping.getMappings().getMapping().get(0);
        Assertions.assertNotNull((Object)fm);
        Assertions.assertEquals((Object)MappingType.SEPARATE, (Object)fm.getMappingType());
        Assertions.assertNull((Object)fm.getAlias());
        XmlField m1 = (XmlField)fm.getInputField().get(0);
        Assertions.assertNotNull((Object)m1);
        Assertions.assertNull((Object)m1.getActions());
        Assertions.assertEquals((Object)"foo", (Object)m1.getName());
        Assertions.assertEquals((Object)"bar", (Object)m1.getValue());
        Assertions.assertNull((Object)m1.getFieldType());
        XmlField m2 = (XmlField)fm.getOutputField().get(0);
        Assertions.assertNotNull((Object)m2);
        Assertions.assertNull((Object)m2.getActions());
        Assertions.assertEquals((Object)"woot", (Object)m2.getName());
        Assertions.assertEquals((Object)"blerg", (Object)m2.getValue());
        Assertions.assertNull((Object)m2.getFieldType());
        Assertions.assertEquals((Integer)1, (Integer)m2.getIndex());
        XmlField m3 = (XmlField)fm.getOutputField().get(0);
        Assertions.assertNotNull((Object)m3);
        Assertions.assertNull((Object)m3.getActions());
        Assertions.assertEquals((Object)"meow", (Object)m3.getName());
        Assertions.assertEquals((Object)"ruff", (Object)m3.getValue());
        Assertions.assertNull((Object)m3.getFieldType());
        Assertions.assertEquals((Integer)new Integer(2), (Integer)m3.getIndex());
    }

    public XmlInspectionRequest generateInspectionRequest() {
        XmlInspectionRequest xmlInspectionRequest = new XmlInspectionRequest();
        xmlInspectionRequest.setType(InspectionType.INSTANCE);
        String xmlData = "<data>\n     <intField a='1'>32000</intField>\n     <longField>12421</longField>\n     <stringField>abc</stringField>\n     <booleanField>true</booleanField>\n     <doubleField b='2'>12.0</doubleField>\n     <shortField>1000</shortField>\n     <floatField>234.5f</floatField>\n     <charField>A</charField>\n</data>";
        xmlInspectionRequest.setXmlData("<data>\n     <intField a='1'>32000</intField>\n     <longField>12421</longField>\n     <stringField>abc</stringField>\n     <booleanField>true</booleanField>\n     <doubleField b='2'>12.0</doubleField>\n     <shortField>1000</shortField>\n     <floatField>234.5f</floatField>\n     <charField>A</charField>\n</data>");
        return xmlInspectionRequest;
    }
}

