/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.xml.v2;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import io.atlasmap.v2.AtlasMapping;
import io.atlasmap.xml.v2.BaseMarshallerTest;
import io.atlasmap.xml.v2.XmlInspectionRequest;
import java.io.File;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;

public class JsonMarshallerTest
extends BaseMarshallerTest {
    public ObjectMapper mapper = null;

    @Override
    @BeforeEach
    public void setUp(TestInfo testInfo) throws Exception {
        super.setUp(testInfo);
        this.deleteTestFolders = false;
        this.mapper = new ObjectMapper();
        this.mapper.configure(SerializationFeature.WRAP_ROOT_VALUE, true);
        this.mapper.configure(DeserializationFeature.UNWRAP_ROOT_VALUE, true);
        this.mapper.configure(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY, true);
        this.mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
    }

    @Override
    @AfterEach
    public void tearDown() throws Exception {
        super.tearDown();
        this.mapper = null;
    }

    @Test
    public void testJsonMapXMLField() throws Exception {
        AtlasMapping atlasMapping = this.generateAtlasMapping();
        this.mapper.writerWithDefaultPrettyPrinter().writeValue(new File("target" + File.separator + "junit" + File.separator + this.testMethodName + File.separator + "atlasmapping.json"), (Object)atlasMapping);
        AtlasMapping uMapping = (AtlasMapping)this.mapper.readValue(new File("target" + File.separator + "junit" + File.separator + this.testMethodName + File.separator + "atlasmapping.json"), AtlasMapping.class);
        Assertions.assertNotNull((Object)uMapping);
        this.validateAtlasMapping(uMapping);
    }

    @Test
    public void testJsonXmlInspectionRequest() throws Exception {
        XmlInspectionRequest request = this.generateInspectionRequest();
        this.mapper.writerWithDefaultPrettyPrinter().writeValue(new File("target" + File.separator + "junit" + File.separator + this.testMethodName + File.separator + "atlasmapping-xmlinspection-request.json"), (Object)request);
        XmlInspectionRequest uRequest = (XmlInspectionRequest)this.mapper.readValue(new File("target" + File.separator + "junit" + File.separator + this.testMethodName + File.separator + "atlasmapping-xmlinspection-request.json"), XmlInspectionRequest.class);
        Assertions.assertNotNull((Object)uRequest);
    }
}

