/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.xml.module;

import io.atlasmap.api.AtlasConversionService;
import io.atlasmap.core.BaseModuleValidationService;
import io.atlasmap.spi.AtlasModuleDetail;
import io.atlasmap.spi.AtlasValidator;
import io.atlasmap.v2.Field;
import io.atlasmap.v2.Validation;
import io.atlasmap.v2.ValidationStatus;
import io.atlasmap.validators.NonNullValidator;
import io.atlasmap.xml.module.XmlModule;
import io.atlasmap.xml.v2.XmlField;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class XmlValidationService
extends BaseModuleValidationService<XmlField> {
    private static Map<String, AtlasValidator> validatorMap = new HashMap<String, AtlasValidator>();
    private AtlasModuleDetail moduleDetail = XmlModule.class.getAnnotation(AtlasModuleDetail.class);

    public XmlValidationService(AtlasConversionService conversionService) {
        super(conversionService);
        this.init();
    }

    public void init() {
        NonNullValidator javaFileNameNonNullValidator = new NonNullValidator("XmlField.Name", "The name element must not be null nor empty");
        NonNullValidator javaFilePathNonNullValidator = new NonNullValidator("XmlField.Path", "The path element must not be null nor empty");
        NonNullValidator inputFieldTypeNonNullValidator = new NonNullValidator("Input.Field.Type", "Field type should not be null nor empty");
        NonNullValidator outputFieldTypeNonNullValidator = new NonNullValidator("Output.Field.Type", "Field type should not be null nor empty");
        NonNullValidator fieldTypeNonNullValidator = new NonNullValidator("Field.Type", "Filed type should not be null nor empty");
        validatorMap.put("xml.field.type.not.null", (AtlasValidator)fieldTypeNonNullValidator);
        validatorMap.put("xml.field.name.not.null", (AtlasValidator)javaFileNameNonNullValidator);
        validatorMap.put("xml.field.path.not.null", (AtlasValidator)javaFilePathNonNullValidator);
        validatorMap.put("input.field.type.not.null", (AtlasValidator)inputFieldTypeNonNullValidator);
        validatorMap.put("output.field.type.not.null", (AtlasValidator)outputFieldTypeNonNullValidator);
    }

    public void destroy() {
        validatorMap.clear();
    }

    protected AtlasModuleDetail getModuleDetail() {
        return this.moduleDetail;
    }

    protected Class<XmlField> getFieldType() {
        return XmlField.class;
    }

    protected String getModuleFieldName(XmlField field) {
        StringBuilder buf = new StringBuilder();
        if (field.getName() != null) {
            buf.append(field.getName());
        }
        if (field.getFieldType() != null) {
            buf.append("(").append(field.getFieldType().name()).append(")");
        }
        return buf.toString();
    }

    protected void validateModuleField(XmlField field, BaseModuleValidationService.FieldDirection direction, List<Validation> validations) {
        validatorMap.get("xml.field.type.not.null").validate((Object)field, validations, ValidationStatus.WARN);
        if (direction == BaseModuleValidationService.FieldDirection.INPUT) {
            if (field != null) {
                validatorMap.get("input.field.type.not.null").validate((Object)field.getFieldType(), validations, ValidationStatus.WARN);
            }
        } else if (field != null) {
            validatorMap.get("output.field.type.not.null").validate((Object)field.getFieldType(), validations, ValidationStatus.WARN);
        }
        if (field != null) {
            if (field.getName() == null && field.getPath() == null) {
                Validation validation = new Validation();
                validation.setField(String.format("Field.%s.Name/Path", direction));
                validation.setMessage("One of path or name must be specified");
                validation.setStatus(ValidationStatus.ERROR);
                validation.setValue(this.getFieldName((Field)field));
                validations.add(validation);
            } else if (field.getName() != null && field.getPath() == null) {
                validatorMap.get("xml.field.name.not.null").validate((Object)field.getName(), validations);
            } else if (field.getName() == null && field.getPath() != null) {
                validatorMap.get("xml.field.path.not.null").validate((Object)field.getPath(), validations);
            }
        }
    }
}

