/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.xml.module;

import io.atlasmap.api.AtlasConversionException;
import io.atlasmap.api.AtlasException;
import io.atlasmap.api.AtlasSession;
import io.atlasmap.api.AtlasValidationException;
import io.atlasmap.core.AtlasPath;
import io.atlasmap.core.AtlasUtil;
import io.atlasmap.core.BaseAtlasModule;
import io.atlasmap.spi.AtlasFieldReader;
import io.atlasmap.spi.AtlasFieldWriter;
import io.atlasmap.spi.AtlasInternalSession;
import io.atlasmap.spi.AtlasModuleDetail;
import io.atlasmap.v2.AuditStatus;
import io.atlasmap.v2.DataSourceType;
import io.atlasmap.v2.Field;
import io.atlasmap.v2.LookupTable;
import io.atlasmap.xml.core.XmlFieldReader;
import io.atlasmap.xml.core.XmlFieldWriter;
import io.atlasmap.xml.core.XmlIOHelper;
import io.atlasmap.xml.core.XmlPath;
import io.atlasmap.xml.module.XmlValidationService;
import io.atlasmap.xml.v2.AtlasXmlModelFactory;
import io.atlasmap.xml.v2.XmlDataSource;
import io.atlasmap.xml.v2.XmlField;
import io.atlasmap.xml.v2.XmlNamespace;
import io.atlasmap.xml.v2.XmlNamespaces;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

@AtlasModuleDetail(name="XmlModule", uri="atlas:xml", modes={"SOURCE", "TARGET"}, dataFormats={"xml"}, configPackages={"io.atlasmap.xml.v2"})
public class XmlModule
extends BaseAtlasModule {
    private static final Logger LOG = LoggerFactory.getLogger(XmlModule.class);

    public void processPreValidation(AtlasInternalSession atlasSession) throws AtlasException {
        if (atlasSession == null || atlasSession.getMapping() == null) {
            LOG.error("Invalid session: Session and AtlasMapping must be specified");
            throw new AtlasValidationException("Invalid session");
        }
        XmlValidationService xmlValidationService = new XmlValidationService(this.getConversionService());
        xmlValidationService.setDocId(this.getDocId());
        List xmlValidations = xmlValidationService.validateMapping(atlasSession.getMapping());
        atlasSession.getValidations().getValidation().addAll(xmlValidations);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Detected " + xmlValidations.size() + " xml validation notices");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("{}: processPreValidation completed", (Object)this.getDocId());
        }
    }

    public void processPreSourceExecution(AtlasInternalSession session) throws AtlasException {
        Object sourceDocument = session.getSourceDocument(this.getDocId());
        if (sourceDocument == null || !(sourceDocument instanceof String)) {
            AtlasUtil.addAudit((AtlasSession)session, (String)this.getDocId(), (String)String.format("Null or non-String source document: docId='%s'", this.getDocId()), null, (AuditStatus)AuditStatus.WARN, null);
        } else {
            Map sourceUriParams = AtlasUtil.getUriParameters((String)this.getUri());
            boolean enableNamespaces = true;
            for (String key : sourceUriParams.keySet()) {
                if (!"disableNamespaces".equals(key) || !"true".equals(sourceUriParams.get("disableNamespaces"))) continue;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Disabling namespace support");
                }
                enableNamespaces = false;
            }
            XmlFieldReader reader = new XmlFieldReader(this.getConversionService());
            reader.setDocument((String)String.class.cast(sourceDocument), enableNamespaces);
            session.setFieldReader(this.getDocId(), (AtlasFieldReader)reader);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("{}: processPreSourceExecution completed", (Object)this.getDocId());
        }
    }

    public void processPreTargetExecution(AtlasInternalSession session) throws AtlasException {
        XmlNamespaces xmlNs = null;
        String template = null;
        for (Object ds : session.getMapping().getDataSource()) {
            if (!DataSourceType.TARGET.equals((Object)ds.getDataSourceType()) || !(ds instanceof XmlDataSource) || ds.getId() != null && !ds.getId().equals(this.getDocId())) continue;
            xmlNs = ((XmlDataSource)ds).getXmlNamespaces();
            template = ((XmlDataSource)ds).getTemplate();
        }
        HashMap<String, String> nsMap = new HashMap<String, String>();
        if (xmlNs != null && xmlNs.getXmlNamespace() != null && !xmlNs.getXmlNamespace().isEmpty()) {
            for (XmlNamespace ns : xmlNs.getXmlNamespace()) {
                nsMap.put(ns.getAlias(), ns.getUri());
            }
        }
        XmlFieldWriter writer = new XmlFieldWriter(nsMap, template);
        session.setFieldWriter(this.getDocId(), (AtlasFieldWriter)writer);
        if (LOG.isDebugEnabled()) {
            LOG.debug("{}: processPreTargetExcution completed", (Object)this.getDocId());
        }
    }

    public void processSourceFieldMapping(AtlasInternalSession session) throws AtlasException {
        Field sourceField = session.head().getSourceField();
        XmlFieldReader reader = (XmlFieldReader)session.getFieldReader(this.getDocId(), XmlFieldReader.class);
        if (reader == null) {
            AtlasUtil.addAudit((AtlasSession)session, (String)sourceField.getDocId(), (String)String.format("Source document '%s' doesn't exist", this.getDocId()), (String)sourceField.getPath(), (AuditStatus)AuditStatus.ERROR, null);
            return;
        }
        reader.read(session);
        if (sourceField.getActions() != null && sourceField.getActions().getActions() != null) {
            this.getFieldActionService().processActions(sourceField.getActions(), sourceField);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("{}: processSourceFieldMapping completed: SourceField:[docId={}, path={}, type={}, value={}]", new Object[]{this.getDocId(), sourceField.getDocId(), sourceField.getPath(), sourceField.getFieldType(), sourceField.getValue()});
        }
    }

    public void processTargetFieldMapping(AtlasInternalSession session) throws AtlasException {
        Field sourceField = session.head().getSourceField();
        Field targetField = session.head().getTargetField();
        if (targetField.getFieldType() == null && sourceField.getValue() != null) {
            targetField.setFieldType(this.getConversionService().fieldTypeFromClass(sourceField.getValue().getClass()));
        }
        Object outputValue = null;
        if (sourceField.getFieldType() != null && sourceField.getFieldType().equals((Object)targetField.getFieldType())) {
            outputValue = sourceField.getValue();
        } else if (sourceField.getValue() != null) {
            try {
                outputValue = this.getConversionService().convertType(sourceField.getValue(), sourceField.getFormat(), targetField.getFieldType(), targetField.getFormat());
            }
            catch (AtlasConversionException e) {
                AtlasUtil.addAudit((AtlasSession)session, (String)targetField.getDocId(), (String)String.format("Unable to auto-convert for sT=%s tT=%s tF=%s msg=%s", sourceField.getFieldType(), targetField.getFieldType(), targetField.getPath(), e.getMessage()), (String)targetField.getPath(), (AuditStatus)AuditStatus.ERROR, null);
                return;
            }
        }
        targetField.setValue(outputValue);
        LookupTable lookupTable = session.head().getLookupTable();
        if (lookupTable != null) {
            this.processLookupField(session, lookupTable, targetField.getValue(), targetField);
        }
        if (this.isAutomaticallyProcessOutputFieldActions() && targetField.getActions() != null && targetField.getActions().getActions() != null) {
            this.getFieldActionService().processActions(targetField.getActions(), targetField);
        }
        XmlFieldWriter writer = (XmlFieldWriter)session.getFieldWriter(this.getDocId(), XmlFieldWriter.class);
        writer.write(session);
        if (LOG.isDebugEnabled()) {
            LOG.debug("{}: processTargetFieldMapping completed: SourceField:[docId={}, path={}, type={}, value={}], TargetField:[docId={}, path={}, type={}, value={}]", new Object[]{this.getDocId(), sourceField.getDocId(), sourceField.getPath(), sourceField.getFieldType(), sourceField.getValue(), targetField.getDocId(), targetField.getPath(), targetField.getFieldType(), targetField.getValue()});
        }
    }

    public void processPostSourceExecution(AtlasInternalSession session) throws AtlasException {
        session.removeFieldReader(this.getDocId());
        if (LOG.isDebugEnabled()) {
            LOG.debug("{}: processPostSourceExecution completed", (Object)this.getDocId());
        }
    }

    public void processPostTargetExecution(AtlasInternalSession session) throws AtlasException {
        XmlFieldWriter writer = (XmlFieldWriter)session.getFieldWriter(this.getDocId(), XmlFieldWriter.class);
        if (writer != null && writer.getDocument() != null) {
            session.setTargetDocument(this.getDocId(), (Object)this.convertDocumentToString(writer.getDocument()));
        } else {
            AtlasUtil.addAudit((AtlasSession)session, (String)this.getDocId(), (String)String.format("No target document created for DataSource:[id=%s, uri=%s]", this.getDocId(), this.getUri()), null, (AuditStatus)AuditStatus.WARN, null);
        }
        session.removeFieldWriter(this.getDocId());
        if (LOG.isDebugEnabled()) {
            LOG.debug("{}: processPostTargetExecution completed", (Object)this.getDocId());
        }
    }

    public Boolean isSupportedField(Field field) {
        if (super.isSupportedField(field).booleanValue()) {
            return true;
        }
        return field instanceof XmlField;
    }

    private String convertDocumentToString(Document document) throws AtlasException {
        DocumentBuilderFactory domFact = DocumentBuilderFactory.newInstance();
        domFact.setNamespaceAware(true);
        StringWriter writer = null;
        try {
            DOMSource domSource = new DOMSource(document);
            writer = new StringWriter();
            StreamResult result = new StreamResult(writer);
            TransformerFactory tf = TransformerFactory.newInstance();
            Transformer transformer = tf.newTransformer();
            transformer.transform(domSource, result);
            return writer.toString();
        }
        catch (TransformerException e) {
            LOG.error(String.format("Error converting Xml document to string msg=%s", e.getMessage()), (Throwable)e);
            throw new AtlasException(e.getMessage(), (Throwable)e);
        }
    }

    private Document getDocument(String data, boolean namespaced) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(namespaced);
        DocumentBuilder b = dbf.newDocumentBuilder();
        return b.parse(new ByteArrayInputStream(data.getBytes("UTF-8")));
    }

    public int getCollectionSize(AtlasInternalSession session, Field field) throws AtlasException {
        try {
            Object sourceObject = session.getSourceDocument(this.getDocId());
            Document document = this.getDocument((String)sourceObject, false);
            Element parentNode = document.getDocumentElement();
            for (AtlasPath.SegmentContext sc : new XmlPath(field.getPath()).getSegmentContexts(false)) {
                List children;
                if (sc.getPrev() == null) continue;
                String childrenElementName = XmlPath.cleanPathSegment((String)sc.getSegment());
                String namespaceAlias = XmlPath.getNamespace((String)sc.getSegment());
                if (namespaceAlias != null && !"".equals(namespaceAlias)) {
                    childrenElementName = namespaceAlias + ":" + childrenElementName;
                }
                if ((children = XmlIOHelper.getChildrenWithName((String)childrenElementName, (Element)parentNode)) == null || children.isEmpty()) {
                    return 0;
                }
                if (XmlPath.isCollectionSegment((String)sc.getSegment()).booleanValue()) {
                    return children.size();
                }
                parentNode = (Element)children.get(0);
            }
            return 0;
        }
        catch (Exception e) {
            throw new AtlasException((Throwable)e);
        }
    }

    public Field cloneField(Field field) throws AtlasException {
        return AtlasXmlModelFactory.cloneField((Field)field);
    }
}

