/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.atlasmap;

import io.atlasmap.api.AtlasContext;
import io.atlasmap.api.AtlasSession;
import io.atlasmap.v2.AtlasMapping;
import io.atlasmap.v2.Audits;
import io.atlasmap.v2.DataSource;
import io.atlasmap.v2.DataSourceType;
import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.component.atlasmap.AtlasComponent;
import org.apache.camel.component.atlasmap.AtlasEndpoint;
import org.junit.Assert;
import org.junit.ComparisonFailure;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AtlasEndpointTest {
    private static final Logger LOG = LoggerFactory.getLogger(AtlasEndpointTest.class);

    @Test
    public void testNoDataSource() throws Exception {
        this.perform(new ArrayList<DataSource>(), null, null, false);
    }

    @Test
    public void testDocId() throws Exception {
        ArrayList<DataSource> ds = new ArrayList<DataSource>();
        DataSource source = new DataSource();
        source.setDataSourceType(DataSourceType.SOURCE);
        source.setId("my-source-doc");
        ds.add(source);
        DataSource target = new DataSource();
        target.setDataSourceType(DataSourceType.TARGET);
        target.setId("my-target-doc");
        ds.add(target);
        this.perform(ds, "my-source-doc", "my-target-doc", false);
    }

    @Test(expected=ComparisonFailure.class)
    public void noConversionIfNoDataSource() throws Exception {
        this.perform(new ArrayList<DataSource>(), null, null, true);
    }

    @Test(expected=ComparisonFailure.class)
    public void noConversionIfJavaDataSource() throws Exception {
        ArrayList<DataSource> dataSources = new ArrayList<DataSource>();
        DataSource dataSource = new DataSource();
        dataSource.setDataSourceType(DataSourceType.SOURCE);
        dataSource.setUri("atlas:java:some.Type");
        dataSources.add(dataSource);
        this.perform(dataSources, null, null, true);
    }

    @Test
    public void doConversionIfJsonDataSource() throws Exception {
        ArrayList<DataSource> dataSources = new ArrayList<DataSource>();
        DataSource dataSource = new DataSource();
        dataSource.setDataSourceType(DataSourceType.SOURCE);
        dataSource.setUri("atlas:json:SomeType");
        dataSources.add(dataSource);
        this.perform(dataSources, null, null, true);
    }

    @Test(expected=ComparisonFailure.class)
    public void noConversionIfJsonTargetDataSource() throws Exception {
        ArrayList<DataSource> dataSources = new ArrayList<DataSource>();
        DataSource dataSource = new DataSource();
        dataSource.setDataSourceType(DataSourceType.TARGET);
        dataSource.setUri("atlas:json:SomeType");
        dataSources.add(dataSource);
        this.perform(dataSources, null, null, true);
    }

    @Test
    public void doConversionIfXmlDataSource() throws Exception {
        ArrayList<DataSource> dataSources = new ArrayList<DataSource>();
        DataSource dataSource = new DataSource();
        dataSource.setDataSourceType(DataSourceType.SOURCE);
        dataSource.setUri("atlas:xml:SomeType");
        dataSources.add(dataSource);
        this.perform(dataSources, null, null, true);
    }

    @Test(expected=ComparisonFailure.class)
    public void noConversionIfXmlTargetDataSource() throws Exception {
        ArrayList<DataSource> dataSources = new ArrayList<DataSource>();
        DataSource dataSource = new DataSource();
        dataSource.setDataSourceType(DataSourceType.TARGET);
        dataSource.setUri("atlas:xml:SomeType");
        dataSources.add(dataSource);
        this.perform(dataSources, null, null, true);
    }

    private void perform(List<DataSource> dataSources, final String sourceDocId, final String targetDocId, boolean fromStream) throws Exception {
        AtlasMapping mapping = new AtlasMapping();
        mapping.getDataSource().addAll(dataSources);
        AtlasContext context = (AtlasContext)Mockito.spy(AtlasContext.class);
        AtlasSession session = (AtlasSession)Mockito.spy(AtlasSession.class);
        Mockito.when((Object)context.createSession()).thenReturn((Object)session);
        Mockito.when((Object)session.getAtlasContext()).thenReturn((Object)context);
        Mockito.when((Object)session.getMapping()).thenReturn((Object)mapping);
        Mockito.when((Object)session.getAudits()).thenReturn((Object)new Audits());
        AtlasEndpoint endpoint = new AtlasEndpoint("atlas:test.xml", new AtlasComponent(), "test.xml");
        endpoint.setAtlasContext(context);
        Exchange exchange = (Exchange)Mockito.spy(Exchange.class);
        Message inMessage = (Message)Mockito.spy(Message.class);
        Mockito.when((Object)inMessage.getBody()).thenReturn(fromStream ? new ByteArrayInputStream("{test}".getBytes()) : "{test}");
        Mockito.when((Object)((String)inMessage.getBody(String.class))).thenReturn((Object)"{test}");
        Mockito.when((Object)exchange.getIn()).thenReturn((Object)inMessage);
        if (sourceDocId == null) {
            ((AtlasSession)Mockito.doAnswer((Answer)new Answer<Void>(){

                public Void answer(InvocationOnMock invocation) {
                    LOG.debug("setDefaultSourceDocument({})", (Object)invocation.getArgument(0).toString());
                    Assert.assertEquals((Object)"{test}", (Object)invocation.getArgument(0).toString());
                    return null;
                }
            }).when((Object)session)).setDefaultSourceDocument(ArgumentMatchers.any());
        } else {
            ((AtlasSession)Mockito.doAnswer((Answer)new Answer<Void>(){

                public Void answer(InvocationOnMock invocation) {
                    LOG.debug("setSourceDocument({}, {})", invocation.getArgument(0), invocation.getArgument(1));
                    Assert.assertEquals((Object)sourceDocId, (Object)invocation.getArgument(0));
                    Assert.assertEquals((Object)"{test}", (Object)invocation.getArgument(1));
                    return null;
                }
            }).when((Object)session)).setSourceDocument((String)ArgumentMatchers.any(), ArgumentMatchers.any());
        }
        Message outMessage = (Message)Mockito.spy(Message.class);
        ((Message)Mockito.doAnswer((Answer)new Answer<Void>(){

            public Void answer(InvocationOnMock invocation) {
                LOG.debug("setBody({})", (Object)invocation.getArgument(0).toString());
                Assert.assertEquals((Object)"<target/>", (Object)invocation.getArgument(0));
                return null;
            }
        }).when((Object)outMessage)).setBody(ArgumentMatchers.any());
        ((Message)Mockito.doNothing().when((Object)outMessage)).setHeaders((Map)ArgumentMatchers.any());
        ((Message)Mockito.doNothing().when((Object)outMessage)).setAttachments((Map)ArgumentMatchers.any());
        if (targetDocId == null) {
            Mockito.when((Object)session.getDefaultTargetDocument()).thenAnswer((Answer)new Answer<Object>(){

                public Object answer(InvocationOnMock invocation) throws Throwable {
                    LOG.debug("getDefaultTargetDocument()");
                    return "<target/>";
                }
            });
        } else {
            Mockito.when((Object)session.getTargetDocument((String)ArgumentMatchers.any())).thenAnswer((Answer)new Answer<Object>(){

                public Object answer(InvocationOnMock invocation) throws Throwable {
                    LOG.debug("getTargetDocument({})", (Object)invocation.getArgument(0).toString());
                    Assert.assertEquals((Object)targetDocId, (Object)invocation.getArgument(0));
                    return "<target/>";
                }
            });
        }
        Mockito.when((Object)exchange.getOut()).thenReturn((Object)outMessage);
        endpoint.onExchange(exchange);
    }
}

