/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.atlasmap;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.camel.CamelContext;
import org.apache.camel.EndpointInject;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.component.atlasmap.Util;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.test.spring.CamelSpringRunner;
import org.apache.camel.test.spring.CamelTestContextBootstrapper;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.annotation.DirtiesContext;
import org.springframework.test.context.BootstrapWith;
import org.springframework.test.context.ContextConfiguration;

@RunWith(value=CamelSpringRunner.class)
@BootstrapWith(value=CamelTestContextBootstrapper.class)
@ContextConfiguration
public class AtlasMapComponentJavaToJsonTest {
    @Autowired
    protected CamelContext camelContext;
    @EndpointInject(uri="mock:result")
    protected MockEndpoint result;

    @Test
    @DirtiesContext
    public void testMocksAreValid() throws Exception {
        this.result.setExpectedCount(1);
        ProducerTemplate producerTemplate = this.camelContext.createProducerTemplate();
        producerTemplate.sendBody("direct:start", (Object)Util.generateMockTwitterStatus());
        MockEndpoint.assertIsSatisfied((CamelContext)this.camelContext);
        Message msg = ((Exchange)this.result.getExchanges().get(0)).getIn();
        Assert.assertEquals((Object)"application/json", (Object)msg.getHeader("Content-Type"));
        Object body = msg.getBody();
        Assert.assertEquals(String.class, body.getClass());
        ObjectMapper mapper = new ObjectMapper();
        JsonNode sfJson = mapper.readTree((String)body);
        Assert.assertNotNull((Object)sfJson.get("TwitterScreenName__c"));
        Assert.assertEquals((Object)"bobvila1982", (Object)sfJson.get("TwitterScreenName__c").asText());
    }
}

