/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.atlasmap;

import java.io.ByteArrayInputStream;
import org.apache.camel.CamelContext;
import org.apache.camel.EndpointInject;
import org.apache.camel.Exchange;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.component.atlasmap.Pojo;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.test.spring.CamelSpringRunner;
import org.apache.camel.test.spring.CamelTestContextBootstrapper;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.annotation.DirtiesContext;
import org.springframework.test.context.BootstrapWith;
import org.springframework.test.context.ContextConfiguration;

@RunWith(value=CamelSpringRunner.class)
@BootstrapWith(value=CamelTestContextBootstrapper.class)
@ContextConfiguration
public class AtlasMapComponentJsonToJavaTest {
    @Autowired
    protected CamelContext camelContext;
    @EndpointInject(uri="mock:result")
    protected MockEndpoint result;

    @Test
    @DirtiesContext
    public void testMocksAreValid() throws Exception {
        this.result.setExpectedCount(1);
        ProducerTemplate producerTemplate = this.camelContext.createProducerTemplate();
        producerTemplate.sendBody("direct:start", (Object)new ByteArrayInputStream("{\"field1\":\"value1\"}".getBytes()));
        MockEndpoint.assertIsSatisfied((CamelContext)this.camelContext);
        Object body = ((Exchange)this.result.getExchanges().get(0)).getIn().getBody();
        Assert.assertEquals(Pojo.class, body.getClass());
        Assert.assertEquals((Object)"value1", (Object)((Pojo)body).getField1());
    }
}

