/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.atlasmap;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.camel.CamelContext;
import org.apache.camel.EndpointInject;
import org.apache.camel.Exchange;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.component.atlasmap.Util;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.test.spring.CamelSpringRunner;
import org.apache.camel.test.spring.CamelTestContextBootstrapper;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mockito;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.annotation.DirtiesContext;
import org.springframework.test.context.BootstrapWith;
import org.springframework.test.context.ContextConfiguration;
import twitter4j.Status;

@RunWith(value=CamelSpringRunner.class)
@BootstrapWith(value=CamelTestContextBootstrapper.class)
@ContextConfiguration
public class AtlasMapComponentTest {
    @Autowired
    protected CamelContext camelContext;
    @EndpointInject(uri="mock:result")
    protected MockEndpoint result;

    @Test
    @DirtiesContext
    public void testMocksAreValid() throws Exception {
        this.result.setExpectedCount(1);
        ProducerTemplate producerTemplate = this.camelContext.createProducerTemplate();
        producerTemplate.sendBody("direct:start", (Object)Util.generateMockTwitterStatus());
        MockEndpoint.assertIsSatisfied((CamelContext)this.camelContext);
        Object body = ((Exchange)this.result.getExchanges().get(0)).getIn().getBody();
        Assert.assertEquals(String.class, body.getClass());
        ObjectMapper mapper = new ObjectMapper();
        JsonNode outJson = mapper.readTree((String)body);
        Assert.assertEquals((Object)"Bob", (Object)outJson.get("FirstName").asText());
        Assert.assertEquals((Object)"Vila", (Object)outJson.get("LastName").asText());
        Assert.assertEquals((Object)"bobvila1982", (Object)outJson.get("Title").asText());
        Assert.assertEquals((Object)"Let's build a house!", (Object)outJson.get("Description").asText());
        Assert.assertEquals((Object)"const foobar", (Object)outJson.get("Constant").asText());
    }

    @Test
    @DirtiesContext
    public void testSeparateNotSucceed() throws Exception {
        this.result.setExpectedCount(1);
        ProducerTemplate producerTemplate = this.camelContext.createProducerTemplate();
        Status s = Util.generateMockTwitterStatus();
        Mockito.when((Object)s.getUser().getName()).thenReturn((Object)"BobVila");
        producerTemplate.sendBody("direct:start", (Object)s);
        MockEndpoint.assertIsSatisfied((CamelContext)this.camelContext);
        Object body = ((Exchange)this.result.getExchanges().get(0)).getIn().getBody();
        Assert.assertEquals(String.class, body.getClass());
        ObjectMapper mapper = new ObjectMapper();
        JsonNode outJson = mapper.readTree((String)body);
        Assert.assertEquals((Object)"BobVila", (Object)outJson.get("FirstName").asText());
        Assert.assertNull((Object)outJson.get("LastName"));
        Assert.assertEquals((Object)"bobvila1982", (Object)outJson.get("Title").asText());
        Assert.assertEquals((Object)"Let's build a house!", (Object)outJson.get("Description").asText());
    }
}

