/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.atlasmap;

import java.io.ByteArrayInputStream;
import org.apache.camel.CamelContext;
import org.apache.camel.EndpointInject;
import org.apache.camel.Exchange;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.test.spring.CamelSpringRunner;
import org.apache.camel.test.spring.CamelTestContextBootstrapper;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.annotation.DirtiesContext;
import org.springframework.test.context.BootstrapWith;
import org.springframework.test.context.ContextConfiguration;
import org.xmlunit.builder.DiffBuilder;
import org.xmlunit.builder.Input;
import org.xmlunit.diff.Diff;

@RunWith(value=CamelSpringRunner.class)
@BootstrapWith(value=CamelTestContextBootstrapper.class)
@ContextConfiguration(value={"AtlasMapComponentXmlToXmlTest-context.xml"})
public class AtlasMapComponentXmlToXmlDefaultNsTest {
    private static final String XML_EXPECTED = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?><tns:Patient xmlns:tns=\"http://hl7.org/fhir\"><tns:id value=\"101138\"/></tns:Patient>";
    @Autowired
    protected CamelContext camelContext;
    @EndpointInject(uri="mock:result")
    protected MockEndpoint result;

    @Test
    @DirtiesContext
    public void testMocksAreValid() throws Exception {
        this.result.setExpectedCount(1);
        ProducerTemplate producerTemplate = this.camelContext.createProducerTemplate();
        producerTemplate.sendBody("direct:start", (Object)new ByteArrayInputStream("<Patient xmlns=\"http://hl7.org/fhir\"><id value=\"101138\"></id></Patient>".getBytes()));
        MockEndpoint.assertIsSatisfied((CamelContext)this.camelContext);
        String body = (String)((Exchange)this.result.getExchanges().get(0)).getIn().getBody(String.class);
        Assert.assertNotNull((Object)body);
        Diff d = DiffBuilder.compare((Object)Input.fromString((String)XML_EXPECTED).build()).withTest((Object)Input.fromString((String)body).build()).ignoreWhitespace().build();
        Assert.assertFalse((String)(d.toString() + ": " + body), (boolean)d.hasDifferences());
    }
}

