/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.atlasmap;

import java.io.ByteArrayInputStream;
import org.apache.camel.CamelContext;
import org.apache.camel.EndpointInject;
import org.apache.camel.Exchange;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.test.spring.CamelSpringRunner;
import org.apache.camel.test.spring.CamelTestContextBootstrapper;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.annotation.DirtiesContext;
import org.springframework.test.context.BootstrapWith;
import org.springframework.test.context.ContextConfiguration;

@RunWith(value=CamelSpringRunner.class)
@BootstrapWith(value=CamelTestContextBootstrapper.class)
@ContextConfiguration
public class AtlasMapExtractMappingsTest {
    private static final String EXPECTED_BODY = "{\"order\":{\"orderId\":\"A123\"}}";
    @Autowired
    protected CamelContext camelContext;
    @EndpointInject(uri="mock:result")
    protected MockEndpoint result;
    @EndpointInject(uri="mock:result-n")
    protected MockEndpoint resultN;

    @Test
    @DirtiesContext
    public void testXMLMappingsExtraction() throws Exception {
        this.result.setExpectedCount(1);
        ProducerTemplate producerTemplate = this.camelContext.createProducerTemplate();
        producerTemplate.sendBody("direct:start", (Object)new ByteArrayInputStream("{ \"order\": { \"orderId\": \"A123\" }}".getBytes()));
        MockEndpoint.assertIsSatisfied((CamelContext)this.camelContext);
        Object body = ((Exchange)this.result.getExchanges().get(0)).getIn().getBody();
        Assert.assertEquals((Object)EXPECTED_BODY, (Object)body);
    }

    @Test
    @DirtiesContext
    public void testXMLMappingsExtractionNumberedMappingFile() throws Exception {
        this.resultN.setExpectedCount(1);
        ProducerTemplate producerTemplate = this.camelContext.createProducerTemplate();
        producerTemplate.sendBody("direct:start-n", (Object)new ByteArrayInputStream("{ \"order\": { \"orderId\": \"A123\" }}".getBytes()));
        MockEndpoint.assertIsSatisfied((CamelContext)this.camelContext);
        Object body = ((Exchange)this.resultN.getExchanges().get(0)).getIn().getBody();
        Assert.assertEquals((Object)EXPECTED_BODY, (Object)body);
    }
}

