/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.atlasmap;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.atlasmap.java.test.SourceContact;
import java.util.HashMap;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.EndpointInject;
import org.apache.camel.Exchange;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.impl.DefaultMessage;
import org.apache.camel.test.spring.CamelSpringRunner;
import org.apache.camel.test.spring.CamelTestContextBootstrapper;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.annotation.DirtiesContext;
import org.springframework.test.context.BootstrapWith;
import org.springframework.test.context.ContextConfiguration;
import org.xmlunit.assertj.XmlAssert;

@RunWith(value=CamelSpringRunner.class)
@BootstrapWith(value=CamelTestContextBootstrapper.class)
@ContextConfiguration
public class AtlasMapMultiDocsTest {
    private static final String JSON_SOURCE = "{\"firstName\": \"JsonFirstName\",\"lastName\": \"JsonLastName\",\"phoneNumber\": \"JsonPhoneNumber\",\"zipCode\": \"JsonZipCode\"}";
    private static final String XML_SOURCE = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<ns:Contact xmlns:ns=\"http://atlasmap.io/xml/test/v2\"\n    xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n    firstName=\"XmlFirstName\" lastName=\"XmlLastName\"\n    phoneNumber=\"XmlPhoneNumber\" zipCode=\"XmlZipCode\" />\n";
    @Autowired
    protected CamelContext camelContext;
    @EndpointInject(uri="mock:result")
    protected MockEndpoint result;
    @EndpointInject(uri="mock:result-body")
    protected MockEndpoint resultBody;

    @After
    public void after() {
        this.result.reset();
        this.resultBody.reset();
    }

    @Test
    @DirtiesContext
    public void test() throws Exception {
        this.result.setExpectedCount(1);
        HashMap<String, DefaultMessage> sourceMap = new HashMap<String, DefaultMessage>();
        SourceContact javaSource = new SourceContact();
        javaSource.setFirstName("JavaFirstName");
        javaSource.setLastName("JavaLastName");
        javaSource.setPhoneNumber("JavaPhoneNumber");
        javaSource.setZipCode("JavaZipCode");
        DefaultMessage msg = new DefaultMessage(this.camelContext);
        msg.setBody((Object)javaSource);
        msg.setHeader("testProp", (Object)"java-source-header");
        sourceMap.put("DOCID-JAVA-CONTACT-S", msg);
        msg = new DefaultMessage(this.camelContext);
        msg.setBody((Object)JSON_SOURCE);
        msg.setHeader("testProp", (Object)"json-source-header");
        sourceMap.put("DOCID-JSON-CONTACT-S", msg);
        msg = new DefaultMessage(this.camelContext);
        msg.setBody((Object)XML_SOURCE);
        msg.setHeader("testProp", (Object)"xml-source-header");
        sourceMap.put("DOCID-XML-CONTACT-S", msg);
        ProducerTemplate producerTemplate = this.camelContext.createProducerTemplate();
        producerTemplate.sendBodyAndProperty("direct:start", null, "CAPTURED_OUT_MESSAGES_MAP", sourceMap);
        MockEndpoint.assertIsSatisfied((CamelContext)this.camelContext);
        Exchange exchange = (Exchange)this.result.getExchanges().get(0);
        Map targetMap = (Map)exchange.getProperty("TARGET_MESSAGES_MAP", Map.class);
        this.verifyTargetDocs(targetMap);
        Assert.assertEquals((Object)"java-source-header", (Object)exchange.getProperty("target-exchange"));
        Assert.assertEquals((Object)"json-source-header", (Object)exchange.getProperty("testProp"));
        Assert.assertEquals((Object)"xml-source-header", (Object)exchange.getIn().getHeader("testProp"));
        Assert.assertEquals((Object)"java-source-headerjson-source-headerxml-source-header", (Object)exchange.getIn().getHeader("testPropExpression"));
    }

    @Test
    public void testBody() throws Exception {
        this.resultBody.setExpectedCount(1);
        HashMap<String, Object> sourceMap = new HashMap<String, Object>();
        SourceContact javaSource = new SourceContact();
        javaSource.setFirstName("JavaFirstName");
        javaSource.setLastName("JavaLastName");
        javaSource.setPhoneNumber("JavaPhoneNumber");
        javaSource.setZipCode("JavaZipCode");
        sourceMap.put("DOCID-JAVA-CONTACT-S", javaSource);
        sourceMap.put("DOCID-JSON-CONTACT-S", JSON_SOURCE);
        sourceMap.put("DOCID-XML-CONTACT-S", XML_SOURCE);
        ProducerTemplate producerTemplate = this.camelContext.createProducerTemplate();
        producerTemplate.sendBody("direct:start-body", sourceMap);
        MockEndpoint.assertIsSatisfied((CamelContext)this.camelContext);
        Exchange exchange = (Exchange)this.resultBody.getExchanges().get(0);
        Map targetMap = (Map)exchange.getIn().getBody(Map.class);
        this.verifyTargetDocs(targetMap);
    }

    @Test
    public void testHeaderDocs() throws Exception {
        this.resultBody.setExpectedCount(1);
        HashMap<String, Object> sourceMap = new HashMap<String, Object>();
        SourceContact javaSource = new SourceContact();
        javaSource.setFirstName("JavaFirstName");
        javaSource.setLastName("JavaLastName");
        javaSource.setPhoneNumber("JavaPhoneNumber");
        javaSource.setZipCode("JavaZipCode");
        sourceMap.put("DOCID-JAVA-CONTACT-S", javaSource);
        sourceMap.put("DOCID-JSON-CONTACT-S", JSON_SOURCE);
        sourceMap.put("DOCID-XML-CONTACT-S", XML_SOURCE);
        ProducerTemplate producerTemplate = this.camelContext.createProducerTemplate();
        producerTemplate.sendBodyAndHeaders("direct:start-header", null, sourceMap);
        MockEndpoint.assertIsSatisfied((CamelContext)this.camelContext);
        Exchange exchange = (Exchange)this.resultBody.getExchanges().get(0);
        this.verifyTargetDocs(exchange.getIn().getHeaders());
    }

    @Test
    public void testExchangePropertyDocs() throws Exception {
        this.resultBody.setExpectedCount(1);
        HashMap<String, Object> sourceMap = new HashMap<String, Object>();
        SourceContact javaSource = new SourceContact();
        javaSource.setFirstName("JavaFirstName");
        javaSource.setLastName("JavaLastName");
        javaSource.setPhoneNumber("JavaPhoneNumber");
        javaSource.setZipCode("JavaZipCode");
        sourceMap.put("DOCID-JAVA-CONTACT-S", javaSource);
        sourceMap.put("DOCID-JSON-CONTACT-S", JSON_SOURCE);
        sourceMap.put("DOCID-XML-CONTACT-S", XML_SOURCE);
        Endpoint ep = this.camelContext.getEndpoint("direct:start-exchange-property");
        Exchange ex = ep.createExchange();
        ex.getProperties().putAll(sourceMap);
        ProducerTemplate producerTemplate = this.camelContext.createProducerTemplate();
        producerTemplate.send(ep, ex);
        MockEndpoint.assertIsSatisfied((CamelContext)this.camelContext);
        Exchange exchange = (Exchange)this.resultBody.getExchanges().get(0);
        this.verifyTargetDocs(exchange.getProperties());
    }

    private void verifyTargetDocs(Map<?, ?> targetMap) throws Exception {
        String jsonTarget = (String)targetMap.get("DOCID-JSON-CONTACT-T");
        ObjectMapper mapper = new ObjectMapper();
        JsonNode jsonTargetNode = mapper.readTree(jsonTarget);
        Assert.assertEquals((Object)"JsonFirstName", (Object)jsonTargetNode.get("firstName").asText());
        Assert.assertEquals((Object)"JavaLastName", (Object)jsonTargetNode.get("lastName").asText());
        Assert.assertEquals((Object)"XmlPhoneNumber", (Object)jsonTargetNode.get("phoneNumber").asText());
        String xmlTarget = (String)targetMap.get("DOCID-XML-CONTACT-T");
        HashMap<String, String> ns = new HashMap<String, String>();
        ns.put("ns", "http://atlasmap.io/xml/test/v2");
        XmlAssert.assertThat((Object)xmlTarget).withNamespaceContext(ns).valueByXPath("/Contact/@firstName").isEqualTo((Object)"XmlFirstName");
        XmlAssert.assertThat((Object)xmlTarget).withNamespaceContext(ns).valueByXPath("/Contact/@lastName").isEqualTo((Object)"JsonLastName");
        XmlAssert.assertThat((Object)xmlTarget).withNamespaceContext(ns).valueByXPath("/Contact/@phoneNumber").isEqualTo((Object)"JavaPhoneNumber");
    }
}

