/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.atlasmap;

import io.atlasmap.java.test.SourceContact;
import org.apache.camel.CamelContext;
import org.apache.camel.EndpointInject;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.test.spring.CamelSpringRunner;
import org.apache.camel.test.spring.CamelTestContextBootstrapper;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.annotation.DirtiesContext;
import org.springframework.test.context.BootstrapWith;
import org.springframework.test.context.ContextConfiguration;
import org.xmlunit.builder.DiffBuilder;
import org.xmlunit.builder.Input;
import org.xmlunit.diff.Diff;

@RunWith(value=CamelSpringRunner.class)
@BootstrapWith(value=CamelTestContextBootstrapper.class)
@ContextConfiguration
public class AtlasMapMultiNSTest {
    private static final String XML_EXPECTED = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<tns:request xmlns:tns=\"http://syndesis.io/v1/swagger-connector-template/request\">\n  <tns:body>\n    <Pet>\n      <name>Jackson</name>\n    </Pet>\n  </tns:body>\n</tns:request>";
    @Autowired
    protected CamelContext camelContext;
    @EndpointInject(uri="mock:result")
    protected MockEndpoint result;

    @Test
    @DirtiesContext
    public void test() throws Exception {
        this.result.setExpectedCount(1);
        ProducerTemplate producerTemplate = this.camelContext.createProducerTemplate();
        SourceContact c = new SourceContact();
        c.setFirstName("Jackson");
        producerTemplate.sendBody("direct:start", (Object)c);
        MockEndpoint.assertIsSatisfied((CamelContext)this.camelContext);
        Message message = ((Exchange)this.result.getExchanges().get(0)).getIn();
        Assert.assertEquals((Object)"application/xml", (Object)message.getHeader("Content-Type"));
        String out = (String)message.getBody(String.class);
        Assert.assertNotNull((Object)out);
        Diff d = DiffBuilder.compare((Object)Input.fromString((String)XML_EXPECTED).build()).withTest((Object)Input.fromString((String)out).build()).ignoreWhitespace().build();
        Assert.assertFalse((String)(d.toString() + ": " + out), (boolean)d.hasDifferences());
    }
}

