/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.atlasmap;

import io.atlasmap.api.AtlasSession;
import io.atlasmap.core.DefaultAtlasSession;
import io.atlasmap.v2.PropertyField;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.component.atlasmap.CamelAtlasPropertyStrategy;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.impl.DefaultExchange;
import org.apache.camel.impl.DefaultMessage;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class CamelAtlasPropertyStrategyTest {
    @Test
    public void testRead() throws Exception {
        CamelAtlasPropertyStrategy strategy = new CamelAtlasPropertyStrategy();
        DefaultCamelContext context = new DefaultCamelContext();
        DefaultExchange exchange = new DefaultExchange((CamelContext)context);
        exchange.setProperty("testProp", (Object)"testProp-exchangeProperty");
        strategy.setExchange((Exchange)exchange);
        DefaultMessage currentMessage = new DefaultMessage((CamelContext)context);
        currentMessage.setExchange((Exchange)exchange);
        currentMessage.setHeader("testProp", (Object)"testProp-currentMessage");
        strategy.setCurrentSourceMessage((Message)currentMessage);
        DefaultMessage message1 = new DefaultMessage((CamelContext)context);
        message1.setExchange((Exchange)exchange);
        message1.setHeader("testProp", (Object)"testProp-message1");
        strategy.setSourceMessage("Doc1", (Message)message1);
        DefaultMessage message2 = new DefaultMessage((CamelContext)context);
        message2.setExchange((Exchange)exchange);
        message2.setHeader("testProp", (Object)"testProp-message2");
        strategy.setSourceMessage("Doc2", (Message)message2);
        AtlasSession session = (AtlasSession)Mockito.mock(AtlasSession.class);
        Mockito.when((Object)session.getAtlasPropertyStrategy()).thenReturn((Object)strategy);
        PropertyField propertyField = new PropertyField();
        propertyField.setName("testProp");
        strategy.readProperty(session, propertyField);
        Assert.assertEquals((Object)"testProp-currentMessage", (Object)propertyField.getValue());
        propertyField.setScope("camelExchangeProperty");
        strategy.readProperty(session, propertyField);
        Assert.assertEquals((Object)"testProp-exchangeProperty", (Object)propertyField.getValue());
        propertyField.setScope("Doc1");
        strategy.readProperty(session, propertyField);
        Assert.assertEquals((Object)"testProp-message1", (Object)propertyField.getValue());
        propertyField.setScope("Doc2");
        strategy.readProperty(session, propertyField);
        Assert.assertEquals((Object)"testProp-message2", (Object)propertyField.getValue());
    }

    @Test
    public void testWrite() throws Exception {
        CamelAtlasPropertyStrategy strategy = new CamelAtlasPropertyStrategy();
        DefaultCamelContext context = new DefaultCamelContext();
        DefaultExchange exchange = new DefaultExchange((CamelContext)context);
        strategy.setExchange((Exchange)exchange);
        DefaultMessage message = new DefaultMessage((CamelContext)context);
        message.setExchange((Exchange)exchange);
        strategy.setTargetMessage((Message)message);
        PropertyField propertyField = new PropertyField();
        propertyField.setName("testProp-message");
        propertyField.setValue((Object)"testValue");
        AtlasSession session = (AtlasSession)Mockito.mock(DefaultAtlasSession.class);
        Mockito.when((Object)session.getAtlasPropertyStrategy()).thenReturn((Object)strategy);
        strategy.writeProperty(session, propertyField);
        propertyField.setName("testProp-exchange");
        propertyField.setScope("camelExchangeProperty");
        strategy.writeProperty(session, propertyField);
        Assert.assertEquals((Object)"testValue", (Object)message.getHeader("testProp-message"));
        Assert.assertNull((Object)message.getHeader("testProp-exchange"));
        Assert.assertNull((Object)exchange.getProperty("testProp-message"));
        Assert.assertEquals((Object)"testValue", (Object)exchange.getProperty("testProp-exchange"));
    }
}

