/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.atlasmap.issue;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.nio.file.Files;
import java.nio.file.Paths;
import org.apache.camel.CamelContext;
import org.apache.camel.EndpointInject;
import org.apache.camel.Exchange;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.test.spring.CamelSpringRunner;
import org.apache.camel.test.spring.CamelTestContextBootstrapper;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.BootstrapWith;
import org.springframework.test.context.ContextConfiguration;

@RunWith(value=CamelSpringRunner.class)
@BootstrapWith(value=CamelTestContextBootstrapper.class)
@ContextConfiguration
public class AtlasMapIssue2552Test {
    @Autowired
    protected CamelContext camelContext;
    @EndpointInject(uri="mock:result-old")
    protected MockEndpoint resultOld;
    @EndpointInject(uri="mock:result-new")
    protected MockEndpoint resultNew;

    @Test
    public void testOld() throws Exception {
        String jsonSource = new String(Files.readAllBytes(Paths.get(this.getClass().getClassLoader().getResource("org/apache/camel/component/atlasmap/issue/2552-input.json").toURI())));
        ProducerTemplate producerTemplate = this.camelContext.createProducerTemplate();
        producerTemplate.sendBody("direct:start-old", (Object)jsonSource);
        MockEndpoint.assertIsSatisfied((CamelContext)this.camelContext);
        ObjectMapper om = new ObjectMapper();
        Exchange exchange = (Exchange)this.resultOld.getExchanges().get(0);
        String target = (String)exchange.getIn().getBody(String.class);
        JsonNode targetJsonOld = om.readTree(target);
        this.assertTarget(targetJsonOld);
    }

    @Test
    public void testNew() throws Exception {
        String jsonSource = new String(Files.readAllBytes(Paths.get(this.getClass().getClassLoader().getResource("org/apache/camel/component/atlasmap/issue/2552-input.json").toURI())));
        ProducerTemplate producerTemplate = this.camelContext.createProducerTemplate();
        producerTemplate.sendBody("direct:start-new", (Object)jsonSource);
        MockEndpoint.assertIsSatisfied((CamelContext)this.camelContext);
        ObjectMapper om = new ObjectMapper();
        Exchange exchange = (Exchange)this.resultNew.getExchanges().get(0);
        String target = (String)exchange.getIn().getBody(String.class);
        JsonNode targetJsonNew = om.readTree(target);
        this.assertTarget(targetJsonNew);
    }

    private void assertTarget(JsonNode root) {
        ArrayNode bodyArray = (ArrayNode)root.get("body");
        Assert.assertEquals((long)3L, (long)bodyArray.size());
        ObjectNode body1 = (ObjectNode)bodyArray.get(0);
        ObjectNode body2 = (ObjectNode)bodyArray.get(1);
        ObjectNode body3 = (ObjectNode)bodyArray.get(2);
        Assert.assertEquals((long)1111L, (long)body1.get("id").asInt());
        Assert.assertEquals((long)1L, (long)body1.get("completed").asInt());
        Assert.assertEquals((Object)"task1", (Object)body1.get("task").asText());
        Assert.assertEquals((long)2222L, (long)body2.get("id").asInt());
        Assert.assertTrue((boolean)body2.get("completed").isNull());
        Assert.assertEquals((Object)"task2", (Object)body2.get("task").asText());
        Assert.assertEquals((long)3333L, (long)body3.get("id").asInt());
        Assert.assertEquals((long)3L, (long)body3.get("completed").asInt());
        Assert.assertEquals((Object)"task3", (Object)body3.get("task").asText());
    }
}

