/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.atlasmap.issue;

import io.atlasmap.java.test.SourceContact;
import io.atlasmap.java.test.TargetContact;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.EndpointInject;
import org.apache.camel.Exchange;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.test.spring.CamelSpringRunner;
import org.apache.camel.test.spring.CamelTestContextBootstrapper;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.BootstrapWith;
import org.springframework.test.context.ContextConfiguration;

@RunWith(value=CamelSpringRunner.class)
@BootstrapWith(value=CamelTestContextBootstrapper.class)
@ContextConfiguration
public class AtlasMapIssue729Test {
    @Autowired
    protected CamelContext camelContext;
    @EndpointInject(uri="mock:result")
    protected MockEndpoint result;

    @Test
    public void test() throws Exception {
        SourceContact javaSource = new SourceContact();
        javaSource.setFirstName("JavaFirstName");
        javaSource.setLastName("JavaLastName");
        javaSource.setPhoneNumber("JavaPhoneNumber");
        javaSource.setZipCode("JavaZipCode");
        ProducerTemplate producerTemplate = this.camelContext.createProducerTemplate();
        producerTemplate.sendBody("direct:start", (Object)javaSource);
        MockEndpoint.assertIsSatisfied((CamelContext)this.camelContext);
        Exchange exchange = (Exchange)this.result.getExchanges().get(0);
        Map targetMap = (Map)exchange.getIn().getBody(Map.class);
        TargetContact javaTarget = (TargetContact)targetMap.get("DOCID:JAVA:CONTACT:T");
        Assert.assertEquals((Object)"JavaFirstName", (Object)javaTarget.getFirstName());
    }
}

