/*
 * Decompiled with CFR 0.152.
 */
package io.atomicbits.scraml.dsl.java.client.ning;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.ning.http.client.AsyncCompletionHandler;
import com.ning.http.client.AsyncHandler;
import com.ning.http.client.AsyncHttpClient;
import com.ning.http.client.AsyncHttpClientConfig;
import com.ning.http.client.multipart.Part;
import io.atomicbits.scraml.dsl.java.BodyPart;
import io.atomicbits.scraml.dsl.java.ByteArrayPart;
import io.atomicbits.scraml.dsl.java.Client;
import io.atomicbits.scraml.dsl.java.FilePart;
import io.atomicbits.scraml.dsl.java.HeaderMap;
import io.atomicbits.scraml.dsl.java.HttpParam;
import io.atomicbits.scraml.dsl.java.RepeatedHttpParam;
import io.atomicbits.scraml.dsl.java.RequestBuilder;
import io.atomicbits.scraml.dsl.java.Response;
import io.atomicbits.scraml.dsl.java.SingleHttpParam;
import io.atomicbits.scraml.dsl.java.StringPart;
import io.atomicbits.scraml.dsl.java.client.ClientConfig;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NingClientSupport
implements Client {
    private String protocol;
    private String host;
    private int port;
    private String prefix;
    private ClientConfig config;
    private Map<String, String> defaultHeaders;
    private AsyncHttpClient ningClient;
    private Logger LOGGER = LoggerFactory.getLogger(NingClientSupport.class);
    private ObjectMapper objectMapper = new ObjectMapper();

    public NingClientSupport(String string, Integer n, String string2, String string3, ClientConfig clientConfig, Map<String, String> map) {
        this.host = string != null ? string : "localhost";
        this.port = n != null ? n : 80;
        this.protocol = string2 != null ? string2 : "http";
        this.prefix = string3;
        this.config = clientConfig != null ? clientConfig : new ClientConfig();
        this.defaultHeaders = map != null ? map : new HashMap<String, String>();
        this.objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        AsyncHttpClientConfig.Builder builder = new AsyncHttpClientConfig.Builder();
        this.ningClient = new AsyncHttpClient(this.applyConfiguration(builder).build());
    }

    public ClientConfig getConfig() {
        return this.config;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String getCleanPrefix() {
        if (this.prefix != null) {
            String string = this.prefix;
            if (this.prefix.startsWith("/")) {
                string = string.substring(1);
            }
            if (this.prefix.endsWith("/")) {
                string = string.substring(0, string.length() - 1);
            }
            return "/" + string;
        }
        return "";
    }

    @Override
    public Map<String, String> defaultHeaders() {
        return this.defaultHeaders;
    }

    private AsyncHttpClient getClient() {
        return this.ningClient;
    }

    private AsyncHttpClientConfig.Builder applyConfiguration(AsyncHttpClientConfig.Builder builder) {
        builder.setReadTimeout(this.config.getRequestTimeout());
        builder.setMaxConnections(this.config.getMaxConnections());
        builder.setRequestTimeout(this.config.getRequestTimeout());
        builder.setMaxRequestRetry(this.config.getMaxRequestRetry());
        builder.setConnectTimeout(this.config.getConnectTimeout());
        builder.setConnectionTTL(this.config.getConnectionTTL());
        builder.setWebSocketTimeout(this.config.getWebSocketTimeout());
        builder.setMaxConnectionsPerHost(this.config.getMaxConnectionsPerHost());
        builder.setAllowPoolingConnections(this.config.getAllowPoolingConnections().booleanValue());
        builder.setAllowPoolingSslConnections(this.config.getAllowPoolingSslConnections().booleanValue());
        builder.setPooledConnectionIdleTimeout(this.config.getPooledConnectionIdleTimeout());
        builder.setAcceptAnyCertificate(this.config.getAcceptAnyCertificate().booleanValue());
        builder.setFollowRedirect(this.config.getFollowRedirect().booleanValue());
        builder.setMaxRedirects(this.config.getMaxRedirects());
        builder.setRemoveQueryParamsOnRedirect(this.config.getRemoveQueryParamOnRedirect().booleanValue());
        builder.setStrict302Handling(this.config.getStrict302Handling().booleanValue());
        return builder;
    }

    @Override
    public <B> CompletableFuture<Response<String>> callToStringResponse(RequestBuilder requestBuilder, B b, String string2) {
        return this.callToTransformedResponse(requestBuilder, b, string2, string -> string);
    }

    @Override
    public <B, R> CompletableFuture<Response<R>> callToTypeResponse(RequestBuilder requestBuilder, B b, String string, String string3) {
        return this.callToTransformedResponse(requestBuilder, b, string, string2 -> this.parseBodyToObject(string3, (String)string2));
    }

    protected <B, R> CompletableFuture<Response<R>> callToTransformedResponse(RequestBuilder requestBuilder, B b, String string, final Function<String, R> function) {
        Object object;
        com.ning.http.client.RequestBuilder requestBuilder2 = new com.ning.http.client.RequestBuilder();
        String string2 = this.protocol + "://" + this.host + ":" + this.port + this.getCleanPrefix();
        requestBuilder2.setUrl(string2 + "/" + requestBuilder.getRelativePath());
        requestBuilder2.setMethod(requestBuilder.getMethod().name());
        HeaderMap headerMap = new HeaderMap();
        headerMap.addHeaders(this.defaultHeaders);
        headerMap.addHeaders(requestBuilder.getHeaders());
        for (Map.Entry<String, List<String>> object22 : headerMap.getHeaders().entrySet()) {
            for (String string3 : object22.getValue()) {
                requestBuilder2.addHeader(object22.getKey(), string3);
            }
        }
        for (Map.Entry<String, Object> entry : requestBuilder.getQueryParameters().entrySet()) {
            if (((HttpParam)entry.getValue()).isSingle().booleanValue()) {
                object = (SingleHttpParam)entry.getValue();
                if (((SingleHttpParam)object).getParameter() == null) continue;
                requestBuilder2.addQueryParam(entry.getKey(), ((SingleHttpParam)object).getParameter());
                continue;
            }
            object = (RepeatedHttpParam)entry.getValue();
            if (((RepeatedHttpParam)object).getParameters() == null) continue;
            for (String string4 : ((RepeatedHttpParam)object).getParameters()) {
                requestBuilder2.addQueryParam(entry.getKey(), string4);
            }
        }
        if (b != null) {
            requestBuilder2.setBody(this.writeBodyToString(string, b));
        }
        for (Map.Entry<String, Object> entry : requestBuilder.getFormParameters().entrySet()) {
            if (((HttpParam)entry.getValue()).isSingle().booleanValue()) {
                object = (SingleHttpParam)entry.getValue();
                if (((SingleHttpParam)object).getParameter() == null) continue;
                requestBuilder2.addFormParam(entry.getKey(), ((SingleHttpParam)object).getParameter());
                continue;
            }
            object = (RepeatedHttpParam)entry.getValue();
            if (((RepeatedHttpParam)object).getParameters() == null) continue;
            for (String string4 : ((RepeatedHttpParam)object).getParameters()) {
                requestBuilder2.addFormParam(entry.getKey(), string4);
            }
        }
        for (BodyPart bodyPart : requestBuilder.getMultipartParams()) {
            if (bodyPart.isString().booleanValue()) {
                object = (StringPart)bodyPart;
                requestBuilder2.addBodyPart((Part)new com.ning.http.client.multipart.StringPart(((StringPart)object).getName(), ((StringPart)object).getValue(), ((StringPart)object).getContentType(), ((StringPart)object).getCharset(), ((StringPart)object).getContentId(), ((StringPart)object).getTransferEncoding()));
            }
            if (bodyPart.isFile().booleanValue()) {
                object = (FilePart)bodyPart;
                requestBuilder2.addBodyPart((Part)new com.ning.http.client.multipart.FilePart(((FilePart)object).getName(), ((FilePart)object).getFile(), ((FilePart)object).getContentType(), ((FilePart)object).getCharset(), ((FilePart)object).getFileName(), ((FilePart)object).getContentId(), ((FilePart)object).getTransferEncoding()));
            }
            if (!bodyPart.isByteArray().booleanValue()) continue;
            object = (ByteArrayPart)bodyPart;
            requestBuilder2.addBodyPart((Part)new com.ning.http.client.multipart.ByteArrayPart(((ByteArrayPart)object).getName(), ((ByteArrayPart)object).getBytes(), ((ByteArrayPart)object).getContentType(), ((ByteArrayPart)object).getCharset(), ((ByteArrayPart)object).getFileName(), ((ByteArrayPart)object).getContentId(), ((ByteArrayPart)object).getTransferEncoding()));
        }
        Iterator<Object> iterator = requestBuilder2.build();
        final CompletableFuture<Response<R>> completableFuture = new CompletableFuture<Response<R>>();
        this.LOGGER.debug("Executing request: " + iterator + "\nWith body: " + iterator.getStringData());
        this.getClient().executeRequest(iterator, (AsyncHandler)new AsyncCompletionHandler<String>(){

            public String onCompleted(com.ning.http.client.Response response) throws Exception {
                try {
                    String string = response.getResponseBody(NingClientSupport.this.config.getResponseCharset().displayName());
                    Response response2 = new Response(string, function.apply(string), response.getStatusCode(), (Map<String, List<String>>)response.getHeaders());
                    completableFuture.complete(response2);
                }
                catch (Throwable throwable) {
                    completableFuture.completeExceptionally(throwable);
                }
                return null;
            }

            public void onThrowable(Throwable throwable) {
                super.onThrowable(throwable);
                completableFuture.completeExceptionally(throwable);
            }
        });
        return completableFuture;
    }

    @Override
    public void close() {
        if (this.ningClient != null) {
            this.ningClient.close();
        }
    }

    private <B> String writeBodyToString(String string, B b) {
        if (string != null) {
            JavaType javaType = TypeFactory.defaultInstance().constructFromCanonical(string);
            ObjectWriter objectWriter = this.objectMapper.writerFor(javaType);
            try {
                return objectWriter.writeValueAsString(b);
            }
            catch (IOException iOException) {
                throw new RuntimeException("JSON parse error: " + iOException.getMessage(), iOException);
            }
        }
        try {
            return this.objectMapper.writeValueAsString(b);
        }
        catch (JsonProcessingException jsonProcessingException) {
            throw new RuntimeException("JSON parse error: " + jsonProcessingException.getMessage(), jsonProcessingException);
        }
    }

    private <R> R parseBodyToObject(String string, String string2) {
        JavaType javaType = TypeFactory.defaultInstance().constructFromCanonical(string);
        try {
            return (R)this.objectMapper.readValue(string2, javaType);
        }
        catch (IOException iOException) {
            throw new RuntimeException("JSON parse error: " + iOException.getMessage(), iOException);
        }
    }
}

