/*
 * Decompiled with CFR 0.152.
 */
package io.atomicbits.scraml.mvnplugin;

import io.atomicbits.scraml.generator.ScramlGenerator;
import io.atomicbits.scraml.mvnplugin.util.ListUtils;
import io.atomicbits.scraml.mvnplugin.util.StringUtil;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

@Mojo(name="scraml")
public class ScramlMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject project;
    @Parameter(property="scraml.ramlApi", defaultValue="")
    private String ramlApi;
    @Parameter(property="scraml.apiPackage", defaultValue="")
    private String apiPackage;
    @Parameter(property="scraml.resourceDirectory", defaultValue="src/main/resources")
    private String resourceDirectory;
    @Parameter(property="scraml.outputDirectory", defaultValue="target/generated-sources/scraml")
    private String outputDirectory;
    @Parameter(property="scraml.licenseKey", defaultValue="")
    private String licenseKey;
    @Parameter(property="scraml.classHeader", defaultValue="")
    private String classHeader;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (!this.ramlApi.isEmpty()) {
            Map generatedFiles;
            File ramlSource;
            File ramlBaseDir;
            if (this.resourceDirectory.startsWith("/") || this.resourceDirectory.contains(":\\") || this.resourceDirectory.contains(":/")) {
                ramlBaseDir = new File(this.resourceDirectory);
                ramlSource = new File(ramlBaseDir, this.ramlApi);
            } else {
                ramlBaseDir = new File(this.project.getBasedir(), this.resourceDirectory);
                ramlSource = new File(ramlBaseDir, this.ramlApi);
            }
            String[] apiPackageAndClass = this.packageAndClassFromRamlPointer(this.ramlApi, this.apiPackage);
            String apiPackageName = apiPackageAndClass[0];
            String apiClassName = apiPackageAndClass[1];
            try {
                generatedFiles = ScramlGenerator.generateJavaCode((String)ramlSource.toURI().toURL().toString(), (String)apiPackageName, (String)apiClassName, (String)this.licenseKey, (String)this.classHeader);
            }
            catch (NullPointerException | MalformedURLException e) {
                this.feedbackOnException(ramlBaseDir, this.ramlApi, ramlSource);
                throw new RuntimeException("Could not generate RAML client.", e);
            }
            File outputDirAsFile = this.outputDirectory.startsWith("/") ? new File(this.outputDirectory) : new File(this.project.getBasedir(), this.outputDirectory);
            outputDirAsFile.mkdirs();
            try {
                for (Map.Entry entry : generatedFiles.entrySet()) {
                    String filePath = (String)entry.getKey();
                    String content = (String)entry.getValue();
                    File fileInDst = new File(outputDirAsFile, filePath);
                    fileInDst.getParentFile().mkdirs();
                    FileWriter writer = new FileWriter(fileInDst);
                    writer.write(content);
                    writer.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new RuntimeException("Could not generate RAML client.", e);
            }
            this.project.addCompileSourceRoot(this.outputDirectory);
        }
    }

    private String escape(char ch) {
        return "\\Q" + ch + "\\E";
    }

    private String[] packageAndClassFromRamlPointer(String pointer, String apiPackageName) {
        String[] parts = pointer.split(this.escape('/'));
        if (parts.length == 1) {
            String packageName = StringUtil.isNullOrEmpty(apiPackageName) ? "io.atomicbits" : apiPackageName;
            return new String[]{packageName, this.cleanFileName(parts[0])};
        }
        String className = this.cleanFileName(parts[parts.length - 1]);
        List<String> firstParts = Arrays.asList(parts).subList(0, parts.length - 1);
        String packageName = StringUtil.isNullOrEmpty(apiPackageName) ? ListUtils.mkString(firstParts, ".") : apiPackageName;
        return new String[]{packageName, className};
    }

    private String cleanFileName(String fileName) {
        String[] nameSplit = fileName.split(this.escape('.'));
        String withOutExtension = nameSplit.length == 0 ? fileName : nameSplit[0];
        List<Character> dropChars = Arrays.asList(Character.valueOf('-'), Character.valueOf('_'), Character.valueOf('+'), Character.valueOf(' '));
        String cleanedDropChars = withOutExtension;
        for (Character dropChar : dropChars) {
            List<String> items = this.removeEmpty(Arrays.asList(cleanedDropChars.split(this.escape(dropChar.charValue()))));
            ArrayList<String> capitalized = new ArrayList<String>();
            for (String item : items) {
                capitalized.add(this.capitalize(item));
            }
            cleanedDropChars = ListUtils.mkString(capitalized, "");
        }
        List<Character> numbers = Arrays.asList(Character.valueOf('0'), Character.valueOf('1'), Character.valueOf('2'), Character.valueOf('3'), Character.valueOf('4'), Character.valueOf('5'), Character.valueOf('6'), Character.valueOf('7'), Character.valueOf('8'), Character.valueOf('9'));
        String cleanedNumbers = cleanedDropChars + " ";
        for (Character number : numbers) {
            List<String> items = Arrays.asList(cleanedNumbers.split(this.escape(number.charValue())));
            ArrayList<String> capitalized = new ArrayList<String>();
            for (String item : items) {
                capitalized.add(this.capitalize(item));
            }
            cleanedNumbers = ListUtils.mkString(capitalized, number.toString());
        }
        return cleanedNumbers.replaceAll("[^A-Za-z0-9]", "").trim();
    }

    private String capitalize(String dirtyName) {
        char[] chars = dirtyName.toCharArray();
        if (chars.length > 0) {
            chars[0] = Character.toUpperCase(chars[0]);
        }
        return new String(chars);
    }

    private List<String> removeEmpty(List<String> items) {
        ArrayList<String> emptied = new ArrayList<String>();
        for (String item : items) {
            if (item.isEmpty()) continue;
            emptied.add(item);
        }
        return emptied;
    }

    private void feedbackOnException(File ramlBaseDir, String ramlPointer, File ramlSource) {
        System.out.println("Exception during RAMl parsing, possibly caused by a wrong RAML path.\nAre you sure the following values are correct (non-null)?\n\n- - - - - - - - - - - - - - - - - - - - - - -\nRAML base path: " + ramlBaseDir + "\n" + "RAML relative path: " + ramlPointer + "\n" + "RAML absolute path" + ramlSource + "\n" + "- - - - - - - - - - - - - - - - - - - - - - -\n\n" + "In case the relative path is wrong or null, check your project settings and" + "make sure the 'scramlRamlApi in scraml in Compile' value points to the main" + "raml file in your project's (or module's) resources directory.");
    }
}

