/*
 * Decompiled with CFR 0.152.
 */
package io.atomicbits.scraml.ramlparser.parser;

import io.atomicbits.scraml.ramlparser.parser.SourceFile;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URI;
import java.net.URL;
import java.nio.file.FileSystem;
import java.nio.file.FileSystemAlreadyExistsException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.stream.Stream;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.collection.immutable.Stream$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.Try$;

public final class SourceReader$ {
    public static SourceReader$ MODULE$;

    static {
        new SourceReader$();
    }

    public SourceFile read(String source, String charsetName) {
        Tuple2 tuple2;
        Option resource = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> MODULE$.getClass().getResource(source).toURI()).toOption();
        Option classLoaderResource = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> MODULE$.getClass().getClassLoader().getResource(source).toURI()).toOption();
        Option file = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> Paths.get(source, new String[0])).filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)SourceReader$.$anonfun$read$4(x$1))).map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.toUri()).toOption();
        Option url = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> new URL(source).toURI()).toOption();
        List uris = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Option[]{resource, classLoaderResource, file, url}));
        URI uri = (URI)((TraversableLike)uris.flatten((Function1 & Serializable & scala.Serializable)xo -> Option$.MODULE$.option2Iterable(xo))).headOption().getOrElse((Function0 & Serializable & scala.Serializable)() -> scala.sys.package$.MODULE$.error(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unable to find resource ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{source}))));
        String string = uri.getScheme();
        if ("jar".equals(string)) {
            FileSystem fileSystem = (FileSystem)Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> FileSystems.newFileSystem(uri, Collections.emptyMap())).recover((PartialFunction)new scala.Serializable(uri){
                public static final long serialVersionUID = 0L;
                private final URI uri$1;

                public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    A1 A1 = x1;
                    Object object = A1 instanceof FileSystemAlreadyExistsException ? FileSystems.getFileSystem(this.uri$1) : function1.apply(x1);
                    return (B1)object;
                }

                public final boolean isDefinedAt(Throwable x1) {
                    Throwable throwable = x1;
                    boolean bl = throwable instanceof FileSystemAlreadyExistsException;
                    return bl;
                }
                {
                    this.uri$1 = uri$1;
                }
            }).getOrElse((Function0 & Serializable & scala.Serializable)() -> scala.sys.package$.MODULE$.error(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Could not create or open filesystem for resource ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{uri}))));
            tuple2 = new Tuple2((Object)fileSystem.getPath(source, new String[0]), (Object)new Some((Object)fileSystem));
        } else {
            tuple2 = new Tuple2((Object)Paths.get(uri), (Object)None$.MODULE$);
        }
        Tuple2 tuple22 = tuple2;
        if (tuple22 == null) {
            throw new MatchError((Object)tuple22);
        }
        Path thePath = (Path)tuple22._1();
        Option fs = (Option)tuple22._2();
        Tuple2 tuple23 = new Tuple2((Object)thePath, (Object)fs);
        Tuple2 tuple24 = tuple23;
        Path thePath2 = (Path)tuple24._1();
        Option fs2 = (Option)tuple24._2();
        byte[] encoded = Files.readAllBytes(thePath2);
        fs2.foreach((Function1 & Serializable & scala.Serializable)x$4 -> {
            x$4.close();
            return BoxedUnit.UNIT;
        });
        return new SourceFile(this.toDefaultFileSystem(thePath2), new String(encoded, charsetName));
    }

    public String read$default$2() {
        return "UTF-8";
    }

    public Set<SourceFile> readResources(String path, String extension, String charsetName) {
        Tuple2 tuple2;
        Option resource = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> MODULE$.getClass().getResource(path).toURI()).toOption();
        Option classLoaderResource = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> MODULE$.getClass().getClassLoader().getResource(path).toURI()).toOption();
        List uris = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Option[]{resource, classLoaderResource}));
        URI uri = (URI)((TraversableLike)uris.flatten((Function1 & Serializable & scala.Serializable)xo -> Option$.MODULE$.option2Iterable(xo))).headOption().getOrElse((Function0 & Serializable & scala.Serializable)() -> scala.sys.package$.MODULE$.error(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unable to find resource ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{path}))));
        String string = uri.getScheme();
        if ("jar".equals(string)) {
            FileSystem fileSystem = (FileSystem)Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> FileSystems.newFileSystem(uri, Collections.emptyMap())).recover((PartialFunction)new scala.Serializable(uri){
                public static final long serialVersionUID = 0L;
                private final URI uri$2;

                public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                    A1 A1 = x2;
                    Object object = A1 instanceof FileSystemAlreadyExistsException ? FileSystems.getFileSystem(this.uri$2) : function1.apply(x2);
                    return (B1)object;
                }

                public final boolean isDefinedAt(Throwable x2) {
                    Throwable throwable = x2;
                    boolean bl = throwable instanceof FileSystemAlreadyExistsException;
                    return bl;
                }
                {
                    this.uri$2 = uri$2;
                }
            }).getOrElse((Function0 & Serializable & scala.Serializable)() -> scala.sys.package$.MODULE$.error(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Could not create or open filesystem for resource ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{uri}))));
            tuple2 = new Tuple2((Object)fileSystem.getPath(path, new String[0]), (Object)new Some((Object)fileSystem));
        } else {
            tuple2 = new Tuple2((Object)Paths.get(uri), (Object)None$.MODULE$);
        }
        Tuple2 tuple22 = tuple2;
        if (tuple22 == null) {
            throw new MatchError((Object)tuple22);
        }
        Path thePath = (Path)tuple22._1();
        Option fs = (Option)tuple22._2();
        Tuple2 tuple23 = new Tuple2((Object)thePath, (Object)fs);
        Tuple2 tuple24 = tuple23;
        Path thePath2 = (Path)tuple24._1();
        Option fs2 = (Option)tuple24._2();
        Stream<Path> walk = Files.walk(thePath2, new FileVisitOption[0]);
        Set paths = JavaConversions$.MODULE$.deprecated$u0020asScalaIterator(walk.iterator()).toSet();
        Set sourceFiles = (Set)paths.collect((PartialFunction)new scala.Serializable(extension, charsetName){
            public static final long serialVersionUID = 0L;
            private final String extension$1;
            private final String charsetName$1;

            public final <A1 extends Path, B1> B1 applyOrElse(A1 x3, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x3;
                if (SourceReader$.io$atomicbits$scraml$ramlparser$parser$SourceReader$$isFileWithExtension$1(A1, this.extension$1)) {
                    byte[] enc = Files.readAllBytes(A1);
                    object = new SourceFile(SourceReader$.MODULE$.toDefaultFileSystem(A1), new String(enc, this.charsetName$1));
                } else {
                    object = function1.apply(x3);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Path x3) {
                Path path = x3;
                boolean bl = SourceReader$.io$atomicbits$scraml$ramlparser$parser$SourceReader$$isFileWithExtension$1(path, this.extension$1);
                return bl;
            }
            {
                this.extension$1 = extension$1;
                this.charsetName$1 = charsetName$1;
            }
        }, Set$.MODULE$.canBuildFrom());
        fs2.foreach((Function1 & Serializable & scala.Serializable)x$6 -> {
            x$6.close();
            return BoxedUnit.UNIT;
        });
        return sourceFiles;
    }

    public String readResources$default$3() {
        return "UTF-8";
    }

    public Path toDefaultFileSystem(Path path) {
        Path rootPath = path.isAbsolute() ? Paths.get(FileSystems.getDefault().getSeparator(), new String[0]) : Paths.get("", new String[0]);
        return (Path)JavaConversions$.MODULE$.deprecated$u0020iterableAsScalaIterable((Iterable)path).foldLeft((Object)rootPath, (Function2 & Serializable & scala.Serializable)(x0$1, x1$1) -> {
            Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Path aggr = (Path)tuple2._1();
            Path component = (Path)tuple2._2();
            Path path = aggr.resolve(((Object)component.getFileName()).toString());
            return path;
        });
    }

    public byte[] getInputStreamContent(InputStream inputStream) {
        return (byte[])((TraversableOnce)package$.MODULE$.Stream().continually((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> inputStream.read()).takeWhile((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$7 -> x$7 != -1).map((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToByte((byte)SourceReader$.$anonfun$getInputStreamContent$3(BoxesRunTime.unboxToInt((Object)x$8))), Stream$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.Byte());
    }

    private String cleanWindowsTripleSlashIssue(String path) {
        boolean hasWindowsPrefix = BoxesRunTime.unboxToBoolean((Object)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new StringOps(Predef$.MODULE$.augmentString(path)).split('/'))).filter((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)SourceReader$.$anonfun$cleanWindowsTripleSlashIssue$1(x$9))))).headOption().collect((PartialFunction)new scala.Serializable(){
            public static final long serialVersionUID = 0L;

            public final <A1 extends String, B1> B1 applyOrElse(A1 x4, Function1<A1, B1> function1) {
                A1 A1 = x4;
                Object object = A1.endsWith(":") ? BoxesRunTime.boxToBoolean((boolean)true) : function1.apply(x4);
                return (B1)object;
            }

            public final boolean isDefinedAt(String x4) {
                String string = x4;
                boolean bl = string.endsWith(":");
                return bl;
            }
        }).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> false));
        return hasWindowsPrefix && path.startsWith("/") ? (String)new StringOps(Predef$.MODULE$.augmentString(path)).drop(1) : path;
    }

    public static final /* synthetic */ boolean $anonfun$read$4(Path x$1) {
        return Files.exists(x$1, new LinkOption[0]);
    }

    public static final boolean io$atomicbits$scraml$ramlparser$parser$SourceReader$$isFileWithExtension$1(Path somePath, String extension$1) {
        return Files.isRegularFile(somePath, new LinkOption[0]) && ((Object)somePath.getFileName()).toString().toLowerCase().endsWith(extension$1.toLowerCase());
    }

    public static final /* synthetic */ byte $anonfun$getInputStreamContent$3(int x$8) {
        return (byte)x$8;
    }

    public static final /* synthetic */ boolean $anonfun$cleanWindowsTripleSlashIssue$1(String x$9) {
        return new StringOps(Predef$.MODULE$.augmentString(x$9)).nonEmpty();
    }

    private SourceReader$() {
        MODULE$ = this;
    }
}

