/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.storage.buffer;

import io.atomix.storage.buffer.Buffer;
import io.atomix.storage.buffer.BufferPool;
import io.atomix.storage.buffer.UnsafeDirectBuffer;
import io.atomix.storage.buffer.UnsafeDirectBytes;
import io.atomix.utils.concurrent.ReferenceCounted;
import io.atomix.utils.concurrent.ReferenceFactory;
import io.atomix.utils.concurrent.ReferenceManager;

public class UnsafeDirectBufferPool
extends BufferPool {
    public UnsafeDirectBufferPool() {
        super(new DirectBufferFactory());
    }

    public void release(Buffer reference) {
        reference.rewind();
        super.release((ReferenceCounted)reference);
    }

    private static class DirectBufferFactory
    implements ReferenceFactory<Buffer> {
        private DirectBufferFactory() {
        }

        public Buffer createReference(ReferenceManager<Buffer> manager) {
            UnsafeDirectBuffer buffer = new UnsafeDirectBuffer(UnsafeDirectBytes.allocate(1024), manager);
            buffer.reset(0, 1024, Integer.MAX_VALUE);
            return buffer;
        }
    }
}

