/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.collections;

import io.atomix.collections.state.MultiMapCommands;
import io.atomix.collections.state.MultiMapState;
import io.atomix.copycat.client.RaftClient;
import io.atomix.resource.AbstractResource;
import io.atomix.resource.Consistency;
import io.atomix.resource.ResourceInfo;
import java.time.Duration;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;

@ResourceInfo(stateMachine=MultiMapState.class)
public class DistributedMultiMap<K, V>
extends AbstractResource {
    public DistributedMultiMap(RaftClient client) {
        super(client);
    }

    public DistributedMultiMap<K, V> with(Consistency consistency) {
        super.with(consistency);
        return this;
    }

    public CompletableFuture<Boolean> isEmpty() {
        return this.submit(new MultiMapCommands.IsEmpty());
    }

    public CompletableFuture<Integer> size() {
        return this.submit(new MultiMapCommands.Size());
    }

    public CompletableFuture<Integer> size(K key) {
        return this.submit(new MultiMapCommands.Size(key));
    }

    public CompletableFuture<Boolean> containsKey(K key) {
        return this.submit(new MultiMapCommands.ContainsKey(key));
    }

    public CompletableFuture<Boolean> containsEntry(K key, V value) {
        return this.submit(new MultiMapCommands.ContainsEntry(key, value));
    }

    public CompletableFuture<Boolean> containsValue(V value) {
        return this.submit(new MultiMapCommands.ContainsValue(value));
    }

    public CompletableFuture<Collection<V>> get(K key) {
        return this.submit(new MultiMapCommands.Get(key)).thenApply(result -> result);
    }

    public CompletableFuture<Boolean> put(K key, V value) {
        return this.submit(new MultiMapCommands.Put(key, value)).thenApply(result -> result);
    }

    public CompletableFuture<Boolean> put(K key, V value, Duration ttl) {
        return this.submit(new MultiMapCommands.Put(key, value, ttl.toMillis()));
    }

    public CompletableFuture<Collection<V>> remove(Object key) {
        return this.submit(new MultiMapCommands.Remove(key)).thenApply(result -> (Collection)result);
    }

    public CompletableFuture<Boolean> remove(Object key, Object value) {
        return this.submit(new MultiMapCommands.Remove(key, value)).thenApply(result -> (boolean)((Boolean)result));
    }

    public CompletableFuture<Void> removeValue(Object value) {
        return this.submit(new MultiMapCommands.RemoveValue(value));
    }

    public CompletableFuture<Void> clear() {
        return this.submit(new MultiMapCommands.Clear());
    }
}

