/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.collections;

import io.atomix.collections.state.QueueCommands;
import io.atomix.collections.state.QueueState;
import io.atomix.copycat.client.RaftClient;
import io.atomix.resource.AbstractResource;
import io.atomix.resource.Consistency;
import io.atomix.resource.ResourceInfo;
import java.util.concurrent.CompletableFuture;

@ResourceInfo(stateMachine=QueueState.class)
public class DistributedQueue<T>
extends AbstractResource {
    public DistributedQueue(RaftClient client) {
        super(client);
    }

    public DistributedQueue<T> with(Consistency consistency) {
        super.with(consistency);
        return this;
    }

    public CompletableFuture<Boolean> add(T value) {
        return this.submit(new QueueCommands.Add(value));
    }

    public CompletableFuture<Boolean> offer(T value) {
        return this.submit(new QueueCommands.Offer(value));
    }

    public CompletableFuture<T> peek() {
        return this.submit(new QueueCommands.Peek()).thenApply(v -> v);
    }

    public CompletableFuture<T> poll() {
        return this.submit(new QueueCommands.Poll()).thenApply(v -> v);
    }

    public CompletableFuture<T> element() {
        return this.submit(new QueueCommands.Element()).thenApply(v -> v);
    }

    public CompletableFuture<T> remove() {
        return this.submit(new QueueCommands.Remove()).thenApply(v -> v);
    }

    public CompletableFuture<Boolean> remove(T value) {
        return this.submit(new QueueCommands.Remove(value)).thenApply(v -> (boolean)((Boolean)v));
    }

    public CompletableFuture<Boolean> contains(Object value) {
        return this.submit(new QueueCommands.Contains(value));
    }

    public CompletableFuture<Integer> size() {
        return this.submit(new QueueCommands.Size());
    }

    public CompletableFuture<Boolean> isEmpty() {
        return this.submit(new QueueCommands.IsEmpty());
    }

    public CompletableFuture<Void> clear() {
        return this.submit(new QueueCommands.Clear());
    }
}

