/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.collections.state;

import io.atomix.catalyst.util.concurrent.Scheduled;
import io.atomix.collections.state.MapCommands;
import io.atomix.copycat.server.Commit;
import io.atomix.copycat.server.StateMachineExecutor;
import io.atomix.resource.ResourceStateMachine;
import java.time.Duration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class MapState
extends ResourceStateMachine {
    private final Map<Object, Value> map = new HashMap<Object, Value>();

    protected void configure(StateMachineExecutor executor) {
        executor.register(MapCommands.ContainsKey.class, this::containsKey);
        executor.register(MapCommands.ContainsValue.class, this::containsValue);
        executor.register(MapCommands.Get.class, this::get);
        executor.register(MapCommands.GetOrDefault.class, this::getOrDefault);
        executor.register(MapCommands.Put.class, this::put);
        executor.register(MapCommands.PutIfAbsent.class, this::putIfAbsent);
        executor.register(MapCommands.Remove.class, this::remove);
        executor.register(MapCommands.RemoveIfPresent.class, this::removeIfPresent);
        executor.register(MapCommands.Replace.class, this::replace);
        executor.register(MapCommands.ReplaceIfPresent.class, this::replaceIfPresent);
        executor.register(MapCommands.Size.class, this::size);
        executor.register(MapCommands.IsEmpty.class, this::isEmpty);
        executor.register(MapCommands.Clear.class, this::clear);
    }

    protected boolean containsKey(Commit<MapCommands.ContainsKey> commit) {
        try {
            boolean bl = this.map.containsKey(((MapCommands.ContainsKey)commit.operation()).key());
            return bl;
        }
        finally {
            commit.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean containsValue(Commit<MapCommands.ContainsValue> commit) {
        try {
            for (Value value : this.map.values()) {
                if (!((MapCommands.TtlCommand)value.commit.operation()).value().equals(((MapCommands.ContainsValue)commit.operation()).value())) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            commit.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object get(Commit<MapCommands.Get> commit) {
        try {
            Value value = this.map.get(((MapCommands.Get)commit.operation()).key());
            Object object = value != null ? ((MapCommands.TtlCommand)value.commit.operation()).value() : null;
            return object;
        }
        finally {
            commit.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object getOrDefault(Commit<MapCommands.GetOrDefault> commit) {
        try {
            Value value = this.map.get(((MapCommands.GetOrDefault)commit.operation()).key());
            Object object = value != null ? ((MapCommands.TtlCommand)value.commit.operation()).value() : ((MapCommands.GetOrDefault)commit.operation()).defaultValue();
            return object;
        }
        finally {
            commit.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Object put(Commit<MapCommands.Put> commit) {
        Object object;
        Scheduled timer = ((MapCommands.Put)commit.operation()).ttl() > 0L ? this.executor().schedule(Duration.ofMillis(((MapCommands.Put)commit.operation()).ttl()), () -> this.map.remove(((MapCommands.Put)commit.operation()).key()).commit.clean()) : null;
        Value value = this.map.put(((MapCommands.Put)commit.operation()).key(), new Value(commit, timer));
        if (value == null) return null;
        try {
            if (value.timer != null) {
                value.timer.cancel();
            }
            object = ((MapCommands.TtlCommand)value.commit.operation()).value();
        }
        catch (Throwable throwable) {
            try {
                value.commit.clean();
                throw throwable;
            }
            catch (Exception e) {
                commit.clean();
                throw e;
            }
        }
        value.commit.clean();
        return object;
    }

    protected Object putIfAbsent(Commit<MapCommands.PutIfAbsent> commit) {
        try {
            Value value = this.map.get(((MapCommands.PutIfAbsent)commit.operation()).key());
            if (value == null) {
                Scheduled timer = ((MapCommands.PutIfAbsent)commit.operation()).ttl() > 0L ? this.executor().schedule(Duration.ofMillis(((MapCommands.PutIfAbsent)commit.operation()).ttl()), () -> this.map.remove(((MapCommands.PutIfAbsent)commit.operation()).key()).commit.clean()) : null;
                this.map.put(((MapCommands.PutIfAbsent)commit.operation()).key(), new Value(commit, timer));
                return null;
            }
            commit.clean();
            return ((MapCommands.TtlCommand)value.commit.operation()).value();
        }
        catch (Exception e) {
            commit.clean();
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object remove(Commit<MapCommands.Remove> commit) {
        try {
            Value value = this.map.remove(((MapCommands.Remove)commit.operation()).key());
            if (value != null) {
                try {
                    if (value.timer != null) {
                        value.timer.cancel();
                    }
                    Object object = ((MapCommands.TtlCommand)value.commit.operation()).value();
                    return object;
                }
                finally {
                    value.commit.clean();
                }
            }
            Object var3_4 = null;
            return var3_4;
        }
        finally {
            commit.clean();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean removeIfPresent(Commit<MapCommands.RemoveIfPresent> commit) {
        try {
            boolean bl;
            Value value = this.map.get(((MapCommands.RemoveIfPresent)commit.operation()).key());
            if (value == null || ((MapCommands.TtlCommand)value.commit.operation()).value() == null && ((MapCommands.RemoveIfPresent)commit.operation()).value() != null || ((MapCommands.TtlCommand)value.commit.operation()).value() != null && !((MapCommands.TtlCommand)value.commit.operation()).value().equals(((MapCommands.RemoveIfPresent)commit.operation()).value())) {
                boolean bl2 = false;
                return bl2;
            }
            try {
                this.map.remove(((MapCommands.RemoveIfPresent)commit.operation()).key());
                if (value.timer != null) {
                    value.timer.cancel();
                }
                bl = true;
            }
            catch (Throwable throwable) {
                value.commit.clean();
                throw throwable;
            }
            value.commit.clean();
            return bl;
        }
        finally {
            commit.clean();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object replace(Commit<MapCommands.Replace> commit) {
        Value value = this.map.get(((MapCommands.Replace)commit.operation()).key());
        if (value != null) {
            try {
                if (value.timer != null) {
                    value.timer.cancel();
                }
                Scheduled timer = ((MapCommands.Replace)commit.operation()).ttl() > 0L ? this.executor().schedule(Duration.ofMillis(((MapCommands.Replace)commit.operation()).ttl()), () -> {
                    this.map.remove(((MapCommands.Replace)commit.operation()).key());
                    commit.clean();
                }) : null;
                this.map.put(((MapCommands.Replace)commit.operation()).key(), new Value(commit, timer));
                Object object = ((MapCommands.TtlCommand)value.commit.operation()).value();
                return object;
            }
            finally {
                value.commit.clean();
            }
        }
        commit.clean();
        return null;
    }

    protected boolean replaceIfPresent(Commit<MapCommands.ReplaceIfPresent> commit) {
        Value value = this.map.get(((MapCommands.ReplaceIfPresent)commit.operation()).key());
        if (value == null) {
            commit.clean();
            return false;
        }
        if (((MapCommands.TtlCommand)value.commit.operation()).value() == null && ((MapCommands.ReplaceIfPresent)commit.operation()).replace() == null || ((MapCommands.TtlCommand)value.commit.operation()).value() != null && ((MapCommands.TtlCommand)value.commit.operation()).value().equals(((MapCommands.ReplaceIfPresent)commit.operation()).replace())) {
            if (value.timer != null) {
                value.timer.cancel();
            }
            Scheduled timer = ((MapCommands.ReplaceIfPresent)commit.operation()).ttl() > 0L ? this.executor().schedule(Duration.ofMillis(((MapCommands.ReplaceIfPresent)commit.operation()).ttl()), () -> this.map.remove(((MapCommands.ReplaceIfPresent)commit.operation()).key()).commit.clean()) : null;
            this.map.put(((MapCommands.ReplaceIfPresent)commit.operation()).key(), new Value(commit, timer));
            value.commit.clean();
            return true;
        }
        commit.clean();
        return false;
    }

    protected int size(Commit<MapCommands.Size> commit) {
        try {
            int n = this.map.size();
            return n;
        }
        finally {
            commit.close();
        }
    }

    protected boolean isEmpty(Commit<MapCommands.IsEmpty> commit) {
        try {
            boolean bl = this.map == null || this.map.isEmpty();
            return bl;
        }
        finally {
            commit.close();
        }
    }

    protected void clear(Commit<MapCommands.Clear> commit) {
        try {
            this.delete();
        }
        finally {
            commit.clean();
        }
    }

    public void delete() {
        Iterator<Map.Entry<Object, Value>> iterator = this.map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Object, Value> entry = iterator.next();
            Value value = entry.getValue();
            if (value.timer != null) {
                value.timer.cancel();
            }
            value.commit.clean();
            iterator.remove();
        }
    }

    private static class Value {
        private final Commit<? extends MapCommands.TtlCommand> commit;
        private final Scheduled timer;

        private Value(Commit<? extends MapCommands.TtlCommand> commit, Scheduled timer) {
            this.commit = commit;
            this.timer = timer;
        }
    }
}

