/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.collections.state;

import io.atomix.catalyst.util.concurrent.Scheduled;
import io.atomix.collections.state.MultiMapCommands;
import io.atomix.copycat.server.Commit;
import io.atomix.copycat.server.StateMachineExecutor;
import io.atomix.resource.ResourceStateMachine;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class MultiMapState
extends ResourceStateMachine {
    private final Map<Object, Map<Object, Commit<? extends MultiMapCommands.TtlCommand>>> map = new HashMap<Object, Map<Object, Commit<? extends MultiMapCommands.TtlCommand>>>();
    private final Map<Long, Scheduled> timers = new HashMap<Long, Scheduled>();

    protected void configure(StateMachineExecutor executor) {
        executor.register(MultiMapCommands.ContainsKey.class, this::containsKey);
        executor.register(MultiMapCommands.Get.class, this::get);
        executor.register(MultiMapCommands.Put.class, this::put);
        executor.register(MultiMapCommands.Remove.class, this::remove);
        executor.register(MultiMapCommands.RemoveValue.class, this::removeValue);
        executor.register(MultiMapCommands.Size.class, this::size);
        executor.register(MultiMapCommands.IsEmpty.class, this::isEmpty);
        executor.register(MultiMapCommands.Clear.class, this::clear);
    }

    protected boolean containsKey(Commit<MultiMapCommands.ContainsKey> commit) {
        try {
            boolean bl = this.map.containsKey(((MultiMapCommands.ContainsKey)commit.operation()).key());
            return bl;
        }
        finally {
            commit.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Collection get(Commit<MultiMapCommands.Get> commit) {
        try {
            Map<Object, Commit<? extends MultiMapCommands.TtlCommand>> values = this.map.get(((MultiMapCommands.Get)commit.operation()).key());
            if (values == null) {
                List list = Collections.EMPTY_LIST;
                return list;
            }
            ArrayList<Object> results = new ArrayList<Object>(values.size());
            for (Commit<? extends MultiMapCommands.TtlCommand> value : values.values()) {
                results.add(((MultiMapCommands.TtlCommand)value.operation()).value());
            }
            ArrayList<Object> arrayList = results;
            return arrayList;
        }
        finally {
            commit.close();
        }
    }

    protected boolean put(Commit<MultiMapCommands.Put> commit) {
        try {
            Map<Object, Commit<? extends MultiMapCommands.TtlCommand>> values = this.map.get(((MultiMapCommands.Put)commit.operation()).key());
            if (values == null) {
                values = new LinkedHashMap<Object, Commit<? extends MultiMapCommands.TtlCommand>>();
                this.map.put(((MultiMapCommands.Put)commit.operation()).key(), values);
            }
            Map<Object, Commit<? extends MultiMapCommands.TtlCommand>> keyValues = values;
            if (!values.containsKey(((MultiMapCommands.Put)commit.operation()).value())) {
                Scheduled timer = ((MultiMapCommands.Put)commit.operation()).ttl() > 0L ? this.executor().schedule(Duration.ofMillis(((MultiMapCommands.Put)commit.operation()).ttl()), () -> ((Commit)keyValues.remove(((MultiMapCommands.Put)commit.operation()).value())).clean()) : null;
                this.timers.put(commit.index(), timer);
                return true;
            }
            commit.clean();
            return false;
        }
        catch (Exception e) {
            commit.clean();
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object remove(Commit<MultiMapCommands.Remove> commit) {
        try {
            if (((MultiMapCommands.Remove)commit.operation()).value() != null) {
                Map<Object, Commit<? extends MultiMapCommands.TtlCommand>> values = this.map.get(((MultiMapCommands.Remove)commit.operation()).key());
                if (values == null) {
                    Boolean bl = false;
                    return bl;
                }
                Commit<? extends MultiMapCommands.TtlCommand> previous = values.remove(((MultiMapCommands.Remove)commit.operation()).value());
                if (previous == null) {
                    Boolean bl = false;
                    return bl;
                }
                previous.clean();
                Scheduled timer = this.timers.remove(previous.index());
                if (timer != null) {
                    timer.cancel();
                }
                if (values.isEmpty()) {
                    this.map.remove(((MultiMapCommands.Remove)commit.operation()).key());
                }
                Boolean bl = true;
                return bl;
            }
            Map<Object, Commit<? extends MultiMapCommands.TtlCommand>> values = this.map.remove(((MultiMapCommands.Remove)commit.operation()).key());
            if (values != null) {
                ArrayList<Object> results = new ArrayList<Object>();
                for (Commit<? extends MultiMapCommands.TtlCommand> value : values.values()) {
                    Scheduled timer = this.timers.remove(value.index());
                    if (timer != null) {
                        timer.cancel();
                    }
                    results.add(((MultiMapCommands.TtlCommand)value.operation()).value());
                }
                ArrayList<Object> arrayList = results;
                return arrayList;
            }
            List list = Collections.EMPTY_LIST;
            return list;
        }
        finally {
            commit.clean();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeValue(Commit<MultiMapCommands.RemoveValue> commit) {
        try {
            Iterator<Map.Entry<Object, Map<Object, Commit<? extends MultiMapCommands.TtlCommand>>>> outerIterator = this.map.entrySet().iterator();
            while (outerIterator.hasNext()) {
                Map<Object, Commit<? extends MultiMapCommands.TtlCommand>> map = outerIterator.next().getValue();
                Iterator<Map.Entry<Object, Commit<? extends MultiMapCommands.TtlCommand>>> innerIterator = map.entrySet().iterator();
                while (innerIterator.hasNext()) {
                    Map.Entry<Object, Commit<? extends MultiMapCommands.TtlCommand>> entry = innerIterator.next();
                    if ((((MultiMapCommands.TtlCommand)entry.getValue().operation()).value() != null || ((MultiMapCommands.RemoveValue)commit.operation()).value() != null) && (((MultiMapCommands.TtlCommand)entry.getValue().operation()).value() == null || ((MultiMapCommands.RemoveValue)commit.operation()).value() == null || !((MultiMapCommands.TtlCommand)entry.getValue().operation()).value().equals(((MultiMapCommands.RemoveValue)commit.operation()).value()))) continue;
                    Scheduled timer = this.timers.remove(entry.getValue().index());
                    if (timer != null) {
                        timer.cancel();
                    }
                    entry.getValue().clean();
                    innerIterator.remove();
                }
                if (!map.isEmpty()) continue;
                outerIterator.remove();
            }
        }
        finally {
            commit.clean();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int size(Commit<MultiMapCommands.Size> commit) {
        try {
            if (((MultiMapCommands.Size)commit.operation()).key() != null) {
                Map<Object, Commit<? extends MultiMapCommands.TtlCommand>> values = this.map.get(((MultiMapCommands.Size)commit.operation()).key());
                int n = values != null ? values.size() : 0;
                return n;
            }
            int size = 0;
            for (Map.Entry<Object, Map<Object, Commit<? extends MultiMapCommands.TtlCommand>>> entry : this.map.entrySet()) {
                size += entry.getValue().size();
            }
            int n = size;
            return n;
        }
        finally {
            commit.close();
        }
    }

    protected boolean isEmpty(Commit<MultiMapCommands.IsEmpty> commit) {
        try {
            boolean bl = this.map == null || this.map.isEmpty();
            return bl;
        }
        finally {
            commit.close();
        }
    }

    protected void clear(Commit<MultiMapCommands.Clear> commit) {
        try {
            this.delete();
        }
        finally {
            commit.clean();
        }
    }

    public void delete() {
        Iterator<Map.Entry<Object, Map<Object, Commit<? extends MultiMapCommands.TtlCommand>>>> iterator = this.map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Object, Map<Object, Commit<? extends MultiMapCommands.TtlCommand>>> entry = iterator.next();
            for (Commit<? extends MultiMapCommands.TtlCommand> value : entry.getValue().values()) {
                Scheduled timer = this.timers.remove(value.index());
                if (timer != null) {
                    timer.cancel();
                }
                value.clean();
            }
            iterator.remove();
        }
    }
}

