/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.collections.state;

import io.atomix.catalyst.buffer.BufferInput;
import io.atomix.catalyst.buffer.BufferOutput;
import io.atomix.catalyst.serializer.CatalystSerializable;
import io.atomix.catalyst.serializer.SerializeWith;
import io.atomix.catalyst.serializer.Serializer;
import io.atomix.copycat.client.Command;
import io.atomix.copycat.client.Query;

public class SetCommands {
    private SetCommands() {
    }

    @SerializeWith(id=105)
    public static class Clear
    extends SetCommand<Void> {
        public Command.PersistenceLevel persistence() {
            return Command.PersistenceLevel.PERSISTENT;
        }
    }

    @SerializeWith(id=104)
    public static class IsEmpty
    extends SetQuery<Boolean> {
    }

    @SerializeWith(id=103)
    public static class Size
    extends SetQuery<Integer> {
    }

    @SerializeWith(id=102)
    public static class Remove
    extends ValueCommand<Boolean> {
        public Remove() {
        }

        public Remove(Object value) {
            super(value);
        }

        public Command.PersistenceLevel persistence() {
            return Command.PersistenceLevel.PERSISTENT;
        }
    }

    @SerializeWith(id=101)
    public static class Add
    extends TtlCommand<Boolean> {
        public Add() {
        }

        public Add(Object value) {
            super(value, 0L);
        }

        public Add(Object value, long ttl) {
            super(value, ttl);
        }
    }

    public static abstract class TtlCommand<V>
    extends ValueCommand<V> {
        protected long ttl;

        protected TtlCommand() {
        }

        protected TtlCommand(Object value, long ttl) {
            super(value);
            this.ttl = ttl;
        }

        public Command.PersistenceLevel persistence() {
            return this.ttl > 0L ? Command.PersistenceLevel.PERSISTENT : Command.PersistenceLevel.EPHEMERAL;
        }

        public long ttl() {
            return this.ttl;
        }

        @Override
        public void writeObject(BufferOutput<?> buffer, Serializer serializer) {
            super.writeObject(buffer, serializer);
            buffer.writeLong(this.ttl);
        }

        @Override
        public void readObject(BufferInput<?> buffer, Serializer serializer) {
            super.readObject(buffer, serializer);
            this.ttl = buffer.readLong();
        }
    }

    @SerializeWith(id=100)
    public static class Contains
    extends ValueQuery<Boolean> {
        public Contains() {
        }

        public Contains(Object value) {
            super(value);
        }
    }

    private static abstract class ValueQuery<V>
    extends SetQuery<V> {
        protected Object value;

        public ValueQuery() {
        }

        public ValueQuery(Object value) {
            this.value = value;
        }

        public Object value() {
            return this.value;
        }

        @Override
        public void writeObject(BufferOutput<?> buffer, Serializer serializer) {
            super.writeObject(buffer, serializer);
            serializer.writeObject(this.value, buffer);
        }

        @Override
        public void readObject(BufferInput<?> buffer, Serializer serializer) {
            super.readObject(buffer, serializer);
            this.value = serializer.readObject(buffer);
        }
    }

    private static abstract class ValueCommand<V>
    extends SetCommand<V> {
        protected Object value;

        public ValueCommand() {
        }

        public ValueCommand(Object value) {
            this.value = value;
        }

        public Object value() {
            return this.value;
        }

        @Override
        public void writeObject(BufferOutput<?> buffer, Serializer serializer) {
            serializer.writeObject(this.value, buffer);
        }

        @Override
        public void readObject(BufferInput<?> buffer, Serializer serializer) {
            this.value = serializer.readObject(buffer);
        }
    }

    private static abstract class SetQuery<V>
    implements Query<V>,
    CatalystSerializable {
        private SetQuery() {
        }

        public void writeObject(BufferOutput<?> buffer, Serializer serializer) {
        }

        public void readObject(BufferInput<?> buffer, Serializer serializer) {
        }
    }

    private static abstract class SetCommand<V>
    implements Command<V>,
    CatalystSerializable {
        private SetCommand() {
        }

        public void writeObject(BufferOutput<?> buffer, Serializer serializer) {
        }

        public void readObject(BufferInput<?> buffer, Serializer serializer) {
        }
    }
}

