/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.collections.state;

import io.atomix.catalyst.util.concurrent.Scheduled;
import io.atomix.collections.state.SetCommands;
import io.atomix.copycat.server.Commit;
import io.atomix.copycat.server.StateMachineExecutor;
import io.atomix.resource.ResourceStateMachine;
import java.time.Duration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class SetState
extends ResourceStateMachine {
    private final Map<Object, Value> map = new HashMap<Object, Value>();

    protected void configure(StateMachineExecutor executor) {
        executor.register(SetCommands.Add.class, this::add);
        executor.register(SetCommands.Contains.class, this::contains);
        executor.register(SetCommands.Remove.class, this::remove);
        executor.register(SetCommands.Size.class, this::size);
        executor.register(SetCommands.IsEmpty.class, this::isEmpty);
        executor.register(SetCommands.Clear.class, this::clear);
    }

    protected boolean contains(Commit<SetCommands.Contains> commit) {
        try {
            boolean bl = this.map.containsKey(((SetCommands.Contains)commit.operation()).value());
            return bl;
        }
        finally {
            commit.close();
        }
    }

    protected boolean add(Commit<SetCommands.Add> commit) {
        try {
            Value value = this.map.get(((SetCommands.Add)commit.operation()).value());
            if (value == null) {
                Scheduled timer = ((SetCommands.Add)commit.operation()).ttl() > 0L ? this.executor().schedule(Duration.ofMillis(((SetCommands.Add)commit.operation()).ttl()), () -> this.map.remove(((SetCommands.Add)commit.operation()).value()).commit.clean()) : null;
                this.map.put(((SetCommands.Add)commit.operation()).value(), new Value(commit, timer));
            } else {
                commit.clean();
            }
        }
        catch (Exception e) {
            commit.clean();
            throw e;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean remove(Commit<SetCommands.Remove> commit) {
        try {
            Value value = this.map.remove(((SetCommands.Remove)commit.operation()).value());
            if (value != null) {
                try {
                    if (value.timer != null) {
                        value.timer.cancel();
                    }
                    boolean bl = true;
                    return bl;
                }
                finally {
                    value.commit.clean();
                }
            }
            boolean bl = false;
            return bl;
        }
        finally {
            commit.clean();
        }
    }

    protected int size(Commit<SetCommands.Size> commit) {
        try {
            int n = this.map != null ? this.map.size() : 0;
            return n;
        }
        finally {
            commit.close();
        }
    }

    protected boolean isEmpty(Commit<SetCommands.IsEmpty> commit) {
        try {
            boolean bl = this.map == null || this.map.isEmpty();
            return bl;
        }
        finally {
            commit.close();
        }
    }

    protected void clear(Commit<SetCommands.Clear> commit) {
        try {
            this.delete();
        }
        finally {
            commit.clean();
        }
    }

    public void delete() {
        Iterator<Map.Entry<Object, Value>> iterator = this.map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Object, Value> entry = iterator.next();
            Value value = entry.getValue();
            if (value.timer != null) {
                value.timer.cancel();
            }
            value.commit.clean();
            iterator.remove();
        }
    }

    private static class Value {
        private final Commit<? extends SetCommands.TtlCommand> commit;
        private final Scheduled timer;

        private Value(Commit<? extends SetCommands.TtlCommand> commit, Scheduled timer) {
            this.commit = commit;
            this.timer = timer;
        }
    }
}

