/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.collections;

import io.atomix.collections.state.MapCommands;
import io.atomix.collections.state.MapState;
import io.atomix.copycat.client.RaftClient;
import io.atomix.resource.AbstractResource;
import io.atomix.resource.Consistency;
import io.atomix.resource.ResourceInfo;
import java.time.Duration;
import java.util.concurrent.CompletableFuture;

@ResourceInfo(stateMachine=MapState.class)
public class DistributedMap<K, V>
extends AbstractResource {
    public DistributedMap(RaftClient client) {
        super(client);
    }

    public DistributedMap<K, V> with(Consistency consistency) {
        super.with(consistency);
        return this;
    }

    public CompletableFuture<Boolean> isEmpty() {
        return this.submit(new MapCommands.IsEmpty());
    }

    public CompletableFuture<Integer> size() {
        return this.submit(new MapCommands.Size());
    }

    public CompletableFuture<Boolean> containsKey(Object key) {
        return this.submit(new MapCommands.ContainsKey(key));
    }

    public CompletableFuture<Boolean> containsValue(Object value) {
        return this.submit(new MapCommands.ContainsValue(value));
    }

    public CompletableFuture<V> get(Object key) {
        return this.submit(new MapCommands.Get(key)).thenApply(result -> result);
    }

    public CompletableFuture<V> getOrDefault(Object key, V defaultValue) {
        return this.submit(new MapCommands.GetOrDefault(key, defaultValue)).thenApply(result -> result);
    }

    public CompletableFuture<V> put(K key, V value) {
        return this.submit(new MapCommands.Put(key, value)).thenApply(result -> result);
    }

    public CompletableFuture<V> put(K key, V value, Duration ttl) {
        return this.submit(new MapCommands.Put(key, value, ttl.toMillis())).thenApply(result -> result);
    }

    public CompletableFuture<V> putIfAbsent(K key, V value) {
        return this.submit(new MapCommands.PutIfAbsent(key, value)).thenApply(result -> result);
    }

    public CompletableFuture<V> putIfAbsent(K key, V value, Duration ttl) {
        return this.submit(new MapCommands.PutIfAbsent(key, value, ttl.toMillis())).thenApply(result -> result);
    }

    public CompletableFuture<V> remove(Object key) {
        return this.submit(new MapCommands.Remove(key)).thenApply(result -> result);
    }

    public CompletableFuture<Boolean> remove(K key, V value) {
        return this.submit(new MapCommands.RemoveIfPresent(key, value));
    }

    public CompletableFuture<V> replace(K key, V value) {
        return this.submit(new MapCommands.Replace(key, value)).thenApply(result -> result);
    }

    public CompletableFuture<V> replace(K key, V value, Duration ttl) {
        return this.submit(new MapCommands.Replace(key, value, ttl.toMillis())).thenApply(result -> result);
    }

    public CompletableFuture<Boolean> replace(K key, V oldValue, V newValue) {
        return this.submit(new MapCommands.ReplaceIfPresent(key, oldValue, newValue));
    }

    public CompletableFuture<Boolean> replace(K key, V oldValue, V newValue, Duration ttl) {
        return this.submit(new MapCommands.ReplaceIfPresent(key, oldValue, newValue, ttl.toMillis()));
    }

    public CompletableFuture<Void> clear() {
        return this.submit(new MapCommands.Clear());
    }
}

