/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.collections;

import io.atomix.collections.state.SetCommands;
import io.atomix.collections.state.SetState;
import io.atomix.copycat.client.RaftClient;
import io.atomix.resource.AbstractResource;
import io.atomix.resource.Consistency;
import io.atomix.resource.ResourceInfo;
import java.time.Duration;
import java.util.concurrent.CompletableFuture;

@ResourceInfo(stateMachine=SetState.class)
public class DistributedSet<T>
extends AbstractResource {
    public DistributedSet(RaftClient client) {
        super(client);
    }

    public DistributedSet<T> with(Consistency consistency) {
        super.with(consistency);
        return this;
    }

    public CompletableFuture<Boolean> add(T value) {
        return this.submit(new SetCommands.Add(value));
    }

    public CompletableFuture<Boolean> add(T value, Duration ttl) {
        return this.submit(new SetCommands.Add(value, ttl.toMillis()));
    }

    public CompletableFuture<Boolean> remove(T value) {
        return this.submit(new SetCommands.Remove(value));
    }

    public CompletableFuture<Boolean> contains(Object value) {
        return this.submit(new SetCommands.Contains(value));
    }

    public CompletableFuture<Integer> size() {
        return this.submit(new SetCommands.Size());
    }

    public CompletableFuture<Boolean> isEmpty() {
        return this.submit(new SetCommands.IsEmpty());
    }

    public CompletableFuture<Void> clear() {
        return this.submit(new SetCommands.Clear());
    }
}

