/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.collections.state;

import io.atomix.catalyst.buffer.BufferInput;
import io.atomix.catalyst.buffer.BufferOutput;
import io.atomix.catalyst.serializer.CatalystSerializable;
import io.atomix.catalyst.serializer.SerializeWith;
import io.atomix.catalyst.serializer.Serializer;
import io.atomix.catalyst.util.Assert;
import io.atomix.copycat.client.Command;
import io.atomix.copycat.client.Query;

public class MapCommands {
    private MapCommands() {
    }

    @SerializeWith(id=72)
    public static class Clear
    extends MapCommand<Void> {
        public Command.PersistenceLevel persistence() {
            return Command.PersistenceLevel.PERSISTENT;
        }
    }

    @SerializeWith(id=71)
    public static class Size
    extends MapQuery<Integer> {
    }

    @SerializeWith(id=70)
    public static class IsEmpty
    extends MapQuery<Boolean> {
    }

    @SerializeWith(id=69)
    public static class ReplaceIfPresent
    extends TtlCommand<Boolean> {
        private Object replace;

        public ReplaceIfPresent() {
        }

        public ReplaceIfPresent(Object key, Object value, Object replace) {
            this(key, value, replace, 0L);
        }

        public ReplaceIfPresent(Object key, Object value, Object replace, long ttl) {
            super(key, value, ttl);
            this.replace = replace;
        }

        public Object replace() {
            return this.replace;
        }

        @Override
        public void writeObject(BufferOutput<?> buffer, Serializer serializer) {
            super.writeObject(buffer, serializer);
            serializer.writeObject(this.replace, buffer);
        }

        @Override
        public void readObject(BufferInput<?> buffer, Serializer serializer) {
            super.readObject(buffer, serializer);
            this.replace = serializer.readObject(buffer);
        }
    }

    @SerializeWith(id=68)
    public static class Replace
    extends TtlCommand<Object> {
        public Replace() {
        }

        public Replace(Object key, Object value) {
            this(key, value, 0L);
        }

        public Replace(Object key, Object value, long ttl) {
            super(key, value, ttl);
        }
    }

    @SerializeWith(id=67)
    public static class RemoveIfPresent
    extends KeyValueCommand<Boolean> {
        public RemoveIfPresent() {
        }

        public RemoveIfPresent(Object key, Object value) {
            super(key, value);
        }

        public Command.PersistenceLevel persistence() {
            return Command.PersistenceLevel.PERSISTENT;
        }
    }

    @SerializeWith(id=66)
    public static class Remove
    extends KeyCommand<Object> {
        public Remove() {
        }

        public Remove(Object key) {
            super(key);
        }

        public Command.PersistenceLevel persistence() {
            return Command.PersistenceLevel.PERSISTENT;
        }
    }

    @SerializeWith(id=65)
    public static class GetOrDefault
    extends KeyQuery<Object> {
        private Object defaultValue;

        public GetOrDefault() {
        }

        public GetOrDefault(Object key, Object defaultValue) {
            super(key);
            this.defaultValue = defaultValue;
        }

        public Object defaultValue() {
            return this.defaultValue;
        }

        @Override
        public void readObject(BufferInput<?> buffer, Serializer serializer) {
            super.readObject(buffer, serializer);
            this.defaultValue = serializer.readObject(buffer);
        }

        @Override
        public void writeObject(BufferOutput<?> buffer, Serializer serializer) {
            super.writeObject(buffer, serializer);
            serializer.writeObject(this.defaultValue, buffer);
        }
    }

    @SerializeWith(id=64)
    public static class Get
    extends KeyQuery<Object> {
        public Get() {
        }

        public Get(Object key) {
            super(key);
        }
    }

    @SerializeWith(id=63)
    public static class PutIfAbsent
    extends TtlCommand<Object> {
        public PutIfAbsent() {
        }

        public PutIfAbsent(Object key, Object value) {
            this(key, value, 0L);
        }

        public PutIfAbsent(Object key, Object value, long ttl) {
            super(key, value, ttl);
        }
    }

    @SerializeWith(id=62)
    public static class Put
    extends TtlCommand<Object> {
        public Put() {
        }

        public Put(Object key, Object value) {
            this(key, value, 0L);
        }

        public Put(Object key, Object value, long ttl) {
            super(key, value, ttl);
        }
    }

    public static abstract class TtlCommand<V>
    extends KeyValueCommand<V> {
        protected long ttl;

        public TtlCommand() {
        }

        public TtlCommand(Object key, Object value, long ttl) {
            super(key, value);
            this.ttl = ttl;
        }

        public Command.PersistenceLevel persistence() {
            return this.ttl > 0L ? Command.PersistenceLevel.PERSISTENT : Command.PersistenceLevel.EPHEMERAL;
        }

        public long ttl() {
            return this.ttl;
        }

        @Override
        public void writeObject(BufferOutput<?> buffer, Serializer serializer) {
            super.writeObject(buffer, serializer);
            buffer.writeLong(this.ttl);
        }

        @Override
        public void readObject(BufferInput<?> buffer, Serializer serializer) {
            super.readObject(buffer, serializer);
            this.ttl = buffer.readLong();
        }
    }

    public static abstract class KeyValueCommand<V>
    extends KeyCommand<V> {
        protected Object value;

        public KeyValueCommand() {
        }

        public KeyValueCommand(Object key, Object value) {
            super(key);
            this.value = value;
        }

        public Object value() {
            return this.value;
        }

        @Override
        public void writeObject(BufferOutput<?> buffer, Serializer serializer) {
            super.writeObject(buffer, serializer);
            serializer.writeObject(this.value, buffer);
        }

        @Override
        public void readObject(BufferInput<?> buffer, Serializer serializer) {
            super.readObject(buffer, serializer);
            this.value = serializer.readObject(buffer);
        }
    }

    @SerializeWith(id=61)
    public static class ContainsValue
    extends MapQuery<Boolean> {
        protected Object value;

        public ContainsValue() {
        }

        public ContainsValue(Object value) {
            this.value = Assert.notNull((Object)value, (String)"value");
        }

        public Object value() {
            return this.value;
        }

        @Override
        public void writeObject(BufferOutput<?> buffer, Serializer serializer) {
            super.writeObject(buffer, serializer);
            serializer.writeObject(this.value, buffer);
        }

        @Override
        public void readObject(BufferInput<?> buffer, Serializer serializer) {
            super.readObject(buffer, serializer);
            this.value = serializer.readObject(buffer);
        }
    }

    @SerializeWith(id=60)
    public static class ContainsKey
    extends KeyQuery<Boolean> {
        public ContainsKey() {
        }

        public ContainsKey(Object key) {
            super(key);
        }
    }

    public static abstract class KeyQuery<V>
    extends MapQuery<V> {
        protected Object key;

        public KeyQuery() {
        }

        public KeyQuery(Object key) {
            this.key = Assert.notNull((Object)key, (String)"key");
        }

        public Object key() {
            return this.key;
        }

        @Override
        public void writeObject(BufferOutput<?> buffer, Serializer serializer) {
            super.writeObject(buffer, serializer);
            serializer.writeObject(this.key, buffer);
        }

        @Override
        public void readObject(BufferInput<?> buffer, Serializer serializer) {
            super.readObject(buffer, serializer);
            this.key = serializer.readObject(buffer);
        }
    }

    public static abstract class KeyCommand<V>
    extends MapCommand<V> {
        protected Object key;

        public KeyCommand() {
        }

        public KeyCommand(Object key) {
            this.key = Assert.notNull((Object)key, (String)"key");
        }

        public Object key() {
            return this.key;
        }

        @Override
        public void writeObject(BufferOutput<?> buffer, Serializer serializer) {
            serializer.writeObject(this.key, buffer);
        }

        @Override
        public void readObject(BufferInput<?> buffer, Serializer serializer) {
            this.key = serializer.readObject(buffer);
        }
    }

    public static abstract class MapQuery<V>
    implements Query<V>,
    CatalystSerializable {
        public void writeObject(BufferOutput<?> buffer, Serializer serializer) {
        }

        public void readObject(BufferInput<?> buffer, Serializer serializer) {
        }
    }

    public static abstract class MapCommand<V>
    implements Command<V>,
    CatalystSerializable {
        public void writeObject(BufferOutput<?> buffer, Serializer serializer) {
        }

        public void readObject(BufferInput<?> buffer, Serializer serializer) {
        }
    }
}

