/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.collections.state;

import io.atomix.catalyst.buffer.BufferInput;
import io.atomix.catalyst.buffer.BufferOutput;
import io.atomix.catalyst.serializer.CatalystSerializable;
import io.atomix.catalyst.serializer.SerializeWith;
import io.atomix.catalyst.serializer.Serializer;
import io.atomix.copycat.client.Command;
import io.atomix.copycat.client.Query;

public class QueueCommands {
    private QueueCommands() {
    }

    @SerializeWith(id=99)
    public static class Clear
    extends QueueCommand<Void> {
        public Command.PersistenceLevel persistence() {
            return Command.PersistenceLevel.PERSISTENT;
        }
    }

    @SerializeWith(id=98)
    public static class IsEmpty
    extends QueueQuery<Boolean> {
    }

    @SerializeWith(id=97)
    public static class Size
    extends QueueQuery<Integer> {
    }

    @SerializeWith(id=96)
    public static class Remove
    extends ValueCommand<Object> {
        public Remove() {
        }

        public Remove(Object value) {
            super(value);
        }

        public Command.PersistenceLevel persistence() {
            return Command.PersistenceLevel.PERSISTENT;
        }
    }

    @SerializeWith(id=95)
    public static class Element
    extends QueueCommand<Object> {
        public Command.PersistenceLevel persistence() {
            return Command.PersistenceLevel.PERSISTENT;
        }
    }

    @SerializeWith(id=94)
    public static class Poll
    extends QueueCommand<Object> {
        public Command.PersistenceLevel persistence() {
            return Command.PersistenceLevel.PERSISTENT;
        }
    }

    @SerializeWith(id=93)
    public static class Peek
    extends QueueQuery<Object> {
    }

    @SerializeWith(id=92)
    public static class Offer
    extends ValueCommand<Boolean> {
        public Offer() {
        }

        public Offer(Object value) {
            super(value);
        }
    }

    @SerializeWith(id=91)
    public static class Add
    extends ValueCommand<Boolean> {
        public Add() {
        }

        public Add(Object value) {
            super(value);
        }
    }

    @SerializeWith(id=90)
    public static class Contains
    extends ValueQuery<Boolean> {
        public Contains() {
        }

        public Contains(Object value) {
            super(value);
        }
    }

    public static abstract class ValueQuery<V>
    extends QueueQuery<V> {
        protected Object value;

        protected ValueQuery() {
        }

        protected ValueQuery(Object value) {
            this.value = value;
        }

        public Object value() {
            return this.value;
        }

        @Override
        public void writeObject(BufferOutput<?> buffer, Serializer serializer) {
            super.writeObject(buffer, serializer);
            serializer.writeObject(this.value, buffer);
        }

        @Override
        public void readObject(BufferInput<?> buffer, Serializer serializer) {
            super.readObject(buffer, serializer);
            this.value = serializer.readObject(buffer);
        }
    }

    public static abstract class ValueCommand<V>
    extends QueueCommand<V> {
        protected Object value;

        protected ValueCommand() {
        }

        protected ValueCommand(Object value) {
            this.value = value;
        }

        public Object value() {
            return this.value;
        }

        @Override
        public void writeObject(BufferOutput<?> buffer, Serializer serializer) {
            serializer.writeObject(this.value, buffer);
        }

        @Override
        public void readObject(BufferInput<?> buffer, Serializer serializer) {
            this.value = serializer.readObject(buffer);
        }
    }

    private static abstract class QueueQuery<V>
    implements Query<V>,
    CatalystSerializable {
        private QueueQuery() {
        }

        public void writeObject(BufferOutput<?> buffer, Serializer serializer) {
        }

        public void readObject(BufferInput<?> buffer, Serializer serializer) {
        }
    }

    private static abstract class QueueCommand<V>
    implements Command<V>,
    CatalystSerializable {
        private QueueCommand() {
        }

        public void writeObject(BufferOutput<?> buffer, Serializer serializer) {
        }

        public void readObject(BufferInput<?> buffer, Serializer serializer) {
        }
    }
}

