/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.protocols.raft.impl;

import com.google.common.base.Preconditions;
import io.atomix.cluster.ClusterMembershipService;
import io.atomix.cluster.MemberId;
import io.atomix.primitive.PrimitiveTypeRegistry;
import io.atomix.protocols.raft.RaftException;
import io.atomix.protocols.raft.RaftServer;
import io.atomix.protocols.raft.cluster.RaftMember;
import io.atomix.protocols.raft.cluster.impl.DefaultRaftMember;
import io.atomix.protocols.raft.cluster.impl.RaftClusterContext;
import io.atomix.protocols.raft.impl.RaftServiceManager;
import io.atomix.protocols.raft.impl.RaftServiceRegistry;
import io.atomix.protocols.raft.protocol.AppendRequest;
import io.atomix.protocols.raft.protocol.CloseSessionRequest;
import io.atomix.protocols.raft.protocol.CommandRequest;
import io.atomix.protocols.raft.protocol.ConfigureRequest;
import io.atomix.protocols.raft.protocol.InstallRequest;
import io.atomix.protocols.raft.protocol.JoinRequest;
import io.atomix.protocols.raft.protocol.KeepAliveRequest;
import io.atomix.protocols.raft.protocol.LeaveRequest;
import io.atomix.protocols.raft.protocol.MetadataRequest;
import io.atomix.protocols.raft.protocol.OpenSessionRequest;
import io.atomix.protocols.raft.protocol.PollRequest;
import io.atomix.protocols.raft.protocol.QueryRequest;
import io.atomix.protocols.raft.protocol.RaftResponse;
import io.atomix.protocols.raft.protocol.RaftServerProtocol;
import io.atomix.protocols.raft.protocol.ReconfigureRequest;
import io.atomix.protocols.raft.protocol.TransferRequest;
import io.atomix.protocols.raft.protocol.VoteRequest;
import io.atomix.protocols.raft.roles.ActiveRole;
import io.atomix.protocols.raft.roles.CandidateRole;
import io.atomix.protocols.raft.roles.FollowerRole;
import io.atomix.protocols.raft.roles.InactiveRole;
import io.atomix.protocols.raft.roles.LeaderRole;
import io.atomix.protocols.raft.roles.PassiveRole;
import io.atomix.protocols.raft.roles.PromotableRole;
import io.atomix.protocols.raft.roles.RaftRole;
import io.atomix.protocols.raft.session.RaftSessionRegistry;
import io.atomix.protocols.raft.storage.RaftStorage;
import io.atomix.protocols.raft.storage.log.RaftLog;
import io.atomix.protocols.raft.storage.log.RaftLogReader;
import io.atomix.protocols.raft.storage.log.RaftLogWriter;
import io.atomix.protocols.raft.storage.snapshot.SnapshotStore;
import io.atomix.protocols.raft.storage.system.MetaStore;
import io.atomix.protocols.raft.utils.LoadMonitor;
import io.atomix.storage.StorageException;
import io.atomix.utils.concurrent.SingleThreadContext;
import io.atomix.utils.concurrent.ThreadContext;
import io.atomix.utils.concurrent.ThreadContextFactory;
import io.atomix.utils.concurrent.ThreadModel;
import io.atomix.utils.concurrent.Threads;
import io.atomix.utils.logging.ContextualLoggerFactory;
import io.atomix.utils.logging.LoggerContext;
import java.time.Duration;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.slf4j.Logger;

public class RaftContext
implements AutoCloseable {
    private static final int LOAD_WINDOW_SIZE = 5;
    private static final int HIGH_LOAD_THRESHOLD = 500;
    private final Logger log;
    private final Set<Consumer<RaftServer.Role>> roleChangeListeners = new CopyOnWriteArraySet<Consumer<RaftServer.Role>>();
    private final Set<Consumer<State>> stateChangeListeners = new CopyOnWriteArraySet<Consumer<State>>();
    private final Set<Consumer<RaftMember>> electionListeners = new CopyOnWriteArraySet<Consumer<RaftMember>>();
    protected final String name;
    protected final ThreadContext threadContext;
    protected final PrimitiveTypeRegistry primitiveTypes;
    protected final ClusterMembershipService membershipService;
    protected final RaftClusterContext cluster;
    protected final RaftServerProtocol protocol;
    protected final RaftStorage storage;
    protected final RaftServiceRegistry services = new RaftServiceRegistry();
    protected final RaftSessionRegistry sessions = new RaftSessionRegistry();
    private final LoadMonitor loadMonitor;
    private volatile State state = State.ACTIVE;
    private final MetaStore meta;
    private final RaftLog raftLog;
    private final RaftLogWriter logWriter;
    private final RaftLogReader logReader;
    private final SnapshotStore snapshotStore;
    private final RaftServiceManager stateMachine;
    private final ThreadContextFactory threadContextFactory;
    private final ThreadContext loadContext;
    private final ThreadContext stateContext;
    private final ThreadContext compactionContext;
    protected RaftRole role = new InactiveRole(this);
    private Duration electionTimeout = Duration.ofMillis(500L);
    private Duration heartbeatInterval = Duration.ofMillis(150L);
    private Duration sessionTimeout = Duration.ofMillis(5000L);
    private volatile MemberId leader;
    private volatile long term;
    private MemberId lastVotedFor;
    private long commitIndex;
    private volatile long firstCommitIndex;
    private volatile long lastApplied;

    public RaftContext(String name, MemberId localMemberId, ClusterMembershipService membershipService, RaftServerProtocol protocol, RaftStorage storage, PrimitiveTypeRegistry primitiveTypes, ThreadModel threadModel, int threadPoolSize) {
        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"name cannot be null");
        this.membershipService = (ClusterMembershipService)Preconditions.checkNotNull((Object)membershipService, (Object)"membershipService cannot be null");
        this.protocol = (RaftServerProtocol)Preconditions.checkNotNull((Object)protocol, (Object)"protocol cannot be null");
        this.storage = (RaftStorage)Preconditions.checkNotNull((Object)storage, (Object)"storage cannot be null");
        this.primitiveTypes = (PrimitiveTypeRegistry)Preconditions.checkNotNull((Object)primitiveTypes, (Object)"registry cannot be null");
        this.log = ContextualLoggerFactory.getLogger(this.getClass(), (LoggerContext)LoggerContext.builder(RaftServer.class).addValue((Object)name).build());
        if (!storage.lock((String)((Object)localMemberId.id()))) {
            throw new StorageException("Failed to acquire storage lock; ensure each Raft server is configured with a distinct storage directory");
        }
        String baseThreadName = String.format("raft-server-%s", name);
        this.threadContext = new SingleThreadContext(Threads.namedThreads((String)baseThreadName, (Logger)this.log));
        this.loadContext = new SingleThreadContext(Threads.namedThreads((String)(baseThreadName + "-load"), (Logger)this.log));
        this.stateContext = new SingleThreadContext(Threads.namedThreads((String)(baseThreadName + "-state"), (Logger)this.log));
        this.compactionContext = new SingleThreadContext(Threads.namedThreads((String)(baseThreadName + "-compaction"), (Logger)this.log));
        this.threadContextFactory = threadModel.factory(baseThreadName + "-%d", threadPoolSize, this.log);
        this.loadMonitor = new LoadMonitor(5, 500, this.loadContext);
        this.meta = storage.openMetaStore();
        this.term = this.meta.loadTerm();
        this.lastVotedFor = this.meta.loadVote();
        this.raftLog = storage.openLog();
        this.logWriter = this.raftLog.writer();
        this.logReader = this.raftLog.openReader(1L, RaftLogReader.Mode.ALL);
        this.snapshotStore = storage.openSnapshotStore();
        this.stateMachine = new RaftServiceManager(this, this.stateContext, this.compactionContext, this.threadContextFactory);
        this.cluster = new RaftClusterContext(localMemberId, this);
        this.registerHandlers(protocol);
    }

    public String getName() {
        return this.name;
    }

    public void addRoleChangeListener(Consumer<RaftServer.Role> listener) {
        this.roleChangeListeners.add(listener);
    }

    public void removeRoleChangeListener(Consumer<RaftServer.Role> listener) {
        this.roleChangeListeners.remove(listener);
    }

    public void addStateChangeListener(Consumer<State> listener) {
        this.stateChangeListeners.add(listener);
    }

    public void removeStateChangeListener(Consumer<State> listener) {
        this.stateChangeListeners.remove(listener);
    }

    public void awaitState(State state, final Consumer<State> listener) {
        if (this.state == state) {
            listener.accept(this.state);
        } else {
            this.addStateChangeListener(new Consumer<State>(){

                @Override
                public void accept(State state) {
                    listener.accept(state);
                    RaftContext.this.removeStateChangeListener(this);
                }
            });
        }
    }

    public void addLeaderElectionListener(Consumer<RaftMember> listener) {
        this.electionListeners.add(listener);
    }

    public void removeLeaderElectionListener(Consumer<RaftMember> listener) {
        this.electionListeners.remove(listener);
    }

    public ThreadContext getThreadContext() {
        return this.threadContext;
    }

    public ClusterMembershipService getMembershipService() {
        return this.membershipService;
    }

    public RaftServerProtocol getProtocol() {
        return this.protocol;
    }

    public RaftStorage getStorage() {
        return this.storage;
    }

    public State getState() {
        return this.state;
    }

    public void setElectionTimeout(Duration electionTimeout) {
        this.electionTimeout = electionTimeout;
    }

    public Duration getElectionTimeout() {
        return this.electionTimeout;
    }

    public void setHeartbeatInterval(Duration heartbeatInterval) {
        this.heartbeatInterval = (Duration)Preconditions.checkNotNull((Object)heartbeatInterval, (Object)"heartbeatInterval cannot be null");
    }

    public Duration getHeartbeatInterval() {
        return this.heartbeatInterval;
    }

    public Duration getSessionTimeout() {
        return this.sessionTimeout;
    }

    public void setSessionTimeout(Duration sessionTimeout) {
        this.sessionTimeout = (Duration)Preconditions.checkNotNull((Object)sessionTimeout, (Object)"sessionTimeout cannot be null");
    }

    public void setLeader(MemberId leader) {
        if (!Objects.equals(this.leader, leader)) {
            if (leader == null) {
                this.leader = null;
            } else {
                DefaultRaftMember member = this.cluster.getMember(leader);
                if (member != null) {
                    this.leader = leader;
                    this.log.info("Found leader {}", (Object)member.memberId());
                    this.electionListeners.forEach(l -> l.accept(member));
                }
            }
            this.lastVotedFor = null;
            this.meta.storeVote(null);
        }
    }

    public RaftClusterContext getCluster() {
        return this.cluster;
    }

    public DefaultRaftMember getLeader() {
        MemberId leader = this.leader;
        return leader != null ? this.cluster.getMember(leader) : null;
    }

    public boolean isLeader() {
        MemberId leader = this.leader;
        return leader != null && leader.equals((Object)this.cluster.getMember().memberId());
    }

    public void setTerm(long term) {
        if (term > this.term) {
            this.term = term;
            this.leader = null;
            this.lastVotedFor = null;
            this.meta.storeTerm(this.term);
            this.meta.storeVote(this.lastVotedFor);
            this.log.debug("Set term {}", (Object)term);
        }
    }

    public long getTerm() {
        return this.term;
    }

    public void setLastVotedFor(MemberId candidate) {
        Preconditions.checkState((this.lastVotedFor == null || candidate == null ? 1 : 0) != 0, (Object)"Already voted for another candidate");
        DefaultRaftMember member = this.cluster.getMember(candidate);
        Preconditions.checkState((member != null ? 1 : 0) != 0, (String)"Unknown candidate: %d", (Object)candidate);
        this.lastVotedFor = candidate;
        this.meta.storeVote(this.lastVotedFor);
        if (candidate != null) {
            this.log.debug("Voted for {}", (Object)member.memberId());
        } else {
            this.log.trace("Reset last voted for");
        }
    }

    public MemberId getLastVotedFor() {
        return this.lastVotedFor;
    }

    public long setCommitIndex(long commitIndex) {
        Preconditions.checkArgument((commitIndex >= 0L ? 1 : 0) != 0, (Object)"commitIndex must be positive");
        long previousCommitIndex = this.commitIndex;
        if (commitIndex > previousCommitIndex) {
            this.commitIndex = commitIndex;
            this.logWriter.commit(Math.min(commitIndex, this.logWriter.getLastIndex()));
            long configurationIndex = this.cluster.getConfiguration().index();
            if (configurationIndex > previousCommitIndex && configurationIndex <= commitIndex) {
                this.cluster.commit();
            }
            this.setFirstCommitIndex(commitIndex);
        }
        return previousCommitIndex;
    }

    public long getCommitIndex() {
        return this.commitIndex;
    }

    public void setFirstCommitIndex(long firstCommitIndex) {
        if (this.firstCommitIndex == 0L) {
            this.firstCommitIndex = firstCommitIndex;
        }
    }

    public long getFirstCommitIndex() {
        return this.firstCommitIndex;
    }

    public void setLastApplied(long lastApplied) {
        this.lastApplied = Math.max(this.lastApplied, lastApplied);
        if (this.state == State.ACTIVE) {
            this.threadContext.execute(() -> {
                if (this.state == State.ACTIVE && this.lastApplied >= this.firstCommitIndex) {
                    this.state = State.READY;
                    this.stateChangeListeners.forEach(l -> l.accept(this.state));
                }
            });
        }
    }

    public long getLastApplied() {
        return this.lastApplied;
    }

    public LoadMonitor getLoadMonitor() {
        return this.loadMonitor;
    }

    public RaftServiceManager getServiceManager() {
        return this.stateMachine;
    }

    public RaftServiceRegistry getServices() {
        return this.services;
    }

    public RaftSessionRegistry getSessions() {
        return this.sessions;
    }

    public PrimitiveTypeRegistry getPrimitiveTypes() {
        return this.primitiveTypes;
    }

    public RaftServer.Role getRole() {
        return this.role.role();
    }

    public RaftRole getRaftRole() {
        return this.role;
    }

    public MetaStore getMetaStore() {
        return this.meta;
    }

    public RaftLog getLog() {
        return this.raftLog;
    }

    public RaftLogWriter getLogWriter() {
        return this.logWriter;
    }

    public RaftLogReader getLogReader() {
        return this.logReader;
    }

    public SnapshotStore getSnapshotStore() {
        return this.snapshotStore;
    }

    public void checkThread() {
        this.threadContext.checkThread();
    }

    private void registerHandlers(RaftServerProtocol protocol) {
        protocol.registerOpenSessionHandler(request -> this.runOnContext(() -> this.role.onOpenSession((OpenSessionRequest)request)));
        protocol.registerCloseSessionHandler(request -> this.runOnContext(() -> this.role.onCloseSession((CloseSessionRequest)request)));
        protocol.registerKeepAliveHandler(request -> this.runOnContext(() -> this.role.onKeepAlive((KeepAliveRequest)request)));
        protocol.registerMetadataHandler(request -> this.runOnContext(() -> this.role.onMetadata((MetadataRequest)request)));
        protocol.registerConfigureHandler(request -> this.runOnContext(() -> this.role.onConfigure((ConfigureRequest)request)));
        protocol.registerInstallHandler(request -> this.runOnContext(() -> this.role.onInstall((InstallRequest)request)));
        protocol.registerJoinHandler(request -> this.runOnContext(() -> this.role.onJoin((JoinRequest)request)));
        protocol.registerReconfigureHandler(request -> this.runOnContext(() -> this.role.onReconfigure((ReconfigureRequest)request)));
        protocol.registerLeaveHandler(request -> this.runOnContext(() -> this.role.onLeave((LeaveRequest)request)));
        protocol.registerTransferHandler(request -> this.runOnContext(() -> this.role.onTransfer((TransferRequest)request)));
        protocol.registerAppendHandler(request -> this.runOnContext(() -> this.role.onAppend((AppendRequest)request)));
        protocol.registerPollHandler(request -> this.runOnContext(() -> this.role.onPoll((PollRequest)request)));
        protocol.registerVoteHandler(request -> this.runOnContext(() -> this.role.onVote((VoteRequest)request)));
        protocol.registerCommandHandler(request -> this.runOnContext(() -> this.role.onCommand((CommandRequest)request)));
        protocol.registerQueryHandler(request -> this.runOnContext(() -> this.role.onQuery((QueryRequest)request)));
    }

    private <R extends RaftResponse> CompletableFuture<R> runOnContext(Supplier<CompletableFuture<R>> function) {
        CompletableFuture future = new CompletableFuture();
        this.threadContext.execute(() -> ((CompletableFuture)function.get()).whenComplete((response, error) -> {
            if (error == null) {
                future.complete(response);
            } else {
                future.completeExceptionally((Throwable)error);
            }
        }));
        return future;
    }

    private void unregisterHandlers(RaftServerProtocol protocol) {
        protocol.unregisterOpenSessionHandler();
        protocol.unregisterCloseSessionHandler();
        protocol.unregisterKeepAliveHandler();
        protocol.unregisterMetadataHandler();
        protocol.unregisterConfigureHandler();
        protocol.unregisterInstallHandler();
        protocol.unregisterJoinHandler();
        protocol.unregisterReconfigureHandler();
        protocol.unregisterLeaveHandler();
        protocol.unregisterTransferHandler();
        protocol.unregisterAppendHandler();
        protocol.unregisterPollHandler();
        protocol.unregisterVoteHandler();
        protocol.unregisterCommandHandler();
        protocol.unregisterQueryHandler();
    }

    public CompletableFuture<Void> anoint() {
        if (this.role.role() == RaftServer.Role.LEADER) {
            return CompletableFuture.completedFuture(null);
        }
        final CompletableFuture<Void> future = new CompletableFuture<Void>();
        this.threadContext.execute(() -> {
            Consumer<RaftMember> electionListener = new Consumer<RaftMember>(){

                @Override
                public void accept(RaftMember member) {
                    if (member.memberId().equals((Object)RaftContext.this.cluster.getMember().memberId())) {
                        future.complete(null);
                    } else {
                        future.completeExceptionally(new RaftException.ProtocolException("Failed to transfer leadership", new Object[0]));
                    }
                    RaftContext.this.removeLeaderElectionListener(this);
                }
            };
            this.addLeaderElectionListener(electionListener);
            RaftMember member = this.getCluster().getMember();
            DefaultRaftMember leader = this.getLeader();
            if (leader != null) {
                this.protocol.transfer(leader.memberId(), TransferRequest.builder().withMember(member.memberId()).build()).whenCompleteAsync((response, error) -> {
                    if (error != null) {
                        future.completeExceptionally((Throwable)error);
                    } else if (response.status() == RaftResponse.Status.ERROR) {
                        future.completeExceptionally((Throwable)response.error().createException());
                    } else {
                        this.transition(RaftServer.Role.CANDIDATE);
                    }
                }, (Executor)this.threadContext);
            } else {
                this.transition(RaftServer.Role.CANDIDATE);
            }
        });
        return future;
    }

    public void transition(RaftMember.Type type) {
        switch (type) {
            case ACTIVE: {
                if (this.role instanceof ActiveRole) break;
                this.transition(RaftServer.Role.FOLLOWER);
                break;
            }
            case PROMOTABLE: {
                if (this.role.role() == RaftServer.Role.PROMOTABLE) break;
                this.transition(RaftServer.Role.PROMOTABLE);
                break;
            }
            case PASSIVE: {
                if (this.role.role() == RaftServer.Role.PASSIVE) break;
                this.transition(RaftServer.Role.PASSIVE);
                break;
            }
            default: {
                if (this.role.role() == RaftServer.Role.INACTIVE) break;
                this.transition(RaftServer.Role.INACTIVE);
            }
        }
    }

    public void transition(RaftServer.Role role) {
        this.checkThread();
        if (this.role != null && role == this.role.role()) {
            return;
        }
        this.log.info("Transitioning to {}", (Object)role);
        try {
            this.role.stop().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new IllegalStateException("failed to close Raft state", e);
        }
        try {
            this.role = this.createRole(role);
            this.role.start().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new IllegalStateException("failed to initialize Raft state", e);
        }
        this.roleChangeListeners.forEach(l -> l.accept(this.role.role()));
    }

    private RaftRole createRole(RaftServer.Role role) {
        switch (role) {
            case INACTIVE: {
                return new InactiveRole(this);
            }
            case PASSIVE: {
                return new PassiveRole(this);
            }
            case PROMOTABLE: {
                return new PromotableRole(this);
            }
            case FOLLOWER: {
                return new FollowerRole(this);
            }
            case CANDIDATE: {
                return new CandidateRole(this);
            }
            case LEADER: {
                return new LeaderRole(this);
            }
        }
        throw new AssertionError();
    }

    @Override
    public void close() {
        this.unregisterHandlers(this.protocol);
        try {
            this.raftLog.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.meta.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.snapshotStore.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.stateMachine.close();
        this.threadContext.close();
        this.loadContext.close();
        this.stateContext.close();
        this.compactionContext.close();
        this.threadContextFactory.close();
    }

    public void delete() {
        this.storage.deleteLog();
        this.storage.deleteSnapshotStore();
        this.storage.deleteMetaStore();
        this.storage.unlock();
    }

    public String toString() {
        return this.getClass().getCanonicalName();
    }

    public static enum State {
        ACTIVE,
        READY;

    }
}

