/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.protocols.raft.session;

import io.atomix.cluster.MemberId;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public enum CommunicationStrategy {
    ANY{

        @Override
        public List<MemberId> selectConnections(MemberId leader, List<MemberId> members) {
            Collections.shuffle(members);
            return members;
        }
    }
    ,
    LEADER{

        @Override
        public List<MemberId> selectConnections(MemberId leader, List<MemberId> members) {
            if (leader != null) {
                return Collections.singletonList(leader);
            }
            Collections.shuffle(members);
            return members;
        }
    }
    ,
    FOLLOWERS{

        @Override
        public List<MemberId> selectConnections(MemberId leader, List<MemberId> members) {
            Collections.shuffle(members);
            if (leader != null && members.size() > 1) {
                ArrayList<MemberId> results = new ArrayList<MemberId>(members.size());
                for (MemberId memberId : members) {
                    if (memberId.equals((Object)leader)) continue;
                    results.add(memberId);
                }
                return results;
            }
            return members;
        }
    };


    public abstract List<MemberId> selectConnections(MemberId var1, List<MemberId> var2);
}

