/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.core.collection.impl;

import com.google.common.base.MoreObjects;

public class CollectionUpdateResult<T> {
    private final Status status;
    private final T result;

    public static CollectionUpdateResult<Void> ok() {
        return new CollectionUpdateResult<Object>(Status.OK, null);
    }

    public static <T> CollectionUpdateResult<T> ok(T result) {
        return new CollectionUpdateResult<T>(Status.OK, result);
    }

    public static <T> CollectionUpdateResult<T> noop() {
        return new CollectionUpdateResult<Object>(Status.NOOP, null);
    }

    public static <T> CollectionUpdateResult<T> noop(T result) {
        return new CollectionUpdateResult<T>(Status.NOOP, result);
    }

    public static <T> CollectionUpdateResult<T> writeLockConflict() {
        return new CollectionUpdateResult<Object>(Status.WRITE_LOCK_CONFLICT, null);
    }

    public CollectionUpdateResult(Status status, T result) {
        this.status = status;
        this.result = result;
    }

    public Status status() {
        return this.status;
    }

    public T result() {
        return this.result;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("status", (Object)this.status).add("result", this.result).toString();
    }

    public static enum Status {
        OK,
        NOOP,
        WRITE_LOCK_CONFLICT;

    }
}

