/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.core.idgenerator.impl;

import io.atomix.core.idgenerator.AsyncAtomicIdGenerator;
import io.atomix.core.idgenerator.AtomicIdGeneratorConfig;
import io.atomix.core.idgenerator.AtomicIdGeneratorType;
import io.atomix.primitive.PrimitiveType;
import io.atomix.primitive.resource.PrimitiveResource;
import java.util.concurrent.CompletableFuture;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.container.Suspended;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/atomic-id-generator")
public class AtomicIdGeneratorResource
extends PrimitiveResource<AsyncAtomicIdGenerator, AtomicIdGeneratorConfig> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AtomicIdGeneratorResource.class);

    public AtomicIdGeneratorResource() {
        super((PrimitiveType)AtomicIdGeneratorType.instance());
    }

    @PUT
    @Path(value="/{name}")
    @Produces(value={"application/json"})
    public void next(@PathParam(value="name") String name, @Suspended AsyncResponse response) {
        ((CompletableFuture)this.getPrimitive(name).thenCompose(idGenerator -> idGenerator.nextId())).whenComplete((result, error) -> {
            if (error == null) {
                response.resume((Object)Response.ok((Object)result).build());
            } else {
                LOGGER.warn("{}", error);
                response.resume((Object)Response.serverError().build());
            }
        });
    }
}

