/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.core.impl;

import io.atomix.core.AtomixRegistry;
import io.atomix.utils.NamedType;
import io.atomix.utils.ServiceException;
import io.atomix.utils.misc.StringUtils;
import io.github.classgraph.ClassGraph;
import io.github.classgraph.ScanResult;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClasspathScanningAtomixRegistry
implements AtomixRegistry {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClasspathScanningAtomixRegistry.class);
    private static final Map<ClassLoader, Map<CacheKey, Map<Class<? extends NamedType>, Map<String, NamedType>>>> CACHE = Collections.synchronizedMap(new WeakHashMap());
    private final Map<Class<? extends NamedType>, Map<String, NamedType>> registrations = new ConcurrentHashMap<Class<? extends NamedType>, Map<String, NamedType>>();

    public ClasspathScanningAtomixRegistry(ClassLoader classLoader, Class<? extends NamedType> ... types) {
        Map mappings = CACHE.computeIfAbsent(classLoader, cl -> new ConcurrentHashMap());
        Map registrations = mappings.computeIfAbsent(new CacheKey(types), cacheKey -> {
            String[] whitelistPackages = StringUtils.split((String)System.getProperty("io.atomix.whitelistPackages"), (String)",");
            ClassGraph classGraph = whitelistPackages != null ? new ClassGraph().enableClassInfo().whitelistPackages(whitelistPackages).addClassLoader(classLoader) : new ClassGraph().enableClassInfo().addClassLoader(classLoader);
            ScanResult scanResult = classGraph.scan();
            ConcurrentHashMap result = new ConcurrentHashMap();
            for (Class type : ((CacheKey)cacheKey).types) {
                ConcurrentHashMap tmp = new ConcurrentHashMap();
                scanResult.getClassesImplementing(type.getName()).forEach(classInfo -> {
                    if (classInfo.isInterface() || classInfo.isAbstract() || Modifier.isPrivate(classInfo.getModifiers())) {
                        return;
                    }
                    NamedType instance = (NamedType)ClasspathScanningAtomixRegistry.newInstance(classInfo.loadClass());
                    NamedType oldInstance = tmp.put(instance.name(), instance);
                    if (oldInstance != null) {
                        LOGGER.warn("Found multiple types with name={}, classes=[{}, {}]", new Object[]{instance.name(), oldInstance.getClass().getName(), instance.getClass().getName()});
                    }
                });
                result.put(type, Collections.unmodifiableMap(tmp));
            }
            return result;
        });
        this.registrations.putAll(registrations);
    }

    private static <T> T newInstance(Class<?> type) {
        try {
            return (T)type.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new ServiceException("Cannot instantiate service class " + type, (Throwable)e);
        }
    }

    @Override
    public <T extends NamedType> Collection<T> getTypes(Class<T> type) {
        Map<String, NamedType> types = this.registrations.get(type);
        return types != null ? types.values() : Collections.emptyList();
    }

    @Override
    public <T extends NamedType> T getType(Class<T> type, String name) {
        Map<String, NamedType> types = this.registrations.get(type);
        return (T)(types != null ? types.get(name) : null);
    }

    private static final class CacheKey {
        private final Class<? extends NamedType>[] types;

        CacheKey(Class<? extends NamedType>[] types) {
            this.types = types;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CacheKey cacheKey = (CacheKey)o;
            return Arrays.equals(this.types, cacheKey.types);
        }

        public int hashCode() {
            return Arrays.hashCode(this.types);
        }
    }
}

