/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.core.iterator.impl;

import io.atomix.core.iterator.AsyncIterator;
import io.atomix.core.iterator.impl.CloseFunction;
import io.atomix.core.iterator.impl.NextFunction;
import io.atomix.core.iterator.impl.OpenFunction;
import io.atomix.core.iterator.impl.ProxyIterator;
import io.atomix.primitive.partition.PartitionId;
import io.atomix.primitive.proxy.ProxyClient;
import io.atomix.utils.concurrent.Futures;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;

public class PartitionedProxyIterator<S, T>
implements AsyncIterator<T> {
    private final ProxyClient<S> client;
    private final Iterator<PartitionId> partitions;
    private final OpenFunction<S> openFunction;
    private final NextFunction<S, T> nextFunction;
    private final CloseFunction<S> closeFunction;
    private volatile AsyncIterator<T> iterator;
    private AtomicBoolean closed = new AtomicBoolean();

    public PartitionedProxyIterator(ProxyClient<S> client, OpenFunction<S> openFunction, NextFunction<S, T> nextFunction, CloseFunction<S> closeFunction) {
        this.client = client;
        this.partitions = client.getPartitionIds().iterator();
        this.openFunction = openFunction;
        this.nextFunction = nextFunction;
        this.closeFunction = closeFunction;
        this.iterator = new ProxyIterator<S, T>(client, this.partitions.next(), openFunction, nextFunction, closeFunction);
    }

    @Override
    public CompletableFuture<Boolean> hasNext() {
        return this.iterator.hasNext().thenCompose(hasNext -> {
            if (!hasNext.booleanValue()) {
                if (this.partitions.hasNext()) {
                    if (this.closed.get()) {
                        return Futures.exceptionalFuture((Throwable)new IllegalStateException("Iterator closed"));
                    }
                    this.iterator = new ProxyIterator<S, T>(this.client, this.partitions.next(), this.openFunction, this.nextFunction, this.closeFunction);
                    return this.hasNext();
                }
                return CompletableFuture.completedFuture(false);
            }
            return CompletableFuture.completedFuture(true);
        });
    }

    @Override
    public CompletableFuture<T> next() {
        return this.iterator.next();
    }

    @Override
    public CompletableFuture<Void> close() {
        this.closed.set(true);
        return this.iterator.close();
    }
}

