/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.core.lock.impl;

import com.google.common.base.MoreObjects;
import io.atomix.core.lock.AtomicLockType;
import io.atomix.core.lock.impl.AtomicLockClient;
import io.atomix.core.lock.impl.AtomicLockService;
import io.atomix.primitive.PrimitiveType;
import io.atomix.primitive.service.AbstractPrimitiveService;
import io.atomix.primitive.service.BackupInput;
import io.atomix.primitive.service.BackupOutput;
import io.atomix.primitive.session.Session;
import io.atomix.primitive.session.SessionId;
import io.atomix.utils.concurrent.Scheduled;
import io.atomix.utils.serializer.Namespace;
import io.atomix.utils.serializer.Serializer;
import java.time.Duration;
import java.util.ArrayDeque;
import java.util.HashMap;
import java.util.Map;
import java.util.Queue;

public abstract class AbstractAtomicLockService
extends AbstractPrimitiveService<AtomicLockClient>
implements AtomicLockService {
    private static final Serializer SERIALIZER = Serializer.using((Namespace)Namespace.builder().register(AtomicLockType.instance().namespace()).register(new Class[]{LockHolder.class}).register(new Class[]{SessionId.class}).build());
    private LockHolder lock;
    private Queue<LockHolder> queue = new ArrayDeque<LockHolder>();
    private final Map<Long, Scheduled> timers = new HashMap<Long, Scheduled>();

    public AbstractAtomicLockService(PrimitiveType primitiveType) {
        super(primitiveType, AtomicLockClient.class);
    }

    public Serializer serializer() {
        return SERIALIZER;
    }

    public void backup(BackupOutput output) {
        output.writeObject((Object)this.lock);
        output.writeObject(this.queue);
    }

    public void restore(BackupInput input) {
        this.lock = (LockHolder)input.readObject();
        this.queue = (Queue)input.readObject();
        this.timers.values().forEach(Scheduled::cancel);
        this.timers.clear();
        for (LockHolder holder : this.queue) {
            if (holder.expire <= 0L) continue;
            this.timers.put(holder.index, this.getScheduler().schedule(Duration.ofMillis(holder.expire - this.getWallClock().getTime().unixTimestamp()), () -> {
                this.timers.remove(holder.index);
                this.queue.remove(holder);
                Session session = this.getSession(holder.session);
                if (session != null && session.getState().active()) {
                    this.getSession(holder.session).accept(service -> service.failed(holder.id));
                }
            }));
        }
    }

    public void onExpire(Session session) {
        this.releaseSession(session);
    }

    public void onClose(Session session) {
        this.releaseSession(session);
    }

    @Override
    public void lock(int id, long timeout) {
        Session session = this.getCurrentSession();
        if (this.lock == null) {
            this.lock = new LockHolder(id, this.getCurrentIndex(), session.sessionId(), 0L);
            session.accept(service -> service.locked(id, this.getCurrentIndex()));
        } else if (timeout == 0L) {
            session.accept(service -> service.failed(id));
        } else if (timeout > 0L) {
            LockHolder holder = new LockHolder(id, this.getCurrentIndex(), session.sessionId(), this.getWallClock().getTime().unixTimestamp() + timeout);
            this.queue.add(holder);
            this.timers.put(this.getCurrentIndex(), this.getScheduler().schedule(Duration.ofMillis(timeout), () -> {
                this.timers.remove(this.getCurrentIndex());
                this.queue.remove(holder);
                if (session.getState().active()) {
                    session.accept(service -> service.failed(id));
                }
            }));
        } else {
            LockHolder holder = new LockHolder(id, this.getCurrentIndex(), session.sessionId(), 0L);
            this.queue.add(holder);
        }
    }

    @Override
    public void unlock(int id) {
        if (this.lock != null) {
            if (!this.lock.session.equals((Object)this.getCurrentSession().sessionId())) {
                return;
            }
            if (this.lock.id != id) {
                return;
            }
            this.lock = this.queue.poll();
            while (this.lock != null) {
                Session lockSession;
                Scheduled timer = this.timers.remove(this.lock.index);
                if (timer != null) {
                    timer.cancel();
                }
                if ((lockSession = this.getSession(this.lock.session)) != null && lockSession.getState().active()) {
                    this.getSession(this.lock.session).accept(service -> service.locked(this.lock.id, this.getCurrentIndex()));
                    break;
                }
                this.lock = this.queue.poll();
            }
        }
    }

    @Override
    public boolean isLocked(long version) {
        return this.lock != null && (version == 0L || this.lock.index == version);
    }

    private void releaseSession(Session session) {
        this.queue.removeIf(lock -> ((LockHolder)lock).session.equals((Object)session.sessionId()));
        if (this.lock != null && this.lock.session.equals((Object)session.sessionId())) {
            this.lock = this.queue.poll();
            while (this.lock != null) {
                Session lockSession;
                Scheduled timer = this.timers.remove(this.lock.index);
                if (timer != null) {
                    timer.cancel();
                }
                if ((lockSession = this.getSession(this.lock.session)) != null && lockSession.getState().active()) {
                    this.getSession(this.lock.session).accept(service -> service.locked(this.lock.id, this.lock.index));
                    break;
                }
                this.lock = this.queue.poll();
            }
        }
    }

    private class LockHolder {
        private final int id;
        private final long index;
        private final SessionId session;
        private final long expire;

        public LockHolder(int id, long index, SessionId session, long expire) {
            this.id = id;
            this.index = index;
            this.session = session;
            this.expire = expire;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("id", this.id).add("index", this.index).add("session", (Object)this.session).add("expire", this.expire).toString();
        }
    }
}

